% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBLB.R
\name{plotBLB}
\alias{plotBLB}
\title{Plot a Binary Logistic Biplot using a BiplotML object}
\usage{
plotBLB(
  x,
  dim = c(1, 2),
  col.ind = NULL,
  col.var = "#00AFBB",
  label.ind = FALSE,
  draw = c("biplot", "ind", "var"),
  titles = NULL,
  ellipses = FALSE,
  endsegm = 0.75,
  repel = TRUE
)
}
\arguments{
\item{x}{Object class BiplotML.}

\item{dim}{Dimensions plot. By default \code{Dim1} and \code{Dim2}.}

\item{col.ind}{Color for the individuals.}

\item{col.var}{Color for the variables.}

\item{label.ind}{By default the row points are not labelled.}

\item{draw}{The graph to draw ("ind" for the individuals, "var" for the variables and "biplot" for the row and columns coordinates in the same graph)}

\item{titles}{Title for the Biplot}

\item{ellipses}{If \code{ellipses=TRUE}, draw confidence ellipses around the rows.}

\item{endsegm}{Represents where the segment of a variable ends on the logit probability scale. By default \code{endsegm=0.75}}

\item{repel}{Repel overlapping text labels.}
}
\value{
Returns the Biplot of the individuals and variables.
}
\description{
Plot the bootstrap binary logistic biplot and draw confidence ellipses on the individuals of an object BiplotML.
}
\details{
If draw = "ind", then the biplot is plotted only for individuals and if draw = "var" then is plotted only for the variables.
}
\examples{
\donttest{
data("Methylation")
set.seed(123456)
outBLB <- bootBLB(x = Methylation, sup = TRUE, plot=FALSE)
plotBLB(x = outBLB, titles = "Methylation Logistic Biplot", ellipses = FALSE)
plotBLB(x = outBLB, titles = "Methylation LogBiplot", endsegm = 0.95)
plotBLB(x = outBLB, label.ind = TRUE, titles = "Methylation LogBiplot")
}
}
\references{
Meulman, J. J., & Heiser, W. J. (1983). The display of bootstrap solutions in multidimensional scaling. Murray Hill, NJ: Bell Laboratories. (Technical memorandum)

Vicente-Villardon, J.L. and Galindo, M. Purificacion (2006), \emph{Multiple Correspondence Analysis and related Methods. Chapter: Logistic Biplots}. Chapman-Hall
}
\seealso{
\code{\link{bootBLB}}
}
\author{
Giovany Babativa <gbabativam@gmail.com>
}
