% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_LogBip.R
\name{cv_LogBip}
\alias{cv_LogBip}
\title{Cross-Validation for logistic biplot}
\usage{
cv_LogBip(
  data,
  k = 0:5,
  K = 7,
  method = "MM",
  type = NULL,
  plot = TRUE,
  maxit = NULL
)
}
\arguments{
\item{data}{Binary matrix.}

\item{k}{Dimensions to analyze. By default \code{k = 1:3}.}

\item{K}{folds. By default \code{K = 7}.}

\item{method}{Method to be used to estimate the parameters. By default \code{ method="MM"}}

\item{type}{For the conjugate-gradients method. Takes value 1 for the Fletcher–Reeves update, 2 for Polak–Ribiere and 3 for Beale–Sorenson.}

\item{plot}{draw the graph. By default \code{plot=TRUE}}

\item{maxit}{The maximum number of iterations. Defaults to 100 for the gradient methods, and 2000 for MM algorithm.}
}
\value{
Training error and generalization error for a logistic biplot model.
}
\description{
This function run cross-validation for logistic biplot
}
\examples{
set.seed(1234)
x <- simBin(n = 100, p = 50, k = 3, D = 0.5, C = 20)
\donttest{
# cross-validation with coordinate descendent MM algorithm
cv_MM <- cv_LogBip(data = x$X, k=0:5, method = "MM", maxit = 1000)

# cross-validation with CG Fletcher-Reeves algorithm
cv_CG <- cv_LogBip(data = x$X, k=0:5, method = "CG", type = 1)
}
}
\references{
Bro R and Kjeldahl K and Smilde AK. (2008). Cross-validation of component models: a critical look at current methods. Analytical and bioanalytical chemistry. 390(5):1241-1251

Wold S. (1978). Cross-validatory estimation of the number of components in factor and principal components models. Technometrics. 20(4):397--405.
}
\seealso{
\code{\link{LogBip}, \link{pred_LB}, \link{fitted_LB}, \link{simBin}}
}
\author{
Giovany Babativa <gbabativam@gmail.com>
}
