% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootBLB.R
\name{bootBLB}
\alias{bootBLB}
\title{Fitting a Binary Logistic Biplot using bootstrap methodology}
\usage{
bootBLB(
  x,
  k = 2,
  L = 0,
  method = "CG",
  type = 1,
  plot = TRUE,
  sup = TRUE,
  ellipses = FALSE,
  maxit = NULL,
  resamples = 100,
  conf = 0.9,
  col.ind = NULL
)
}
\arguments{
\item{x}{Binary matrix.}

\item{k}{Dimensions number. By default \code{k = 2}.}

\item{L}{Penalization parameter. By default \code{L = 0}.}

\item{method}{Method to be used to estimate the parameters. By default \code{ method="CG"}}

\item{type}{For the conjugate-gradients method. Takes value 1 for the Fletcher–Reeves update, 2 for Polak–Ribiere and 3 for Beale–Sorenson.}

\item{plot}{Plot the Bootstrap Logistic Biplot.}

\item{sup}{Boolean, if TRUE, rows that are not selected in each resample are treated as supplementary individuals. See details.}

\item{ellipses}{Draw confidence ellipses. By default is FALSE.}

\item{maxit}{The maximum number of iterations. Defaults to 100 for the gradient methods, and 500 without gradient.}

\item{resamples}{Number of iterations in the bootstrap process. By default \code{100}.}

\item{conf}{Level confidence in the ellipses. By default \code{conf=0.90}}

\item{col.ind}{Color for the rows.}
}
\value{
Coordenates of the matrix A and B in resamples and Biplot
}
\description{
This function estimates the vector \eqn{\mu}, matrix A and matrix B using the optimization algorithm chosen by the user and applies a bootstrap methodology to determine the confidence ellipses.
}
\details{
Fitting when sup=TRUE ... whereas sup=FALSE ...
}
\examples{
\donttest{
data("Methylation")
set.seed(02052020)
out.sup <- bootBLB(x = Methylation, ellipses = FALSE)
out <- bootBLB(x = Methylation, sup = FALSE, ellipses = TRUE)
}
}
\references{
John C. Nash (2011). Unifying Optimization Algorithms to Aid Software System Users:optimx for R. Journal of Statistical Software. 43(9). 1--14.

John C. Nash (2014). On Best Practice Optimization Methods in R. Journal of Statistical Software. 60(2). 1--14.

Milan, L., & Whittaker, J. (1995). Application of the parametric bootstrap to models that incorporate a singular value decomposition. Applied Statistics, 44, 31–49.

Vicente-Villardon, J.L. and Galindo, M. Purificacion (2006), \emph{Multiple Correspondence Analysis and related Methods. Chapter: Logistic Biplots}. Chapman-Hall
}
\seealso{
\code{\link{plotBLB}, \link{performanceBLB}}
}
\author{
Giovany Babativa <gbabativam@gmail.com>
}
