# Whole workflow works consistently

    Code
      set.seed(42)
      gridding(meta, btf) %>% resampling(measure = "ABUNDANCE", resamps = 1L) %>%
        getAlphaMetrics(measure = "ABUNDANCE") %>% getLinearRegressions(divType = "alpha")
    Message
      OK: all SL studies have 1 grid cell
    Output
           assemblageID     metric         slope       pvalue significance
      1       10_359170          S -1.071429e-01 5.456289e-01            0
      2       10_359170          N -9.094643e+01 2.713185e-01            0
      3       10_359170       maxN -4.566071e+01 3.600373e-01            0
      4       10_359170    Shannon  2.876712e-04 9.115369e-01            0
      5       10_359170 expShannon  1.535312e-03 9.111816e-01            0
      6       10_359170    Simpson  6.874126e-05 9.809871e-01            0
      7       10_359170 invSimpson  1.080483e-03 9.732770e-01            0
      8       10_359170        PIE  7.769795e-05 9.785639e-01            0
      9       10_359170      DomMc  3.730028e-04 5.829388e-02            0
      10      18_335699          S  6.636194e-02 3.593922e-01            0
      11      18_335699          N  7.985858e+00 5.519224e-02            0
      12      18_335699       maxN  1.286679e+00 3.175131e-01            0
      13      18_335699    Shannon  1.221322e-03 7.471293e-01            0
      14      18_335699 expShannon  1.408762e-02 7.215063e-01            0
      15      18_335699    Simpson  9.327292e-04 3.238158e-01            0
      16      18_335699 invSimpson  3.721588e-02 2.742686e-01            0
      17      18_335699        PIE  9.077169e-04 3.363446e-01            0
      18      18_335699      DomMc -1.361926e-03 3.690006e-01            0
      19      41_453357          S -2.563657e-01 1.379129e-01            0
      20      41_453357          N -1.936343e+00 5.137263e-02            0
      21      41_453357       maxN  4.328704e-01 1.559284e-02            1
      22      41_453357    Shannon -1.468300e-02 6.603122e-03            1
      23      41_453357 expShannon -4.490074e-01 5.283188e-03            1
      24      41_453357    Simpson -1.257937e-03 1.818562e-03            1
      25      41_453357 invSimpson -6.612574e-01 4.743937e-04            1
      26      41_453357        PIE -1.139895e-03 3.169750e-03            1
      27      41_453357      DomMc  7.400296e-03 1.927566e-04            1
      28      53_394335          S -4.224059e-02 6.302075e-01            0
      29      53_394335          N -6.050735e-01 1.326488e-01            0
      30      53_394335       maxN -3.575987e-01 2.948843e-01            0
      31      53_394335    Shannon  4.247240e-03 8.821820e-01            0
      32      53_394335 expShannon  2.999347e-02 6.880607e-01            0
      33      53_394335    Simpson  2.379700e-04 9.876894e-01            0
      34      53_394335 invSimpson  3.524614e-02 6.222640e-01            0
      35      53_394335        PIE  1.165605e-02 5.448768e-01            0
      36      53_394335      DomMc -6.298767e-03 5.061098e-01            0
      37      59_470660          S -3.247863e-02 7.118995e-01            0
      38      59_470660          N  1.567521e+00 1.702835e-01            0
      39      59_470660       maxN  1.247521e+00 5.361505e-02            0
      40      59_470660    Shannon -1.069113e-02 2.360752e-01            0
      41      59_470660 expShannon -4.081747e-02 2.142391e-01            0
      42      59_470660    Simpson -4.257660e-03 2.520287e-01            0
      43      59_470660 invSimpson -2.116523e-02 2.914275e-01            0
      44      59_470660        PIE -4.369669e-03 2.421277e-01            0
      45      59_470660      DomMc  4.197549e-04 8.633088e-01            0
      46     333_426984          S -2.009852e-01 3.152207e-01            0
      47     333_426984          N  5.456650e+00 7.722171e-02            0
      48     333_426984       maxN  2.124138e+00 8.098710e-03            1
      49     333_426984    Shannon -1.344153e-02 6.432507e-02            0
      50     333_426984 expShannon -3.080318e-01 4.350395e-02            1
      51     333_426984    Simpson -1.194386e-03 1.339874e-01            0
      52     333_426984 invSimpson -3.106756e-01 1.645732e-02            1
      53     333_426984        PIE -1.223376e-03 1.229621e-01            0
      54     333_426984      DomMc  5.184093e-03 1.568682e-02            1
      55    372_2374518          S  3.000000e-01 9.017352e-01            0
      56    372_2374518          N  3.040000e+01 5.490272e-01            0
      57    372_2374518       maxN  1.390000e+01 4.621618e-01            0
      58    372_2374518    Shannon -3.237260e-02 5.997846e-01            0
      59    372_2374518 expShannon -6.432104e-01 5.770782e-01            0
      60    372_2374518    Simpson -6.035446e-03 5.211398e-01            0
      61    372_2374518 invSimpson -8.110171e-01 5.006171e-01            0
      62    372_2374518        PIE -6.262759e-03 5.092328e-01            0
      63    372_2374518      DomMc  1.357972e-02 5.942072e-01            0
      64    372_2378881          S -1.700000e+00 4.555643e-01            0
      65    372_2378881          N  3.060000e+01 4.770262e-01            0
      66    372_2378881       maxN  1.930000e+01 6.189482e-01            0
      67    372_2378881    Shannon -1.013326e-01 4.722237e-01            0
      68    372_2378881 expShannon -1.123141e+00 4.334689e-01            0
      69    372_2378881    Simpson -1.890460e-02 6.917431e-01            0
      70    372_2378881 invSimpson -7.134108e-01 6.359300e-01            0
      71    372_2378881        PIE -1.944701e-02 6.870436e-01            0
      72    372_2378881      DomMc  1.297921e-02 8.375983e-01            0
      73    372_2426320          S -5.000000e-01 7.945770e-01            0
      74    372_2426320          N -4.500000e+00 9.138568e-01            0
      75    372_2426320       maxN  2.100000e+00 6.800286e-01            0
      76    372_2426320    Shannon -2.139588e-02 8.342281e-01            0
      77    372_2426320 expShannon -3.075058e-01 8.307670e-01            0
      78    372_2426320    Simpson -5.578021e-03 6.752799e-01            0
      79    372_2426320 invSimpson -4.029724e-01 7.029579e-01            0
      80    372_2426320        PIE -5.500318e-03 6.715979e-01            0
      81    372_2426320      DomMc  1.025446e-02 6.994830e-01            0
      82    372_2427777          S -3.000000e+00 2.201871e-01            0
      83    372_2427777          N -1.810000e+02 1.168735e-01            0
      84    372_2427777       maxN -7.300000e+00 6.862500e-01            0
      85    372_2427777    Shannon -6.925465e-02 4.308905e-01            0
      86    372_2427777 expShannon -9.418779e-01 4.417241e-01            0
      87    372_2427777    Simpson -9.771983e-03 4.683435e-01            0
      88    372_2427777 invSimpson -7.068256e-01 4.628988e-01            0
      89    372_2427777        PIE -9.686982e-03 4.714819e-01            0
      90    372_2427777      DomMc  2.092992e-02 5.815513e-01            0
      91    372_2428506          S -1.400000e+00 5.889458e-01            0
      92    372_2428506          N -6.800000e+01 5.170864e-01            0
      93    372_2428506       maxN -5.700000e+00 6.018462e-01            0
      94    372_2428506    Shannon -5.947378e-02 1.202014e-01            0
      95    372_2428506 expShannon -1.011952e+00 1.177683e-01            0
      96    372_2428506    Simpson -5.099251e-03 2.108308e-01            0
      97    372_2428506 invSimpson -8.007625e-01 2.092569e-01            0
      98    372_2428506        PIE -5.029972e-03 2.045570e-01            0
      99    372_2428506      DomMc  1.244385e-02 4.605015e-01            0
      100   372_2426316          S -5.000000e-01 3.545028e-01            0
      101   372_2426316          N  8.900000e+00 6.508327e-01            0
      102   372_2426316       maxN -6.900000e+00 2.917021e-01            0
      103   372_2426316    Shannon  3.695045e-02 9.408404e-02            0
      104   372_2426316 expShannon  3.950208e-01 8.685382e-02            0
      105   372_2426316    Simpson  1.506670e-02 3.771464e-02            1
      106   372_2426316 invSimpson  7.554024e-01 4.453525e-02            1
      107   372_2426316        PIE  1.492656e-02 3.570276e-02            1
      108   372_2426316      DomMc -3.049931e-02 6.293633e-02            0
      109   372_2408087          S -4.000000e-01 9.531835e-01            0
      110   372_2408087          N -5.400000e+00 8.684647e-01            0
      111   372_2408087       maxN -7.000000e-01 8.424877e-01            0
      112   372_2408087    Shannon -1.071249e-01 7.830949e-01            0
      113   372_2408087 expShannon -6.011611e-01 8.937141e-01            0
      114   372_2408087    Simpson -2.393341e-02 5.757924e-01            0
      115   372_2408087 invSimpson -6.278271e-01 8.501695e-01            0
      116   372_2408087        PIE -1.896426e-02 5.705982e-01            0
      117   372_2408087      DomMc  4.451762e-02 6.092102e-01            0
      118   372_2399318          S -3.300000e+00 2.720391e-01            0
      119   372_2399318          N -6.350000e+01 6.458519e-01            0
      120   372_2399318       maxN  3.000000e-01 9.891954e-01            0
      121   372_2399318    Shannon -1.056229e-01 1.187049e-01            0
      122   372_2399318 expShannon -1.805322e+00 1.128754e-01            0
      123   372_2399318    Simpson -1.043237e-02 4.151990e-02            1
      124   372_2399318 invSimpson -1.205343e+00 2.858452e-02            1
      125   372_2399318        PIE -1.030042e-02 4.158033e-02            1
      126   372_2399318      DomMc  1.793081e-02 1.216130e-01            0
      127   372_2347502          S -7.000000e-01 7.884607e-01            0
      128   372_2347502          N -5.210000e+01 1.362314e-01            0
      129   372_2347502       maxN -1.500000e+01 2.582977e-01            0
      130   372_2347502    Shannon  1.855270e-02 8.582446e-01            0
      131   372_2347502 expShannon  1.622795e-01 8.919685e-01            0
      132   372_2347502    Simpson  5.466839e-03 6.534319e-01            0
      133   372_2347502 invSimpson  3.064518e-01 7.328236e-01            0
      134   372_2347502        PIE  6.421967e-03 6.119027e-01            0
      135   372_2347502      DomMc -1.523584e-02 6.195891e-01            0
      136   372_2430698          S  1.700000e+00 5.074184e-01            0
      137   372_2430698          N -3.150000e+01 1.231454e-01            0
      138   372_2430698       maxN -1.700000e+00 7.178775e-01            0
      139   372_2430698    Shannon  1.307061e-02 8.601369e-01            0
      140   372_2430698 expShannon  3.933196e-01 8.065503e-01            0
      141   372_2430698    Simpson -5.993533e-04 9.082914e-01            0
      142   372_2430698 invSimpson  8.489416e-02 9.496277e-01            0
      143   372_2430698        PIE -4.923757e-04 9.240292e-01            0
      144   372_2430698      DomMc  4.259224e-03 8.213165e-01            0
      145   372_2428503          S -1.700000e+00 2.545792e-01            0
      146   372_2428503          N -8.700000e+00 3.048884e-01            0
      147   372_2428503       maxN  8.000000e-01 6.874182e-01            0
      148   372_2428503    Shannon -1.100568e-01 4.338058e-02            1
      149   372_2428503 expShannon -1.630983e+00 4.079297e-02            1
      150   372_2428503    Simpson -1.133524e-02 1.822087e-02            1
      151   372_2428503 invSimpson -1.338334e+00 2.345368e-02            1
      152   372_2428503        PIE -1.108377e-02 1.629732e-02            1
      153   372_2428503      DomMc  2.965493e-02 8.801665e-02            0
      154   372_2408078          S -3.000000e-01 7.487072e-01            0
      155   372_2408078          N -1.180000e+01 2.412250e-01            0
      156   372_2408078       maxN -4.200000e+00 1.197622e-01            0
      157   372_2408078    Shannon  5.218669e-02 3.876627e-01            0
      158   372_2408078 expShannon  6.804533e-01 3.562991e-01            0
      159   372_2408078    Simpson  8.066168e-03 3.848195e-01            0
      160   372_2408078 invSimpson  5.572903e-01 3.445523e-01            0
      161   372_2408078        PIE  9.258249e-03 2.831947e-01            0
      162   372_2408078      DomMc -2.743348e-02 2.118768e-01            0
      163   372_2397858          S  1.700000e+00 7.666840e-02            0
      164   372_2397858          N -9.480000e+01 2.313556e-01            0
      165   372_2397858       maxN -2.650000e+01 2.576829e-01            0
      166   372_2397858    Shannon  6.978499e-02 3.416295e-01            0
      167   372_2397858 expShannon  9.112887e-01 3.688530e-01            0
      168   372_2397858    Simpson  6.362324e-03 5.027520e-01            0
      169   372_2397858 invSimpson  4.955269e-01 5.398076e-01            0
      170   372_2397858        PIE  6.691025e-03 4.877027e-01            0
      171   372_2397858      DomMc -2.044317e-02 4.201970e-01            0
      172   372_2400785          S  1.057143e+00 4.372891e-01            0
      173   372_2400785          N  6.577143e+01 1.096997e-01            0
      174   372_2400785       maxN  1.308571e+01 3.020843e-01            0
      175   372_2400785    Shannon  2.485314e-02 7.372027e-01            0
      176   372_2400785 expShannon  3.183906e-01 7.660907e-01            0
      177   372_2400785    Simpson  3.991750e-03 7.094818e-01            0
      178   372_2400785 invSimpson  3.645229e-01 6.843396e-01            0
      179   372_2400785        PIE  2.901023e-03 7.900465e-01            0
      180   372_2400785      DomMc -1.695021e-02 5.860773e-01            0
      181   372_2437271          S  2.100000e+00 1.531983e-01            0
      182   372_2437271          N  1.480000e+01 6.997175e-01            0
      183   372_2437271       maxN  6.300000e+00 7.010657e-01            0
      184   372_2437271    Shannon  7.882983e-02 2.784352e-01            0
      185   372_2437271 expShannon  1.204434e+00 2.702375e-01            0
      186   372_2437271    Simpson  3.951206e-03 6.826858e-01            0
      187   372_2437271 invSimpson  3.410804e-01 6.399895e-01            0
      188   372_2437271        PIE  3.839732e-03 6.989360e-01            0
      189   372_2437271      DomMc  2.145451e-03 9.202707e-01            0
      190   372_2424858          S  3.800000e+00 7.836462e-02            0
      191   372_2424858          N  3.080000e+01 1.646334e-01            0
      192   372_2424858       maxN  7.900000e+00 2.657117e-01            0
      193   372_2424858    Shannon  2.048856e-01 1.435629e-01            0
      194   372_2424858 expShannon  1.507613e+00 1.456327e-01            0
      195   372_2424858    Simpson  3.073998e-02 7.100295e-02            0
      196   372_2424858 invSimpson  8.566041e-01 1.008309e-01            0
      197   372_2424858        PIE  2.643947e-02 6.740181e-02            0
      198   372_2424858      DomMc -6.229547e-02 1.444449e-01            0
      199   372_2410991          S -5.000000e-01 2.394426e-01            0
      200   372_2410991          N -1.000000e+00 9.187243e-01            0
      201   372_2410991       maxN  6.100000e+00 4.489076e-01            0
      202   372_2410991    Shannon -1.746861e-01 1.676061e-01            0
      203   372_2410991 expShannon -1.222293e+00 1.090216e-01            0
      204   372_2410991    Simpson -5.552698e-02 2.902377e-01            0
      205   372_2410991 invSimpson -1.295645e+00 9.967891e-02            0
      206   372_2410991        PIE -5.638861e-02 3.052421e-01            0
      207   372_2410991      DomMc  6.923987e-02 1.545219e-01            0
      208   372_2375241          S -1.900000e+00 3.915130e-01            0
      209   372_2375241          N -2.730000e+01 6.959147e-02            0
      210   372_2375241       maxN -4.200000e+00 1.633400e-01            0
      211   372_2375241    Shannon -2.582666e-02 6.101272e-01            0
      212   372_2375241 expShannon -4.930257e-01 6.340010e-01            0
      213   372_2375241    Simpson -4.125909e-04 8.542806e-01            0
      214   372_2375241 invSimpson -9.094793e-02 8.847393e-01            0
      215   372_2375241        PIE  7.822857e-05 9.736745e-01            0
      216   372_2375241      DomMc -7.378123e-03 2.054496e-01            0
      217   372_2406610          S  6.000000e-01 7.008801e-01            0
      218   372_2406610          N  3.250000e+01 6.225960e-01            0
      219   372_2406610       maxN  7.000000e+00 7.595987e-01            0
      220   372_2406610    Shannon -2.053146e-02 8.522710e-01            0
      221   372_2406610 expShannon -3.387662e-01 7.625904e-01            0
      222   372_2406610    Simpson  2.193478e-03 9.256192e-01            0
      223   372_2406610 invSimpson -2.068443e-01 7.928910e-01            0
      224   372_2406610        PIE  1.984463e-03 9.328825e-01            0
      225   372_2406610      DomMc  1.730755e-02 6.450233e-01            0
      226   372_2459963          S  3.400000e+00 3.446488e-02            1
      227   372_2459963          N  1.560000e+01 1.284780e-01            0
      228   372_2459963       maxN  3.200000e+00 2.192799e-01            0
      229   372_2459963    Shannon  1.933220e-01 3.624219e-02            1
      230   372_2459963 expShannon  1.542891e+00 1.869975e-02            1
      231   372_2459963    Simpson  2.934036e-02 8.284854e-02            0
      232   372_2459963 invSimpson  7.912680e-01 5.740554e-02            0
      233   372_2459963        PIE  2.837731e-02 9.008978e-02            0
      234   372_2459963      DomMc -5.757719e-02 1.532647e-01            0
      235   372_2442444          S -1.000000e+01 2.754587e-01            0
      236   372_2442444          N -6.750000e+01 1.367121e-01            0
      237   372_2442444       maxN -1.450000e+01 1.847464e-01            0
      238   372_2442444    Shannon -9.652094e-01 3.317561e-01            0
      239   372_2442444 expShannon -5.567966e+00 3.297755e-01            0
      240   372_2442444    Simpson -2.222222e-01 3.325251e-01            0
      241   372_2442444 invSimpson -3.600000e+00 3.293042e-01            0
      242   372_2442444        PIE -1.143552e-01 3.386364e-01            0
      243   372_2442444      DomMc  3.079710e-01 3.321158e-01            0
      244   372_2434415          S -1.800000e+00 6.108961e-01            0
      245   372_2434415          N  1.350000e+01 5.639599e-01            0
      246   372_2434415       maxN -3.900000e+00 4.867977e-01            0
      247   372_2434415    Shannon -2.822343e-02 8.333318e-01            0
      248   372_2434415 expShannon -3.731070e-01 8.540662e-01            0
      249   372_2434415    Simpson  5.111184e-03 7.807163e-01            0
      250   372_2434415 invSimpson  6.205680e-01 7.293947e-01            0
      251   372_2434415        PIE  4.924855e-03 7.844652e-01            0
      252   372_2434415      DomMc -1.915906e-02 6.887504e-01            0
      253   372_2367201          S -8.214286e-01 3.395831e-01            0
      254   372_2367201          N  3.142857e+00 8.167170e-01            0
      255   372_2367201       maxN -1.785714e-01 9.652310e-01            0
      256   372_2367201    Shannon -4.456745e-02 2.620868e-01            0
      257   372_2367201 expShannon -5.616572e-01 2.685307e-01            0
      258   372_2367201    Simpson -3.042517e-03 5.611686e-01            0
      259   372_2367201 invSimpson -3.118701e-01 4.400991e-01            0
      260   372_2367201        PIE -4.305546e-03 4.765357e-01            0
      261   372_2367201      DomMc  5.388322e-03 7.509632e-01            0
      262   372_2440940          S -1.900000e+00 6.834483e-02            0
      263   372_2440940          N -4.080000e+01 4.673818e-01            0
      264   372_2440940       maxN -2.550000e+01 5.267101e-01            0
      265   372_2440940    Shannon -3.496670e-02 8.283230e-01            0
      266   372_2440940 expShannon -5.611557e-01 6.397838e-01            0
      267   372_2440940    Simpson  1.305793e-02 7.896616e-01            0
      268   372_2440940 invSimpson -2.461096e-01 8.134815e-01            0
      269   372_2440940        PIE  1.596435e-02 7.514811e-01            0
      270   372_2440940      DomMc -1.031302e-02 8.700897e-01            0
      271   372_2443127          S -1.028571e+00 6.310360e-01            0
      272   372_2443127          N -3.834286e+01 1.033666e-01            0
      273   372_2443127       maxN -1.391429e+01 1.112562e-01            0
      274   372_2443127    Shannon  6.750015e-02 5.541119e-01            0
      275   372_2443127 expShannon  6.844436e-01 6.070076e-01            0
      276   372_2443127    Simpson  1.301822e-02 3.209628e-01            0
      277   372_2443127 invSimpson  6.533870e-01 3.302200e-01            0
      278   372_2443127        PIE  1.364606e-02 3.090872e-01            0
      279   372_2443127      DomMc -2.822061e-02 2.994051e-01            0
      280   372_2432888          S -2.100000e+00 5.612019e-02            0
      281   372_2432888          N -5.200000e+00 8.866992e-01            0
      282   372_2432888       maxN -1.400000e+00 9.562585e-01            0
      283   372_2432888    Shannon -9.872130e-02 6.181194e-01            0
      284   372_2432888 expShannon -1.186608e+00 6.011525e-01            0
      285   372_2432888    Simpson -8.360406e-03 8.468548e-01            0
      286   372_2432888 invSimpson -2.466633e-01 9.073219e-01            0
      287   372_2432888        PIE -7.997001e-03 8.562681e-01            0
      288   372_2432888      DomMc -4.423016e-03 9.654003e-01            0
      289   372_2428509          S -4.100000e+00 3.104129e-01            0
      290   372_2428509          N -9.140000e+01 3.140759e-01            0
      291   372_2428509       maxN -4.260000e+01 2.276218e-01            0
      292   372_2428509    Shannon -4.252074e-03 9.805173e-01            0
      293   372_2428509 expShannon  2.735645e-02 9.875131e-01            0
      294   372_2428509    Simpson  1.527103e-02 4.000683e-01            0
      295   372_2428509 invSimpson  9.213739e-01 3.299608e-01            0
      296   372_2428509        PIE  1.595096e-02 3.843670e-01            0
      297   372_2428509      DomMc -3.449252e-02 2.789827e-01            0
      298   372_2421957          S -5.000000e+00 1.444879e-01            0
      299   372_2421957          N -4.850000e+01 1.666035e-01            0
      300   372_2421957       maxN -1.000000e+01 1.444879e-01            0
      301   372_2421957    Shannon -1.028674e-01 2.483500e-01            0
      302   372_2421957 expShannon -1.027442e+00 2.560817e-01            0
      303   372_2421957    Simpson -6.683717e-03 4.280872e-01            0
      304   372_2421957 invSimpson -3.666277e-01 4.185856e-01            0
      305   372_2421957        PIE  1.627670e-02 3.855234e-01            0
      306   372_2421957      DomMc  8.513932e-03 7.677353e-01            0
      307   372_2406614          S  4.300000e+00 9.448597e-02            0
      308   372_2406614          N  2.710000e+01 6.941736e-01            0
      309   372_2406614       maxN -6.800000e+00 8.710353e-01            0
      310   372_2406614    Shannon  9.017227e-02 4.225391e-01            0
      311   372_2406614 expShannon  1.757527e+00 4.285907e-01            0
      312   372_2406614    Simpson  6.059696e-03 7.187429e-01            0
      313   372_2406614 invSimpson  1.010280e+00 7.133841e-01            0
      314   372_2406614        PIE  6.007663e-03 7.220325e-01            0
      315   372_2406614      DomMc -9.923370e-03 8.815803e-01            0
      316   372_2402963          S -2.100000e+00 2.980474e-01            0
      317   372_2402963          N -9.110000e+01 9.874177e-02            0
      318   372_2402963       maxN -2.280000e+01 7.197381e-02            0
      319   372_2402963    Shannon -5.129593e-02 3.745855e-01            0
      320   372_2402963 expShannon -9.022137e-01 3.924346e-01            0
      321   372_2402963    Simpson -3.468768e-03 4.331147e-01            0
      322   372_2402963 invSimpson -4.790548e-01 4.677527e-01            0
      323   372_2402963        PIE -3.382144e-03 4.433986e-01            0
      324   372_2402963      DomMc  7.327123e-03 4.331813e-01            0
      325   372_2426315          S -1.500000e+00 5.934803e-01            0
      326   372_2426315          N -1.140000e+02 8.651537e-02            0
      327   372_2426315       maxN -4.050000e+01 3.726639e-01            0
      328   372_2426315    Shannon  9.626862e-02 1.938753e-01            0
      329   372_2426315 expShannon  1.584400e+00 1.822900e-01            0
      330   372_2426315    Simpson  7.540625e-03 5.793284e-01            0
      331   372_2426315 invSimpson  6.441583e-01 6.206500e-01            0
      332   372_2426315        PIE  7.740637e-03 5.719333e-01            0
      333   372_2426315      DomMc  8.356152e-03 7.860817e-01            0
      334   372_2427046          S  2.000000e-01 9.274524e-01            0
      335   372_2427046          N  4.240000e+01 5.749146e-01            0
      336   372_2427046       maxN  1.880000e+01 2.706382e-01            0
      337   372_2427046    Shannon -4.967786e-02 6.989253e-01            0
      338   372_2427046 expShannon -6.144735e-01 7.784173e-01            0
      339   372_2427046    Simpson -6.822159e-03 6.260019e-01            0
      340   372_2427046 invSimpson -4.501582e-01 8.118685e-01            0
      341   372_2427046        PIE -6.923033e-03 6.186425e-01            0
      342   372_2427046      DomMc  7.889305e-03 8.098788e-01            0
      343   372_2403683          S -1.300000e+00 2.897341e-01            0
      344   372_2403683          N -2.440000e+01 3.128805e-01            0
      345   372_2403683       maxN -1.010000e+01 2.508235e-01            0
      346   372_2403683    Shannon  6.403203e-02 5.574603e-01            0
      347   372_2403683 expShannon  5.596508e-01 5.474855e-01            0
      348   372_2403683    Simpson  1.975635e-02 2.658304e-01            0
      349   372_2403683 invSimpson  8.094767e-01 2.169382e-01            0
      350   372_2403683        PIE  2.469512e-02 2.125511e-01            0
      351   372_2403683      DomMc -4.844539e-02 1.474124e-01            0
      352   372_2369392          S -1.300000e+00 4.638289e-01            0
      353   372_2369392          N -2.120000e+01 4.754026e-01            0
      354   372_2369392       maxN -2.310000e+01 2.670920e-01            0
      355   372_2369392    Shannon  1.550866e-01 4.593908e-01            0
      356   372_2369392 expShannon  7.946285e-01 6.160226e-01            0
      357   372_2369392    Simpson  8.063962e-02 2.364558e-01            0
      358   372_2369392 invSimpson  9.095776e-01 5.168061e-01            0
      359   372_2369392        PIE  8.357280e-02 2.332769e-01            0
      360   372_2369392      DomMc -7.012024e-02 3.438418e-01            0
      361   372_2400047          S  7.619048e-01 7.500978e-02            0
      362   372_2400047          N  5.440476e+00 5.956691e-01            0
      363   372_2400047       maxN -2.023810e-01 9.744126e-01            0
      364   372_2400047    Shannon  6.506272e-02 1.482999e-01            0
      365   372_2400047 expShannon  7.689991e-01 1.581310e-01            0
      366   372_2400047    Simpson  7.012475e-03 3.145177e-01            0
      367   372_2400047 invSimpson  5.025876e-01 3.409715e-01            0
      368   372_2400047        PIE  6.944686e-03 3.263374e-01            0
      369   372_2400047      DomMc -1.208367e-02 4.278105e-01            0
      370   372_2431454          S  8.571429e-01 3.329495e-01            0
      371   372_2431454          N  8.000000e-01 7.796233e-01            0
      372   372_2431454       maxN -1.257143e+00 1.162078e-01            0
      373   372_2431454    Shannon  7.105499e-02 2.079223e-01            0
      374   372_2431454 expShannon  7.813023e-01 2.398309e-01            0
      375   372_2431454    Simpson  1.048887e-02 1.222827e-01            0
      376   372_2431454 invSimpson  7.467944e-01 1.589879e-01            0
      377   372_2431454        PIE  1.051891e-02 1.163772e-01            0
      378   372_2431454      DomMc -2.393691e-02 8.871462e-02            0
      379   372_2443903          S -2.628571e+00 1.806651e-01            0
      380   372_2443903          N -9.828571e+00 5.085302e-01            0
      381   372_2443903       maxN -7.428571e-01 7.371685e-01            0
      382   372_2443903    Shannon -1.184263e-01 1.701259e-01            0
      383   372_2443903 expShannon -1.671000e+00 1.826411e-01            0
      384   372_2443903    Simpson -1.061888e-02 1.904203e-01            0
      385   372_2443903 invSimpson -1.156028e+00 2.406978e-01            0
      386   372_2443903        PIE -9.781196e-03 1.871872e-01            0
      387   372_2443903      DomMc  2.664814e-02 2.292365e-01            0
      388   372_2394207          S -1.000000e+00 1.761776e-01            0
      389   372_2394207          N -8.185714e+01 1.631105e-01            0
      390   372_2394207       maxN -9.800000e+00 4.553777e-01            0
      391   372_2394207    Shannon -3.949848e-02 1.609530e-01            0
      392   372_2394207 expShannon -4.420349e-01 1.705405e-01            0
      393   372_2394207    Simpson -4.885303e-03 2.982995e-01            0
      394   372_2394207 invSimpson -2.962935e-01 3.285283e-01            0
      395   372_2394207        PIE -4.699407e-03 3.209017e-01            0
      396   372_2394207      DomMc  1.090612e-02 4.683707e-01            0
      397   372_2362812          S  2.269231e+00 4.266836e-01            0
      398   372_2362812          N  5.896154e+01 4.810009e-02            1
      399   372_2362812       maxN  3.119231e+01 4.838090e-01            0
      400   372_2362812    Shannon -1.945810e-03 9.929070e-01            0
      401   372_2362812 expShannon  1.598608e-01 9.595690e-01            0
      402   372_2362812    Simpson -1.555235e-02 7.065386e-01            0
      403   372_2362812 invSimpson -3.637187e-01 9.064578e-01            0
      404   372_2362812        PIE -1.608195e-02 6.982764e-01            0
      405   372_2362812      DomMc  2.518039e-02 7.445055e-01            0
      406   372_2410264          S -5.000000e-01 5.675928e-01            0
      407   372_2410264          N -7.000000e+00 5.585425e-01            0
      408   372_2410264       maxN -1.500000e+00 6.766682e-01            0
      409   372_2410264    Shannon -3.833122e-02 2.540529e-01            0
      410   372_2410264 expShannon -4.683675e-01 2.655915e-01            0
      411   372_2410264    Simpson -1.826105e-03 6.964664e-01            0
      412   372_2410264 invSimpson -1.549351e-01 7.194447e-01            0
      413   372_2410264        PIE -1.479836e-03 7.762092e-01            0
      414   372_2410264      DomMc -6.991920e-04 9.675358e-01            0
      415   372_2452656          S  5.000000e-01 7.744185e-01            0
      416   372_2452656          N  5.140000e+01 2.206258e-01            0
      417   372_2452656       maxN  3.100000e+00 3.227024e-01            0
      418   372_2452656    Shannon  3.223672e-02 1.660242e-01            0
      419   372_2452656 expShannon  7.560172e-01 1.670220e-01            0
      420   372_2452656    Simpson  3.769733e-03 5.508955e-03            1
      421   372_2452656 invSimpson  9.915616e-01 7.914542e-03            1
      422   372_2452656        PIE  3.665964e-03 4.202329e-03            1
      423   372_2452656      DomMc -4.459694e-03 5.560817e-01            0
      424   372_2379617          S -2.600000e+00 1.428054e-01            0
      425   372_2379617          N  3.200000e+01 7.058371e-01            0
      426   372_2379617       maxN  6.400000e+00 6.998314e-01            0
      427   372_2379617    Shannon -4.155689e-02 4.858768e-01            0
      428   372_2379617 expShannon -5.911407e-01 4.651664e-01            0
      429   372_2379617    Simpson -9.975674e-04 8.361387e-01            0
      430   372_2379617 invSimpson -8.414973e-02 7.956587e-01            0
      431   372_2379617        PIE -1.036236e-03 8.292143e-01            0
      432   372_2379617      DomMc -4.703636e-03 6.742070e-01            0
      433   372_2441713          S -1.390219e-15 1.000000e+00            0
      434   372_2441713          N  5.340000e+01 1.882023e-01            0
      435   372_2441713       maxN -6.000000e+00 4.429140e-01            0
      436   372_2441713    Shannon  4.349764e-02 4.402155e-01            0
      437   372_2441713 expShannon  8.843395e-01 4.615024e-01            0
      438   372_2441713    Simpson  6.482625e-03 2.487241e-01            0
      439   372_2441713 invSimpson  1.221498e+00 3.080927e-01            0
      440   372_2441713        PIE  6.362731e-03 2.526198e-01            0
      441   372_2441713      DomMc -2.095938e-02 3.722275e-01            0
      442   372_2442439          S -2.400000e+00 2.333481e-01            0
      443   372_2442439          N  6.130000e+01 7.033865e-01            0
      444   372_2442439       maxN  5.220000e+01 7.173651e-01            0
      445   372_2442439    Shannon -2.226838e-01 5.256888e-01            0
      446   372_2442439 expShannon -3.234089e+00 4.081943e-01            0
      447   372_2442439    Simpson -4.088689e-02 6.918577e-01            0
      448   372_2442439 invSimpson -2.181924e+00 4.977257e-01            0
      449   372_2442439        PIE -4.126278e-02 6.913905e-01            0
      450   372_2442439      DomMc  5.673614e-02 6.524001e-01            0
      451   372_2440221          S  6.000000e-01 6.274294e-01            0
      452   372_2440221          N -1.560000e+01 3.328349e-01            0
      453   372_2440221       maxN -9.000000e+00 4.309183e-01            0
      454   372_2440221    Shannon  4.818823e-02 1.017459e-01            0
      455   372_2440221 expShannon  5.583978e-01 9.673822e-02            0
      456   372_2440221    Simpson  1.091956e-02 4.003685e-01            0
      457   372_2440221 invSimpson  5.818792e-01 3.195954e-01            0
      458   372_2440221        PIE  1.147693e-02 3.923201e-01            0
      459   372_2440221      DomMc -2.282834e-02 2.672665e-01            0
      460   372_2438027          S -2.200000e+00 4.600312e-01            0
      461   372_2438027          N -2.520000e+01 3.828643e-01            0
      462   372_2438027       maxN -1.000000e-01 9.794804e-01            0
      463   372_2438027    Shannon -1.156173e-01 3.110935e-01            0
      464   372_2438027 expShannon -1.870186e+00 2.661744e-01            0
      465   372_2438027    Simpson -1.004266e-02 2.297411e-01            0
      466   372_2438027 invSimpson -1.411520e+00 1.754624e-01            0
      467   372_2438027        PIE -9.266696e-03 2.039492e-01            0
      468   372_2438027      DomMc  2.147853e-02 7.155184e-02            0
      469   372_2434379          S -7.000000e+00 1.544210e-01            0
      470   372_2434379          N -1.020000e+02 5.392253e-02            0
      471   372_2434379       maxN -1.250000e+01 4.145679e-01            0
      472   372_2434379    Shannon -2.995711e-01 1.829268e-01            0
      473   372_2434379 expShannon -3.676084e+00 2.175944e-01            0
      474   372_2434379    Simpson -3.635856e-02 2.237979e-01            0
      475   372_2434379 invSimpson -2.410336e+00 2.689790e-01            0
      476   372_2434379        PIE -3.248340e-02 2.738893e-01            0
      477   372_2434379      DomMc  6.944123e-02 4.225727e-01            0
      478   372_2435823          S -8.000000e-01 4.037152e-01            0
      479   372_2435823          N -7.090000e+01 2.801251e-01            0
      480   372_2435823       maxN  1.570000e+01 5.252766e-01            0
      481   372_2435823    Shannon -8.128725e-02 4.038192e-01            0
      482   372_2435823 expShannon -1.289597e+00 4.406448e-01            0
      483   372_2435823    Simpson -1.369356e-02 2.709298e-01            0
      484   372_2435823 invSimpson -1.464710e+00 3.043182e-01            0
      485   372_2435823        PIE -1.361339e-02 2.753707e-01            0
      486   372_2435823      DomMc  5.103194e-02 2.309211e-01            0
      487   372_2425589          S -2.000000e+00 4.460828e-02            1
      488   372_2425589          N -1.950000e+01 1.517085e-02            1
      489   372_2425589       maxN -2.300000e+00 3.981714e-01            0
      490   372_2425589    Shannon -5.517332e-02 3.608278e-01            0
      491   372_2425589 expShannon -8.087674e-01 3.396091e-01            0
      492   372_2425589    Simpson -4.016347e-03 5.962611e-01            0
      493   372_2425589 invSimpson -4.521993e-01 5.771379e-01            0
      494   372_2425589        PIE -2.752219e-03 7.259019e-01            0
      495   372_2425589      DomMc  5.011803e-03 8.523251e-01            0
      496   372_2427047          S -1.500000e+00 6.066356e-02            0
      497   372_2427047          N -5.752000e+02 5.564035e-02            0
      498   372_2427047       maxN -2.872000e+02 1.139161e-01            0
      499   372_2427047    Shannon  1.739153e-01 8.277816e-02            0
      500   372_2427047 expShannon  1.724303e+00 1.053354e-01            0
      501   372_2427047    Simpson  3.277683e-02 1.015885e-01            0
      502   372_2427047 invSimpson  1.328316e+00 1.491719e-01            0
      503   372_2427047        PIE  3.285135e-02 1.014975e-01            0
      504   372_2427047      DomMc -7.868504e-02 1.262743e-01            0
      505   372_2427776          S  2.900000e+00 5.159859e-02            0
      506   372_2427776          N  1.612000e+02 1.414375e-01            0
      507   372_2427776       maxN  2.030000e+01 2.572370e-01            0
      508   372_2427776    Shannon  9.735790e-02 7.216765e-02            0
      509   372_2427776 expShannon  1.200029e+00 7.145931e-02            0
      510   372_2427776    Simpson  1.595772e-02 5.618473e-02            0
      511   372_2427776 invSimpson  1.057578e+00 2.897582e-02            1
      512   372_2427776        PIE  1.536270e-02 5.205871e-02            0
      513   372_2427776      DomMc -3.514145e-02 3.370341e-02            1
      514   372_2429234          S -5.000000e-01 4.784302e-01            0
      515   372_2429234          N -1.240000e+01 2.739166e-01            0
      516   372_2429234       maxN -1.000000e+00 7.707930e-01            0
      517   372_2429234    Shannon -2.818367e-02 6.277699e-01            0
      518   372_2429234 expShannon -2.867400e-01 6.705875e-01            0
      519   372_2429234    Simpson -5.043155e-03 5.009361e-01            0
      520   372_2429234 invSimpson -2.409757e-01 6.479948e-01            0
      521   372_2429234        PIE -4.876662e-03 5.186359e-01            0
      522   372_2429234      DomMc  1.180413e-02 5.253967e-01            0
      523   372_2429233          S  8.000000e-01 7.171573e-01            0
      524   372_2429233          N  1.780000e+01 4.197982e-01            0
      525   372_2429233       maxN  7.400000e+00 9.996713e-02            0
      526   372_2429233    Shannon -4.134084e-02 3.810667e-01            0
      527   372_2429233 expShannon -5.992862e-01 3.659955e-01            0
      528   372_2429233    Simpson -8.032142e-03 1.449563e-01            0
      529   372_2429233 invSimpson -8.472237e-01 1.504428e-01            0
      530   372_2429233        PIE -8.401817e-03 1.148493e-01            0
      531   372_2429233      DomMc  3.046955e-02 1.456485e-01            0
      532   372_2425610          S  4.000000e-01 7.830695e-01            0
      533   372_2425610          N -6.180000e+01 3.662588e-01            0
      534   372_2425610       maxN -1.730000e+01 5.778918e-01            0
      535   372_2425610    Shannon -6.067384e-02 3.147085e-01            0
      536   372_2425610 expShannon -5.504898e-01 3.348997e-01            0
      537   372_2425610    Simpson -1.070331e-02 4.284174e-01            0
      538   372_2425610 invSimpson -4.395794e-01 4.728486e-01            0
      539   372_2425610        PIE -1.029568e-02 4.580740e-01            0
      540   372_2425610      DomMc  2.689281e-02 3.193492e-01            0
      541   372_2423417          S  6.000000e+00 1.789124e-01            0
      542   372_2423417          N -2.035000e+02 3.945449e-01            0
      543   372_2423417       maxN -2.350000e+02 3.403267e-01            0
      544   372_2423417    Shannon  1.012615e+00 3.001500e-01            0
      545   372_2423417 expShannon  6.711603e+00 2.578699e-01            0
      546   372_2423417    Simpson  3.053637e-01 3.193848e-01            0
      547   372_2423417 invSimpson  4.496933e+00 2.390353e-01            0
      548   372_2423417        PIE  3.072396e-01 3.205086e-01            0
      549   372_2423417      DomMc -2.882599e-01 2.803290e-01            0
      550   372_2404439          S  3.000000e+00 1.210377e-01            0
      551   372_2404439          N  8.000000e+01 2.867244e-01            0
      552   372_2404439       maxN  4.600000e+01 3.193428e-02            1
      553   372_2404439    Shannon -2.863430e-02 7.834158e-01            0
      554   372_2404439 expShannon -3.619513e-01 7.966771e-01            0
      555   372_2404439    Simpson -2.053329e-02 3.911740e-01            0
      556   372_2404439 invSimpson -1.420321e+00 4.161164e-01            0
      557   372_2404439        PIE -2.101510e-02 3.802063e-01            0
      558   372_2404439      DomMc  4.428668e-02 4.167232e-01            0
      559   372_2412474          S -2.383826e-13 1.000000e+00            0
      560   372_2412474          N -6.350000e+01 2.643995e-01            0
      561   372_2412474       maxN -1.500000e+01 6.841648e-01            0
      562   372_2412474    Shannon  1.249940e-01 2.601780e-01            0
      563   372_2412474 expShannon  2.061469e+00 2.683230e-01            0
      564   372_2412474    Simpson  1.267719e-02 6.392837e-01            0
      565   372_2412474 invSimpson  1.899149e+00 5.501426e-01            0
      566   372_2412474        PIE  1.375907e-02 6.238006e-01            0
      567   372_2412474      DomMc -2.884279e-02 7.172159e-01            0
      568   372_2419754          S -2.700000e+00 1.687388e-01            0
      569   372_2419754          N -1.800000e+00 9.301780e-01            0
      570   372_2419754       maxN  7.300000e+00 5.158551e-01            0
      571   372_2419754    Shannon -1.145239e-01 2.168756e-01            0
      572   372_2419754 expShannon -1.425156e+00 2.492362e-01            0
      573   372_2419754    Simpson -1.563760e-02 4.513423e-01            0
      574   372_2419754 invSimpson -1.073912e+00 4.914253e-01            0
      575   372_2419754        PIE -1.567816e-02 4.510838e-01            0
      576   372_2419754      DomMc  2.377334e-02 6.073556e-01            0
      577   372_2419028          S -4.000000e-01 7.734566e-01            0
      578   372_2419028          N -1.550000e+01 1.606053e-01            0
      579   372_2419028       maxN -1.240000e+01 1.435637e-01            0
      580   372_2419028    Shannon  1.352175e-01 3.804891e-01            0
      581   372_2419028 expShannon  1.104888e+00 5.079099e-01            0
      582   372_2419028    Simpson  3.585253e-02 2.216010e-01            0
      583   372_2419028 invSimpson  1.390523e+00 3.357286e-01            0
      584   372_2419028        PIE  3.716445e-02 2.166300e-01            0
      585   372_2419028      DomMc -8.167168e-02 1.967226e-01            0
      586   372_2409543          S  3.500000e+00 6.055959e-01            0
      587   372_2409543          N  2.250000e+01 4.227535e-01            0
      588   372_2409543       maxN  1.500000e+00 8.585497e-01            0
      589   372_2409543    Shannon  2.184521e-01 5.006694e-01            0
      590   372_2409543 expShannon  1.507084e+00 5.432749e-01            0
      591   372_2409543    Simpson  5.350840e-02 3.116441e-01            0
      592   372_2409543 invSimpson  1.204369e+00 2.979646e-01            0
      593   372_2409543        PIE  4.947856e-02 3.047637e-01            0
      594   372_2409543      DomMc -5.049261e-02 2.699669e-01            0
      595   372_2403696          S -3.300000e+00 1.788402e-01            0
      596   372_2403696          N  7.080000e+01 4.760527e-01            0
      597   372_2403696       maxN  2.450000e+01 4.020743e-01            0
      598   372_2403696    Shannon -7.856302e-02 1.777556e-01            0
      599   372_2403696 expShannon -1.806687e+00 1.778053e-01            0
      600   372_2403696    Simpson -4.638586e-03 3.208467e-01            0
      601   372_2403696 invSimpson -9.884449e-01 3.549253e-01            0
      602   372_2403696        PIE -4.713937e-03 3.266962e-01            0
      603   372_2403696      DomMc  1.014406e-02 3.734596e-01            0
      604   372_2400777          S  1.000000e-01 8.954583e-01            0
      605   372_2400777          N -1.200000e+00 7.631306e-01            0
      606   372_2400777       maxN  1.000000e-01 9.378969e-01            0
      607   372_2400777    Shannon  2.316003e-03 9.658847e-01            0
      608   372_2400777 expShannon  1.172661e-02 9.836469e-01            0
      609   372_2400777    Simpson -7.315820e-04 9.157366e-01            0
      610   372_2400777 invSimpson -4.629209e-02 9.332848e-01            0
      611   372_2400777        PIE -2.670036e-04 9.661204e-01            0
      612   372_2400777      DomMc  7.921727e-03 7.170449e-01            0
      613   372_2394218          S -2.500000e+00 1.993592e-01            0
      614   372_2394218          N  1.210000e+01 6.003247e-01            0
      615   372_2394218       maxN  1.190000e+01 4.335581e-01            0
      616   372_2394218    Shannon -1.485801e-01 8.248296e-02            0
      617   372_2394218 expShannon -1.632551e+00 8.013406e-02            0
      618   372_2394218    Simpson -1.913405e-02 2.543004e-01            0
      619   372_2394218 invSimpson -8.257165e-01 2.730398e-01            0
      620   372_2394218        PIE -1.932137e-02 2.588805e-01            0
      621   372_2394218      DomMc  2.711512e-02 5.329526e-01            0
      622   372_2399315          S -3.500000e+00 5.676877e-02            0
      623   372_2399315          N -1.345000e+02 6.050048e-02            0
      624   372_2399315       maxN -1.880000e+01 9.910005e-03            1
      625   372_2399315    Shannon -3.508371e-02 3.908733e-01            0
      626   372_2399315 expShannon -7.373772e-01 3.933697e-01            0
      627   372_2399315    Simpson -9.426674e-04 7.714321e-01            0
      628   372_2399315 invSimpson -2.018862e-01 7.658117e-01            0
      629   372_2399315        PIE -7.157038e-04 8.231184e-01            0
      630   372_2399315      DomMc -2.108334e-03 8.322597e-01            0
      631   372_2375959          S -1.300000e+00 4.578625e-01            0
      632   372_2375959          N -6.760000e+01 1.117097e-01            0
      633   372_2375959       maxN -6.300000e+00 8.159240e-01            0
      634   372_2375959    Shannon -3.564748e-02 7.546834e-01            0
      635   372_2375959 expShannon -4.975054e-01 6.820512e-01            0
      636   372_2375959    Simpson -3.247978e-03 9.053956e-01            0
      637   372_2375959 invSimpson -5.014895e-01 6.890407e-01            0
      638   372_2375959        PIE -2.941510e-03 9.147517e-01            0
      639   372_2375959      DomMc -3.326733e-04 9.963923e-01            0
      640   372_2363562          S -3.000000e+00 1.210377e-01            0
      641   372_2363562          N -2.400000e+01 8.614642e-01            0
      642   372_2363562       maxN -7.800000e+01 2.131367e-01            0
      643   372_2363562    Shannon  1.631839e-01 1.854629e-01            0
      644   372_2363562 expShannon  2.450525e+00 2.047744e-01            0
      645   372_2363562    Simpson  3.954735e-02 5.964107e-02            0
      646   372_2363562 invSimpson  3.374215e+00 1.718016e-01            0
      647   372_2363562        PIE  3.964918e-02 6.210404e-02            0
      648   372_2363562      DomMc -1.062414e-01 2.213891e-01            0
      649   372_2365726          S  1.000000e+00 8.712907e-02            0
      650   372_2365726          N -2.000000e+00 6.507849e-01            0
      651   372_2365726       maxN -1.600000e+00 4.037152e-01            0
      652   372_2365726    Shannon  1.002728e-01 1.719457e-01            0
      653   372_2365726 expShannon  1.006394e+00 1.719300e-01            0
      654   372_2365726    Simpson  1.390376e-02 3.541655e-01            0
      655   372_2365726 invSimpson  8.748913e-01 3.837120e-01            0
      656   372_2365726        PIE  1.558625e-02 3.511473e-01            0
      657   372_2365726      DomMc -3.360806e-02 5.683652e-01            0
      658   372_2435073          S  1.100000e+00 2.496255e-01            0
      659   372_2435073          N  8.100000e+00 5.615546e-01            0
      660   372_2435073       maxN  1.300000e+00 6.722136e-01            0
      661   372_2435073    Shannon  8.489150e-02 1.821978e-01            0
      662   372_2435073 expShannon  6.127416e-01 1.845732e-01            0
      663   372_2435073    Simpson  1.288205e-02 2.799998e-01            0
      664   372_2435073 invSimpson  3.537414e-01 3.462605e-01            0
      665   372_2435073        PIE  1.254611e-02 2.801200e-01            0
      666   372_2435073      DomMc -1.559033e-02 4.634865e-01            0
      667   372_2428505          S  3.000000e-01 2.254033e-01            0
      668   372_2428505          N -6.200000e+00 5.055010e-01            0
      669   372_2428505       maxN -3.900000e+00 4.680444e-01            0
      670   372_2428505    Shannon  9.146333e-02 2.088423e-01            0
      671   372_2428505 expShannon  2.109024e-01 2.111021e-01            0
      672   372_2428505    Simpson  3.171863e-02 1.786484e-01            0
      673   372_2428505 invSimpson  1.512438e-01 1.867597e-01            0
      674   372_2428505        PIE  4.158156e-02 2.050838e-01            0
      675   372_2428505      DomMc -4.615385e-02 2.254033e-01            0
      676   402_3191117          S -2.857143e+00 1.434291e-01            0
      677   402_3191117          N -1.276000e+02 4.307846e-03            1
      678   402_3191117       maxN -5.780000e+01 2.142946e-02            1
      679   402_3191117    Shannon  3.715274e-02 6.169784e-01            0
      680   402_3191117 expShannon  5.060355e-01 6.473871e-01            0
      681   402_3191117    Simpson  1.639202e-02 2.028579e-01            0
      682   402_3191117 invSimpson  9.109611e-01 2.888097e-01            0
      683   402_3191117        PIE  1.723287e-02 1.848636e-01            0
      684   402_3191117      DomMc -2.307556e-02 3.316080e-01            0
      685   402_3191116          S -1.800000e+00 4.371885e-02            1
      686   402_3191116          N -3.294286e+01 3.429106e-02            1
      687   402_3191116       maxN -1.560000e+01 1.192741e-01            0
      688   402_3191116    Shannon -6.380536e-02 2.040116e-02            1
      689   402_3191116 expShannon -3.299276e-01 1.827408e-02            1
      690   402_3191116    Simpson -2.980417e-04 9.854839e-01            0
      691   402_3191116 invSimpson -1.899363e-02 9.177852e-01            0
      692   402_3191116        PIE  7.626240e-03 6.837172e-01            0
      693   402_3191116      DomMc  5.494374e-03 6.735007e-01            0
      694   402_3190385          S -8.000000e-01 3.015263e-02            1
      695   402_3190385          N -1.008571e+01 3.738062e-01            0
      696   402_3190385       maxN  2.600000e+00 6.184586e-01            0
      697   402_3190385    Shannon -1.212413e-01 1.624278e-02            1
      698   402_3190385 expShannon -6.796573e-01 2.170716e-02            1
      699   402_3190385    Simpson -4.282418e-02 2.593913e-02            1
      700   402_3190385 invSimpson -6.769059e-01 7.116366e-02            0
      701   402_3190385        PIE -4.228392e-02 2.756373e-02            1
      702   402_3190385      DomMc  4.953691e-02 1.298995e-01            0
      703   431_5118319          S -3.346457e-01 7.270028e-02            0
      704   431_5118319          N -1.252756e+01 1.461117e-01            0
      705   431_5118319       maxN -7.787402e+00 1.329611e-01            0
      706   431_5118319    Shannon -1.621110e-02 5.878485e-01            0
      707   431_5118319 expShannon -3.426745e-02 5.144634e-01            0
      708   431_5118319    Simpson -2.630428e-03 8.980583e-01            0
      709   431_5118319 invSimpson -1.307204e-02 7.870924e-01            0
      710   431_5118319        PIE  1.562298e-02 5.646485e-01            0
      711   431_5118319      DomMc  3.876549e-03 8.822888e-02            0
      712   431_5122694          S  1.645570e-01 4.778212e-01            0
      713   431_5122694          N  2.772152e+00 8.218590e-01            0
      714   431_5122694       maxN  2.525316e+00 8.331989e-01            0
      715   431_5122694    Shannon  2.434531e-02 7.451768e-01            0
      716   431_5122694 expShannon  3.344321e-02 7.720379e-01            0
      717   431_5122694    Simpson  1.492147e-02 8.079165e-01            0
      718   431_5122694 invSimpson  2.792671e-02 8.302746e-01            0
      719   431_5122694        PIE  2.756726e-02 8.330186e-01            0
      720   431_5122694      DomMc -1.567209e-03 4.778212e-01            0
      721   431_5103014          S -1.000000e+00 3.333333e-01            0
      722   431_5103014          N -3.150000e+01 8.696746e-02            0
      723   431_5103014       maxN -1.050000e+01 5.380248e-01            0
      724   431_5103014    Shannon -1.603610e-01 5.453197e-01            0
      725   431_5103014 expShannon -5.553754e-01 5.090955e-01            0
      726   431_5103014    Simpson -6.909928e-02 6.797756e-01            0
      727   431_5103014 invSimpson -5.762061e-01 5.563008e-01            0
      728   431_5103014        PIE -5.311355e-02 7.621857e-01            0
      729   431_5103014      DomMc  7.307692e-02 5.397326e-01            0
      730   431_4749643          S  4.043662e-17 5.328272e-01            0
      731   431_4749643          N -1.088785e+00 3.287985e-01            0
      732   431_4749643       maxN -7.897196e-01 3.251380e-01            0
      733   431_4749643    Shannon  4.678336e-03 4.099223e-01            0
      734   431_4749643 expShannon  8.905419e-03 4.150340e-01            0
      735   431_4749643    Simpson  4.521086e-03 4.135122e-01            0
      736   431_4749643 invSimpson  1.513576e-02 4.318721e-01            0
      737   431_4749643        PIE  3.087777e-02 3.848360e-01            0
      738   431_4749643      DomMc  2.021831e-17 5.328272e-01            0
      739   431_5120509          S  2.036388e-17 8.210876e-01            0
      740   431_5120509          N -1.615385e+00 1.544210e-01            0
      741   431_5120509       maxN -1.538462e+00 5.499567e-02            0
      742   431_5120509    Shannon  4.026492e-02 4.346759e-01            0
      743   431_5120509 expShannon  7.126972e-02 4.415653e-01            0
      744   431_5120509    Simpson  3.682136e-02 4.401799e-01            0
      745   431_5120509 invSimpson  9.968674e-02 4.578743e-01            0
      746   431_5120509        PIE  5.804196e-02 3.464584e-01            0
      747   431_5120509      DomMc  1.018194e-17 8.210876e-01            0
      748   431_5132911          S  8.646617e-02 4.785132e-02            1
      749   431_5132911          N  1.022556e+00 6.053354e-01            0
      750   431_5132911       maxN  6.766917e-01 7.145180e-01            0
      751   431_5132911    Shannon  1.294852e-02 7.985245e-01            0
      752   431_5132911 expShannon  4.630729e-02 7.625621e-01            0
      753   431_5132911    Simpson  7.597118e-04 9.790511e-01            0
      754   431_5132911 invSimpson  3.818609e-02 8.419477e-01            0
      755   431_5132911        PIE -2.747997e-03 9.360602e-01            0
      756   431_5132911      DomMc -1.331454e-02 6.640537e-01            0
      757   431_5133641          S -2.289023e-17 4.785132e-02            1
      758   431_5133641          N -6.278195e-01 2.446987e-01            0
      759   431_5133641       maxN -7.030075e-01 8.788589e-02            0
      760   431_5133641    Shannon  3.359306e-02 4.785132e-02            1
      761   431_5133641 expShannon  5.567285e-02 4.785132e-02            1
      762   431_5133641    Simpson  2.894115e-02 4.785132e-02            1
      763   431_5133641 invSimpson  6.934415e-02 4.785132e-02            1
      764   431_5133641        PIE  5.570745e-02 2.773146e-01            0
      765   431_5133641      DomMc -1.144511e-17 4.785132e-02            1
      766   431_5132912          S  2.742616e-02 8.880502e-01            0
      767   431_5132912          N -3.588608e+00 7.797333e-01            0
      768   431_5132912       maxN -1.755274e+00 7.942732e-01            0
      769   431_5132912    Shannon  5.816847e-03 8.470454e-01            0
      770   431_5132912 expShannon  6.150222e-03 9.351122e-01            0
      771   431_5132912    Simpson  5.463380e-04 9.693435e-01            0
      772   431_5132912 invSimpson -9.296164e-03 8.997846e-01            0
      773   431_5132912        PIE  7.444839e-03 6.160490e-01            0
      774   431_5132912      DomMc -9.440508e-04 9.551571e-01            0
      775   431_4745246          S  2.605863e-02 6.981455e-01            0
      776   431_4745246          N  7.703583e-01 7.932240e-01            0
      777   431_4745246       maxN  9.413681e-01 7.506567e-01            0
      778   431_4745246    Shannon -6.100222e-03 8.891515e-01            0
      779   431_4745246 expShannon -4.533037e-03 9.515894e-01            0
      780   431_4745246    Simpson -7.595048e-03 7.768580e-01            0
      781   431_4745246 invSimpson -9.716124e-03 8.650043e-01            0
      782   431_4745246        PIE -6.291360e-03 8.472636e-01            0
      783   431_4745246      DomMc -4.343105e-03 6.981455e-01            0
      784   431_5104466          S  4.048583e-02 5.609407e-01            0
      785   431_5104466          N  2.874494e-01 3.486451e-01            0
      786   431_5104466       maxN  2.469636e-01 3.007937e-01            0
      787   431_5104466    Shannon -1.193193e-03 9.235022e-01            0
      788   431_5104466 expShannon -1.947353e-03 9.345574e-01            0
      789   431_5104466    Simpson -6.578947e-03 2.601469e-01            0
      790   431_5104466 invSimpson -2.169188e-02 2.336984e-01            0
      791   431_5104466        PIE -3.282244e-02 6.774841e-02            0
      792   431_5104466      DomMc -5.060729e-03 5.609407e-01            0
      793   431_5122695          S -5.943536e-03 8.614569e-01            0
      794   431_5122695          N -5.686478e+00 8.688097e-01            0
      795   431_5122695       maxN -5.256315e+00 8.673532e-01            0
      796   431_5122695    Shannon  7.696829e-03 5.161210e-01            0
      797   431_5122695 expShannon  1.226711e-02 5.356313e-01            0
      798   431_5122695    Simpson  6.487905e-03 5.346095e-01            0
      799   431_5122695 invSimpson  1.395937e-02 5.824855e-01            0
      800   431_5122695        PIE  7.318082e-03 5.859466e-01            0
      801   431_5122695      DomMc  2.902117e-05 8.614569e-01            0
      802   431_5101552          S  0.000000e+00          NaN           NA
      803   431_5101552          N  9.400000e-01 8.137427e-01            0
      804   431_5101552       maxN  9.200000e-01 8.125180e-01            0
      805   431_5101552    Shannon -3.556041e-02 5.053844e-01            0
      806   431_5101552 expShannon -5.954299e-02 4.566262e-01            0
      807   431_5101552    Simpson -3.110564e-02 4.553064e-01            0
      808   431_5101552 invSimpson -7.219906e-02 3.660196e-01            0
      809   431_5101552        PIE -5.785398e-02 3.779589e-01            0
      810   431_5101552      DomMc  0.000000e+00          NaN           NA
      811   431_5111033          S -3.533569e-02 8.284004e-01            0
      812   431_5111033          N -8.445230e-01 6.495017e-01            0
      813   431_5111033       maxN -6.643110e-01 6.816101e-01            0
      814   431_5111033    Shannon -2.024420e-03 8.964840e-01            0
      815   431_5111033 expShannon -2.612555e-03 9.233239e-01            0
      816   431_5111033    Simpson  7.381233e-04 9.635187e-01            0
      817   431_5111033 invSimpson  5.619473e-03 8.942598e-01            0
      818   431_5111033        PIE  6.652857e-03 7.625429e-01            0
      819   431_5111033      DomMc  1.177856e-03 8.284004e-01            0
      820   431_4756925          S  0.000000e+00          NaN           NA
      821   431_4756925          N -1.785714e+00 5.508882e-02            0
      822   431_4756925       maxN -1.357143e+00 1.126725e-01            0
      823   431_4756925    Shannon  6.173238e-03 8.418587e-01            0
      824   431_4756925 expShannon  1.177514e-02 8.341826e-01            0
      825   431_4756925    Simpson  5.992063e-03 8.356569e-01            0
      826   431_4756925 invSimpson  1.932773e-02 8.199826e-01            0
      827   431_4756925        PIE  3.614719e-02 4.841710e-01            0
      828   431_4756925      DomMc  0.000000e+00          NaN           NA
      829   431_5119779          S -7.480315e-02 3.615880e-01            0
      830   431_5119779          N -1.751969e+00 8.671238e-01            0
      831   431_5119779       maxN -1.633858e+00 8.606406e-01            0
      832   431_5119779    Shannon  1.683490e-02 5.338098e-01            0
      833   431_5119779 expShannon  3.027507e-02 5.079375e-01            0
      834   431_5119779    Simpson  2.029252e-02 3.665148e-01            0
      835   431_5119779 invSimpson  5.355477e-02 3.450172e-01            0
      836   431_5119779        PIE  3.253952e-02 3.560201e-01            0
      837   431_5119779      DomMc  3.400143e-03 3.615880e-01            0
      838   431_4748913          S  0.000000e+00          NaN           NA
      839   431_4748913          N  1.914286e+00 4.619298e-01            0
      840   431_4748913       maxN  1.857143e+00 4.632497e-01            0
      841   431_4748913    Shannon -2.944769e-02 7.590651e-01            0
      842   431_4748913 expShannon -3.510438e-02 8.195980e-01            0
      843   431_4748913    Simpson -1.870289e-02 8.152220e-01            0
      844   431_4748913 invSimpson -9.810508e-03 9.568018e-01            0
      845   431_4748913        PIE -2.385154e-02 8.008530e-01            0
      846   431_4748913      DomMc  0.000000e+00          NaN           NA
      847   431_5102284          S -4.132231e-02 5.454545e-01            0
      848   431_5102284          N -1.035813e+00 2.725626e-01            0
      849   431_5102284       maxN -8.787879e-01 2.678728e-01            0
      850   431_5102284    Shannon  1.590586e-03 8.692033e-01            0
      851   431_5102284 expShannon  2.673665e-03 8.702146e-01            0
      852   431_5102284    Simpson  3.776646e-03 7.390319e-01            0
      853   431_5102284 invSimpson  7.417455e-03 7.631893e-01            0
      854   431_5102284        PIE  5.838596e-03 6.856459e-01            0
      855   431_5102284      DomMc  2.430724e-03 5.454545e-01            0
      856   431_5113947          S -1.067616e-02 9.106236e-01            0
      857   431_5113947          N -3.629893e+00 7.806309e-01            0
      858   431_5113947       maxN -2.629893e+00 7.922297e-01            0
      859   431_5113947    Shannon -1.544645e-02 6.354533e-01            0
      860   431_5113947 expShannon -4.272964e-02 5.850089e-01            0
      861   431_5113947    Simpson -1.108771e-02 4.865676e-01            0
      862   431_5113947 invSimpson -6.344320e-02 3.520870e-01            0
      863   431_5113947        PIE -1.330752e-02 4.984616e-01            0
      864   431_5113947      DomMc  7.838577e-03 4.526137e-01            0
      865   431_5101555          S -1.346154e-01 1.544210e-01            0
      866   431_5101555          N  1.865385e+00 6.074137e-01            0
      867   431_5101555       maxN  1.942308e+00 5.622633e-01            0
      868   431_5101555    Shannon -6.592230e-02 1.858317e-01            0
      869   431_5101555 expShannon -1.361049e-01 1.335277e-01            0
      870   431_5101555    Simpson -3.783056e-02 3.487028e-01            0
      871   431_5101555 invSimpson -1.282828e-01 2.510080e-01            0
      872   431_5101555        PIE -4.202191e-02 4.968529e-01            0
      873   431_5101555      DomMc  1.682692e-02 1.544210e-01            0
      874   431_5100825          S -1.288344e-01 2.028719e-01            0
      875   431_5100825          N  2.328221e+00 8.965534e-01            0
      876   431_5100825       maxN  3.303681e+00 8.537547e-01            0
      877   431_5100825    Shannon -4.029657e-02 4.722386e-01            0
      878   431_5100825 expShannon -7.944576e-02 3.992265e-01            0
      879   431_5100825    Simpson -2.028809e-02 5.811513e-01            0
      880   431_5100825 invSimpson -5.645175e-02 4.558586e-01            0
      881   431_5100825        PIE -1.851868e-02 6.438798e-01            0
      882   431_5100825      DomMc  7.243419e-03 7.288084e-02            0
      883   431_5121236          S -3.080569e-02 7.046442e-01            0
      884   431_5121236          N -2.319905e+00 7.251835e-01            0
      885   431_5121236       maxN -1.481043e+00 7.446880e-01            0
      886   431_5121236    Shannon -2.189953e-02 1.717863e-01            0
      887   431_5121236 expShannon -3.897876e-02 1.933187e-01            0
      888   431_5121236    Simpson -1.631448e-02 5.386278e-02            0
      889   431_5121236 invSimpson -4.192379e-02 9.403367e-02            0
      890   431_5121236        PIE -1.999558e-02 3.151349e-01            0
      891   431_5121236      DomMc  1.791028e-03 7.046442e-01            0
      892   431_5123423          S  5.504587e-02 6.107074e-02            0
      893   431_5123423          N -3.949541e+00 1.292497e-01            0
      894   431_5123423       maxN -3.055046e+00 1.199730e-01            0
      895   431_5123423    Shannon  1.350294e-02 1.193603e-01            0
      896   431_5123423 expShannon  2.803099e-02 1.267965e-01            0
      897   431_5123423    Simpson  4.536658e-03 6.291744e-02            0
      898   431_5123423 invSimpson  1.369997e-02 6.320163e-02            0
      899   431_5123423        PIE  5.097901e-03 8.523832e-02            0
      900   431_5123423      DomMc -4.249138e-03 2.185902e-01            0
      901   431_5120508          S  7.636364e-02 2.688738e-01            0
      902   431_5120508          N  1.488727e+01 1.602029e-01            0
      903   431_5120508       maxN  1.460727e+01 1.587213e-01            0
      904   431_5120508    Shannon -4.986752e-02 1.704910e-01            0
      905   431_5120508 expShannon -7.228216e-02 1.879966e-01            0
      906   431_5120508    Simpson -3.798338e-02 1.815957e-01            0
      907   431_5120508 invSimpson -6.777576e-02 2.455599e-01            0
      908   431_5120508        PIE -5.143296e-02 1.544345e-01            0
      909   431_5120508      DomMc -4.172876e-04 2.688738e-01            0
      910   431_5113218          S -6.000000e-01 5.766889e-02            0
      911   431_5113218          N  3.384489e-14 1.000000e+00            0
      912   431_5113218       maxN  3.000000e-01 6.713538e-01            0
      913   431_5113218    Shannon -1.878945e-01 1.219109e-01            0
      914   431_5113218 expShannon -4.603023e-01 1.084038e-01            0
      915   431_5113218    Simpson -7.525450e-02 2.606157e-01            0
      916   431_5113218 invSimpson -3.398291e-01 1.894353e-01            0
      917   431_5113218        PIE -8.580087e-02 2.679513e-01            0
      918   431_5113218      DomMc  8.311688e-02 6.224414e-02            0
      919   431_5101554          S  9.302326e-02 5.823435e-01            0
      920   431_5101554          N  9.418605e-01 8.241763e-01            0
      921   431_5101554       maxN  7.558140e-01 8.669927e-01            0
      922   431_5101554    Shannon  3.930163e-02 7.050674e-01            0
      923   431_5101554 expShannon  6.949059e-02 6.744054e-01            0
      924   431_5101554    Simpson  2.315207e-02 7.074140e-01            0
      925   431_5101554 invSimpson  5.040248e-02 6.620730e-01            0
      926   431_5101554        PIE  2.570220e-02 7.074924e-01            0
      927   431_5101554      DomMc -8.456660e-03 5.823435e-01            0
      928   431_4752549          S  1.174935e-02 7.766080e-01            0
      929   431_4752549          N -7.490862e+00 2.985284e-01            0
      930   431_4752549       maxN -6.644909e+00 2.654077e-01            0
      931   431_4752549    Shannon  1.794010e-02 1.932996e-01            0
      932   431_4752549 expShannon  3.002821e-02 1.621003e-01            0
      933   431_4752549    Simpson  1.415046e-02 1.328542e-01            0
      934   431_4752549 invSimpson  3.231489e-02 8.937195e-02            0
      935   431_4752549        PIE  1.586417e-02 1.146439e-01            0
      936   431_4752549      DomMc -4.505911e-04 8.479083e-01            0
      937   431_4754005          S -1.632000e-14 1.000000e+00            0
      938   431_4754005          N  1.583333e+01 3.724647e-01            0
      939   431_4754005       maxN  1.100000e+01 3.811847e-01            0
      940   431_4754005    Shannon -7.793845e-03 9.515951e-01            0
      941   431_4754005 expShannon -1.735713e-02 9.632788e-01            0
      942   431_4754005    Simpson -4.621744e-03 9.384834e-01            0
      943   431_4754005 invSimpson -1.660514e-02 9.672411e-01            0
      944   431_4754005        PIE -1.126634e-02 9.082754e-01            0
      945   431_4754005      DomMc  2.985462e-03 9.696939e-01            0
      946   431_5115406          S  2.498269e-14 1.000000e+00            0
      947   431_5115406          N  9.500000e+01 1.717467e-01            0
      948   431_5115406       maxN  9.100000e+01 1.255753e-01            0
      949   431_5115406    Shannon -9.299009e-02 6.079041e-01            0
      950   431_5115406 expShannon -1.527206e-01 5.530080e-01            0
      951   431_5115406    Simpson -6.574860e-02 5.541598e-01            0
      952   431_5115406 invSimpson -1.318084e-01 4.799631e-01            0
      953   431_5115406        PIE -6.704309e-02 5.513366e-01            0
      954   431_5115406      DomMc  4.934211e-03 4.877543e-01            0
      955   431_4754011          S  1.141331e-02 6.104557e-01            0
      956   431_4754011          N  4.854298e-01 9.075697e-01            0
      957   431_4754011       maxN  1.017727e+00 7.491234e-01            0
      958   431_4754011    Shannon -1.194718e-02 2.301487e-01            0
      959   431_4754011 expShannon -1.906828e-02 2.362964e-01            0
      960   431_4754011    Simpson -1.018015e-02 2.131599e-01            0
      961   431_4754011 invSimpson -2.321404e-02 2.154442e-01            0
      962   431_4754011        PIE -1.537202e-02 2.345557e-01            0
      963   431_4754011      DomMc -6.412994e-05 6.285707e-01            0
      964   431_4745247          S  1.190476e-01 2.122956e-01            0
      965   431_4745247          N -1.254762e+01 6.826728e-01            0
      966   431_4745247       maxN -1.257143e+01 6.835960e-01            0
      967   431_4745247    Shannon  1.185501e-01 2.630623e-01            0
      968   431_4745247 expShannon  2.251146e-01 2.414978e-01            0
      969   431_4745247    Simpson  7.428522e-02 2.493735e-01            0
      970   431_4745247 invSimpson  2.327501e-01 2.250568e-01            0
      971   431_4745247        PIE  1.139018e-01 2.370270e-01            0
      972   431_4745247      DomMc -3.968254e-02 2.122956e-01            0
      973   431_4752551          S -2.692308e-01 1.544210e-01            0
      974   431_4752551          N  3.976923e+01 5.450189e-01            0
      975   431_4752551       maxN  4.226923e+01 4.941742e-01            0
      976   431_4752551    Shannon -2.018384e-01 3.153556e-01            0
      977   431_4752551 expShannon -3.636575e-01 3.788702e-01            0
      978   431_4752551    Simpson -1.235599e-01 3.598756e-01            0
      979   431_4752551 invSimpson -3.388109e-01 4.470931e-01            0
      980   431_4752551        PIE -1.296678e-01 3.677693e-01            0
      981   431_4752551      DomMc  4.953989e-02 3.880008e-01            0
      982   431_4753280          S -9.210526e-02 4.065197e-01            0
      983   431_4753280          N -3.000000e+00 6.142777e-01            0
      984   431_4753280       maxN -2.223684e+00 5.233328e-01            0
      985   431_4753280    Shannon -1.246967e-03 9.625027e-01            0
      986   431_4753280 expShannon -2.953908e-03 9.524827e-01            0
      987   431_4753280    Simpson  3.726108e-03 8.571531e-01            0
      988   431_4753280 invSimpson  1.274799e-02 8.376327e-01            0
      989   431_4753280        PIE  4.523536e-03 7.847184e-01            0
      990   431_4753280      DomMc  1.509922e-03 4.065197e-01            0
      991   431_4751821          S -3.781864e-17 5.456289e-01            0
      992   431_4751821          N -9.285714e-01 8.629851e-01            0
      993   431_4751821       maxN -7.142857e-02 9.881448e-01            0
      994   431_4751821    Shannon -7.428825e-02 3.737079e-01            0
      995   431_4751821 expShannon -1.114607e-01 4.147888e-01            0
      996   431_4751821    Simpson -5.821294e-02 4.112069e-01            0
      997   431_4751821 invSimpson -1.106752e-01 5.135421e-01            0
      998   431_4751821        PIE -6.429744e-02 4.707128e-01            0
      999   431_4751821      DomMc -1.890932e-17 5.456289e-01            0
      1000  431_4756195          S -1.270954e-17 8.025442e-02            0
      1001  431_4756195          N  8.641686e-01 6.884443e-01            0
      1002  431_4756195       maxN  1.908665e-01 8.385110e-01            0
      1003  431_4756195    Shannon  1.559050e-02 4.543280e-01            0
      1004  431_4756195 expShannon  2.433301e-02 4.791181e-01            0
      1005  431_4756195    Simpson  1.264280e-02 4.792146e-01            0
      1006  431_4756195 invSimpson  2.720694e-02 5.228368e-01            0
      1007  431_4756195        PIE  1.297699e-02 4.582302e-01            0
      1008  431_4756195      DomMc -6.354771e-18 8.025442e-02            0
      1009   466_544469          S -5.919003e-02 8.560994e-01            0
      1010   466_544469          N -1.308157e+02 6.217510e-01            0
      1011   466_544469       maxN -7.772430e+01 2.867777e-01            0
      1012   466_544469    Shannon  1.872738e-02 1.563021e-01            0
      1013   466_544469 expShannon  6.943368e-02 1.621445e-01            0
      1014   466_544469    Simpson  6.936803e-03 4.236760e-01            0
      1015   466_544469 invSimpson  3.797686e-02 5.149626e-01            0
      1016   466_544469        PIE  6.957521e-03 4.224391e-01            0
      1017   466_544469      DomMc -4.625993e-03 4.750129e-01            0
      1018   466_541561          S  3.165183e-02 7.945677e-01            0
      1019   466_541561          N  2.631949e+01 5.318908e-01            0
      1020   466_541561       maxN  1.991197e+01 5.707342e-01            0
      1021   466_541561    Shannon  5.756986e-03 8.886868e-01            0
      1022   466_541561 expShannon  2.132369e-02 9.105356e-01            0
      1023   466_541561    Simpson  2.049607e-03 9.046503e-01            0
      1024   466_541561 invSimpson  3.322689e-03 9.810341e-01            0
      1025   466_541561        PIE  2.050914e-03 9.048083e-01            0
      1026   466_541561      DomMc -2.308544e-03 8.184047e-01            0
      1027   466_544468          S  1.688951e-02 9.257500e-01            0
      1028   466_544468          N -1.004457e+02 7.168597e-01            0
      1029   466_544468       maxN -6.413160e+01 6.656005e-01            0
      1030   466_544468    Shannon  1.537814e-03 8.562899e-01            0
      1031   466_544468 expShannon  4.631206e-04 9.876450e-01            0
      1032   466_544468    Simpson  9.500690e-04 7.689168e-01            0
      1033   466_544468 invSimpson  2.969217e-03 8.963689e-01            0
      1034   466_544468        PIE  9.540695e-04 7.680337e-01            0
      1035   466_544468      DomMc -1.897056e-03 5.687022e-01            0
      1036   466_541560          S -6.392440e-03 9.721857e-01            0
      1037   466_541560          N -6.997540e+01 4.998434e-01            0
      1038   466_541560       maxN -4.688216e+01 4.639202e-01            0
      1039   466_541560    Shannon  2.482172e-02 1.674911e-01            0
      1040   466_541560 expShannon  9.958623e-02 1.736661e-01            0
      1041   466_541560    Simpson  8.916843e-03 1.881967e-01            0
      1042   466_541560 invSimpson  6.526609e-02 2.066919e-01            0
      1043   466_541560        PIE  8.948562e-03 1.869508e-01            0
      1044   466_541560      DomMc -8.220121e-03 1.887958e-01            0
      1045   466_544470          S  1.767241e-02 9.013111e-01            0
      1046   466_544470          N -1.524575e+02 3.161752e-01            0
      1047   466_544470       maxN -1.169760e+02 3.250064e-01            0
      1048   466_544470    Shannon  1.438940e-02 3.926595e-01            0
      1049   466_544470 expShannon  3.554999e-02 5.441306e-01            0
      1050   466_544470    Simpson  8.826608e-03 1.900323e-01            0
      1051   466_544470 invSimpson  3.217283e-02 3.038935e-01            0
      1052   466_544470        PIE  8.844247e-03 1.897414e-01            0
      1053   466_544470      DomMc -2.689450e-03 5.362868e-01            0
      1054   466_540104          S  9.197508e-02 6.371136e-01            0
      1055   466_540104          N -3.659069e+01 5.472364e-01            0
      1056   466_540104       maxN -1.262221e+01 7.927110e-01            0
      1057   466_540104    Shannon  1.110758e-06 9.999632e-01            0
      1058   466_540104 expShannon  1.645360e-02 8.723357e-01            0
      1059   466_540104    Simpson -4.122198e-03 6.478838e-01            0
      1060   466_540104 invSimpson  1.794324e-02 7.970510e-01            0
      1061   466_540104        PIE -4.088304e-03 6.514772e-01            0
      1062   466_540104      DomMc -4.046585e-03 6.065454e-01            0
      1063   466_548115          S -3.112263e-01 9.971968e-03            1
      1064   466_548115          N -4.251426e+02 2.324346e-01            0
      1065   466_548115       maxN -2.773339e+02 2.293667e-01            0
      1066   466_548115    Shannon  2.080431e-02 4.166875e-02            1
      1067   466_548115 expShannon  8.770410e-02 4.161774e-02            1
      1068   466_548115    Simpson  6.579072e-03 1.040806e-01            0
      1069   466_548115 invSimpson  6.900454e-02 7.440724e-02            0
      1070   466_548115        PIE  6.597340e-03 1.036535e-01            0
      1071   466_548115      DomMc -6.861619e-03 1.504210e-01            0
      1072   466_560514          S  3.501946e-02 8.960523e-01            0
      1073   466_560514          N -1.139776e+02 8.138047e-02            0
      1074   466_560514       maxN -4.572860e+01 1.111874e-01            0
      1075   466_560514    Shannon  1.757613e-02 1.020108e-01            0
      1076   466_560514 expShannon  9.131331e-02 9.055735e-02            0
      1077   466_560514    Simpson  2.352421e-03 5.270018e-01            0
      1078   466_560514 invSimpson  3.769707e-02 4.531389e-01            0
      1079   466_560514        PIE  2.410372e-03 5.181401e-01            0
      1080   466_560514      DomMc -3.343600e-03 5.403760e-01            0
      1081   466_543001          S -2.508442e-02 8.675960e-01            0
      1082   466_543001          N  2.163177e+02 6.066250e-01            0
      1083   466_543001       maxN  2.271669e+02 5.785824e-01            0
      1084   466_543001    Shannon -1.818105e-02 5.498512e-01            0
      1085   466_543001 expShannon -6.727691e-02 5.469548e-01            0
      1086   466_543001    Simpson -8.566398e-03 5.380654e-01            0
      1087   466_543001 invSimpson -6.008561e-02 5.017964e-01            0
      1088   466_543001        PIE -8.552240e-03 5.394917e-01            0
      1089   466_543001      DomMc  5.514950e-03 5.595298e-01            0
      1090   466_569257          S -1.609907e-01 5.076350e-01            0
      1091   466_569257          N -2.271899e+02 1.769401e-02            1
      1092   466_569257       maxN -1.713540e+02 9.534052e-03            1
      1093   466_569257    Shannon  6.350408e-02 5.750233e-04            1
      1094   466_569257 expShannon  2.876667e-01 3.656914e-04            1
      1095   466_569257    Simpson  2.427562e-02 5.428383e-04            1
      1096   466_569257 invSimpson  2.500076e-01 1.924978e-04            1
      1097   466_569257        PIE  2.439476e-02 5.243167e-04            1
      1098   466_569257      DomMc -2.469805e-02 7.523466e-04            1
      1099   466_540834          S -8.767123e-02 7.946822e-01            0
      1100   466_540834          N -8.838356e+00 9.612549e-01            0
      1101   466_540834       maxN  6.841096e+00 9.531859e-01            0
      1102   466_540834    Shannon -1.976572e-02 4.502968e-01            0
      1103   466_540834 expShannon -9.201680e-02 4.337658e-01            0
      1104   466_540834    Simpson -8.937075e-03 3.623508e-01            0
      1105   466_540834 invSimpson -8.359846e-02 3.341405e-01            0
      1106   466_540834        PIE -8.905506e-03 3.679433e-01            0
      1107   466_540834      DomMc  5.845687e-03 5.688801e-01            0
      1108   466_540833          S -1.394737e+00 2.079746e-02            1
      1109   466_540833          N -5.378947e+01 9.237526e-01            0
      1110   466_540833       maxN -1.047368e+01 9.686336e-01            0
      1111   466_540833    Shannon -2.998044e-02 1.597328e-01            0
      1112   466_540833 expShannon -1.264710e-01 1.464832e-01            0
      1113   466_540833    Simpson -2.308791e-03 4.522839e-01            0
      1114   466_540833 invSimpson -2.383111e-02 4.542641e-01            0
      1115   466_540833        PIE -2.282521e-03 4.447935e-01            0
      1116   466_540833      DomMc -6.101013e-03 6.729757e-01            0
      1117   466_543011          S -1.271129e-01 4.617046e-01            0
      1118   466_543011          N -6.743164e+02 1.001448e-01            0
      1119   466_543011       maxN -5.146383e+02 1.364806e-01            0
      1120   466_543011    Shannon  5.391996e-02 1.941506e-02            1
      1121   466_543011 expShannon  2.476123e-01 9.081144e-03            1
      1122   466_543011    Simpson  1.743683e-02 5.251243e-02            0
      1123   466_543011 invSimpson  1.391616e-01 1.607685e-02            1
      1124   466_543011        PIE  1.759526e-02 5.087406e-02            0
      1125   466_543011      DomMc -1.461533e-02 2.513470e-02            1
      1126   466_541549          S -2.409403e-01 1.800546e-01            0
      1127   466_541549          N -8.240137e+02 4.015282e-01            0
      1128   466_541549       maxN -4.306464e+02 5.927532e-01            0
      1129   466_541549    Shannon  2.890983e-03 8.710288e-01            0
      1130   466_541549 expShannon  2.221395e-02 6.924699e-01            0
      1131   466_541549    Simpson -3.589758e-03 6.751102e-01            0
      1132   466_541549 invSimpson  4.157294e-03 9.218177e-01            0
      1133   466_541549        PIE -3.583675e-03 6.757997e-01            0
      1134   466_541549      DomMc -3.964549e-03 4.017383e-01            0
      1135   466_545198          S -2.027882e-01 1.306335e-01            0
      1136   466_545198          N -1.806183e+02 2.615831e-01            0
      1137   466_545198       maxN -1.158516e+02 2.627106e-01            0
      1138   466_545198    Shannon  3.145668e-03 7.635711e-01            0
      1139   466_545198 expShannon  1.179148e-02 7.628268e-01            0
      1140   466_545198    Simpson  3.472222e-03 4.439179e-01            0
      1141   466_545198 invSimpson  2.127399e-02 4.892874e-01            0
      1142   466_545198        PIE  3.510203e-03 4.405192e-01            0
      1143   466_545198      DomMc -1.772301e-03 6.313658e-01            0
      1144   466_559051          S -1.552076e-01 2.175546e-01            0
      1145   466_559051          N -6.830085e+02 1.839484e-02            1
      1146   466_559051       maxN -6.741569e+02 1.829031e-02            1
      1147   466_559051    Shannon  5.294853e-02 8.901599e-03            1
      1148   466_559051 expShannon  1.394639e-01 3.338149e-02            1
      1149   466_559051    Simpson  2.417374e-02 1.277731e-02            1
      1150   466_559051 invSimpson  8.767537e-02 7.405911e-02            0
      1151   466_559051        PIE  2.420985e-02 1.270456e-02            1
      1152   466_559051      DomMc -1.150398e-02 2.765261e-02            1
      1153   466_543738          S -1.384615e+00 1.789124e-01            0
      1154   466_543738          N -1.838077e+02 4.814656e-01            0
      1155   466_543738       maxN -6.826923e+01 1.435046e-01            0
      1156   466_543738    Shannon -1.309078e-01 2.432047e-02            1
      1157   466_543738 expShannon -5.147663e-01 5.123622e-02            0
      1158   466_543738    Simpson -3.270880e-02 2.327378e-01            0
      1159   466_543738 invSimpson -2.733728e-01 2.093482e-01            0
      1160   466_543738        PIE -3.269956e-02 2.324324e-01            0
      1161   466_543738      DomMc  4.395012e-02 1.210226e-01            0
      1162   466_547388          S -2.983369e-01 1.237530e-02            1
      1163   466_547388          N -2.197219e+02 2.251657e-01            0
      1164   466_547388       maxN -2.183896e+02 1.459682e-01            0
      1165   466_547388    Shannon  4.095909e-02 6.287888e-04            1
      1166   466_547388 expShannon  1.187399e-01 7.432008e-04            1
      1167   466_547388    Simpson  2.181327e-02 2.821371e-04            1
      1168   466_547388 invSimpson  9.573052e-02 3.258637e-04            1
      1169   466_547388        PIE  2.188202e-02 2.764423e-04            1
      1170   466_547388      DomMc -9.567597e-03 1.831883e-03            1
      1171   466_565614          S -3.729013e-01 3.986049e-03            1
      1172   466_565614          N -4.472085e+02 1.956557e-01            0
      1173   466_565614       maxN -3.835802e+02 2.378750e-01            0
      1174   466_565614    Shannon  2.749309e-02 2.506963e-01            0
      1175   466_565614 expShannon  7.839500e-02 3.948194e-01            0
      1176   466_565614    Simpson  1.289913e-02 1.823065e-01            0
      1177   466_565614 invSimpson  6.430337e-02 2.511468e-01            0
      1178   466_565614        PIE  1.299761e-02 1.800076e-01            0
      1179   466_565614      DomMc -9.807105e-03 1.124925e-01            0
      1180   466_562698          S -8.000000e-01 5.219086e-01            0
      1181   466_562698          N  1.408000e+02 4.471387e-01            0
      1182   466_562698       maxN  6.230000e+01 3.913342e-01            0
      1183   466_562698    Shannon -2.482440e-02 3.199721e-01            0
      1184   466_562698 expShannon -1.080317e-01 3.303018e-01            0
      1185   466_562698    Simpson -7.669716e-03 4.708373e-01            0
      1186   466_562698 invSimpson -8.228671e-02 4.518724e-01            0
      1187   466_562698        PIE -7.789947e-03 4.436779e-01            0
      1188   466_562698      DomMc  1.361316e-02 3.848604e-01            0
      1189   466_559779          S -9.716599e-02 8.480712e-01            0
      1190   466_559779          N -6.768765e+02 2.065512e-01            0
      1191   466_559779       maxN -6.285911e+02 1.611559e-01            0
      1192   466_559779    Shannon  7.619163e-02 1.344490e-01            0
      1193   466_559779 expShannon  2.906118e-01 1.265696e-01            0
      1194   466_559779    Simpson  3.565061e-02 8.249479e-02            0
      1195   466_559779 invSimpson  2.654719e-01 4.884091e-02            1
      1196   466_559779        PIE  3.567813e-02 8.245216e-02            0
      1197   466_559779      DomMc -2.649622e-02 9.103407e-02            0
      1198   466_560509          S -3.038991e-02 8.445347e-01            0
      1199   466_560509          N -3.324759e+02 1.287368e-01            0
      1200   466_560509       maxN -2.988148e+02 1.327549e-01            0
      1201   466_560509    Shannon  3.356146e-02 2.015535e-01            0
      1202   466_560509 expShannon  1.593749e-01 1.584879e-01            0
      1203   466_560509    Simpson  1.160665e-02 2.629046e-01            0
      1204   466_560509 invSimpson  1.206179e-01 1.629396e-01            0
      1205   466_560509        PIE  1.165866e-02 2.622104e-01            0
      1206   466_560509      DomMc -7.857267e-03 3.411868e-01            0
      1207   466_545919          S -1.729428e-01 4.299466e-01            0
      1208   466_545919          N  4.094840e+01 6.568388e-01            0
      1209   466_545919       maxN  1.400558e+01 7.029317e-01            0
      1210   466_545919    Shannon -1.667369e-02 4.432528e-01            0
      1211   466_545919 expShannon -9.332762e-02 3.800629e-01            0
      1212   466_545919    Simpson -2.679478e-03 6.805114e-01            0
      1213   466_545919 invSimpson -5.795758e-02 5.436764e-01            0
      1214   466_545919        PIE -2.780515e-03 6.719307e-01            0
      1215   466_545919      DomMc  7.515372e-03 5.093157e-01            0
      1216   466_545912          S  4.341927e-02 7.367382e-01            0
      1217   466_545912          N -5.194335e+01 5.289993e-01            0
      1218   466_545912       maxN -5.652408e+01 4.358391e-01            0
      1219   466_545912    Shannon  1.578589e-02 4.401195e-01            0
      1220   466_545912 expShannon  5.233282e-02 4.900127e-01            0
      1221   466_545912    Simpson  7.850811e-03 3.835403e-01            0
      1222   466_545912 invSimpson  3.446297e-02 5.492371e-01            0
      1223   466_545912        PIE  7.867058e-03 3.837426e-01            0
      1224   466_545912      DomMc -1.850262e-03 7.565176e-01            0
      1225   466_548798          S -4.431818e-02 3.954852e-01            0
      1226   466_548798          N -1.157795e+02 1.873616e-01            0
      1227   466_548798       maxN -9.420341e+01 1.926820e-01            0
      1228   466_548798    Shannon  2.080258e-02 1.650194e-02            1
      1229   466_548798 expShannon  4.953568e-02 1.519578e-02            1
      1230   466_548798    Simpson  1.221954e-02 1.454024e-02            1
      1231   466_548798 invSimpson  3.916556e-02 1.772537e-02            1
      1232   466_548798        PIE  1.225710e-02 1.437400e-02            1
      1233   466_548798      DomMc -2.969433e-03 8.492968e-02            0
      1234   466_552442          S  4.970446e-03 9.416271e-01            0
      1235   466_552442          N -1.676260e+02 8.713525e-03            1
      1236   466_552442       maxN -1.591812e+02 2.317459e-03            1
      1237   466_552442    Shannon  1.673089e-02 1.538692e-01            0
      1238   466_552442 expShannon  2.837249e-02 3.677507e-01            0
      1239   466_552442    Simpson  1.125856e-02 5.781345e-02            0
      1240   466_552442 invSimpson  2.408039e-02 3.149462e-01            0
      1241   466_552442        PIE  1.130481e-02 5.698128e-02            0
      1242   466_552442      DomMc -2.343842e-04 9.366891e-01            0
      1243   466_553900          S  2.307692e-01 4.116516e-01            0
      1244   466_553900          N  2.066154e+02 4.862828e-01            0
      1245   466_553900       maxN -6.153846e+00 9.861988e-01            0
      1246   466_553900    Shannon  1.767076e-01 2.045926e-01            0
      1247   466_553900 expShannon  3.798808e-01 1.976604e-01            0
      1248   466_553900    Simpson  9.367946e-02 2.390792e-01            0
      1249   466_553900 invSimpson  2.649822e-01 2.168041e-01            0
      1250   466_553900        PIE  9.371065e-02 2.390974e-01            0
      1251   466_553900      DomMc -2.573846e-02 1.878448e-01            0
      1252   466_555359          S -5.831409e-02 2.393715e-01            0
      1253   466_555359          N  1.866478e+02 4.091092e-01            0
      1254   466_555359       maxN  1.775987e+02 4.084232e-01            0
      1255   466_555359    Shannon  2.944771e-03 8.117775e-01            0
      1256   466_555359 expShannon  2.591841e-03 9.130099e-01            0
      1257   466_555359    Simpson -6.217137e-04 9.389364e-01            0
      1258   466_555359 invSimpson -6.994365e-03 7.343109e-01            0
      1259   466_555359        PIE -6.221252e-04 9.389169e-01            0
      1260   466_555359      DomMc -1.752658e-03 4.684792e-01            0
      1261   466_559004          S  2.271497e-01 3.754155e-05            1
      1262   466_559004          N -3.147429e+01 8.500441e-01            0
      1263   466_559004       maxN -2.763877e+01 8.156142e-01            0
      1264   466_559004    Shannon  1.173420e-02 2.895347e-01            0
      1265   466_559004 expShannon  1.900833e-02 3.482835e-01            0
      1266   466_559004    Simpson  5.514462e-03 4.167371e-01            0
      1267   466_559004 invSimpson  9.492243e-03 5.591839e-01            0
      1268   466_559004        PIE  5.520773e-03 4.162778e-01            0
      1269   466_559004      DomMc -1.256566e-03 3.700424e-01            0
      1270   466_553901          S  2.528573e-03 9.657426e-01            0
      1271   466_553901          N -1.871620e+02 4.014946e-02            1
      1272   466_553901       maxN -1.712800e+02 2.476912e-02            1
      1273   466_553901    Shannon  2.108296e-02 3.784119e-02            1
      1274   466_553901 expShannon  4.057981e-02 5.588397e-02            0
      1275   466_553901    Simpson  1.156529e-02 3.920410e-02            1
      1276   466_553901 invSimpson  2.728315e-02 6.031118e-02            0
      1277   466_553901        PIE  1.159726e-02 3.879820e-02            1
      1278   466_553901      DomMc -2.456206e-03 2.726284e-01            0
      1279   466_552446          S  8.914769e-02 4.966080e-02            1
      1280   466_552446          N -1.348753e+02 2.258430e-01            0
      1281   466_552446       maxN -1.513115e+02 1.447055e-01            0
      1282   466_552446    Shannon  3.806781e-02 3.004699e-03            1
      1283   466_552446 expShannon  8.224471e-02 2.023344e-03            1
      1284   466_552446    Simpson  2.070362e-02 2.397764e-03            1
      1285   466_552446 invSimpson  5.467074e-02 1.382549e-03            1
      1286   466_552446        PIE  2.071671e-02 2.401680e-03            1
      1287   466_552446      DomMc -6.230225e-03 1.079722e-02            1
      1288   466_553171          S  5.902539e-02 3.355153e-01            0
      1289   466_553171          N -3.518236e+02 9.265995e-03            1
      1290   466_553171       maxN -2.925580e+02 1.877429e-02            1
      1291   466_553171    Shannon  2.537766e-02 8.906451e-02            0
      1292   466_553171 expShannon  5.630132e-02 6.786208e-02            0
      1293   466_553171    Simpson  1.256496e-02 2.084754e-01            0
      1294   466_553171 invSimpson  3.931970e-02 1.549547e-01            0
      1295   466_553171        PIE  1.259281e-02 2.076953e-01            0
      1296   466_553171      DomMc -4.351266e-03 1.922729e-01            0
      1297   466_553175          S -5.936018e-02 4.736109e-01            0
      1298   466_553175          N -1.756295e+02 3.959588e-01            0
      1299   466_553175       maxN -1.624765e+02 3.826750e-01            0
      1300   466_553175    Shannon  2.273234e-02 2.274416e-01            0
      1301   466_553175 expShannon  5.832529e-02 2.362555e-01            0
      1302   466_553175    Simpson  1.241114e-02 1.813451e-01            0
      1303   466_553175 invSimpson  4.850607e-02 1.759035e-01            0
      1304   466_553175        PIE  1.244583e-02 1.808179e-01            0
      1305   466_553175      DomMc -5.271797e-03 2.415385e-01            0
      1306   466_556090          S -5.917160e-03 9.755086e-01            0
      1307   466_556090          N -6.011538e+01 7.443456e-01            0
      1308   466_556090       maxN -1.083491e+02 5.229514e-01            0
      1309   466_556090    Shannon  3.599970e-02 3.411866e-02            1
      1310   466_556090 expShannon  8.076913e-02 1.533180e-02            1
      1311   466_556090    Simpson  2.574512e-02 1.235443e-02            1
      1312   466_556090 invSimpson  7.727218e-02 1.009856e-01            0
      1313   466_556090        PIE  2.576073e-02 1.218023e-02            1
      1314   466_556090      DomMc -7.586934e-04 8.161208e-01            0
      1315   466_557547          S  1.119254e-01 1.857117e-01            0
      1316   466_557547          N -2.103058e+02 4.984011e-02            1
      1317   466_557547       maxN -1.652139e+02 5.988173e-02            0
      1318   466_557547    Shannon  1.297547e-02 3.461267e-01            0
      1319   466_557547 expShannon  3.168302e-02 3.177919e-01            0
      1320   466_557547    Simpson  5.001365e-03 5.091801e-01            0
      1321   466_557547 invSimpson  1.823699e-02 4.076683e-01            0
      1322   466_557547        PIE  5.014442e-03 5.084020e-01            0
      1323   466_557547      DomMc -4.207446e-03 1.655034e-01            0
      1324   466_554630          S -5.502063e-02 5.453826e-01            0
      1325   466_554630          N -2.990399e+02 2.976687e-01            0
      1326   466_554630       maxN -3.061176e+02 2.710251e-01            0
      1327   466_554630    Shannon  2.126313e-02 1.394427e-01            0
      1328   466_554630 expShannon  4.205106e-02 1.717648e-01            0
      1329   466_554630    Simpson  1.414269e-02 8.213106e-02            0
      1330   466_554630 invSimpson  3.438489e-02 1.735218e-01            0
      1331   466_554630        PIE  1.416929e-02 8.169180e-02            0
      1332   466_554630      DomMc -2.117330e-03 5.556714e-01            0
      1333   466_553902          S  6.959315e-02 5.966378e-01            0
      1334   466_553902          N -5.511424e+02 1.652128e-02            1
      1335   466_553902       maxN -4.808630e+02 1.198545e-02            1
      1336   466_553902    Shannon  4.186079e-03 8.199702e-01            0
      1337   466_553902 expShannon  6.468733e-03 8.498965e-01            0
      1338   466_553902    Simpson -1.222013e-03 9.178958e-01            0
      1339   466_553902 invSimpson -3.825398e-03 8.822088e-01            0
      1340   466_553902        PIE -1.220277e-03 9.180167e-01            0
      1341   466_553902      DomMc -2.362812e-03 4.779047e-01            0
      1342   466_549529          S -2.254374e-02 7.899428e-01            0
      1343   466_549529          N -9.271198e+01 8.129902e-01            0
      1344   466_549529       maxN -1.208449e+02 7.412665e-01            0
      1345   466_549529    Shannon  3.915394e-02 7.517323e-02            0
      1346   466_549529 expShannon  8.657664e-02 8.815155e-02            0
      1347   466_549529    Simpson  2.260190e-02 5.694035e-02            0
      1348   466_549529 invSimpson  6.544324e-02 8.822239e-02            0
      1349   466_549529        PIE  2.261291e-02 5.690625e-02            0
      1350   466_549529      DomMc -8.679368e-03 1.416694e-01            0
      1351   466_551714          S  1.032389e-01 1.326942e-01            0
      1352   466_551714          N -6.686987e+02 3.829424e-01            0
      1353   466_551714       maxN -6.795931e+02 3.814540e-01            0
      1354   466_551714    Shannon  5.800959e-03 8.239849e-01            0
      1355   466_551714 expShannon  9.085310e-03 8.880915e-01            0
      1356   466_551714    Simpson  3.893300e-03 7.825503e-01            0
      1357   466_551714 invSimpson  9.348562e-03 8.594826e-01            0
      1358   466_551714        PIE  3.894251e-03 7.826228e-01            0
      1359   466_551714      DomMc  7.512327e-04 9.084889e-01            0
      1360   466_550254          S -1.709469e-01 7.598204e-02            0
      1361   466_550254          N  1.477942e+02 6.184815e-01            0
      1362   466_550254       maxN  1.630777e+02 5.303321e-01            0
      1363   466_550254    Shannon -1.274102e-02 3.887126e-01            0
      1364   466_550254 expShannon -2.156307e-02 5.132018e-01            0
      1365   466_550254    Simpson -5.433213e-03 4.895276e-01            0
      1366   466_550254 invSimpson -7.946563e-03 7.525540e-01            0
      1367   466_550254        PIE -5.424986e-03 4.905679e-01            0
      1368   466_550254      DomMc  1.525394e-03 6.662719e-01            0
      1369   466_549527          S -1.079755e-01 2.156074e-01            0
      1370   466_549527          N -1.709387e+01 8.888293e-01            0
      1371   466_549527       maxN  2.404294e+00 9.830125e-01            0
      1372   466_549527    Shannon -9.264749e-03 5.719298e-01            0
      1373   466_549527 expShannon -3.304073e-02 4.979981e-01            0
      1374   466_549527    Simpson -8.613688e-04 9.151555e-01            0
      1375   466_549527 invSimpson -1.492222e-02 6.965700e-01            0
      1376   466_549527        PIE -8.511151e-04 9.162168e-01            0
      1377   466_549527      DomMc  6.765168e-03 1.621529e-01            0
      1378   466_553903          S -9.512625e-02 3.848880e-01            0
      1379   466_553903          N -2.774686e+02 2.782647e-01            0
      1380   466_553903       maxN -2.826514e+02 2.138599e-01            0
      1381   466_553903    Shannon  2.794148e-02 2.648997e-02            1
      1382   466_553903 expShannon  5.513184e-02 3.725340e-02            1
      1383   466_553903    Simpson  1.537415e-02 4.407034e-02            1
      1384   466_553903 invSimpson  3.845912e-02 6.645414e-02            0
      1385   466_553903        PIE  1.538171e-02 4.400217e-02            1
      1386   466_553903      DomMc -4.014669e-03 1.333440e-02            1
      1387   466_550258          S  1.757469e-02 7.741247e-01            0
      1388   466_550258          N -4.399253e+01 8.328439e-01            0
      1389   466_550258       maxN -1.080633e+02 4.441548e-01            0
      1390   466_550258    Shannon  3.250419e-02 2.250255e-01            0
      1391   466_550258 expShannon  5.431758e-02 2.970065e-01            0
      1392   466_550258    Simpson  1.642520e-02 3.133381e-01            0
      1393   466_550258 invSimpson  3.237075e-02 4.824440e-01            0
      1394   466_550258        PIE  1.643492e-02 3.130862e-01            0
      1395   466_550258      DomMc -5.601567e-03 3.915247e-01            0
      1396   466_556089          S  1.327739e-01 1.602597e-01            0
      1397   466_556089          N -2.080136e+02 9.137276e-02            0
      1398   466_556089       maxN -1.817853e+02 8.832058e-02            0
      1399   466_556089    Shannon  2.681679e-02 4.277835e-02            1
      1400   466_556089 expShannon  7.321525e-02 4.718908e-02            1
      1401   466_556089    Simpson  1.213602e-02 8.047659e-02            0
      1402   466_556089 invSimpson  5.758712e-02 7.659997e-02            0
      1403   466_556089        PIE  1.215108e-02 8.036413e-02            0
      1404   466_556089      DomMc -8.566565e-03 4.685136e-02            1
      1405   466_556091          S  1.573046e-01 9.903977e-03            1
      1406   466_556091          N -7.608177e+01 1.008978e-01            0
      1407   466_556091       maxN -9.278584e+01 2.383873e-02            1
      1408   466_556091    Shannon  4.684963e-02 2.717684e-03            1
      1409   466_556091 expShannon  1.310501e-01 4.807023e-03            1
      1410   466_556091    Simpson  2.351459e-02 1.403701e-03            1
      1411   466_556091 invSimpson  9.972983e-02 4.198789e-03            1
      1412   466_556091        PIE  2.357734e-02 1.405973e-03            1
      1413   466_556091      DomMc -1.036211e-02 1.447669e-02            1
      1414   466_556092          S  9.369025e-02 1.315277e-01            0
      1415   466_556092          N -1.837349e+02 2.146216e-01            0
      1416   466_556092       maxN -1.783773e+02 2.044668e-01            0
      1417   466_556092    Shannon  3.095189e-02 1.436082e-01            0
      1418   466_556092 expShannon  1.125367e-01 1.440885e-01            0
      1419   466_556092    Simpson  1.247307e-02 1.675715e-01            0
      1420   466_556092 invSimpson  1.003589e-01 1.250167e-01            0
      1421   466_556092        PIE  1.256181e-02 1.663763e-01            0
      1422   466_556092      DomMc -8.442066e-03 1.787569e-01            0
      1423   466_553904          S  4.832057e-02 3.487638e-01            0
      1424   466_553904          N -1.803363e+02 2.560480e-01            0
      1425   466_553904       maxN -1.560448e+02 3.135651e-01            0
      1426   466_553904    Shannon  1.789609e-02 6.625592e-02            0
      1427   466_553904 expShannon  3.591421e-02 5.232204e-02            0
      1428   466_553904    Simpson  6.869457e-03 2.155916e-01            0
      1429   466_553904 invSimpson  1.444060e-02 2.280509e-01            0
      1430   466_553904        PIE  6.891790e-03 2.146608e-01            0
      1431   466_553904      DomMc -5.096534e-03 2.127390e-03            1
      1432   466_552445          S -3.637566e-03 9.697755e-01            0
      1433   466_552445          N -7.616286e+01 5.849462e-01            0
      1434   466_552445       maxN -8.135450e+01 4.900832e-01            0
      1435   466_552445    Shannon  1.529389e-02 2.962509e-01            0
      1436   466_552445 expShannon  2.850330e-02 3.448931e-01            0
      1437   466_552445    Simpson  8.181071e-03 3.011512e-01            0
      1438   466_552445 invSimpson  1.578071e-02 4.147768e-01            0
      1439   466_552445        PIE  8.188624e-03 3.008999e-01            0
      1440   466_552445      DomMc -2.914145e-03 2.936981e-01            0
      1441   466_554632          S  1.597773e-01 2.451900e-02            1
      1442   466_554632          N -4.109156e+02 3.782582e-01            0
      1443   466_554632       maxN -3.951296e+02 1.780242e-01            0
      1444   466_554632    Shannon  4.924843e-02 3.355339e-04            1
      1445   466_554632 expShannon  1.008667e-01 1.905828e-04            1
      1446   466_554632    Simpson  2.280985e-02 2.722534e-03            1
      1447   466_554632 invSimpson  5.336026e-02 3.249690e-03            1
      1448   466_554632        PIE  2.283607e-02 2.698905e-03            1
      1449   466_554632      DomMc -9.896437e-03 1.627278e-03            1
      1450   466_556818          S  1.000000e+00 2.721805e-14            1
      1451   466_556818          N -2.506429e+02 5.029834e-01            0
      1452   466_556818       maxN -3.775714e+02 2.816882e-01            0
      1453   466_556818    Shannon  1.977807e-01 2.407331e-01            0
      1454   466_556818 expShannon  3.960820e-01 2.334909e-01            0
      1455   466_556818    Simpson  1.003300e-01 2.319368e-01            0
      1456   466_556818 invSimpson  2.041088e-01 2.254441e-01            0
      1457   466_556818        PIE  1.003802e-01 2.318950e-01            0
      1458   466_556818      DomMc -1.816704e-02 3.146567e-01            0
      1459   466_556088          S  1.328976e-01 3.828755e-01            0
      1460   466_556088          N -7.380185e+02 8.119958e-02            0
      1461   466_556088       maxN -4.899336e+02 4.974822e-02            1
      1462   466_556088    Shannon  1.993526e-02 1.209707e-01            0
      1463   466_556088 expShannon  5.069230e-02 1.022688e-01            0
      1464   466_556088    Simpson  7.008899e-03 3.588641e-01            0
      1465   466_556088 invSimpson  2.894357e-02 2.878659e-01            0
      1466   466_556088        PIE  7.019834e-03 3.582758e-01            0
      1467   466_556088      DomMc -4.488659e-03 2.126341e-01            0
      1468   466_550255          S -1.819580e-01 1.404040e-01            0
      1469   466_550255          N -4.359621e+02 1.951066e-02            1
      1470   466_550255       maxN -2.879595e+02 7.749457e-03            1
      1471   466_550255    Shannon  2.283403e-04 9.896457e-01            0
      1472   466_550255 expShannon -1.111936e-02 7.964197e-01            0
      1473   466_550255    Simpson  1.899003e-03 8.588078e-01            0
      1474   466_550255 invSimpson -1.326860e-02 7.580714e-01            0
      1475   466_550255        PIE  1.910403e-03 8.579888e-01            0
      1476   466_550255      DomMc  4.838032e-03 3.907186e-01            0
      1477   466_553905          S  1.131222e-01 3.830147e-01            0
      1478   466_553905          N -3.661742e+02 1.706022e-01            0
      1479   466_553905       maxN -2.894118e+02 1.080249e-01            0
      1480   466_553905    Shannon  5.235038e-02 1.932662e-02            1
      1481   466_553905 expShannon  1.291201e-01 2.421291e-02            1
      1482   466_553905    Simpson  2.229011e-02 4.157315e-02            1
      1483   466_553905 invSimpson  7.751703e-02 5.111492e-02            0
      1484   466_553905        PIE  2.237774e-02 4.126267e-02            1
      1485   466_553905      DomMc -1.297362e-02 1.408984e-02            1
      1486   466_555362          S  1.527650e-01 5.134594e-02            0
      1487   466_555362          N -9.165553e+01 1.471173e-01            0
      1488   466_555362       maxN -9.511544e+01 8.298761e-02            0
      1489   466_555362    Shannon  3.194288e-02 2.027577e-01            0
      1490   466_555362 expShannon  8.005447e-02 2.826162e-01            0
      1491   466_555362    Simpson  1.425819e-02 2.337099e-01            0
      1492   466_555362 invSimpson  4.989975e-02 3.413479e-01            0
      1493   466_555362        PIE  1.428753e-02 2.339120e-01            0
      1494   466_555362      DomMc -7.050848e-03 2.715114e-01            0
      1495   466_559733          S  4.226434e-02 5.916719e-01            0
      1496   466_559733          N -2.225569e+02 3.573527e-01            0
      1497   466_559733       maxN -1.341647e+02 3.195039e-01            0
      1498   466_559733    Shannon  5.154347e-03 7.470043e-01            0
      1499   466_559733 expShannon  6.879325e-03 8.544147e-01            0
      1500   466_559733    Simpson  1.948203e-03 8.317651e-01            0
      1501   466_559733 invSimpson -1.321576e-03 9.673428e-01            0
      1502   466_559733        PIE  1.960807e-03 8.308347e-01            0
      1503   466_559733      DomMc -1.260792e-04 9.712181e-01            0
      1504   466_557548          S  2.388906e-01 3.884923e-04            1
      1505   466_557548          N -1.332971e+02 1.537452e-01            0
      1506   466_557548       maxN -1.310889e+02 1.336900e-01            0
      1507   466_557548    Shannon  3.145747e-02 4.051526e-02            1
      1508   466_557548 expShannon  6.983652e-02 9.420753e-02            0
      1509   466_557548    Simpson  1.388085e-02 5.489579e-02            0
      1510   466_557548 invSimpson  3.965677e-02 1.696367e-01            0
      1511   466_557548        PIE  1.391920e-02 5.464587e-02            0
      1512   466_557548      DomMc -5.948275e-03 1.074148e-01            0
      1513   466_550256          S  1.661743e-02 7.766974e-01            0
      1514   466_550256          N -1.202548e+01 8.858583e-01            0
      1515   466_550256       maxN -5.648301e+01 4.551750e-01            0
      1516   466_550256    Shannon  4.206335e-02 4.318557e-03            1
      1517   466_550256 expShannon  9.820786e-02 6.337566e-03            1
      1518   466_550256    Simpson  2.501396e-02 1.269455e-03            1
      1519   466_550256 invSimpson  8.215635e-02 3.508333e-03            1
      1520   466_550256        PIE  2.502297e-02 1.271797e-03            1
      1521   466_550256      DomMc -7.486051e-03 2.565950e-02            1
      1522   466_554634          S  8.955765e-02 4.332420e-01            0
      1523   466_554634          N -1.831672e+02 1.252007e-01            0
      1524   466_554634       maxN -1.905540e+02 1.027023e-01            0
      1525   466_554634    Shannon  2.800352e-02 2.365236e-01            0
      1526   466_554634 expShannon  5.287863e-02 3.021771e-01            0
      1527   466_554634    Simpson  1.352084e-02 2.301714e-01            0
      1528   466_554634 invSimpson  2.819782e-02 3.141248e-01            0
      1529   466_554634        PIE  1.351635e-02 2.311366e-01            0
      1530   466_554634      DomMc -4.816175e-03 3.358887e-01            0
      1531   466_554631          S  1.721470e-01 4.951660e-01            0
      1532   466_554631          N -5.469130e+02 4.519147e-02            1
      1533   466_554631       maxN -3.847805e+02 8.644738e-02            0
      1534   466_554631    Shannon  2.508894e-03 9.080931e-01            0
      1535   466_554631 expShannon -2.184859e-04 9.970307e-01            0
      1536   466_554631    Simpson  1.645824e-03 8.769242e-01            0
      1537   466_554631 invSimpson -2.558356e-03 9.563118e-01            0
      1538   466_554631        PIE  1.658612e-03 8.760111e-01            0
      1539   466_554631      DomMc  6.753398e-03 4.228298e-01            0
      1540   466_553176          S  3.453307e-02 7.939738e-01            0
      1541   466_553176          N -5.802967e+01 5.902878e-01            0
      1542   466_553176       maxN -6.836673e+01 3.579405e-01            0
      1543   466_553176    Shannon  2.075922e-02 3.157093e-01            0
      1544   466_553176 expShannon  3.886721e-02 4.119493e-01            0
      1545   466_553176    Simpson  1.247456e-02 2.603718e-01            0
      1546   466_553176 invSimpson  3.410652e-02 2.955236e-01            0
      1547   466_553176        PIE  1.247913e-02 2.606439e-01            0
      1548   466_553176      DomMc -1.858553e-03 6.888375e-01            0
      1549   466_556819          S  2.914418e-01 1.075400e-03            1
      1550   466_556819          N -8.998901e+01 7.542274e-01            0
      1551   466_556819       maxN -1.732226e+02 4.871067e-01            0
      1552   466_556819    Shannon  5.115565e-02 4.165138e-03            1
      1553   466_556819 expShannon  1.109347e-01 1.459113e-02            1
      1554   466_556819    Simpson  2.823605e-02 4.813484e-04            1
      1555   466_556819 invSimpson  7.958476e-02 4.012746e-03            1
      1556   466_556819        PIE  2.826079e-02 4.885738e-04            1
      1557   466_556819      DomMc -8.123916e-03 8.884500e-02            0
      1558   466_550984          S  6.432193e-02 4.551722e-01            0
      1559   466_550984          N -2.924534e+02 2.422336e-02            1
      1560   466_550984       maxN -2.113530e+02 2.191813e-02            1
      1561   466_550984    Shannon  4.045293e-05 9.972526e-01            0
      1562   466_550984 expShannon  1.658695e-03 9.574457e-01            0
      1563   466_550984    Simpson  1.797722e-03 7.769638e-01            0
      1564   466_550984 invSimpson  7.991052e-03 7.615529e-01            0
      1565   466_550984        PIE  1.814605e-03 7.750288e-01            0
      1566   466_550984      DomMc  3.119489e-03 3.756228e-01            0
      1567   466_561188          S  3.035714e-01 2.999501e-01            0
      1568   466_561188          N -4.005357e+01 9.819930e-01            0
      1569   466_561188       maxN -8.950000e+01 9.263240e-01            0
      1570   466_561188    Shannon  2.407571e-02 2.701048e-01            0
      1571   466_561188 expShannon  5.541957e-02 2.920292e-01            0
      1572   466_561188    Simpson  9.544909e-03 9.762643e-02            0
      1573   466_561188 invSimpson  3.864285e-02 1.413554e-01            0
      1574   466_561188        PIE  9.560025e-03 9.868939e-02            0
      1575   466_561188      DomMc -4.433171e-03 3.915008e-01            0
      1576   466_558274          S  9.699170e-02 6.466084e-02            0
      1577   466_558274          N -7.687217e+02 2.190703e-01            0
      1578   466_558274       maxN -6.963846e+02 1.959377e-01            0
      1579   466_558274    Shannon  3.164643e-02 1.099101e-02            1
      1580   466_558274 expShannon  6.674140e-02 2.085579e-02            1
      1581   466_558274    Simpson  1.845005e-02 2.146134e-02            1
      1582   466_558274 invSimpson  5.238558e-02 5.209056e-02            0
      1583   466_558274        PIE  1.846215e-02 2.141723e-02            1
      1584   466_558274      DomMc -5.126513e-03 8.853438e-02            0
      1585   466_555361          S -1.242718e-02 7.092626e-01            0
      1586   466_555361          N -3.474435e+02 5.437287e-01            0
      1587   466_555361       maxN -2.976971e+02 6.062505e-01            0
      1588   466_555361    Shannon  6.239972e-02 3.243257e-02            1
      1589   466_555361 expShannon  1.628668e-01 1.463799e-02            1
      1590   466_555361    Simpson  2.670736e-02 7.451068e-02            0
      1591   466_555361 invSimpson  9.524115e-02 3.202193e-02            1
      1592   466_555361        PIE  2.679753e-02 7.390587e-02            0
      1593   466_555361      DomMc -1.454250e-02 4.564785e-03            1
      1594   466_553172          S -3.512397e-02 6.098143e-01            0
      1595   466_553172          N -3.504398e+02 1.468020e-03            1
      1596   466_553172       maxN -3.349096e+02 3.019297e-03            1
      1597   466_553172    Shannon  3.081150e-02 8.823266e-02            0
      1598   466_553172 expShannon  6.625742e-02 1.136848e-01            0
      1599   466_553172    Simpson  1.673407e-02 1.191400e-01            0
      1600   466_553172 invSimpson  4.666814e-02 1.958469e-01            0
      1601   466_553172        PIE  1.677282e-02 1.187989e-01            0
      1602   466_553172      DomMc -4.481974e-03 3.132830e-01            0
      1603   466_556087          S  2.215068e-01 7.231883e-02            0
      1604   466_556087          N  1.281165e+02 8.657649e-01            0
      1605   466_556087       maxN  1.281700e+02 8.600942e-01            0
      1606   466_556087    Shannon  7.408713e-03 6.739960e-01            0
      1607   466_556087 expShannon  1.631708e-02 6.386024e-01            0
      1608   466_556087    Simpson  1.430076e-03 9.039999e-01            0
      1609   466_556087 invSimpson  2.110328e-03 9.444832e-01            0
      1610   466_556087        PIE  1.430152e-03 9.040148e-01            0
      1611   466_556087      DomMc -4.331825e-03 4.928712e-02            1
      1612   466_548799          S  7.463405e-18 7.966236e-01            0
      1613   466_548799          N -3.853908e+02 2.878733e-02            1
      1614   466_548799       maxN -3.055210e+02 2.583434e-02            1
      1615   466_548799    Shannon  5.878286e-03 7.926370e-01            0
      1616   466_548799 expShannon  1.595308e-02 7.550000e-01            0
      1617   466_548799    Simpson  4.947798e-03 7.447388e-01            0
      1618   466_548799 invSimpson  2.094599e-02 6.812120e-01            0
      1619   466_548799        PIE  4.978049e-03 7.434690e-01            0
      1620   466_548799      DomMc  7.370133e-04 8.048638e-01            0
      1621   466_550257          S -5.595668e-02 4.161981e-01            0
      1622   466_550257          N  5.055415e+01 6.108733e-01            0
      1623   466_550257       maxN  7.177377e+01 4.780978e-01            0
      1624   466_550257    Shannon -1.444631e-02 4.996820e-01            0
      1625   466_550257 expShannon -1.781009e-02 7.501991e-01            0
      1626   466_550257    Simpson -1.097594e-02 3.205452e-01            0
      1627   466_550257 invSimpson -1.642587e-02 7.217322e-01            0
      1628   466_550257        PIE -1.097776e-02 3.208841e-01            0
      1629   466_550257      DomMc -7.176052e-04 9.002210e-01            0
      1630   466_559005          S  1.565404e-01 3.548559e-01            0
      1631   466_559005          N -5.611001e+02 1.047277e-02            1
      1632   466_559005       maxN -3.881687e+02 6.929818e-03            1
      1633   466_559005    Shannon -4.777878e-03 8.058083e-01            0
      1634   466_559005 expShannon -6.315562e-03 8.862304e-01            0
      1635   466_559005    Simpson -4.452731e-04 9.711224e-01            0
      1636   466_559005 invSimpson  8.312305e-03 8.451925e-01            0
      1637   466_559005        PIE -4.291797e-04 9.721816e-01            0
      1638   466_559005      DomMc  5.744839e-03 1.978958e-01            0
      1639   466_559734          S  3.138801e-01 5.696903e-03            1
      1640   466_559734          N -1.567156e+02 1.172901e-01            0
      1641   466_559734       maxN -1.373270e+02 1.167691e-01            0
      1642   466_559734    Shannon  3.396533e-03 8.489142e-01            0
      1643   466_559734 expShannon  5.155152e-03 8.900218e-01            0
      1644   466_559734    Simpson  4.969915e-04 9.590666e-01            0
      1645   466_559734 invSimpson  1.696031e-03 9.427929e-01            0
      1646   466_559734        PIE  5.075741e-04 9.582211e-01            0
      1647   466_559734      DomMc -3.608193e-04 9.241981e-01            0
      1648   466_551717          S  1.381866e-01 2.957542e-01            0
      1649   466_551717          N -7.649564e+01 5.275307e-01            0
      1650   466_551717       maxN -6.972711e+01 5.592946e-01            0
      1651   466_551717    Shannon  2.709988e-02 3.165230e-01            0
      1652   466_551717 expShannon  4.549827e-02 4.823325e-01            0
      1653   466_551717    Simpson  1.280077e-02 3.725725e-01            0
      1654   466_551717 invSimpson  1.693171e-02 7.643941e-01            0
      1655   466_551717        PIE  1.283984e-02 3.715891e-01            0
      1656   466_551717      DomMc -2.850740e-03 6.996103e-01            0
      1657   466_553174          S  2.294275e-01 1.306282e-02            1
      1658   466_553174          N -1.535555e+02 1.967779e-01            0
      1659   466_553174       maxN -1.631874e+02 1.326008e-01            0
      1660   466_553174    Shannon  3.407004e-02 3.259852e-03            1
      1661   466_553174 expShannon  6.935675e-02 1.777088e-03            1
      1662   466_553174    Simpson  1.597904e-02 6.626153e-03            1
      1663   466_553174 invSimpson  3.499943e-02 3.355034e-03            1
      1664   466_553174        PIE  1.599761e-02 6.592485e-03            1
      1665   466_553174      DomMc -6.393718e-03 3.342357e-03            1
      1666   466_559003          S  3.795380e-02 8.314328e-01            0
      1667   466_559003          N -5.529035e+02 6.978033e-02            0
      1668   466_559003       maxN -3.891964e+02 1.423300e-01            0
      1669   466_559003    Shannon -9.551355e-03 6.211140e-01            0
      1670   466_559003 expShannon -2.323905e-02 5.942560e-01            0
      1671   466_559003    Simpson -1.024563e-02 3.519894e-01            0
      1672   466_559003 invSimpson -3.535064e-02 3.558310e-01            0
      1673   466_559003        PIE -1.024314e-02 3.525676e-01            0
      1674   466_559003      DomMc -1.989879e-04 9.727026e-01            0
      1675   466_550988          S  1.461988e-01 4.235713e-01            0
      1676   466_550988          N -1.895848e+02 2.148502e-01            0
      1677   466_550988       maxN -1.248772e+02 1.063702e-01            0
      1678   466_550988    Shannon  2.824588e-02 5.751194e-01            0
      1679   466_550988 expShannon  1.049923e-01 5.210030e-01            0
      1680   466_550988    Simpson  1.235675e-02 6.579897e-01            0
      1681   466_550988 invSimpson  1.060232e-01 5.171925e-01            0
      1682   466_550988        PIE  1.239376e-02 6.571495e-01            0
      1683   466_550988      DomMc -1.546019e-02 2.278667e-01            0
      1684   466_556086          S  2.474227e-02 8.338496e-01            0
      1685   466_556086          N -4.588845e+02 1.230993e-01            0
      1686   466_556086       maxN -1.878577e+02 1.885879e-01            0
      1687   466_556086    Shannon -4.990997e-02 9.603717e-02            0
      1688   466_556086 expShannon -1.084504e-01 1.067499e-01            0
      1689   466_556086    Simpson -3.317551e-02 7.268161e-02            0
      1690   466_556086 invSimpson -9.654569e-02 1.254139e-01            0
      1691   466_556086        PIE -3.317087e-02 7.291779e-02            0
      1692   466_556086      DomMc  5.588390e-03 2.561934e-01            0
      1693   466_560463          S  1.435407e-02 8.984858e-01            0
      1694   466_560463          N -2.859916e+02 5.486287e-01            0
      1695   466_560463       maxN -1.070766e+02 7.432021e-01            0
      1696   466_560463    Shannon  2.085321e-02 5.273057e-01            0
      1697   466_560463 expShannon  5.432605e-02 4.140649e-01            0
      1698   466_560463    Simpson  1.017036e-02 6.546890e-01            0
      1699   466_560463 invSimpson  4.421468e-02 4.892686e-01            0
      1700   466_560463        PIE  1.019230e-02 6.540720e-01            0
      1701   466_560463      DomMc -6.399876e-03 1.426571e-01            0
      1702   466_549526          S -6.188605e-02 5.571236e-01            0
      1703   466_549526          N -5.338900e+00 8.966363e-01            0
      1704   466_549526       maxN -1.216896e+01 7.182186e-01            0
      1705   466_549526    Shannon  4.678214e-03 4.388873e-01            0
      1706   466_549526 expShannon  1.100841e-02 4.451876e-01            0
      1707   466_549526    Simpson  5.152813e-03 2.870158e-01            0
      1708   466_549526 invSimpson  1.617187e-02 2.957822e-01            0
      1709   466_549526        PIE  5.158334e-03 2.869478e-01            0
      1710   466_549526      DomMc  5.298448e-04 7.181695e-01            0
      1711   466_550259          S -5.038760e-02 4.958367e-01            0
      1712   466_550259          N  2.432558e+01 6.430645e-01            0
      1713   466_550259       maxN -5.201550e+00 8.719031e-01            0
      1714   466_550259    Shannon  3.133038e-02 5.621950e-02            0
      1715   466_550259 expShannon  6.365867e-02 1.095296e-01            0
      1716   466_550259    Simpson  1.910790e-02 4.442833e-02            1
      1717   466_550259 invSimpson  4.731091e-02 1.516146e-01            0
      1718   466_550259        PIE  1.912015e-02 4.433100e-02            1
      1719   466_550259      DomMc -4.138416e-03 3.436315e-01            0
      1720   466_542290          S  3.015075e-02 9.216369e-01            0
      1721   466_542290          N  2.185955e+02 7.392339e-02            0
      1722   466_542290       maxN  1.708266e+02 8.449175e-03            1
      1723   466_542290    Shannon -1.915456e-02 3.374241e-01            0
      1724   466_542290 expShannon -5.924945e-02 3.674767e-01            0
      1725   466_542290    Simpson -9.740914e-03 5.644039e-01            0
      1726   466_542290 invSimpson -5.371400e-02 5.739383e-01            0
      1727   466_542290        PIE -9.772135e-03 5.636447e-01            0
      1728   466_542290      DomMc  4.385415e-03 6.060730e-01            0
      1729   466_565606          S -1.098113e-01 4.617496e-01            0
      1730   466_565606          N  3.477045e+02 4.131508e-01            0
      1731   466_565606       maxN  3.324068e+02 3.946760e-01            0
      1732   466_565606    Shannon -8.799451e-02 3.544503e-02            1
      1733   466_565606 expShannon -3.567680e-01 3.809543e-02            1
      1734   466_565606    Simpson -3.446839e-02 3.708800e-02            1
      1735   466_565606 invSimpson -2.585497e-01 3.762854e-02            1
      1736   466_565606        PIE -3.460703e-02 3.684383e-02            1
      1737   466_565606      DomMc  2.324791e-02 3.707234e-02            1
      1738   466_553933          S  4.812030e-02 8.769879e-01            0
      1739   466_553933          N -1.291414e+02 5.068361e-01            0
      1740   466_553933       maxN -6.904436e+01 6.414581e-01            0
      1741   466_553933    Shannon  5.775235e-02 1.095591e-01            0
      1742   466_553933 expShannon  3.062284e-01 6.332394e-02            0
      1743   466_553933    Simpson  1.394771e-02 2.670510e-01            0
      1744   466_553933 invSimpson  2.429459e-01 8.337589e-02            0
      1745   466_553933        PIE  1.408860e-02 2.640550e-01            0
      1746   466_553933      DomMc -2.728870e-02 6.820802e-02            0
      1747   466_562687          S -2.448025e-01 2.552381e-01            0
      1748   466_562687          N -7.396050e-01 9.752640e-01            0
      1749   466_562687       maxN  2.607588e+00 8.483644e-01            0
      1750   466_562687    Shannon -6.412627e-03 7.302539e-01            0
      1751   466_562687 expShannon  2.249143e-03 9.783528e-01            0
      1752   466_562687    Simpson -1.591698e-03 8.513982e-01            0
      1753   466_562687 invSimpson  3.086310e-02 6.604212e-01            0
      1754   466_562687        PIE -1.593739e-03 8.515781e-01            0
      1755   466_562687      DomMc  7.395224e-04 9.111458e-01            0
      1756   466_556851          S  1.000000e-01 9.210877e-01            0
      1757   466_556851          N  4.918500e+03 1.859394e-01            0
      1758   466_556851       maxN  4.759900e+03 1.914596e-01            0
      1759   466_556851    Shannon -1.259951e-01 4.399000e-01            0
      1760   466_556851 expShannon -2.147646e-01 5.730149e-01            0
      1761   466_556851    Simpson -5.408485e-02 5.376749e-01            0
      1762   466_556851 invSimpson -8.609912e-02 7.697133e-01            0
      1763   466_556851        PIE -5.415625e-02 5.375990e-01            0
      1764   466_556851      DomMc  2.218216e-02 4.343899e-01            0
      1765   466_571439          S -7.000000e-01 2.034752e-01            0
      1766   466_571439          N -1.519167e+02 8.143490e-02            0
      1767   466_571439       maxN -5.728333e+01 1.479558e-01            0
      1768   466_571439    Shannon -3.434689e-03 9.478035e-01            0
      1769   466_571439 expShannon -6.302304e-02 8.309671e-01            0
      1770   466_571439    Simpson -3.268142e-03 8.562056e-01            0
      1771   466_571439 invSimpson -8.761051e-02 6.853206e-01            0
      1772   466_571439        PIE -3.088259e-03 8.644941e-01            0
      1773   466_571439      DomMc  3.162835e-03 8.396598e-01            0
      1774   466_565610          S -1.907399e-01 3.806683e-01            0
      1775   466_565610          N -1.877154e+03 7.204829e-02            0
      1776   466_565610       maxN -1.665429e+03 9.513235e-02            0
      1777   466_565610    Shannon  5.917353e-02 2.668298e-02            1
      1778   466_565610 expShannon  2.091461e-01 3.637988e-02            1
      1779   466_565610    Simpson  2.541326e-02 1.739545e-02            1
      1780   466_565610 invSimpson  1.790991e-01 1.559714e-02            1
      1781   466_565610        PIE  2.551505e-02 1.706680e-02            1
      1782   466_565610      DomMc -2.027667e-02 8.439837e-03            1
      1783   466_565611          S -2.857143e-01 4.616990e-01            0
      1784   466_565611          N -5.745119e+02 3.276584e-01            0
      1785   466_565611       maxN -3.770833e+02 2.058709e-01            0
      1786   466_565611    Shannon  8.032170e-02 1.788475e-01            0
      1787   466_565611 expShannon  2.612292e-01 2.027400e-01            0
      1788   466_565611    Simpson  3.016010e-02 2.690680e-01            0
      1789   466_565611 invSimpson  1.863822e-01 2.225507e-01            0
      1790   466_565611        PIE  3.019863e-02 2.688371e-01            0
      1791   466_565611      DomMc -2.952192e-02 6.988401e-02            0
      1792   466_541545          S  1.807838e-01 5.830440e-01            0
      1793   466_541545          N -1.078860e+03 2.246794e-01            0
      1794   466_541545       maxN -9.231378e+02 2.989335e-01            0
      1795   466_541545    Shannon  1.189315e-01 1.125620e-01            0
      1796   466_541545 expShannon  4.634001e-01 1.337276e-01            0
      1797   466_541545    Simpson  4.470670e-02 1.244358e-01            0
      1798   466_541545 invSimpson  3.053283e-01 1.887149e-01            0
      1799   466_541545        PIE  4.485505e-02 1.240891e-01            0
      1800   466_541545      DomMc -3.269166e-02 1.288446e-01            0
      1801   466_546649          S -4.354839e-01 7.461538e-01            0
      1802   466_546649          N -6.364516e+01 7.066969e-01            0
      1803   466_546649       maxN -2.292581e+02 2.217761e-02            1
      1804   466_546649    Shannon  6.664818e-02 4.004291e-01            0
      1805   466_546649 expShannon  2.951673e-01 3.532150e-01            0
      1806   466_546649    Simpson  3.718202e-02 3.247880e-01            0
      1807   466_546649 invSimpson  3.803506e-01 2.185927e-01            0
      1808   466_546649        PIE  3.719597e-02 3.246910e-01            0
      1809   466_546649      DomMc -3.007522e-02 3.328217e-01            0
      1810   466_566335          S -2.024573e-01 2.733555e-01            0
      1811   466_566335          N  3.557949e+02 1.220987e-01            0
      1812   466_566335       maxN  3.610107e+02 1.061006e-01            0
      1813   466_566335    Shannon -4.758449e-02 1.755372e-01            0
      1814   466_566335 expShannon -1.470145e-01 2.721801e-01            0
      1815   466_566335    Simpson -2.375100e-02 1.085639e-01            0
      1816   466_566335 invSimpson -1.170173e-01 2.421782e-01            0
      1817   466_566335        PIE -2.379106e-02 1.090202e-01            0
      1818   466_566335      DomMc  9.665933e-03 3.387043e-01            0
      1819   466_543008          S -1.176471e-01 9.284801e-01            0
      1820   466_543008          N -4.846588e+03 3.183514e-01            0
      1821   466_543008       maxN -3.674794e+03 3.279393e-01            0
      1822   466_543008    Shannon -1.811485e-02 8.962070e-01            0
      1823   466_543008 expShannon -3.294113e-03 9.932041e-01            0
      1824   466_543008    Simpson -1.704306e-02 7.898431e-01            0
      1825   466_543008 invSimpson  8.383245e-03 9.709423e-01            0
      1826   466_543008        PIE -1.703052e-02 7.901346e-01            0
      1827   466_543008      DomMc  5.317075e-03 8.358377e-01            0
      1828   466_542272          S -1.067207e-01 5.869410e-01            0
      1829   466_542272          N -4.432793e+02 4.296929e-02            1
      1830   466_542272       maxN -2.967606e+02 6.209414e-02            0
      1831   466_542272    Shannon  1.778436e-02 2.319355e-01            0
      1832   466_542272 expShannon  4.256733e-02 2.611647e-01            0
      1833   466_542272    Simpson  2.630981e-03 7.152811e-01            0
      1834   466_542272 invSimpson -1.517540e-03 9.504352e-01            0
      1835   466_542272        PIE  2.689907e-03 7.094765e-01            0
      1836   466_542272      DomMc -4.104621e-03 2.622083e-01            0
      1837   466_564884          S -9.765625e-02 8.690529e-01            0
      1838   466_564884          N  7.961328e+01 6.823110e-01            0
      1839   466_564884       maxN  2.731250e+01 8.869931e-01            0
      1840   466_564884    Shannon -6.028944e-04 9.941075e-01            0
      1841   466_564884 expShannon  2.649189e-02 9.254925e-01            0
      1842   466_564884    Simpson  2.285871e-03 9.526852e-01            0
      1843   466_564884 invSimpson  8.210830e-02 6.410834e-01            0
      1844   466_564884        PIE  2.238938e-03 9.537426e-01            0
      1845   466_564884      DomMc -5.649567e-03 7.596257e-01            0
      1846   466_558310          S -1.548966e-01 3.554595e-01            0
      1847   466_558310          N  6.158478e+02 7.286397e-02            0
      1848   466_558310       maxN  5.880808e+02 6.851990e-02            0
      1849   466_558310    Shannon -5.539471e-02 7.631554e-04            1
      1850   466_558310 expShannon -1.483940e-01 6.938634e-04            1
      1851   466_558310    Simpson -2.346984e-02 4.189402e-03            1
      1852   466_558310 invSimpson -9.823546e-02 4.199587e-03            1
      1853   466_558310        PIE -2.362663e-02 4.078297e-03            1
      1854   466_558310      DomMc  1.322910e-02 1.600889e-03            1
      1855   466_541548          S  8.782201e-04 9.964791e-01            0
      1856   466_541548          N -3.470685e+02 2.581820e-01            0
      1857   466_541548       maxN -2.081493e+02 3.381875e-01            0
      1858   466_541548    Shannon  1.633163e-02 2.701106e-01            0
      1859   466_541548 expShannon  6.254340e-02 2.368930e-01            0
      1860   466_541548    Simpson  3.869440e-03 5.680479e-01            0
      1861   466_541548 invSimpson  3.483005e-02 4.043173e-01            0
      1862   466_541548        PIE  3.882882e-03 5.670109e-01            0
      1863   466_541548      DomMc -7.514195e-03 1.056227e-01            0
      1864   466_568522          S -2.227510e-01 1.978736e-01            0
      1865   466_568522          N  3.365520e+00 7.740703e-01            0
      1866   466_568522       maxN  3.764354e+00 4.709905e-01            0
      1867   466_568522    Shannon -2.128741e-02 1.432193e-01            0
      1868   466_568522 expShannon -1.044635e-01 2.375268e-01            0
      1869   466_568522    Simpson -4.793647e-03 2.263458e-01            0
      1870   466_568522 invSimpson -5.274770e-02 4.328346e-01            0
      1871   466_568522        PIE -4.683263e-03 2.210778e-01            0
      1872   466_568522      DomMc  6.467847e-03 2.369499e-01            0
      1873   466_561970          S -1.401869e-02 9.839907e-01            0
      1874   466_561970          N -6.075888e+02 1.823999e-01            0
      1875   466_561970       maxN -4.143925e+02 2.799762e-01            0
      1876   466_561970    Shannon  6.576260e-02 4.224230e-01            0
      1877   466_561970 expShannon  2.349837e-01 4.452652e-01            0
      1878   466_561970    Simpson  1.281983e-02 7.218873e-01            0
      1879   466_561970 invSimpson  8.080665e-02 7.497509e-01            0
      1880   466_561970        PIE  1.294990e-02 7.193179e-01            0
      1881   466_561970      DomMc -1.646399e-02 5.340782e-01            0
      1882   466_568523          S  6.706943e-15 1.000000e+00            0
      1883   466_568523          N  2.675000e+01 7.034120e-01            0
      1884   466_568523       maxN  4.040000e+01 5.867050e-01            0
      1885   466_568523    Shannon -2.253961e-02 7.969784e-01            0
      1886   466_568523 expShannon -5.219387e-02 8.890747e-01            0
      1887   466_568523    Simpson -1.598369e-02 6.342081e-01            0
      1888   466_568523 invSimpson -4.666647e-02 8.670035e-01            0
      1889   466_568523        PIE -1.600105e-02 6.348350e-01            0
      1890   466_568523      DomMc  6.471902e-04 9.838907e-01            0
      1891   466_553937          S -7.471264e-02 6.062808e-01            0
      1892   466_553937          N -3.115891e+02 2.152660e-02            1
      1893   466_553937       maxN -2.329023e+02 4.678824e-02            1
      1894   466_553937    Shannon  1.978946e-02 2.592961e-01            0
      1895   466_553937 expShannon  6.792396e-02 3.061988e-01            0
      1896   466_553937    Simpson  6.390595e-03 3.846610e-01            0
      1897   466_553937 invSimpson  3.174064e-02 4.610076e-01            0
      1898   466_553937        PIE  6.443093e-03 3.816823e-01            0
      1899   466_553937      DomMc -5.202919e-03 2.530793e-01            0
      1900   466_564158          S -4.285714e-01 5.252093e-01            0
      1901   466_564158          N  1.516190e+02 1.535169e-01            0
      1902   466_564158       maxN  1.055833e+02 1.645849e-01            0
      1903   466_564158    Shannon -4.391107e-03 9.370521e-01            0
      1904   466_564158 expShannon -1.270076e-02 9.589444e-01            0
      1905   466_564158    Simpson -2.883020e-03 8.757293e-01            0
      1906   466_564158 invSimpson  1.192089e-02 9.389789e-01            0
      1907   466_564158        PIE -2.917772e-03 8.748636e-01            0
      1908   466_564158      DomMc -6.295406e-03 6.873210e-01            0
      1909   466_564876          S -1.616541e-01 5.022224e-01            0
      1910   466_564876          N  2.382707e+01 4.296174e-01            0
      1911   466_564876       maxN  2.612782e+00 5.256726e-01            0
      1912   466_564876    Shannon -1.406323e-02 6.269808e-01            0
      1913   466_564876 expShannon -6.128323e-02 6.139537e-01            0
      1914   466_564876    Simpson  5.445762e-04 9.573051e-01            0
      1915   466_564876 invSimpson  1.331853e-02 8.953952e-01            0
      1916   466_564876        PIE  5.168348e-04 9.594378e-01            0
      1917   466_564876      DomMc  4.529947e-03 8.075675e-01            0
      1918   466_545927          S -2.224576e-01 9.993468e-02            0
      1919   466_545927          N  7.076271e+00 9.455725e-01            0
      1920   466_545927       maxN -1.622881e+00 9.760271e-01            0
      1921   466_545927    Shannon  3.061317e-04 9.697512e-01            0
      1922   466_545927 expShannon  4.439661e-03 8.835926e-01            0
      1923   466_545927    Simpson  1.507803e-03 7.380731e-01            0
      1924   466_545927 invSimpson  2.063266e-02 5.326554e-01            0
      1925   466_545927        PIE  1.501618e-03 7.389771e-01            0
      1926   466_545927      DomMc -3.206855e-03 3.012655e-01            0
      1927   466_551018          S -1.245947e-01 5.260813e-01            0
      1928   466_551018          N -8.446723e+01 5.313708e-01            0
      1929   466_551018       maxN -2.867161e+01 8.237602e-01            0
      1930   466_551018    Shannon  1.810277e-02 4.049134e-01            0
      1931   466_551018 expShannon  1.064962e-01 1.625190e-01            0
      1932   466_551018    Simpson  4.315452e-03 6.527899e-01            0
      1933   466_551018 invSimpson  8.102516e-02 1.761256e-01            0
      1934   466_551018        PIE  4.393374e-03 6.476478e-01            0
      1935   466_551018      DomMc -6.260213e-03 3.210814e-01            0
      1936   466_569984          S -2.500000e+00 6.666667e-01            0
      1937   466_569984          N  5.100000e+01 9.774430e-01            0
      1938   466_569984       maxN  2.300000e+01 9.883837e-01            0
      1939   466_569984    Shannon -4.635094e-02 9.413032e-01            0
      1940   466_569984 expShannon -2.473388e-01 9.126136e-01            0
      1941   466_569984    Simpson  2.707309e-03 9.923932e-01            0
      1942   466_569984 invSimpson  3.155145e-02 9.822080e-01            0
      1943   466_569984        PIE  2.482778e-03 9.930540e-01            0
      1944   466_569984      DomMc -1.503831e-02 9.354988e-01            0
      1945   466_556135          S  5.708824e-14 1.000000e+00            0
      1946   466_556135          N -2.024000e+02 9.195430e-01            0
      1947   466_556135       maxN -1.899000e+02 9.178852e-01            0
      1948   466_556135    Shannon  1.246669e-01 4.625827e-01            0
      1949   466_556135 expShannon  3.279276e-01 3.601603e-01            0
      1950   466_556135    Simpson  7.725373e-02 3.507810e-01            0
      1951   466_556135 invSimpson  2.702634e-01 2.257754e-01            0
      1952   466_556135        PIE  7.732176e-02 3.508055e-01            0
      1953   466_556135      DomMc -1.245964e-02 6.294000e-01            0
      1954   466_558313          S -1.965679e-01 2.655488e-01            0
      1955   466_558313          N -2.241966e+01 1.270263e-01            0
      1956   466_558313       maxN -1.111778e+01 1.979088e-01            0
      1957   466_558313    Shannon  2.099709e-03 8.927719e-01            0
      1958   466_558313 expShannon  3.171551e-05 9.996531e-01            0
      1959   466_558313    Simpson -8.072390e-04 8.494233e-01            0
      1960   466_558313 invSimpson -1.376089e-02 7.367857e-01            0
      1961   466_558313        PIE -6.357134e-04 8.811151e-01            0
      1962   466_558313      DomMc -3.568231e-03 3.815641e-01            0
      1963   466_557581          S -2.230769e-01 3.831183e-01            0
      1964   466_557581          N  4.988846e+01 2.114014e-01            0
      1965   466_557581       maxN  5.519231e+01 8.594654e-02            0
      1966   466_557581    Shannon -5.011460e-02 2.597825e-03            1
      1967   466_557581 expShannon -1.608233e-01 1.015024e-02            1
      1968   466_557581    Simpson -2.231685e-02 1.550818e-03            1
      1969   466_557581 invSimpson -9.701655e-02 1.976984e-02            1
      1970   466_557581        PIE -2.237898e-02 1.409234e-03            1
      1971   466_557581      DomMc  1.336751e-02 5.528796e-02            0
      1972   466_547368          S -8.666403e-02 6.551079e-01            0
      1973   466_547368          N -4.778670e+01 9.301322e-01            0
      1974   466_547368       maxN -2.941828e+01 9.543877e-01            0
      1975   466_547368    Shannon -3.662316e-03 9.126825e-01            0
      1976   466_547368 expShannon -2.112126e-02 8.368583e-01            0
      1977   466_547368    Simpson -9.254740e-04 9.475370e-01            0
      1978   466_547368 invSimpson -6.739261e-03 9.056378e-01            0
      1979   466_547368        PIE -9.413122e-04 9.468351e-01            0
      1980   466_547368      DomMc  1.443376e-03 8.640487e-01            0
      1981   466_548098          S -1.941964e-01 2.139168e-01            0
      1982   466_548098          N -4.476406e+02 3.759169e-01            0
      1983   466_548098       maxN -3.328549e+02 4.952778e-01            0
      1984   466_548098    Shannon  2.199118e-02 2.651085e-01            0
      1985   466_548098 expShannon  8.510365e-02 1.385051e-01            0
      1986   466_548098    Simpson  8.247752e-03 3.982885e-01            0
      1987   466_548098 invSimpson  6.945734e-02 1.183022e-01            0
      1988   466_548098        PIE  8.282941e-03 3.971856e-01            0
      1989   466_548098      DomMc -7.717634e-03 1.032486e-01            0
      1990   466_544455          S  5.148741e-02 7.696420e-01            0
      1991   466_544455          N -2.484439e+01 4.897616e-01            0
      1992   466_544455       maxN -2.403661e+01 4.096685e-01            0
      1993   466_544455    Shannon  2.585083e-02 3.862139e-01            0
      1994   466_544455 expShannon  9.415542e-02 4.104608e-01            0
      1995   466_544455    Simpson  1.001132e-02 4.330258e-01            0
      1996   466_544455 invSimpson  5.245231e-02 4.956894e-01            0
      1997   466_544455        PIE  1.013952e-02 4.338366e-01            0
      1998   466_544455      DomMc -2.708383e-03 7.267002e-01            0
      1999   466_554676          S -2.435233e-01 6.626819e-03            1
      2000   466_554676          N -7.180699e+01 4.085722e-01            0
      2001   466_554676       maxN -6.999093e+01 3.556307e-01            0
      2002   466_554676    Shannon -9.816299e-03 6.059568e-01            0
      2003   466_554676 expShannon -5.681482e-02 4.493104e-01            0
      2004   466_554676    Simpson -1.727848e-03 8.343360e-01            0
      2005   466_554676 invSimpson -2.349555e-02 6.678629e-01            0
      2006   466_554676        PIE -1.731430e-03 8.345047e-01            0
      2007   466_554676      DomMc  1.428397e-03 8.011330e-01            0
      2008   466_565605          S -8.831711e-02 6.318182e-01            0
      2009   466_565605          N  4.383171e+01 8.756147e-01            0
      2010   466_565605       maxN  4.614256e+01 8.678575e-01            0
      2011   466_565605    Shannon -3.463757e-02 3.309622e-01            0
      2012   466_565605 expShannon -7.362077e-02 4.448227e-01            0
      2013   466_565605    Simpson -1.604915e-02 3.244238e-01            0
      2014   466_565605 invSimpson -4.000947e-02 5.106278e-01            0
      2015   466_565605        PIE -1.610600e-02 3.237465e-01            0
      2016   466_565605      DomMc  6.035871e-03 3.739175e-01            0
      2017   466_561962          S  1.361216e-01 3.628779e-01            0
      2018   466_561962          N -3.264682e+02 3.723440e-02            1
      2019   466_561962       maxN -2.922223e+02 4.027052e-02            1
      2020   466_561962    Shannon  3.946917e-02 2.727363e-02            1
      2021   466_561962 expShannon  1.399343e-01 5.887553e-02            0
      2022   466_561962    Simpson  1.588121e-02 2.565725e-02            1
      2023   466_561962 invSimpson  9.005950e-02 9.892759e-02            0
      2024   466_561962        PIE  1.594025e-02 2.556431e-02            1
      2025   466_561962      DomMc -9.618845e-03 6.728822e-02            0
      2026   466_548097          S -1.030542e-02 9.055425e-01            0
      2027   466_548097          N  3.071451e+01 6.995001e-01            0
      2028   466_548097       maxN  2.450328e+01 7.370671e-01            0
      2029   466_548097    Shannon -4.404151e-03 7.866785e-01            0
      2030   466_548097 expShannon -9.372711e-03 8.848184e-01            0
      2031   466_548097    Simpson -3.017833e-03 6.631453e-01            0
      2032   466_548097 invSimpson -7.965653e-03 8.776758e-01            0
      2033   466_548097        PIE -3.033011e-03 6.623162e-01            0
      2034   466_548097      DomMc  1.342328e-03 7.935472e-01            0
      2035   466_564146          S  9.638554e-01 3.790796e-01            0
      2036   466_564146          N  8.708434e+01 1.088527e-02            1
      2037   466_564146       maxN  4.807229e+01 1.518465e-01            0
      2038   466_564146    Shannon  1.282083e-03 9.909702e-01            0
      2039   466_564146 expShannon  3.142358e-02 9.665821e-01            0
      2040   466_564146    Simpson -8.289600e-03 7.874006e-01            0
      2041   466_564146 invSimpson -4.328301e-02 9.418964e-01            0
      2042   466_564146        PIE -9.136106e-03 7.663720e-01            0
      2043   466_564146      DomMc  1.252836e-02 7.840431e-01            0
      2044   466_544471          S -1.341772e-01 4.066316e-01            0
      2045   466_544471          N -1.640608e+02 3.396929e-01            0
      2046   466_544471       maxN -9.632785e+01 4.988812e-01            0
      2047   466_544471    Shannon  5.230754e-02 2.333878e-01            0
      2048   466_544471 expShannon  3.177148e-01 1.408605e-01            0
      2049   466_544471    Simpson  1.239046e-02 4.601389e-01            0
      2050   466_544471 invSimpson  2.221755e-01 1.689785e-01            0
      2051   466_544471        PIE  1.261485e-02 4.549237e-01            0
      2052   466_544471      DomMc -1.682050e-02 2.083714e-01            0
      2053   466_557584          S -5.051546e-01 6.931496e-02            0
      2054   466_557584          N -6.530928e+00 9.269223e-01            0
      2055   466_557584       maxN  1.010309e+01 8.100925e-01            0
      2056   466_557584    Shannon -1.750151e-02 5.409333e-01            0
      2057   466_557584 expShannon -7.750495e-02 6.030214e-01            0
      2058   466_557584    Simpson -5.476710e-03 5.095763e-01            0
      2059   466_557584 invSimpson -4.879274e-02 6.464487e-01            0
      2060   466_557584        PIE -5.417207e-03 5.194023e-01            0
      2061   466_557584      DomMc  4.935494e-03 5.904676e-01            0
      2062   466_543726          S -5.223368e-01 3.393363e-02            1
      2063   466_543726          N -5.728210e+00 5.682934e-01            0
      2064   466_543726       maxN -7.636988e+00 2.350642e-01            0
      2065   466_543726    Shannon -6.140999e-03 7.731256e-01            0
      2066   466_543726 expShannon -6.839724e-02 5.961730e-01            0
      2067   466_543726    Simpson  3.018104e-03 6.514966e-01            0
      2068   466_543726 invSimpson -1.152209e-02 9.008588e-01            0
      2069   466_543726        PIE  3.044120e-03 6.488345e-01            0
      2070   466_543726      DomMc  1.237791e-03 8.458977e-01            0
      2071   466_553207          S -1.588629e-01 4.574009e-01            0
      2072   466_553207          N -3.242124e+02 8.221933e-02            0
      2073   466_553207       maxN -2.199114e+02 2.005632e-01            0
      2074   466_553207    Shannon  2.694960e-02 5.625209e-01            0
      2075   466_553207 expShannon  1.392887e-01 5.243293e-01            0
      2076   466_553207    Simpson  5.706004e-03 7.646208e-01            0
      2077   466_553207 invSimpson  7.465958e-02 6.035632e-01            0
      2078   466_553207        PIE  5.820062e-03 7.611303e-01            0
      2079   466_553207      DomMc -8.231722e-03 5.267628e-01            0
      2080   466_551748          S -2.230997e-01 5.430265e-02            0
      2081   466_551748          N -1.740516e+02 4.850602e-01            0
      2082   466_551748       maxN -1.143986e+02 6.419034e-01            0
      2083   466_551748    Shannon  1.302614e-02 5.839746e-01            0
      2084   466_551748 expShannon  5.540725e-02 4.909693e-01            0
      2085   466_551748    Simpson  4.419021e-03 6.907948e-01            0
      2086   466_551748 invSimpson  3.941742e-02 5.099932e-01            0
      2087   466_551748        PIE  4.477522e-03 6.873799e-01            0
      2088   466_551748      DomMc -4.627779e-03 4.315170e-01            0
      2089   466_551015          S -9.495021e-02 5.675958e-01            0
      2090   466_551015          N -9.762767e+01 8.538956e-01            0
      2091   466_551015       maxN -2.662233e+01 9.559697e-01            0
      2092   466_551015    Shannon  1.712582e-02 4.996667e-01            0
      2093   466_551015 expShannon  9.399661e-02 2.828989e-01            0
      2094   466_551015    Simpson  5.414775e-03 6.167623e-01            0
      2095   466_551015 invSimpson  6.787833e-02 2.080660e-01            0
      2096   466_551015        PIE  5.492164e-03 6.126240e-01            0
      2097   466_551015      DomMc -6.918283e-03 2.882447e-01            0
      2098   466_559044          S -3.227593e-01 1.405747e-01            0
      2099   466_559044          N -6.697024e+02 2.280353e-01            0
      2100   466_559044       maxN -6.088610e+02 2.595915e-01            0
      2101   466_559044    Shannon  2.246251e-02 6.861754e-01            0
      2102   466_559044 expShannon  9.506783e-02 7.028572e-01            0
      2103   466_559044    Simpson  8.790421e-03 6.718714e-01            0
      2104   466_559044 invSimpson  6.348605e-02 6.820104e-01            0
      2105   466_559044        PIE  8.872378e-03 6.701320e-01            0
      2106   466_559044      DomMc -9.553399e-04 9.508383e-01            0
      2107   466_557595          S -1.500000e+00 1.266662e-01            0
      2108   466_557595          N -1.786000e+02 6.686357e-01            0
      2109   466_557595       maxN  1.256000e+02 7.625335e-01            0
      2110   466_557595    Shannon -1.311252e-01 1.905057e-01            0
      2111   466_557595 expShannon -3.169755e-01 2.144835e-01            0
      2112   466_557595    Simpson -9.296403e-02 2.223304e-01            0
      2113   466_557595 invSimpson -2.684533e-01 2.991308e-01            0
      2114   466_557595        PIE -9.298600e-02 2.223925e-01            0
      2115   466_557595      DomMc  2.065622e-02 7.737913e-02            0
      2116   466_559773          S -4.285714e-01 4.078435e-01            0
      2117   466_559773          N -1.917619e+02 3.077705e-01            0
      2118   466_559773       maxN -9.609524e+01 4.788599e-01            0
      2119   466_559773    Shannon -3.391297e-02 8.449864e-01            0
      2120   466_559773 expShannon  2.587731e-02 9.648821e-01            0
      2121   466_559773    Simpson -2.712820e-02 7.236199e-01            0
      2122   466_559773 invSimpson  9.012519e-03 9.783378e-01            0
      2123   466_559773        PIE -2.700372e-02 7.255806e-01            0
      2124   466_559773      DomMc -6.662420e-03 8.594610e-01            0
      2125   466_554666          S -1.654676e-01 6.457711e-01            0
      2126   466_554666          N  5.273921e+02 4.555258e-01            0
      2127   466_554666       maxN  4.615701e+02 5.008609e-01            0
      2128   466_554666    Shannon -6.748715e-02 1.792489e-01            0
      2129   466_554666 expShannon -2.841805e-01 6.883537e-02            0
      2130   466_554666    Simpson -2.496346e-02 3.125393e-01            0
      2131   466_554666 invSimpson -2.227687e-01 6.215635e-02            0
      2132   466_554666        PIE -2.497930e-02 3.124115e-01            0
      2133   466_554666      DomMc  2.684315e-02 6.220888e-02            0
      2134   466_547369          S  1.592742e-01 6.539364e-01            0
      2135   466_547369          N -2.410081e+02 3.046593e-01            0
      2136   466_547369       maxN -2.087480e+02 2.963371e-01            0
      2137   466_547369    Shannon  2.622757e-02 4.281348e-01            0
      2138   466_547369 expShannon  6.926470e-02 4.387005e-01            0
      2139   466_547369    Simpson  1.200401e-02 4.101704e-01            0
      2140   466_547369 invSimpson  4.378168e-02 3.686046e-01            0
      2141   466_547369        PIE  1.203746e-02 4.092180e-01            0
      2142   466_547369      DomMc -6.276263e-03 4.444179e-01            0
      2143   466_550285          S -1.091954e-01 7.793327e-01            0
      2144   466_550285          N -3.439253e+02 6.590950e-02            0
      2145   466_550285       maxN -1.352787e+02 2.984807e-01            0
      2146   466_550285    Shannon  9.239368e-03 8.682192e-01            0
      2147   466_550285 expShannon  8.169515e-02 6.966463e-01            0
      2148   466_550285    Simpson -8.901955e-03 6.874740e-01            0
      2149   466_550285 invSimpson -2.980652e-02 8.083198e-01            0
      2150   466_550285        PIE -8.760476e-03 6.927091e-01            0
      2151   466_550285      DomMc -2.419105e-03 8.696418e-01            0
      2152   466_561232          S -6.113360e-01 2.294697e-03            1
      2153   466_561232          N -8.390081e+01 4.147976e-02            1
      2154   466_561232       maxN -5.479150e+01 1.527609e-01            0
      2155   466_561232    Shannon -1.282362e-03 9.655713e-01            0
      2156   466_561232 expShannon -6.036995e-02 6.514906e-01            0
      2157   466_561232    Simpson  5.725417e-03 6.490319e-01            0
      2158   466_561232 invSimpson -3.103471e-03 9.739806e-01            0
      2159   466_561232        PIE  5.842980e-03 6.429183e-01            0
      2160   466_561232      DomMc  3.516665e-04 9.673102e-01            0
      2161   466_557594          S  1.048951e-01 7.014846e-01            0
      2162   466_557594          N -9.366888e+02 3.076992e-02            1
      2163   466_557594       maxN -7.172867e+02 4.746714e-02            1
      2164   466_557594    Shannon  4.257638e-02 2.469972e-01            0
      2165   466_557594 expShannon  1.277362e-01 2.572044e-01            0
      2166   466_557594    Simpson  1.826719e-02 3.319611e-01            0
      2167   466_557594 invSimpson  8.028366e-02 4.068481e-01            0
      2168   466_557594        PIE  1.834419e-02 3.306111e-01            0
      2169   466_557594      DomMc -4.145002e-03 7.076550e-01            0
      2170   466_559050          S -4.236111e-01 1.536465e-01            0
      2171   466_559050          N -1.383403e+02 6.353518e-01            0
      2172   466_559050       maxN -1.101181e+02 7.070126e-01            0
      2173   466_559050    Shannon -2.379948e-02 6.274814e-01            0
      2174   466_559050 expShannon -1.019684e-01 5.184981e-01            0
      2175   466_559050    Simpson -8.429889e-03 6.897892e-01            0
      2176   466_559050 invSimpson -8.192695e-02 4.315751e-01            0
      2177   466_559050        PIE -8.414900e-03 6.906692e-01            0
      2178   466_559050      DomMc  1.064871e-02 4.050899e-01            0
      2179   466_546657          S -8.571429e-01 5.456289e-01            0
      2180   466_546657          N  1.399571e+03 1.694356e-01            0
      2181   466_546657       maxN  1.619500e+03 2.324902e-01            0
      2182   466_546657    Shannon -1.571148e-01 3.032905e-01            0
      2183   466_546657 expShannon -3.678945e-01 2.690799e-01            0
      2184   466_546657    Simpson -9.526770e-02 3.041988e-01            0
      2185   466_546657 invSimpson -3.167684e-01 2.228853e-01            0
      2186   466_546657        PIE -9.529783e-02 3.041469e-01            0
      2187   466_546657      DomMc  1.817075e-02 3.450821e-01            0
      2188   466_565615          S -9.677419e-01 4.940550e-01            0
      2189   466_565615          N -6.048548e+02 2.283666e-02            1
      2190   466_565615       maxN -5.207419e+02 7.505966e-02            0
      2191   466_565615    Shannon  1.710581e-01 2.626440e-01            0
      2192   466_565615 expShannon  7.251032e-01 3.470277e-01            0
      2193   466_565615    Simpson  8.203418e-02 1.518707e-01            0
      2194   466_565615 invSimpson  6.332102e-01 2.739428e-01            0
      2195   466_565615        PIE  8.266060e-02 1.473400e-01            0
      2196   466_565615      DomMc -5.757234e-02 2.251155e-01            0
      2197   466_555405          S -3.394495e-01 9.110097e-02            0
      2198   466_555405          N -8.075688e+01 7.452415e-01            0
      2199   466_555405       maxN -2.962844e+01 8.835829e-01            0
      2200   466_555405    Shannon -8.249583e-03 6.758161e-01            0
      2201   466_555405 expShannon -1.218903e-02 8.335600e-01            0
      2202   466_555405    Simpson -5.442675e-03 6.053912e-01            0
      2203   466_555405 invSimpson  3.442727e-03 9.479594e-01            0
      2204   466_555405        PIE -5.404787e-03 6.087327e-01            0
      2205   466_555405      DomMc  2.000505e-03 7.340636e-01            0
      2206   466_559043          S -3.690476e-01 1.438815e-01            0
      2207   466_559043          N  4.771429e+01 4.657533e-01            0
      2208   466_559043       maxN  4.422619e+01 2.754843e-01            0
      2209   466_559043    Shannon -9.766778e-02 3.406385e-02            1
      2210   466_559043 expShannon -6.539617e-01 2.936835e-02            1
      2211   466_559043    Simpson -2.485794e-02 1.098731e-01            0
      2212   466_559043 invSimpson -5.155162e-01 5.697537e-02            0
      2213   466_559043        PIE -2.523184e-02 1.077652e-01            0
      2214   466_559043      DomMc  3.751726e-02 7.007635e-02            0
      2215   466_543012          S -7.500000e-01 2.078903e-01            0
      2216   466_543012          N -1.512500e+02 3.111425e-01            0
      2217   466_543012       maxN -1.628929e+02 1.258629e-01            0
      2218   466_543012    Shannon  1.086834e-01 5.294580e-02            0
      2219   466_543012 expShannon  4.780968e-01 5.399645e-02            0
      2220   466_543012    Simpson  4.533559e-02 4.671484e-03            1
      2221   466_543012 invSimpson  3.931466e-01 3.881932e-03            1
      2222   466_543012        PIE  4.540786e-02 4.777708e-03            1
      2223   466_543012      DomMc -2.769339e-02 9.797604e-02            0
      2224   466_549575          S -4.543326e-01 2.789511e-05            1
      2225   466_549575          N -4.299415e+01 4.248185e-01            0
      2226   466_549575       maxN -2.139813e+01 6.635438e-01            0
      2227   466_549575    Shannon -7.732565e-03 5.718502e-01            0
      2228   466_549575 expShannon -3.526940e-02 4.134763e-01            0
      2229   466_549575    Simpson -4.282926e-04 9.464425e-01            0
      2230   466_549575 invSimpson -7.454678e-03 7.996170e-01            0
      2231   466_549575        PIE  2.234042e-05 9.972596e-01            0
      2232   466_549575      DomMc  9.087515e-05 9.789468e-01            0
      2233   466_547385          S -1.988491e-01 1.637012e-01            0
      2234   466_547385          N  2.995780e+01 9.248715e-01            0
      2235   466_547385       maxN -3.804220e+01 8.524336e-01            0
      2236   466_547385    Shannon  3.228219e-02 7.403538e-02            0
      2237   466_547385 expShannon  8.618393e-02 8.403978e-02            0
      2238   466_547385    Simpson  1.675981e-02 6.041165e-02            0
      2239   466_547385 invSimpson  5.823178e-02 6.154165e-02            0
      2240   466_547385        PIE  1.677885e-02 6.043671e-02            0
      2241   466_547385      DomMc -6.945518e-03 2.038602e-01            0
      2242   466_551017          S -1.028571e+00 3.172984e-01            0
      2243   466_551017          N -3.322857e+01 7.926025e-01            0
      2244   466_551017       maxN -5.028571e+00 9.357335e-01            0
      2245   466_551017    Shannon -8.007449e-02 4.164399e-01            0
      2246   466_551017 expShannon -4.561563e-01 4.891115e-01            0
      2247   466_551017    Simpson -1.334389e-02 5.466755e-01            0
      2248   466_551017 invSimpson -2.087439e-01 6.804834e-01            0
      2249   466_551017        PIE -1.328603e-02 5.517269e-01            0
      2250   466_551017      DomMc  2.559081e-02 4.903774e-01            0
      2251   466_543725          S -3.000000e-01 7.763932e-01            0
      2252   466_543725          N -4.120000e+01 7.493320e-01            0
      2253   466_543725       maxN  1.590000e+01 8.783534e-01            0
      2254   466_543725    Shannon -1.531828e-01 2.847368e-01            0
      2255   466_543725 expShannon -6.995349e-01 2.779363e-01            0
      2256   466_543725    Simpson -7.429461e-02 1.928692e-01            0
      2257   466_543725 invSimpson -5.981877e-01 2.177373e-01            0
      2258   466_543725        PIE -7.442351e-02 1.933213e-01            0
      2259   466_543725      DomMc  5.270706e-02 2.640333e-01            0
      2260   466_558321          S -3.477011e-01 1.215269e-02            1
      2261   466_558321          N -1.163736e+02 3.112420e-01            0
      2262   466_558321       maxN -1.032672e+02 3.321674e-01            0
      2263   466_558321    Shannon -2.366873e-02 3.856757e-01            0
      2264   466_558321 expShannon -1.462168e-01 1.646853e-01            0
      2265   466_558321    Simpson -3.968730e-03 7.311741e-01            0
      2266   466_558321 invSimpson -9.026998e-02 1.851146e-01            0
      2267   466_558321        PIE -3.991336e-03 7.301147e-01            0
      2268   466_558321      DomMc  8.502519e-03 2.554385e-01            0
      2269   466_559780          S  4.285714e-01 7.451764e-01            0
      2270   466_559780          N -6.021143e+02 3.539737e-01            0
      2271   466_559780       maxN -4.438571e+02 3.203247e-01            0
      2272   466_559780    Shannon  9.384649e-02 5.724962e-01            0
      2273   466_559780 expShannon  4.332943e-01 6.599233e-01            0
      2274   466_559780    Simpson  3.749680e-02 4.719283e-01            0
      2275   466_559780 invSimpson  3.467697e-01 6.841134e-01            0
      2276   466_559780        PIE  3.762807e-02 4.717633e-01            0
      2277   466_559780      DomMc -9.511018e-03 8.964673e-01            0
      2278   466_541551          S -2.250000e+00 1.210377e-01            0
      2279   466_541551          N -4.682500e+02 3.102024e-01            0
      2280   466_541551       maxN -2.537500e+02 2.496288e-01            0
      2281   466_541551    Shannon  4.389020e-02 4.985349e-01            0
      2282   466_541551 expShannon  1.920224e-01 5.149109e-01            0
      2283   466_541551    Simpson  1.685199e-02 7.348891e-02            0
      2284   466_541551 invSimpson  1.855181e-01 1.110222e-01            0
      2285   466_541551        PIE  1.700972e-02 7.071204e-02            0
      2286   466_541551      DomMc -2.392235e-02 2.799167e-01            0
      2287   466_548114          S -3.281520e-02 8.972011e-01            0
      2288   466_548114          N -3.132435e+02 4.742671e-01            0
      2289   466_548114       maxN -1.928446e+02 2.868208e-01            0
      2290   466_548114    Shannon  4.093059e-02 6.838704e-02            0
      2291   466_548114 expShannon  1.346154e-01 4.564741e-02            1
      2292   466_548114    Simpson  1.832748e-02 1.997220e-01            0
      2293   466_548114 invSimpson  1.073195e-01 1.987732e-01            0
      2294   466_548114        PIE  1.835498e-02 1.990961e-01            0
      2295   466_548114      DomMc -1.191444e-02 3.134041e-01            0
      2296   466_546656          S  5.000000e-01 8.789623e-01            0
      2297   466_546656          N -8.800000e+01 8.895874e-01            0
      2298   466_546656       maxN -1.550000e+01 9.637905e-01            0
      2299   466_546656    Shannon -1.537730e-01 5.541075e-01            0
      2300   466_546656 expShannon -7.558476e-01 5.177683e-01            0
      2301   466_546656    Simpson -7.651011e-02 2.519588e-01            0
      2302   466_546656 invSimpson -8.356610e-01 2.823465e-01            0
      2303   466_546656        PIE -7.570175e-02 2.647782e-01            0
      2304   466_546656      DomMc  1.052964e-01 3.315958e-01            0
      2305   466_554678          S  5.172414e-02 8.929336e-01            0
      2306   466_554678          N -1.386207e+02 6.280255e-01            0
      2307   466_554678       maxN  6.813793e+01 7.295782e-01            0
      2308   466_554678    Shannon -4.209527e-02 3.099247e-01            0
      2309   466_554678 expShannon -1.447635e-01 3.370174e-01            0
      2310   466_554678    Simpson -2.218546e-02 2.825336e-01            0
      2311   466_554678 invSimpson -1.476087e-01 3.245783e-01            0
      2312   466_554678        PIE -2.212718e-02 2.848637e-01            0
      2313   466_554678      DomMc  9.639786e-03 5.494805e-01            0
      2314   466_555360          S  1.932295e-01 2.149952e-01            0
      2315   466_555360          N -1.124095e+02 8.152851e-01            0
      2316   466_555360       maxN -1.702687e+02 7.044353e-01            0
      2317   466_555360    Shannon  3.264682e-02 5.762236e-02            0
      2318   466_555360 expShannon  7.773027e-02 2.774124e-02            1
      2319   466_555360    Simpson  2.020453e-02 4.714475e-02            1
      2320   466_555360 invSimpson  7.377748e-02 1.151460e-02            1
      2321   466_555360        PIE  2.021123e-02 4.714726e-02            1
      2322   466_555360      DomMc -5.990577e-03 1.216558e-01            0
      2323   466_554629          S  2.500000e-01 1.004276e-15            1
      2324   466_554629          N  3.178750e+02 1.312261e-01            0
      2325   466_554629       maxN  3.457500e+02 1.368474e-01            0
      2326   466_554629    Shannon -6.760396e-02 2.767832e-02            1
      2327   466_554629 expShannon -1.509309e-01 2.174517e-02            1
      2328   466_554629    Simpson -4.143443e-02 5.618272e-02            0
      2329   466_554629 invSimpson -1.405955e-01 5.325865e-02            0
      2330   466_554629        PIE -4.146581e-02 5.610111e-02            0
      2331   466_554629      DomMc  1.531152e-02 2.083901e-01            0
      2332   466_551718          S -2.931034e-01 3.117823e-01            0
      2333   466_551718          N  2.057759e+01 9.775538e-01            0
      2334   466_551718       maxN -2.387931e+00 9.973519e-01            0
      2335   466_551718    Shannon  2.918694e-02 2.647268e-01            0
      2336   466_551718 expShannon  4.967743e-02 2.042559e-01            0
      2337   466_551718    Simpson  1.592181e-02 2.568826e-01            0
      2338   466_551718 invSimpson  2.739113e-02 1.962204e-01            0
      2339   466_551718        PIE  1.592061e-02 2.570534e-01            0
      2340   466_551718      DomMc -4.742740e-03 1.399091e-01            0
      2341   466_551716          S -8.769231e-02 3.915130e-01            0
      2342   466_551716          N -1.540462e+02 3.525905e-01            0
      2343   466_551716       maxN -1.471646e+02 3.651660e-01            0
      2344   466_551716    Shannon  1.856907e-02 3.995094e-01            0
      2345   466_551716 expShannon  3.943243e-02 3.809523e-01            0
      2346   466_551716    Simpson  9.778409e-03 3.319656e-01            0
      2347   466_551716 invSimpson  2.435719e-02 2.767485e-01            0
      2348   466_551716        PIE  9.791005e-03 3.317201e-01            0
      2349   466_551716      DomMc -4.505633e-03 3.567582e-01            0
      2350   466_558275          S -1.790451e-01 3.872023e-02            1
      2351   466_558275          N -9.163926e+01 3.855782e-01            0
      2352   466_558275       maxN -7.172679e+01 3.567154e-01            0
      2353   466_558275    Shannon -2.448373e-03 8.811971e-01            0
      2354   466_558275 expShannon -6.070799e-03 8.325172e-01            0
      2355   466_558275    Simpson -2.549127e-03 7.449876e-01            0
      2356   466_558275 invSimpson -5.158548e-03 6.884989e-01            0
      2357   466_558275        PIE -2.547493e-03 7.451594e-01            0
      2358   466_558275      DomMc -5.711028e-04 8.648241e-01            0
      2359   466_552443          S -3.418803e-02 7.677317e-01            0
      2360   466_552443          N -4.168625e+02 2.080015e-01            0
      2361   466_552443       maxN -4.211484e+02 1.489745e-01            0
      2362   466_552443    Shannon  2.451569e-02 1.542004e-01            0
      2363   466_552443 expShannon  4.576299e-02 1.501907e-01            0
      2364   466_552443    Simpson  1.969124e-02 8.553122e-02            0
      2365   466_552443 invSimpson  4.487925e-02 9.811951e-02            0
      2366   466_552443        PIE  1.969895e-02 8.552791e-02            0
      2367   466_552443      DomMc  4.137735e-05 9.862221e-01            0
      2368   466_557546          S  9.937311e-02 5.669755e-01            0
      2369   466_557546          N -2.640323e+02 1.902523e-01            0
      2370   466_557546       maxN -2.003197e+02 1.799730e-01            0
      2371   466_557546    Shannon  8.443864e-03 5.934381e-01            0
      2372   466_557546 expShannon  2.037906e-02 5.521567e-01            0
      2373   466_557546    Simpson  2.231436e-03 8.091943e-01            0
      2374   466_557546 invSimpson  8.238358e-03 7.517714e-01            0
      2375   466_557546        PIE  2.239689e-03 8.086154e-01            0
      2376   466_557546      DomMc -2.050302e-03 4.955048e-01            0
      2377   466_553173          S  4.171867e-02 4.675063e-01            0
      2378   466_553173          N  3.967923e+02 4.911442e-01            0
      2379   466_553173       maxN  3.761503e+02 5.001514e-01            0
      2380   466_553173    Shannon  1.549566e-02 2.710829e-01            0
      2381   466_553173 expShannon  3.917322e-02 1.816770e-01            0
      2382   466_553173    Simpson  8.676506e-03 2.856884e-01            0
      2383   466_553173 invSimpson  3.121762e-02 1.726876e-01            0
      2384   466_553173        PIE  8.682044e-03 2.856056e-01            0
      2385   466_553173      DomMc -3.689039e-03 1.201719e-01            0
      2386   466_564882          S -1.134615e-01 8.384311e-01            0
      2387   466_564882          N  6.027979e+03 1.764467e-03            1
      2388   466_564882       maxN  6.054319e+03 1.560805e-03            1
      2389   466_564882    Shannon -1.168843e-01 1.092029e-01            0
      2390   466_564882 expShannon -4.266612e-01 2.333321e-01            0
      2391   466_564882    Simpson -4.760123e-02 3.384701e-02            1
      2392   466_564882 invSimpson -2.797251e-01 2.509940e-01            0
      2393   466_564882        PIE -4.770897e-02 3.475431e-02            1
      2394   466_564882      DomMc  2.254453e-02 2.917103e-01            0
      2395   466_556816          S  2.221507e-01 1.554183e-01            0
      2396   466_556816          N -5.951178e+02 1.259614e-02            1
      2397   466_556816       maxN -5.235023e+02 4.173390e-02            1
      2398   466_556816    Shannon  3.105516e-02 2.679567e-01            0
      2399   466_556816 expShannon  5.355249e-02 3.128982e-01            0
      2400   466_556816    Simpson  1.318104e-02 3.948190e-01            0
      2401   466_556816 invSimpson  1.831530e-02 6.161044e-01            0
      2402   466_556816        PIE  1.320418e-02 3.941887e-01            0
      2403   466_556816      DomMc -5.338809e-03 2.667487e-01            0
      2404   466_557544          S -3.656716e-01 3.765085e-01            0
      2405   466_557544          N  6.151493e+01 7.888545e-01            0
      2406   466_557544       maxN  1.072015e+02 5.806597e-01            0
      2407   466_557544    Shannon -1.377652e-01 1.423684e-01            0
      2408   466_557544 expShannon -3.743050e-01 3.435474e-02            1
      2409   466_557544    Simpson -6.904557e-02 1.370718e-01            0
      2410   466_557544 invSimpson -3.043642e-01 3.434486e-02            1
      2411   466_557544        PIE -6.913279e-02 1.368014e-01            0
      2412   466_557544      DomMc  3.576288e-02 1.194091e-02            1
      2413   466_550987          S -6.043956e-02 5.083108e-01            0
      2414   466_550987          N -1.815934e+02 4.888063e-01            0
      2415   466_550987       maxN -1.847033e+02 1.348734e-01            0
      2416   466_550987    Shannon  7.875281e-02 8.043506e-03            1
      2417   466_550987 expShannon  2.263225e-01 3.375007e-02            1
      2418   466_550987    Simpson  3.790276e-02 3.792315e-02            1
      2419   466_550987 invSimpson  2.140617e-01 3.268393e-02            1
      2420   466_550987        PIE  3.796851e-02 3.758640e-02            1
      2421   466_550987      DomMc -2.780052e-02 1.262360e-01            0
      2422   466_558277          S -2.631579e-02 9.268136e-01            0
      2423   466_558277          N -1.756316e+02 1.627854e-01            0
      2424   466_558277       maxN -1.199474e+02 4.610826e-01            0
      2425   466_558277    Shannon  8.641946e-02 4.766143e-01            0
      2426   466_558277 expShannon  2.886584e-01 3.854112e-01            0
      2427   466_558277    Simpson  3.327980e-02 6.072259e-01            0
      2428   466_558277 invSimpson  1.807697e-01 4.639949e-01            0
      2429   466_558277        PIE  3.360125e-02 6.047700e-01            0
      2430   466_558277      DomMc -2.527156e-02 2.106941e-01            0
      2431   466_559732          S -5.294609e-16 3.333333e-01            0
      2432   466_559732          N -1.219000e+03 2.986109e-01            0
      2433   466_559732       maxN -1.561000e+03 1.459625e-01            0
      2434   466_559732    Shannon  2.602792e-01 2.475063e-01            0
      2435   466_559732 expShannon  4.714381e-01 2.663103e-01            0
      2436   466_559732    Simpson  2.031350e-01 2.774309e-01            0
      2437   466_559732 invSimpson  4.876074e-01 3.024672e-01            0
      2438   466_559732        PIE  2.032544e-01 2.773943e-01            0
      2439   466_559732      DomMc  1.220250e-03 8.871754e-01            0
      2440   466_562648          S  1.000000e-01 7.418011e-01            0
      2441   466_562648          N  1.025500e+03 3.432856e-01            0
      2442   466_562648       maxN  9.072000e+02 3.701533e-01            0
      2443   466_562648    Shannon  5.071126e-02 5.349680e-02            0
      2444   466_562648 expShannon  7.118387e-02 5.290401e-02            0
      2445   466_562648    Simpson  2.439417e-02 1.499352e-02            1
      2446   466_562648 invSimpson  3.205011e-02 1.474247e-02            1
      2447   466_562648        PIE  2.438719e-02 1.506035e-02            1
      2448   466_562648      DomMc -9.248962e-03 2.636050e-01            0
      2449   211_529239          S -1.735294e+00 2.027782e-01            0
      2450   211_529239          N  7.617647e+00 7.223984e-01            0
      2451   211_529239       maxN  4.029412e+00 3.055014e-01            0
      2452   211_529239    Shannon -9.024519e-02 1.584857e-01            0
      2453   211_529239 expShannon -7.779693e-01 1.394338e-01            0
      2454   211_529239    Simpson -1.500088e-02 3.330712e-01            0
      2455   211_529239 invSimpson -3.039842e-01 2.550297e-01            0
      2456   211_529239        PIE -1.512943e-02 3.205442e-01            0
      2457   211_529239      DomMc  2.144733e-02 2.588063e-01            0
      2458   211_525598          S -4.094203e-01 5.648898e-01            0
      2459   211_525598          N -3.086594e+01 5.409952e-02            0
      2460   211_525598       maxN -1.294928e+01 1.149692e-02            1
      2461   211_525598    Shannon -3.709323e-02 5.496275e-01            0
      2462   211_525598 expShannon -1.591431e-01 6.889734e-01            0
      2463   211_525598    Simpson -1.177740e-02 4.291502e-01            0
      2464   211_525598 invSimpson -1.181043e-01 6.762612e-01            0
      2465   211_525598        PIE -1.063866e-02 4.672394e-01            0
      2466   211_525598      DomMc  1.414122e-02 5.784912e-01            0
      2467   211_521960          S -5.342466e-01 6.920654e-01            0
      2468   211_521960          N  8.986301e+00 7.682497e-01            0
      2469   211_521960       maxN  3.835616e+00 7.224501e-01            0
      2470   211_521960    Shannon -8.190492e-03 9.315559e-01            0
      2471   211_521960 expShannon -1.917838e-01 7.859257e-01            0
      2472   211_521960    Simpson  4.528673e-03 8.472533e-01            0
      2473   211_521960 invSimpson  1.114771e-01 8.234589e-01            0
      2474   211_521960        PIE  4.275175e-03 8.539355e-01            0
      2475   211_521960      DomMc -7.282542e-03 8.322052e-01            0
      2476   211_523410          S -6.071429e-01 4.407892e-01            0
      2477   211_523410          N  7.464286e+00 6.429730e-01            0
      2478   211_523410       maxN -1.190476e-01 9.853829e-01            0
      2479   211_523410    Shannon -2.541040e-02 7.079017e-01            0
      2480   211_523410 expShannon -1.333572e-01 6.451904e-01            0
      2481   211_523410    Simpson  7.224659e-03 7.735741e-01            0
      2482   211_523410 invSimpson  3.893851e-02 8.637747e-01            0
      2483   211_523410        PIE  7.816709e-03 7.527699e-01            0
      2484   211_523410      DomMc  2.095058e-03 9.238449e-01            0
      2485   211_517585          S -2.000000e+00 3.258001e-01            0
      2486   211_517585          N -2.080000e+01 3.475102e-01            0
      2487   211_517585       maxN -1.630000e+01 1.568652e-01            0
      2488   211_517585    Shannon -7.504626e-02 9.833613e-02            0
      2489   211_517585 expShannon -3.865105e-01 9.564147e-02            0
      2490   211_517585    Simpson  1.323675e-02 7.261074e-02            0
      2491   211_517585 invSimpson  1.506665e-01 7.318807e-02            0
      2492   211_517585        PIE  1.425017e-02 6.089155e-02            0
      2493   211_517585      DomMc  2.801250e-02 2.180101e-01            0
      2494   211_516855          S  2.400000e+00 1.177425e-01            0
      2495   211_516855          N  7.900000e+01 4.678149e-01            0
      2496   211_516855       maxN  5.030000e+01 4.668974e-01            0
      2497   211_516855    Shannon  5.828053e-02 7.323762e-01            0
      2498   211_516855 expShannon  1.364060e-01 8.092947e-01            0
      2499   211_516855    Simpson  2.777139e-03 9.692534e-01            0
      2500   211_516855 invSimpson -6.470339e-02 9.014853e-01            0
      2501   211_516855        PIE  1.539167e-04 9.983726e-01            0
      2502   211_516855      DomMc -6.451861e-03 9.358881e-01            0
      2503  437_2075128          S  3.571429e+00 3.756807e-01            0
      2504  437_2075128          N  4.307143e+01 3.042622e-01            0
      2505  437_2075128       maxN  3.857143e+00 3.230290e-01            0
      2506  437_2075128    Shannon  1.207825e-01 4.856452e-01            0
      2507  437_2075128 expShannon  1.583326e+00 4.602805e-01            0
      2508  437_2075128    Simpson  1.513082e-02 4.950162e-01            0
      2509  437_2075128 invSimpson  1.255697e+00 4.325460e-01            0
      2510  437_2075128        PIE  1.364557e-02 4.971791e-01            0
      2511  437_2075128      DomMc -3.923115e-02 4.770480e-01            0
      2512  437_2077319          S  3.975904e-01 8.451250e-01            0
      2513  437_2077319          N  2.898795e+01 6.151596e-02            0
      2514  437_2077319       maxN  1.169880e+01 1.380894e-01            0
      2515  437_2077319    Shannon -5.180435e-02 4.788611e-01            0
      2516  437_2077319 expShannon -9.922004e-01 4.371294e-01            0
      2517  437_2077319    Simpson -7.347280e-03 5.627697e-01            0
      2518  437_2077319 invSimpson -7.821004e-01 4.018830e-01            0
      2519  437_2077319        PIE -7.665103e-03 5.491935e-01            0
      2520  437_2077319      DomMc  1.476522e-02 5.016367e-01            0
      2521  437_2076590          S  1.325301e-01 9.871370e-01            0
      2522  437_2076590          N  5.995181e+01 5.647613e-01            0
      2523  437_2076590       maxN  3.544578e+01 1.325823e-01            0
      2524  437_2076590    Shannon -4.293999e-02 6.669258e-01            0
      2525  437_2076590 expShannon -1.684171e+00 6.042921e-01            0
      2526  437_2076590    Simpson -5.673150e-03 1.521237e-01            0
      2527  437_2076590 invSimpson -1.597240e+00 2.595072e-01            0
      2528  437_2076590        PIE -5.722869e-03 1.430866e-01            0
      2529  437_2076590      DomMc  1.815957e-02 6.015803e-02            0
      2530  437_2078777          S -6.867470e-01 9.223909e-01            0
      2531  437_2078777          N  9.372289e+01 3.361044e-01            0
      2532  437_2078777       maxN  4.608434e+01 4.796795e-02            1
      2533  437_2078777    Shannon -1.031067e-01 3.944142e-01            0
      2534  437_2078777 expShannon -2.383952e+00 4.077056e-01            0
      2535  437_2078777    Simpson -1.199216e-02 3.610889e-01            0
      2536  437_2078777 invSimpson -1.412730e+00 3.948968e-01            0
      2537  437_2078777        PIE -1.209777e-02 3.547715e-01            0
      2538  437_2078777      DomMc  3.186511e-02 3.037307e-01            0
      2539  437_2076589          S  1.571429e+00 3.338324e-02            1
      2540  437_2076589          N  1.271429e+01 1.303031e-01            0
      2541  437_2076589       maxN  3.642857e+00 7.887005e-02            0
      2542  437_2076589    Shannon  1.547882e-02 6.204052e-01            0
      2543  437_2076589 expShannon  2.656532e-01 6.251218e-01            0
      2544  437_2076589    Simpson -5.056574e-04 8.415599e-01            0
      2545  437_2076589 invSimpson -7.577548e-02 8.358517e-01            0
      2546  437_2076589        PIE -7.286166e-04 7.822304e-01            0
      2547  437_2076589      DomMc  2.914939e-03 7.109326e-01            0
      2548  437_2075860          S  8.857143e+00 2.112364e-01            0
      2549  437_2075860          N  9.564286e+01 4.685435e-02            1
      2550  437_2075860       maxN -7.928571e+00 1.526367e-01            0
      2551  437_2075860    Shannon  2.229849e-01 1.051274e-01            0
      2552  437_2075860 expShannon  3.897473e+00 1.119665e-01            0
      2553  437_2075860    Simpson  3.115083e-02 1.138985e-01            0
      2554  437_2075860 invSimpson  2.546991e+00 4.375078e-02            1
      2555  437_2075860        PIE  3.089897e-02 1.149106e-01            0
      2556  437_2075860      DomMc -7.236363e-02 9.619146e-02            0
      2557  437_2074400          S  1.142857e+00 6.882791e-01            0
      2558  437_2074400          N  5.214286e+00 7.406458e-01            0
      2559  437_2074400       maxN -1.571429e+00 8.671915e-01            0
      2560  437_2074400    Shannon  1.264382e-02 9.050977e-01            0
      2561  437_2074400 expShannon  1.741330e-01 9.280099e-01            0
      2562  437_2074400    Simpson  2.088081e-03 8.487628e-01            0
      2563  437_2074400 invSimpson  2.177642e-01 8.842929e-01            0
      2564  437_2074400        PIE  1.988833e-03 8.595079e-01            0
      2565  437_2074400      DomMc -8.747615e-03 7.176802e-01            0
      2566  437_2074399          S  3.500000e+00 3.333333e-01            0
      2567  437_2074399          N  7.728571e+01 2.458516e-01            0
      2568  437_2074399       maxN  9.357143e+00 6.986183e-02            0
      2569  437_2074399    Shannon  4.890532e-02 5.274095e-01            0
      2570  437_2074399 expShannon  1.084920e+00 4.938032e-01            0
      2571  437_2074399    Simpson  2.091613e-03 7.424230e-01            0
      2572  437_2074399 invSimpson  4.418913e-01 7.242550e-01            0
      2573  437_2074399        PIE  1.601957e-03 7.833754e-01            0
      2574  437_2074399      DomMc -2.877749e-03 9.190108e-01            0
               intercept
      1     2.332857e+02
      2     1.835584e+05
      3     9.215793e+04
      4     1.094391e+00
      5     2.240499e+00
      6     5.602721e-01
      7     1.155550e+00
      8     5.427301e-01
      9    -7.453550e-02
      10   -1.029210e+02
      11   -1.486837e+04
      12   -2.308460e+03
      13   -3.926969e-02
      14   -1.680343e+01
      15   -9.733307e-01
      16   -6.545918e+01
      17   -9.232533e-01
      18    3.106645e+00
      19    5.368935e+02
      20    3.854565e+03
      21   -8.242593e+02
      22    3.179601e+01
      23    8.984978e+02
      24    3.386410e+00
      25    1.301187e+03
      26    3.167031e+00
      27   -1.411255e+01
      28    8.765197e+01
      29    1.201147e+03
      30    7.104488e+02
      31   -7.441081e+00
      32   -5.649365e+01
      33    2.301861e-02
      34   -6.732495e+01
      35   -2.239074e+01
      36    1.327550e+01
      37    7.573162e+01
      38   -2.972930e+03
      39   -2.400136e+03
      40    2.270696e+01
      41    8.562077e+01
      42    9.085805e+00
      43    4.495038e+01
      44    9.313223e+00
      45   -1.127589e-01
      46    4.437931e+02
      47   -1.049291e+04
      48   -4.168172e+03
      49    2.987583e+01
      50    6.369328e+02
      51    3.302417e+00
      52    6.344856e+02
      53    3.362942e+00
      54   -1.003767e+01
      55   -5.702000e+02
      56   -6.076260e+04
      57   -2.787200e+04
      58    6.796558e+01
      59    1.311156e+03
      60    1.304792e+01
      61    1.642883e+03
      62    1.350798e+01
      63   -2.699857e+01
      64    3.443600e+03
      65   -6.126630e+04
      66   -3.871890e+04
      67    2.061315e+02
      68    2.269366e+03
      69    3.885122e+01
      70    1.441655e+03
      71    3.994531e+01
      72   -2.565150e+01
      73    1.032600e+03
      74    9.328400e+03
      75   -4.156600e+03
      76    4.568966e+01
      77    6.331115e+02
      78    1.210474e+01
      79    8.199921e+02
      80    1.195200e+01
      81   -2.025355e+01
      82    6.070500e+03
      83    3.651575e+05
      84    1.498040e+04
      85    1.418689e+02
      86    1.907682e+03
      87    2.052649e+01
      88    1.429652e+03
      89    2.035632e+01
      90   -4.166881e+01
      91    2.854700e+03
      92    1.376050e+05
      93    1.160860e+04
      94    1.224163e+02
      95    2.051769e+03
      96    1.116918e+01
      97    1.622099e+03
      98    1.103096e+01
      99   -2.473533e+01
      100   1.026000e+03
      101  -1.766750e+04
      102   1.393150e+04
      103  -7.188340e+01
      104  -7.830888e+02
      105  -2.942664e+01
      106  -1.511128e+03
      107  -2.914093e+01
      108   6.172767e+01
      109   8.213000e+02
      110   1.092480e+04
      111   1.418900e+03
      112   2.176855e+02
      113   1.220966e+03
      114   4.897134e+01
      115   1.272065e+03
      116   3.900620e+01
      117  -8.910182e+01
      118   6.672400e+03
      119   1.283060e+05
      120  -4.684000e+02
      121   2.152389e+02
      122   3.647642e+03
      123   2.188264e+01
      124   2.434439e+03
      125   2.161891e+01
      126  -3.569931e+01
      127   1.427100e+03
      128   1.049673e+05
      129   3.020700e+04
      130  -3.486195e+01
      131  -3.146871e+02
      132  -1.010690e+01
      133  -6.072931e+02
      134  -1.202273e+01
      135   3.099575e+01
      136  -3.382800e+03
      137   6.382220e+04
      138   3.485200e+03
      139  -2.330478e+01
      140  -7.708417e+02
      141   2.135848e+00
      142  -1.555997e+02
      143   1.922683e+00
      144  -8.315936e+00
      145   3.441200e+03
      146   1.764320e+04
      147  -1.577000e+03
      148   2.239296e+02
      149   3.293613e+03
      150   2.368914e+01
      151   2.700977e+03
      152   2.318961e+01
      153  -5.925857e+01
      154   6.218000e+02
      155   2.382520e+04
      156   8.470000e+03
      157  -1.024180e+02
      158  -1.355671e+03
      159  -1.533771e+01
      160  -1.111874e+03
      161  -1.772484e+01
      162   5.554853e+01
      163  -3.390400e+03
      164   1.911590e+05
      165   5.342360e+04
      166  -1.377245e+02
      167  -1.818750e+03
      168  -1.190806e+01
      169  -9.873109e+02
      170  -1.256709e+01
      171   4.148728e+01
      172  -2.094048e+03
      173  -1.318128e+05
      174  -2.622057e+04
      175  -4.715339e+01
      176  -6.232712e+02
      177  -7.116507e+00
      178  -7.211102e+02
      179  -4.920902e+00
      180   3.439562e+01
      181  -4.190800e+03
      182  -2.939740e+04
      183  -1.257440e+04
      184  -1.558369e+02
      185  -2.407244e+03
      186  -7.060236e+00
      187  -6.770200e+02
      188  -6.833576e+00
      189  -3.924745e+00
      190  -7.626400e+03
      191  -6.184090e+04
      192  -1.585520e+04
      193  -4.099388e+02
      194  -3.023526e+03
      195  -6.100394e+01
      196  -1.717039e+03
      197  -5.234528e+01
      198   1.257965e+02
      199   1.017000e+03
      200   2.067200e+03
      201  -1.223840e+04
      202   3.530769e+02
      203   2.464274e+03
      204   1.123852e+02
      205   2.609961e+03
      206   1.141337e+02
      207  -1.386558e+02
      208   3.850700e+03
      209   5.511440e+04
      210   8.471100e+03
      211   5.495364e+01
      212   1.011964e+03
      213   1.769425e+00
      214   1.995392e+02
      215   7.868646e-01
      216   1.504536e+01
      217  -1.183000e+03
      218  -6.492140e+04
      219  -1.393040e+04
      220   4.347209e+01
      221   6.902842e+02
      222  -3.605863e+00
      223   4.212965e+02
      224  -3.183480e+00
      225  -3.421909e+01
      226  -6.815300e+03
      227  -3.124820e+04
      228  -6.398400e+03
      229  -3.863684e+02
      230  -3.091973e+03
      231  -5.814549e+01
      232  -1.584498e+03
      233  -5.620174e+01
      234   1.162549e+02
      235   2.011467e+04
      236   1.357540e+05
      237   2.916400e+04
      238   1.941993e+03
      239   1.120090e+04
      240   4.474072e+02
      241   7.242583e+03
      242   2.306739e+02
      243  -6.184319e+02
      244   3.651400e+03
      245  -2.693900e+04
      246   7.885200e+03
      247   5.955476e+01
      248   7.670464e+02
      249  -9.378417e+00
      250  -1.237236e+03
      251  -8.999242e+00
      252   3.888253e+01
      253   1.672679e+03
      254  -6.188714e+03
      255   3.861786e+02
      256   9.209295e+01
      257   1.141475e+03
      258   7.000882e+00
      259   6.358727e+02
      260   9.547651e+00
      261  -1.045886e+01
      262   3.834000e+03
      263   8.216640e+04
      264   5.133120e+04
      265   7.231528e+01
      266   1.136052e+03
      267  -2.546384e+01
      268   5.003943e+02
      269  -3.129649e+01
      270   2.125900e+01
      271   2.094171e+03
      272   7.730206e+04
      273   2.802649e+04
      274  -1.331373e+02
      275  -1.362823e+03
      276  -2.529206e+01
      277  -1.305057e+03
      278  -2.655001e+01
      279   5.715530e+01
      280   4.243700e+03
      281   1.064240e+04
      282   2.869300e+03
      283   2.008861e+02
      284   2.397226e+03
      285   1.766242e+01
      286   5.041853e+02
      287   1.693702e+01
      288   9.314447e+00
      289   8.264800e+03
      290   1.840482e+05
      291   8.573630e+04
      292   1.086186e+01
      293  -4.459621e+01
      294  -2.985656e+01
      295  -1.845653e+03
      296  -3.121990e+01
      297   6.980167e+01
      298   1.006533e+04
      299   9.754300e+04
      300   2.011367e+04
      301   2.090388e+02
      302   2.074929e+03
      303   1.429601e+01
      304   7.441737e+02
      305  -3.182719e+01
      306  -1.669688e+01
      307  -8.608400e+03
      308  -5.373030e+04
      309   1.379290e+04
      310  -1.783269e+02
      311  -3.513827e+03
      312  -1.126059e+01
      313  -2.017100e+03
      314  -1.115474e+01
      315   2.023845e+01
      316   4.261800e+03
      317   1.841268e+05
      318   4.601440e+04
      319   1.060397e+02
      320   1.832321e+03
      321   7.891689e+00
      322   9.753783e+02
      323   7.718491e+00
      324  -1.443158e+01
      325   3.055333e+03
      326   2.298730e+05
      327   8.156800e+04
      328  -1.906832e+02
      329  -3.167865e+03
      330  -1.425951e+01
      331  -1.284945e+03
      332  -1.466029e+01
      333  -1.640880e+01
      334  -3.681000e+02
      335  -8.456870e+04
      336  -3.767240e+04
      337   1.026931e+02
      338   1.252389e+03
      339   1.462739e+01
      340   9.169373e+02
      341   1.483158e+01
      342  -1.555433e+01
      343   2.628900e+03
      344   4.915570e+04
      345   2.033780e+04
      346  -1.265640e+02
      347  -1.116286e+03
      348  -3.888078e+01
      349  -1.621012e+03
      350  -4.879893e+01
      351   9.787043e+01
      352   2.630400e+03
      353   4.272680e+04
      354   4.648520e+04
      355  -3.096966e+02
      356  -1.588706e+03
      357  -1.613325e+02
      358  -1.822114e+03
      359  -1.672168e+02
      360   1.414623e+02
      361  -1.507286e+03
      362  -1.066507e+04
      363   4.673571e+02
      364  -1.281049e+02
      365  -1.530987e+03
      366  -1.319740e+01
      367  -9.995808e+02
      368  -1.305769e+01
      369   2.462342e+01
      370  -1.704762e+03
      371  -1.538933e+03
      372   2.541562e+03
      373  -1.402873e+02
      374  -1.557633e+03
      375  -2.018892e+01
      376  -1.491280e+03
      377  -2.023594e+01
      378   4.846507e+01
      379   5.309448e+03
      380   1.990285e+04
      381   1.514771e+03
      382   2.408663e+02
      383   3.376612e+03
      384   2.226243e+01
      385   2.337479e+03
      386   2.058607e+01
      387  -5.328116e+01
      388   2.039000e+03
      389   1.652756e+05
      390   1.985440e+04
      391   8.186735e+01
      392   9.004266e+02
      393   1.069793e+01
      394   6.038992e+02
      395   1.032560e+01
      396  -2.153690e+01
      397  -4.534577e+03
      398  -1.181643e+05
      399  -6.260927e+04
      400   6.491026e+00
      401  -3.075718e+02
      402   3.213721e+01
      403   7.408582e+02
      404   3.320451e+01
      405  -5.024884e+01
      406   1.023800e+03
      407   1.420600e+04
      408   3.041400e+03
      409   7.956967e+01
      410   9.539421e+02
      411   4.566512e+00
      412   3.211401e+02
      413   3.877460e+00
      414   1.748532e+00
      415  -9.588000e+02
      416  -1.027204e+05
      417  -6.154200e+03
      418  -6.162599e+01
      419  -1.495745e+03
      420  -6.639376e+00
      421  -1.976837e+03
      422  -6.429172e+00
      423   9.210396e+00
      424   5.261300e+03
      425  -6.372750e+04
      426  -1.270670e+04
      427   8.615514e+01
      428   1.202075e+03
      429   2.884045e+00
      430   1.774349e+02
      431   2.963300e+00
      432   9.858144e+00
      433   4.200000e+01
      434  -1.067382e+05
      435   1.215400e+04
      436  -8.442051e+01
      437  -1.757157e+03
      438  -1.210408e+01
      439  -2.441422e+03
      440  -1.186151e+01
      441   4.239928e+01
      442   4.861700e+03
      443  -1.228309e+05
      444  -1.047856e+05
      445   4.503400e+02
      446   6.517743e+03
      447   8.304088e+01
      448   4.397264e+03
      449   8.379929e+01
      450  -1.136915e+02
      451  -1.185200e+03
      452   3.152300e+04
      453   1.813280e+04
      454  -9.442725e+01
      455  -1.110967e+03
      456  -2.107905e+01
      457  -1.161580e+03
      458  -2.219380e+01
      459   4.628994e+01
      460   4.446600e+03
      461   5.082610e+04
      462   2.303000e+02
      463   2.352041e+02
      464   3.776009e+03
      465   2.110367e+01
      466   2.849661e+03
      467   1.954980e+01
      468  -4.286243e+01
      469   1.409300e+04
      470   2.052040e+05
      471   2.516700e+04
      472   6.045792e+02
      473   7.400810e+03
      474   7.394491e+01
      475   4.852642e+03
      476   6.616207e+01
      477  -1.391344e+02
      478   1.646900e+03
      479   1.433667e+05
      480  -3.142560e+04
      481   1.663183e+02
      482   2.610935e+03
      483   2.844516e+01
      484   2.957038e+03
      485   2.828511e+01
      486  -1.022869e+02
      487   4.041200e+03
      488   3.932200e+04
      489   4.646400e+03
      490   1.135135e+02
      491   1.639444e+03
      492   8.974819e+00
      493   9.194574e+02
      494   6.441529e+00
      495  -9.744601e+00
      496   3.051500e+03
      497   1.159448e+06
      498   5.783466e+05
      499  -3.474458e+02
      500  -3.457367e+03
      501  -6.507865e+01
      502  -2.664657e+03
      503  -6.522817e+01
      504   1.587339e+02
      505  -5.802700e+03
      506  -3.234581e+05
      507  -4.067440e+04
      508  -1.932020e+02
      509  -2.399943e+03
      510  -3.120300e+01
      511  -2.117736e+03
      512  -3.000505e+01
      513   7.105127e+01
      514   1.027000e+03
      515   2.514320e+04
      516   2.058600e+03
      517   5.908207e+01
      518   5.878426e+02
      519   1.101487e+01
      520   4.927411e+02
      521   1.068430e+01
      522  -2.333544e+01
      523  -1.584400e+03
      524  -3.556890e+04
      525  -1.483570e+04
      526   8.573016e+01
      527   1.218563e+03
      528   1.704875e+01
      529   1.713473e+03
      530   1.779625e+01
      531  -6.092443e+01
      532  -7.857000e+02
      533   1.246004e+05
      534   3.489490e+04
      535   1.242255e+02
      536   1.116206e+03
      537   2.236111e+01
      538   8.902310e+02
      539   2.154423e+01
      540  -5.361003e+01
      541  -1.203300e+04
      542   4.091662e+05
      543   4.723197e+05
      544  -2.032319e+03
      545  -1.347320e+04
      546  -6.127805e+02
      547  -9.027404e+03
      548  -6.165458e+02
      549   5.796543e+02
      550  -6.008333e+03
      551  -1.604447e+05
      552  -9.239233e+04
      553   6.016705e+01
      554   7.411599e+02
      555   4.217883e+01
      556   2.865331e+03
      557   4.314987e+01
      558  -8.870252e+01
      559   2.766667e+01
      560   1.278352e+05
      561   3.019000e+04
      562  -2.483439e+02
      563  -4.125446e+03
      564  -2.456266e+01
      565  -3.804288e+03
      566  -2.673249e+01
      567   5.825357e+01
      568   5.452600e+03
      569   3.801400e+03
      570  -1.462890e+04
      571   2.327878e+02
      572   2.878095e+03
      573   3.231389e+01
      574   2.167652e+03
      575   3.240037e+01
      576  -4.739997e+01
      577   8.230000e+02
      578   3.126120e+04
      579   2.494940e+04
      580  -2.692647e+02
      581  -2.207592e+03
      582  -7.118410e+01
      583  -2.784434e+03
      584  -7.381197e+01
      585   1.645213e+02
      586  -7.023167e+03
      587  -4.517283e+04
      588  -2.991167e+03
      589  -4.372573e+02
      590  -3.022740e+03
      591  -1.068064e+02
      592  -2.416739e+03
      593  -9.869028e+01
      594   1.020722e+02
      595   6.679900e+03
      596  -1.415294e+05
      597  -4.913000e+04
      598   1.610909e+02
      599   3.655578e+03
      600   1.026102e+01
      601   2.002888e+03
      602   1.041370e+01
      603  -2.014118e+01
      604  -1.878000e+02
      605   2.461600e+03
      606  -1.900000e+02
      607  -2.351848e+00
      608  -1.348576e+01
      609   2.347470e+00
      610   1.013347e+02
      611   1.432358e+00
      612  -1.555227e+01
      613   5.052000e+03
      614  -2.406480e+04
      615  -2.385670e+04
      616   3.011585e+02
      617   3.293877e+03
      618   3.933053e+01
      619   1.667586e+03
      620   3.971048e+01
      621  -5.406245e+01
      622   7.075200e+03
      623   2.710704e+05
      624   3.790460e+04
      625   7.356731e+01
      626   1.503328e+03
      627   2.825195e+00
      628   4.203296e+02
      629   2.370386e+00
      630   4.511270e+00
      631   2.637400e+03
      632   1.363583e+05
      633   1.278040e+04
      634   7.405465e+01
      635   1.011240e+03
      636   7.387506e+00
      637   1.015732e+03
      638   6.773348e+00
      639   1.116633e+00
      640   6.065667e+03
      641   4.899467e+04
      642   1.569637e+05
      643  -3.253232e+02
      644  -4.910876e+03
      645  -7.860758e+01
      646  -6.772877e+03
      647  -7.881106e+01
      648   2.139417e+02
      649  -1.997500e+03
      650   4.054000e+03
      651   3.223800e+03
      652  -1.992865e+02
      653  -2.013167e+03
      654  -2.707685e+01
      655  -1.750553e+03
      656  -3.043096e+01
      657   6.795125e+01
      658  -2.197000e+03
      659  -1.613880e+04
      660  -2.571400e+03
      661  -1.685641e+02
      662  -1.223595e+03
      663  -2.506271e+01
      664  -7.049679e+02
      665  -2.438127e+01
      666   3.181668e+01
      667  -6.009000e+02
      668   1.249710e+04
      669   7.858700e+03
      670  -1.831268e+02
      671  -4.218617e+02
      672  -6.325299e+01
      673  -3.019852e+02
      674  -8.305947e+01
      675   9.375385e+01
      676   5.789000e+03
      677   2.572520e+05
      678   1.164593e+05
      679  -7.205448e+01
      680  -1.002848e+03
      681  -3.211146e+01
      682  -1.824121e+03
      683  -3.380100e+01
      684   4.683377e+01
      685   3.634000e+03
      686   6.641933e+04
      687   3.145533e+04
      688   1.300513e+02
      689   6.691895e+02
      690   1.308933e+00
      691   4.176846e+01
      692  -1.462435e+01
      693  -1.041444e+01
      694   1.620667e+03
      695   2.040600e+04
      696  -5.190667e+03
      697   2.457522e+02
      698   1.373742e+03
      699   8.693054e+01
      700   1.366712e+03
      701   8.585115e+01
      702  -9.911071e+01
      703   6.745669e+02
      704   2.518991e+04
      705   1.566016e+04
      706   3.315930e+01
      707   7.066180e+01
      708   5.678515e+00
      709   2.794197e+01
      710  -3.089777e+01
      711  -6.791607e+00
      712  -3.275443e+02
      713  -5.508785e+03
      714  -5.015468e+03
      715  -4.852444e+01
      716  -6.566994e+01
      717  -2.973913e+01
      718  -5.466721e+01
      719  -5.494789e+01
      720   4.138517e+00
      721   1.999333e+03
      722   6.286000e+04
      723   2.096333e+04
      724   3.208910e+02
      725   1.110581e+03
      726   1.383583e+02
      727   1.151502e+03
      728   1.065024e+02
      729  -1.449406e+02
      730   2.000000e+00
      731   2.182299e+03
      732   1.582607e+03
      733  -8.711231e+00
      734  -1.590324e+01
      735  -8.588844e+00
      736  -2.843741e+01
      737  -6.104261e+01
      738   1.000000e+00
      739   2.000000e+00
      740   3.248000e+03
      741   3.092000e+03
      742  -8.023567e+01
      743  -1.412521e+02
      744  -7.351008e+01
      745  -1.983991e+02
      746  -1.160091e+02
      747   1.000000e+00
      748  -1.697556e+02
      749  -2.034241e+03
      750  -1.347218e+03
      751  -2.491966e+01
      752  -8.994095e+01
      753  -9.374786e-01
      754  -7.392125e+01
      755   6.153327e+00
      756   2.749063e+01
      757   2.000000e+00
      758   1.265530e+03
      759   1.414665e+03
      760  -6.681284e+01
      761  -1.098758e+02
      762  -5.765788e+01
      763  -1.373486e+02
      764  -1.111366e+02
      765   1.000000e+00
      766  -5.138397e+01
      767   7.265241e+03
      768   3.555574e+03
      769  -1.081689e+01
      770  -9.948961e+00
      771  -5.858328e-01
      772   2.077722e+01
      773  -1.436857e+01
      774   2.792929e+00
      775  -4.998371e+01
      776  -1.520956e+03
      777  -1.867287e+03
      778   1.278691e+01
      779   1.088780e+01
      780   1.557294e+01
      781   2.108954e+01
      782   1.299724e+01
      783   9.663952e+00
      784  -7.897571e+01
      785  -5.726275e+02
      786  -4.926518e+02
      787   3.060030e+00
      788   5.858115e+00
      789   1.363980e+01
      790   4.532593e+01
      791   6.657316e+01
      792   1.112196e+01
      793   1.412036e+01
      794   1.162040e+04
      795   1.073807e+04
      796  -1.501516e+01
      797  -2.306161e+01
      798  -1.275268e+01
      799  -2.659422e+01
      800  -1.438849e+01
      801   9.408186e-01
      802   2.000000e+00
      803  -1.868860e+03
      804  -1.829980e+03
      805   7.170475e+01
      806   1.209201e+02
      807   6.262699e+01
      808   1.461903e+02
      809   1.163626e+02
      810   1.000000e+00
      811   7.342756e+01
      812   1.707919e+03
      813   1.343438e+03
      814   4.649360e+00
      815   7.046508e+00
      816  -1.113820e+00
      817  -9.667956e+00
      818  -1.292809e+01
      819  -1.380919e+00
      820   2.000000e+00
      821   3.595286e+03
      822   2.732107e+03
      823  -1.181011e+01
      824  -2.184453e+01
      825  -1.163419e+01
      826  -3.713109e+01
      827  -7.212024e+01
      828   1.000000e+00
      829   1.522638e+02
      830   3.555862e+03
      831   3.313130e+03
      832  -3.322670e+01
      833  -5.899070e+01
      834  -4.035388e+01
      835  -1.058103e+02
      836  -6.484085e+01
      837  -5.830172e+00
      838   2.000000e+00
      839  -3.808229e+03
      840  -3.696714e+03
      841   5.925263e+01
      842   7.171223e+01
      843   3.764648e+01
      844   2.114005e+01
      845   4.796711e+01
      846   1.000000e+00
      847   8.480165e+01
      848   2.084295e+03
      849   1.767848e+03
      850  -2.673451e+00
      851  -3.682930e+00
      852  -7.234740e+00
      853  -1.335399e+01
      854  -1.132287e+01
      855  -3.870685e+00
      856   2.487544e+01
      857   7.318651e+03
      858   5.301651e+03
      859   3.182246e+01
      860   8.803843e+01
      861   2.272061e+01
      862   1.291804e+02
      863   2.719806e+01
      864  -1.479801e+01
      865   2.713846e+02
      866  -3.714615e+03
      867  -3.871692e+03
      868   1.324463e+02
      869   2.740759e+02
      870   7.605454e+01
      871   2.583191e+02
      872   8.451832e+01
      873  -3.267308e+01
      874   2.608405e+02
      875  -4.574546e+03
      876  -6.534767e+03
      877   8.120304e+01
      878   1.608368e+02
      879   4.092646e+01
      880   1.145867e+02
      881   3.740772e+01
      882  -1.353225e+01
      883   6.389336e+01
      884   4.668277e+03
      885   2.981950e+03
      886   4.438788e+01
      887   7.978339e+01
      888   3.300357e+01
      889   8.550369e+01
      890   4.043060e+01
      891  -2.598451e+00
      892  -1.066453e+02
      893   7.973547e+03
      894   6.164979e+03
      895  -2.629004e+01
      896  -5.400020e+01
      897  -8.654636e+00
      898  -2.567098e+01
      899  -9.768757e+00
      900   9.453182e+00
      901  -1.503818e+02
      902  -2.969744e+04
      903  -2.914004e+04
      904   1.000444e+02
      905   1.459697e+02
      906   7.615799e+01
      907   1.368739e+02
      908   1.031020e+02
      909   1.832688e+00
      910   1.202200e+03
      911   9.600000e+00
      912  -5.941000e+02
      913   3.764363e+02
      914   9.225867e+02
      915   1.509368e+02
      916   6.815554e+02
      917   1.720807e+02
      918  -1.652623e+02
      919  -1.844884e+02
      920  -1.871570e+03
      921  -1.499593e+03
      922  -7.854857e+01
      923  -1.380372e+02
      924  -4.629110e+01
      925  -9.990321e+01
      926  -5.139435e+01
      927   1.795349e+01
      928  -2.114230e+01
      929   1.509517e+04
      930   1.338592e+04
      931  -3.550020e+01
      932  -5.858248e+01
      933  -2.809826e+01
      934  -6.337446e+01
      935  -3.152215e+01
      936   1.884124e+00
      937   3.333333e+00
      938  -3.176783e+04
      939  -2.207100e+04
      940   1.663561e+01
      941   3.761852e+01
      942   9.839915e+00
      943   3.581429e+01
      944   2.326508e+01
      945  -5.180711e+00
      946   2.666667e+00
      947  -1.905243e+05
      948  -1.825120e+05
      949   1.870628e+02
      950   3.081157e+02
      951   1.322147e+02
      952   2.659686e+02
      953   1.348160e+02
      954  -8.918860e+00
      955  -2.076056e+01
      956  -8.949014e+02
      957  -1.985437e+03
      958   2.455027e+01
      959   4.006347e+01
      960   2.082136e+01
      961   4.829442e+01
      962   3.129557e+01
      963   1.127854e+00
      964  -2.361190e+02
      965   2.523855e+04
      966   2.528457e+04
      967  -2.370401e+02
      968  -4.491856e+02
      969  -1.485512e+02
      970  -4.645109e+02
      971  -2.277919e+02
      972   8.037302e+01
      973   5.431923e+02
      974  -7.967669e+04
      975  -8.471019e+04
      976   4.057518e+02
      977   7.319365e+02
      978   2.483604e+02
      979   6.818972e+02
      980   2.606339e+02
      981  -9.855521e+01
      982   1.869737e+02
      983   6.046000e+03
      984   4.477079e+03
      985   3.150715e+00
      986   7.846129e+00
      987  -7.027181e+00
      988  -2.373637e+01
      989  -8.602012e+00
      990  -2.032355e+00
      991   2.000000e+00
      992   1.879190e+03
      993   1.581429e+02
      994   1.493396e+02
      995   2.249900e+02
      996   1.169636e+02
      997   2.233090e+02
      998   1.291899e+02
      999   1.000000e+00
      1000  2.000000e+00
      1001 -1.702049e+03
      1002 -3.643361e+02
      1003 -3.076240e+01
      1004 -4.711412e+01
      1005 -2.501840e+01
      1006 -5.295909e+01
      1007 -2.567437e+01
      1008  1.000000e+00
      1009  1.375670e+02
      1010  2.654210e+05
      1011  1.571540e+05
      1012 -3.606936e+01
      1013 -1.347888e+02
      1014 -1.324558e+01
      1015 -7.302929e+01
      1016 -1.328666e+01
      1017  9.971242e+00
      1018 -4.616914e+01
      1019 -5.155486e+04
      1020 -3.918256e+04
      1021 -9.961176e+00
      1022 -3.756122e+01
      1023 -3.464752e+00
      1024 -3.341603e+00
      1025 -3.466547e+00
      1026  5.314991e+00
      1027 -1.540910e+01
      1028  2.076559e+05
      1029  1.318307e+05
      1030 -1.831606e+00
      1031  2.609541e+00
      1032 -1.283678e+00
      1033 -3.224036e+00
      1034 -1.291511e+00
      1035  4.571412e+00
      1036  2.831267e+01
      1037  1.424794e+05
      1038  9.515415e+04
      1039 -4.831820e+01
      1040 -1.951345e+02
      1041 -1.721609e+01
      1042 -1.275492e+02
      1043 -1.727898e+01
      1044  1.719943e+01
      1045 -1.636207e+01
      1046  3.085227e+05
      1047  2.364223e+05
      1048 -2.758201e+01
      1049 -6.759297e+01
      1050 -1.710800e+01
      1051 -6.195907e+01
      1052 -1.714293e+01
      1053  6.192214e+00
      1054 -1.673796e+02
      1055  7.476686e+04
      1056  2.628233e+04
      1057  1.256502e+00
      1058 -2.894754e+01
      1059  8.797237e+00
      1060 -3.316026e+01
      1061  8.730201e+00
      1062  8.886708e+00
      1063  6.400760e+02
      1064  8.593730e+05
      1065  5.598962e+05
      1066 -4.038319e+01
      1067 -1.718457e+02
      1068 -1.254587e+01
      1069 -1.351662e+02
      1070 -1.258222e+01
      1071  1.449710e+01
      1072 -5.156031e+01
      1073  2.294611e+05
      1074  9.206416e+04
      1075 -3.352938e+01
      1076 -1.774810e+02
      1077 -3.976042e+00
      1078 -7.156326e+01
      1079 -4.091163e+00
      1080  7.333002e+00
      1081  6.604149e+01
      1082 -4.277324e+05
      1083 -4.501507e+05
      1084  3.741565e+01
      1085  1.377656e+02
      1086  1.760097e+01
      1087  1.225143e+02
      1088  1.757325e+01
      1089 -1.020424e+01
      1090  3.395676e+02
      1091  4.563147e+05
      1092  3.437758e+05
      1093 -1.254423e+02
      1094 -5.701049e+02
      1095 -4.787365e+01
      1096 -4.961076e+02
      1097 -4.811098e+01
      1098  5.005478e+01
      1099  1.925233e+02
      1100  1.955822e+04
      1101 -1.255119e+04
      1102  4.088984e+01
      1103  1.881020e+02
      1104  1.848233e+01
      1105  1.700182e+02
      1106  1.842036e+01
      1107 -1.091126e+01
      1108  2.802158e+03
      1109  1.094803e+05
      1110  2.180579e+04
      1111  6.130304e+01
      1112  2.567584e+02
      1113  5.301135e+00
      1114  5.082294e+01
      1115  5.249080e+00
      1116  1.291640e+01
      1117  2.742735e+02
      1118  1.354280e+06
      1119  1.033132e+06
      1120 -1.064402e+02
      1121 -4.907694e+02
      1122 -3.426185e+01
      1123 -2.752876e+02
      1124 -3.457808e+01
      1125  2.995606e+01
      1126  5.005578e+02
      1127  1.661468e+06
      1128  8.712322e+05
      1129 -4.729712e+00
      1130 -4.145211e+01
      1131  7.682650e+00
      1132 -6.143495e+00
      1133  7.670595e+00
      1134  8.777601e+00
      1135  4.239697e+02
      1136  3.650148e+05
      1137  2.339721e+05
      1138 -5.063313e+00
      1139 -2.008142e+01
      1140 -6.362570e+00
      1141 -4.001387e+01
      1142 -6.438059e+00
      1143  4.345935e+00
      1144  3.283542e+02
      1145  1.369627e+06
      1146  1.351097e+06
      1147 -1.047734e+02
      1148 -2.755196e+02
      1149 -4.784623e+01
      1150 -1.728991e+02
      1151 -4.791804e+01
      1152  2.381251e+01
      1153  2.788846e+03
      1154  3.703701e+05
      1155  1.378267e+05
      1156  2.635481e+02
      1157  1.034999e+03
      1158  6.615278e+01
      1159  5.504098e+02
      1160  6.613458e+01
      1161 -8.723810e+01
      1162  6.120315e+02
      1163  4.437886e+05
      1164  4.398836e+05
      1165 -8.086219e+01
      1166 -2.344204e+02
      1167 -4.311455e+01
      1168 -1.891283e+02
      1169 -4.325152e+01
      1170  1.998756e+01
      1171  7.640473e+02
      1172  8.982492e+05
      1173  7.702659e+05
      1174 -5.358892e+01
      1175 -1.522314e+02
      1176 -2.520002e+01
      1177 -1.255024e+02
      1178 -2.539597e+01
      1179  2.034860e+01
      1180  1.617400e+03
      1181 -2.818479e+05
      1182 -1.247139e+05
      1183  5.126016e+01
      1184  2.210316e+02
      1185  1.607625e+01
      1186  1.683097e+02
      1187  1.631910e+01
      1188 -2.660187e+01
      1189  2.156599e+02
      1190  1.357881e+06
      1191  1.259534e+06
      1192 -1.508084e+02
      1193 -5.761354e+02
      1194 -7.060628e+01
      1195 -5.271313e+02
      1196 -7.066103e+01
      1197  5.363983e+01
      1198  7.903635e+01
      1199  6.690209e+05
      1200  6.007866e+05
      1201 -6.574351e+01
      1202 -3.140427e+02
      1203 -2.262979e+01
      1204 -2.378005e+02
      1205 -2.273299e+01
      1206  1.643569e+01
      1207  3.596053e+02
      1208 -8.047332e+04
      1209 -2.744602e+04
      1210  3.495031e+01
      1211  1.917947e+02
      1212  6.092487e+00
      1213  1.199867e+02
      1214  6.295692e+00
      1215 -1.437888e+01
      1216 -6.922117e+01
      1217  1.058025e+05
      1218  1.144263e+05
      1219 -3.026902e+01
      1220 -1.006119e+02
      1221 -1.514729e+01
      1222 -6.616100e+01
      1223 -1.517893e+01
      1224  4.465540e+00
      1225  9.850341e+01
      1226  2.342092e+05
      1227  1.903625e+05
      1228 -4.072800e+01
      1229 -9.658559e+01
      1230 -2.399250e+01
      1231 -7.639536e+01
      1232 -2.406711e+01
      1233  6.844531e+00
      1234  2.951370e-01
      1235  3.375892e+05
      1236  3.199212e+05
      1237 -3.254766e+01
      1238 -5.415509e+01
      1239 -2.203841e+01
      1240 -4.610178e+01
      1241 -2.213039e+01
      1242  1.374689e+00
      1243 -4.488846e+02
      1244 -4.079742e+05
      1245  1.444092e+04
      1246 -3.506957e+02
      1247 -7.532394e+02
      1248 -1.859436e+02
      1249 -5.252061e+02
      1250 -1.860055e+02
      1251  5.210669e+01
      1252  1.256057e+02
      1253 -3.651335e+05
      1254 -3.487662e+05
      1255 -5.167825e+00
      1256 -3.083413e+00
      1257  1.623204e+00
      1258  1.568146e+01
      1259  1.624115e+00
      1260  4.433738e+00
      1261 -4.440273e+02
      1262  6.767470e+04
      1263  5.907239e+04
      1264 -2.294324e+01
      1265 -3.626065e+01
      1266 -1.078653e+01
      1267 -1.757906e+01
      1268 -1.079904e+01
      1269  3.460686e+00
      1270  4.009305e+00
      1271  3.772267e+05
      1272  3.447025e+05
      1273 -4.131715e+01
      1274 -7.876890e+01
      1275 -2.270131e+01
      1276 -5.274422e+01
      1277 -2.276492e+01
      1278  5.812972e+00
      1279 -1.673237e+02
      1280  2.727549e+05
      1281  3.050653e+05
      1282 -7.530823e+01
      1283 -1.620835e+02
      1284 -4.101771e+01
      1285 -1.075674e+02
      1286 -4.104364e+01
      1287  1.334075e+01
      1288 -1.079371e+02
      1289  7.063496e+05
      1290  5.870084e+05
      1291 -4.986288e+01
      1292 -1.100931e+02
      1293 -2.465749e+01
      1294 -7.660350e+01
      1295 -2.471287e+01
      1296  9.602491e+00
      1297  1.291943e+02
      1298  3.551589e+05
      1299  3.283155e+05
      1300 -4.470912e+01
      1301 -1.142886e+02
      1302 -2.448184e+01
      1303 -9.521993e+01
      1304 -2.455090e+01
      1305  1.142597e+01
      1306  2.247337e+01
      1307  1.229162e+05
      1308  2.184009e+05
      1309 -7.103611e+01
      1310 -1.588920e+02
      1311 -5.098281e+01
      1312 -1.524301e+02
      1313 -5.101381e+01
      1314  2.419846e+00
      1315 -2.130493e+02
      1316  4.233306e+05
      1317  3.323555e+05
      1318 -2.504174e+01
      1319 -6.076988e+01
      1320 -9.568364e+00
      1321 -3.455581e+01
      1322 -9.594234e+00
      1323  9.284852e+00
      1324  1.193862e+02
      1325  6.041463e+05
      1326  6.170305e+05
      1327 -4.174692e+01
      1328 -8.184059e+01
      1329 -2.787904e+01
      1330 -6.696420e+01
      1331 -2.793196e+01
      1332  5.144596e+00
      1333 -1.296263e+02
      1334  1.107838e+06
      1335  9.660803e+05
      1336 -7.799710e+00
      1337 -1.112079e+01
      1338  2.700480e+00
      1339  9.052601e+00
      1340  2.697051e+00
      1341  5.652573e+00
      1342  5.562752e+01
      1343  1.932825e+05
      1344  2.479901e+05
      1345 -7.741316e+01
      1346 -1.705813e+02
      1347 -4.475402e+01
      1348 -1.288901e+02
      1349 -4.477588e+01
      1350  1.821685e+01
      1351 -1.957773e+02
      1352  1.344578e+06
      1353  1.365034e+06
      1354 -1.074698e+01
      1355 -1.561247e+01
      1356 -7.337640e+00
      1357 -1.654984e+01
      1358 -7.339369e+00
      1359 -6.176164e-01
      1360  3.522919e+02
      1361 -2.900695e+05
      1362 -3.217552e+05
      1363  2.623072e+01
      1364  4.534939e+01
      1365  1.125266e+01
      1366  1.766366e+01
      1367  1.123639e+01
      1368 -2.129456e+00
      1369  2.255963e+02
      1370  3.794408e+04
      1371 -2.014644e+03
      1372  1.943646e+01
      1373  6.870271e+01
      1374  2.182195e+00
      1375  3.190866e+01
      1376  2.161928e+00
      1377 -1.265258e+01
      1378  1.997669e+02
      1379  5.607801e+05
      1380  5.701100e+05
      1381 -5.523793e+01
      1382 -1.082731e+02
      1383 -3.044389e+01
      1384 -7.536631e+01
      1385 -3.045892e+01
      1386  8.960273e+00
      1387 -2.557996e+01
      1388  9.301700e+04
      1389  2.193221e+05
      1390 -6.425098e+01
      1391 -1.064226e+02
      1392 -3.247416e+01
      1393 -6.297081e+01
      1394 -3.249346e+01
      1395  1.208711e+01
      1396 -2.535301e+02
      1397  4.195539e+05
      1398  3.660691e+05
      1399 -5.266696e+01
      1400 -1.436590e+02
      1401 -2.378546e+01
      1402 -1.129762e+02
      1403 -2.381534e+01
      1404  1.800080e+01
      1405 -3.034540e+02
      1406  1.539344e+05
      1407  1.869218e+05
      1408 -9.272107e+01
      1409 -2.590426e+02
      1410 -4.658774e+01
      1411 -1.971354e+02
      1412 -4.671250e+01
      1413  2.155046e+01
      1414 -1.768859e+02
      1415  3.697149e+05
      1416  3.587454e+05
      1417 -6.097464e+01
      1418 -2.219282e+02
      1419 -2.455735e+01
      1420 -1.982864e+02
      1421 -2.473372e+01
      1422  1.770923e+01
      1423 -8.682145e+01
      1424  3.655887e+05
      1425  3.166071e+05
      1426 -3.527137e+01
      1427 -7.005543e+01
      1428 -1.351075e+01
      1429 -2.751208e+01
      1430 -1.355519e+01
      1431  1.112641e+01
      1432  1.765079e+01
      1433  1.568619e+05
      1434  1.663260e+05
      1435 -2.984528e+01
      1436 -5.482746e+01
      1437 -1.600623e+01
      1438 -2.992959e+01
      1439 -1.602119e+01
      1440  6.734851e+00
      1441 -3.093716e+02
      1442  8.266612e+05
      1443  7.935400e+05
      1444 -9.758334e+01
      1445 -1.991443e+02
      1446 -4.519109e+01
      1447 -1.048778e+02
      1448 -4.524320e+01
      1449  2.065954e+01
      1450 -1.978000e+03
      1451  5.011119e+05
      1452  7.532914e+05
      1453 -3.928680e+02
      1454 -7.860789e+02
      1455 -1.993536e+02
      1456 -4.046838e+02
      1457 -1.994535e+02
      1458  3.707300e+01
      1459 -2.547462e+02
      1460  1.481557e+06
      1461  9.835579e+05
      1462 -3.894676e+01
      1463 -9.882309e+01
      1464 -1.353274e+01
      1465 -5.587102e+01
      1466 -1.355447e+01
      1467  9.876231e+00
      1468  3.747227e+02
      1469  8.770899e+05
      1470  5.793267e+05
      1471  4.008858e-01
      1472  2.465415e+01
      1473 -3.352563e+00
      1474  2.846588e+01
      1475 -3.375242e+00
      1476 -8.780418e+00
      1477 -2.152908e+02
      1478  7.356218e+05
      1479  5.814187e+05
      1480 -1.038653e+02
      1481 -2.556383e+02
      1482 -4.421647e+01
      1483 -1.531628e+02
      1484 -4.439102e+01
      1485  2.680528e+01
      1486 -2.951979e+02
      1487  1.850589e+05
      1488  1.915899e+05
      1489 -6.297641e+01
      1490 -1.573331e+02
      1491 -2.812120e+01
      1492 -9.779937e+01
      1493 -2.817937e+01
      1494  1.494034e+01
      1495 -7.461014e+01
      1496  4.481457e+05
      1497  2.703820e+05
      1498 -9.524836e+00
      1499 -1.145005e+01
      1500 -3.511905e+00
      1501  4.459377e+00
      1502 -3.536773e+00
      1503  1.153725e+00
      1504 -4.667930e+02
      1505  2.686653e+05
      1506  2.639072e+05
      1507 -6.200403e+01
      1508 -1.369736e+02
      1509 -2.736232e+01
      1510 -7.740883e+01
      1511 -2.743843e+01
      1512  1.274968e+01
      1513 -2.347846e+01
      1514  2.668536e+04
      1515  1.146398e+05
      1516 -8.311487e+01
      1517 -1.935414e+02
      1518 -4.949664e+01
      1519 -1.619962e+02
      1520 -4.951438e+01
      1521  1.584735e+01
      1522 -1.688941e+02
      1523  3.685049e+05
      1524  3.830401e+05
      1525 -5.537000e+01
      1526 -1.037464e+02
      1527 -2.677841e+01
      1528 -5.494743e+01
      1529 -2.676918e+01
      1530  1.053524e+01
      1531 -3.355106e+02
      1532  1.098530e+06
      1533  7.726107e+05
      1534 -4.042678e+00
      1535  3.151736e+00
      1536 -2.775631e+00
      1537  7.283705e+00
      1538 -2.801033e+00
      1539 -1.262922e+01
      1540 -5.819893e+01
      1541  1.179216e+05
      1542  1.379443e+05
      1543 -4.057557e+01
      1544 -7.511804e+01
      1545 -2.448014e+01
      1546 -6.622656e+01
      1547 -2.448894e+01
      1548  4.612717e+00
      1549 -5.724981e+02
      1550  1.843230e+05
      1551  3.496154e+05
      1552 -1.014145e+02
      1553 -2.192281e+02
      1554 -5.602148e+01
      1555 -1.571409e+02
      1556 -5.607056e+01
      1557  1.713434e+01
      1558 -1.171835e+02
      1559  5.884687e+05
      1560  4.249397e+05
      1561  8.887646e-01
      1562 -6.398090e-01
      1563 -3.078796e+00
      1564 -1.383699e+01
      1565 -3.112344e+00
      1566 -5.344990e+00
      1567 -5.945536e+02
      1568  8.845580e+04
      1569  1.833935e+05
      1570 -4.718350e+01
      1571 -1.082079e+02
      1572 -1.852534e+01
      1573 -7.500559e+01
      1574 -1.855534e+01
      1575  9.808264e+00
      1576 -1.837277e+02
      1577  1.543560e+06
      1578  1.397461e+06
      1579 -6.247454e+01
      1580 -1.311562e+02
      1581 -3.647679e+01
      1582 -1.029165e+02
      1583 -3.650085e+01
      1584  1.115690e+01
      1585  3.480932e+01
      1586  7.018356e+05
      1587  6.016618e+05
      1588 -1.238160e+02
      1589 -3.226940e+02
      1590 -5.296640e+01
      1591 -1.882871e+02
      1592 -5.314601e+01
      1593  2.992181e+01
      1594  8.045455e+01
      1595  7.041349e+05
      1596  6.724375e+05
      1597 -6.081479e+01
      1598 -1.301303e+02
      1599 -3.305922e+01
      1600 -9.141464e+01
      1601 -3.313631e+01
      1602  9.859900e+00
      1603 -4.322762e+02
      1604 -2.452087e+05
      1605 -2.472332e+05
      1606 -1.409159e+01
      1607 -3.051353e+01
      1608 -2.490446e+00
      1609 -2.555834e+00
      1610 -2.490540e+00
      1611  9.587721e+00
      1612  1.000000e+01
      1613  7.728610e+05
      1614  6.125890e+05
      1615 -1.100570e+01
      1616 -2.975141e+01
      1617 -9.500180e+00
      1618 -4.015738e+01
      1619 -9.560393e+00
      1620 -5.279647e-01
      1621  1.221721e+02
      1622 -9.892190e+04
      1623 -1.419179e+05
      1624  2.988653e+01
      1625  3.859626e+01
      1626  2.244004e+01
      1627  3.524194e+01
      1628  2.244405e+01
      1629  2.267633e+00
      1630 -3.026862e+02
      1631  1.126516e+06
      1632  7.793089e+05
      1633  1.045265e+01
      1634  1.513651e+01
      1635  1.348479e+00
      1636 -1.466844e+01
      1637  1.316455e+00
      1638 -1.060801e+01
      1639 -6.173580e+02
      1640  3.158243e+05
      1641  2.765991e+05
      1642 -6.128666e+00
      1643 -8.277363e+00
      1644 -6.875594e-01
      1645 -1.857027e+00
      1646 -7.085255e-01
      1647  1.640827e+00
      1648 -2.662738e+02
      1649  1.554014e+05
      1650  1.414405e+05
      1651 -5.343115e+01
      1652 -8.866360e+01
      1653 -2.524611e+01
      1654 -3.207502e+01
      1655 -2.532394e+01
      1656  6.572422e+00
      1657 -4.475778e+02
      1658  3.111046e+05
      1659  3.296133e+05
      1660 -6.736814e+01
      1661 -1.364623e+02
      1662 -3.160368e+01
      1663 -6.838680e+01
      1664 -3.164061e+01
      1665  1.368632e+01
      1666 -6.463036e+01
      1667  1.112113e+06
      1668  7.831090e+05
      1669  1.988369e+01
      1670  4.873945e+01
      1671  2.090829e+01
      1672  7.255236e+01
      1673  2.090349e+01
      1674  1.321323e+00
      1675 -2.836959e+02
      1676  3.816528e+05
      1677  2.512872e+05
      1678 -5.547969e+01
      1679 -2.072439e+02
      1680 -2.421042e+01
      1681 -2.100404e+02
      1682 -2.428423e+01
      1683  3.177855e+01
      1684 -3.946392e+01
      1685  9.208558e+05
      1686  3.777851e+05
      1687  1.006368e+02
      1688  2.192396e+02
      1689  6.674731e+01
      1690  1.948819e+02
      1691  6.673823e+01
      1692 -1.027250e+01
      1693 -1.951196e+01
      1694  5.785233e+05
      1695  2.187334e+05
      1696 -4.091316e+01
      1697 -1.063152e+02
      1698 -1.990746e+01
      1699 -8.642001e+01
      1700 -1.995116e+01
      1701  1.371553e+01
      1702  1.337308e+02
      1703  1.269957e+04
      1704  2.569047e+04
      1705 -8.487983e+00
      1706 -1.962426e+01
      1707 -9.829988e+00
      1708 -3.040540e+01
      1709 -9.840771e+00
      1710 -1.256303e-01
      1711  1.105426e+02
      1712 -4.666231e+04
      1713  1.174450e+04
      1714 -6.183259e+01
      1715 -1.249315e+02
      1716 -3.779785e+01
      1717 -9.275042e+01
      1718 -3.782213e+01
      1719  9.186863e+00
      1720 -4.508040e+01
      1721 -4.334786e+05
      1722 -3.389695e+05
      1723  3.930093e+01
      1724  1.212015e+02
      1725  1.993865e+01
      1726  1.092789e+02
      1727  2.000125e+01
      1728 -7.937839e+00
      1729  2.363543e+02
      1730 -6.896854e+05
      1731 -6.596877e+05
      1732  1.771968e+02
      1733  7.182984e+02
      1734  6.941476e+01
      1735  5.206445e+02
      1736  6.969306e+01
      1737 -4.575359e+01
      1738 -7.956241e+01
      1739  2.603130e+05
      1740  1.392005e+05
      1741 -1.141646e+02
      1742 -6.085110e+02
      1743 -2.725599e+01
      1744 -4.829593e+02
      1745 -2.753724e+01
      1746  5.536677e+01
      1747  5.069912e+02
      1748  2.173732e+03
      1749 -4.908458e+03
      1750  1.452967e+01
      1751  1.135051e+00
      1752  3.900843e+00
      1753 -5.781409e+01
      1754  3.906190e+00
      1755 -8.404252e-01
      1756 -1.822000e+02
      1757 -9.840799e+06
      1758 -9.523808e+06
      1759  2.531481e+02
      1760  4.326075e+02
      1761  1.087101e+02
      1762  1.743605e+02
      1763  1.088534e+02
      1764 -4.351354e+01
      1765  1.422133e+03
      1766  3.053011e+05
      1767  1.151706e+05
      1768  8.647983e+00
      1769  1.324725e+02
      1770  7.271033e+00
      1771  1.797297e+02
      1772  6.911863e+00
      1773 -5.703379e+00
      1774  3.991063e+02
      1775  3.763740e+06
      1776  3.338691e+06
      1777 -1.168162e+02
      1778 -4.131482e+02
      1779 -5.016817e+01
      1780 -3.544419e+02
      1781 -5.037114e+01
      1782  4.122372e+01
      1783  5.882857e+02
      1784  1.152733e+06
      1785  7.564433e+05
      1786 -1.593708e+02
      1787 -5.185151e+02
      1788 -5.978328e+01
      1789 -3.700638e+02
      1790 -5.986004e+01
      1791  5.980038e+01
      1792 -3.463932e+02
      1793  2.167222e+06
      1794  1.854431e+06
      1795 -2.369458e+02
      1796 -9.237050e+02
      1797 -8.900655e+01
      1798 -6.083074e+02
      1799 -8.930291e+01
      1800  6.622743e+01
      1801  8.886774e+02
      1802  1.307462e+05
      1803  4.602343e+05
      1804 -1.318396e+02
      1805 -5.859353e+02
      1806 -7.371089e+01
      1807 -7.574422e+02
      1808 -7.373860e+01
      1809  6.083019e+01
      1810  4.209311e+02
      1811 -7.079602e+05
      1812 -7.187719e+05
      1813  9.627963e+01
      1814  2.977362e+02
      1815  4.796331e+01
      1816  2.366857e+02
      1817  4.804430e+01
      1818 -1.855060e+01
      1819  2.558235e+02
      1820  9.725937e+06
      1821  7.374430e+06
      1822  3.730953e+01
      1823  9.493696e+00
      1824  3.460245e+01
      1825 -1.484769e+01
      1826  3.457746e+01
      1827 -9.806881e+00
      1828  2.264228e+02
      1829  8.912382e+05
      1830  5.967330e+05
      1831 -3.457043e+01
      1832 -8.233953e+01
      1833 -4.795022e+00
      1834  5.002682e+00
      1835 -4.912499e+00
      1836  9.062879e+00
      1837  2.112969e+02
      1838 -1.567930e+05
      1839 -5.327875e+04
      1840  2.547160e+00
      1841 -4.855420e+01
      1842 -3.974210e+00
      1843 -1.606088e+02
      1844 -3.880150e+00
      1845  1.201184e+01
      1846  3.229079e+02
      1847 -1.227359e+06
      1848 -1.172252e+06
      1849  1.115235e+02
      1850  2.990798e+02
      1851  4.726319e+01
      1852  1.981523e+02
      1853  4.757739e+01
      1854 -2.555739e+01
      1855  1.758197e+01
      1856  6.979806e+05
      1857  4.186041e+05
      1858 -3.132079e+01
      1859 -1.211254e+02
      1860 -7.126402e+00
      1861 -6.683511e+01
      1862 -7.153018e+00
      1863  1.578694e+01
      1864  4.611979e+02
      1865 -6.243626e+03
      1866 -7.313718e+03
      1867  4.421427e+01
      1868  2.145056e+02
      1869  1.028734e+01
      1870  1.093614e+02
      1871  1.007039e+01
      1872 -1.225592e+01
      1873  4.665421e+01
      1874  1.219306e+06
      1875  8.315023e+05
      1876 -1.304250e+02
      1877 -4.667054e+02
      1878 -2.513073e+01
      1879 -1.592068e+02
      1880 -2.539064e+01
      1881  3.374418e+01
      1882  1.700000e+01
      1883 -5.234917e+04
      1884 -7.997053e+04
      1885  4.625950e+01
      1886  1.083500e+02
      1887  3.247127e+01
      1888  9.628174e+01
      1889  3.250673e+01
      1890 -5.195593e-01
      1891  1.675425e+02
      1892  6.257821e+05
      1893  4.675787e+05
      1894 -3.823608e+01
      1895 -1.316871e+02
      1896 -1.220793e+01
      1897 -6.073868e+01
      1898 -1.231222e+01
      1899  1.116453e+01
      1900  8.743214e+02
      1901 -3.026886e+05
      1902 -2.108924e+05
      1903  1.021011e+01
      1904  2.973780e+01
      1905  6.390141e+00
      1906 -2.112454e+01
      1907  6.460554e+00
      1908  1.336995e+01
      1909  3.375977e+02
      1910 -4.680587e+04
      1911 -4.872801e+03
      1912  2.957622e+01
      1913  1.268687e+02
      1914 -4.087608e-01
      1915 -2.342889e+01
      1916 -3.524551e-01
      1917 -8.321828e+00
      1918  4.599141e+02
      1919 -1.146827e+04
      1920  4.661759e+03
      1921  6.772931e-01
      1922 -5.190218e+00
      1923 -2.407433e+00
      1924 -3.852980e+01
      1925 -2.394784e+00
      1926  7.180595e+00
      1927  2.659884e+02
      1928  1.714950e+05
      1929  5.924233e+04
      1930 -3.474113e+01
      1931 -2.081245e+02
      1932 -8.004345e+00
      1933 -1.585251e+02
      1934 -8.159094e+00
      1935  1.321396e+01
      1936  4.984500e+03
      1937 -1.001073e+05
      1938 -4.477533e+04
      1939  9.348405e+01
      1940  4.957684e+02
      1941 -4.803170e+00
      1942 -5.993039e+01
      1943 -4.355788e+00
      1944  3.060379e+01
      1945  1.840000e+01
      1946  4.072912e+05
      1947  3.818124e+05
      1948 -2.471086e+02
      1949 -6.496738e+02
      1950 -1.532769e+02
      1951 -5.356842e+02
      1952 -1.534119e+02
      1953  2.567204e+01
      1954  4.070702e+02
      1955  4.528701e+04
      1956  2.246536e+04
      1957 -2.679837e+00
      1958  4.645100e+00
      1959  2.276050e+00
      1960  3.060436e+01
      1961  1.935739e+00
      1962  7.860947e+00
      1963  4.602615e+02
      1964 -9.849412e+04
      1965 -1.093668e+05
      1966  1.011590e+02
      1967  3.243595e+02
      1968  4.502598e+01
      1969  1.958483e+02
      1970  4.515075e+01
      1971 -2.587420e+01
      1972  1.891389e+02
      1973  1.003351e+05
      1974  6.312042e+04
      1975  8.420653e+00
      1976  4.556220e+01
      1977  2.312815e+00
      1978  1.563511e+01
      1979  2.345364e+00
      1980 -2.071100e+00
      1981  4.060448e+02
      1982  9.019413e+05
      1983  6.713390e+05
      1984 -4.299968e+01
      1985 -1.673019e+02
      1986 -1.605991e+01
      1987 -1.368267e+02
      1988 -1.612987e+01
      1989  1.627503e+01
      1990 -8.965561e+01
      1991  5.007295e+04
      1992  4.827260e+04
      1993 -5.031664e+01
      1994 -1.841571e+02
      1995 -1.938986e+01
      1996 -1.020275e+02
      1997 -1.964321e+01
      1998  6.230124e+00
      1999  5.023078e+02
      2000  1.450658e+05
      2001  1.410058e+05
      2002  2.083259e+01
      2003  1.172943e+02
      2004  3.980043e+00
      2005  4.959390e+01
      2006  3.988149e+00
      2007 -2.076199e+00
      2008  1.904722e+02
      2009 -8.399472e+04
      2010 -8.892553e+04
      2011  7.006844e+01
      2012  1.499121e+02
      2013  3.243290e+01
      2014  8.193127e+01
      2015  3.254712e+01
      2016 -1.120021e+01
      2017 -2.539256e+02
      2018  6.548705e+05
      2019  5.858392e+05
      2020 -7.742560e+01
      2021 -2.749415e+02
      2022 -3.112650e+01
      2023 -1.768150e+02
      2024 -3.124335e+01
      2025  1.994202e+01
      2026  3.734177e+01
      2027 -5.968170e+04
      2028 -4.778293e+04
      2029  1.023253e+01
      2030  2.328183e+01
      2031  6.640894e+00
      2032  1.907181e+01
      2033  6.672168e+00
      2034 -1.978459e+00
      2035 -1.904723e+03
      2036 -1.731043e+05
      2037 -9.559555e+04
      2038 -8.355654e-01
      2039 -5.671366e+01
      2040  1.723766e+01
      2041  9.032277e+01
      2042  1.892708e+01
      2043 -2.431774e+01
      2044  2.854316e+02
      2045  3.307370e+05
      2046  1.945156e+05
      2047 -1.031784e+02
      2048 -6.303176e+02
      2049 -2.416954e+01
      2050 -4.405689e+02
      2051 -2.461657e+01
      2052  3.435114e+01
      2053  1.028120e+03
      2054  1.414672e+04
      2055 -1.968979e+04
      2056  3.667276e+01
      2057  1.605151e+02
      2058  1.167645e+01
      2059  1.014658e+02
      2060  1.155873e+01
      2061 -9.237981e+00
      2062  1.059639e+03
      2063  1.175423e+04
      2064  1.542212e+04
      2065  1.390957e+01
      2066  1.422219e+02
      2067 -5.354974e+00
      2068  2.665360e+01
      2069 -5.403323e+00
      2070 -1.791994e+00
      2071  3.371572e+02
      2072  6.512854e+05
      2073  4.418939e+05
      2074 -5.258449e+01
      2075 -2.743431e+02
      2076 -1.087347e+01
      2077 -1.465522e+02
      2078 -1.110063e+01
      2079  1.722229e+01
      2080  4.653337e+02
      2081  3.504486e+05
      2082  2.304566e+05
      2083 -2.459252e+01
      2084 -1.062562e+02
      2085 -8.197942e+00
      2086 -7.562990e+01
      2087 -8.314177e+00
      2088  9.984252e+00
      2089  2.061255e+02
      2090  2.037424e+05
      2091  6.023183e+04
      2092 -3.315855e+01
      2093 -1.845742e+02
      2094 -1.035051e+01
      2095 -1.334014e+02
      2096 -1.050469e+01
      2097  1.465445e+01
      2098  6.655831e+02
      2099  1.342948e+06
      2100  1.220736e+06
      2101 -4.356107e+01
      2102 -1.853265e+02
      2103 -1.702446e+01
      2104 -1.238016e+02
      2105 -1.718728e+01
      2106  2.663201e+00
      2107  3.011000e+03
      2108  3.595937e+05
      2109 -2.480167e+05
      2110  2.624206e+02
      2111  6.346868e+02
      2112  1.858217e+02
      2113  5.372062e+02
      2114  1.858657e+02
      2115 -4.032974e+01
      2116  8.755714e+02
      2117  3.843444e+05
      2118  1.927932e+05
      2119  6.894819e+01
      2120 -4.793542e+01
      2121  5.469318e+01
      2122 -1.557200e+01
      2123  5.444527e+01
      2124  1.412583e+01
      2125  3.487266e+02
      2126 -1.044090e+06
      2127 -9.151737e+05
      2128  1.357886e+02
      2129  5.703745e+02
      2130  5.034301e+01
      2131  4.470070e+02
      2132  5.037473e+01
      2133 -5.275002e+01
      2134 -3.040121e+02
      2135  4.846975e+05
      2136  4.194709e+05
      2137 -5.143634e+01
      2138 -1.356731e+02
      2139 -2.355005e+01
      2140 -8.564322e+01
      2141 -2.361665e+01
      2142  1.342168e+01
      2143  2.378678e+02
      2144  6.906958e+05
      2145  2.720912e+05
      2146 -1.704941e+01
      2147 -1.588122e+02
      2148  1.843464e+01
      2149  6.280295e+01
      2150  1.815220e+01
      2151  5.561727e+00
      2152  1.243015e+03
      2153  1.687971e+05
      2154  1.101247e+05
      2155  4.270441e+00
      2156  1.266403e+02
      2157 -1.076404e+01
      2158  1.003061e+01
      2159 -1.099816e+01
      2160 -4.612032e-02
      2161 -1.917191e+02
      2162  1.881122e+06
      2163  1.440185e+06
      2164 -8.412840e+01
      2165 -2.524482e+02
      2166 -3.604752e+01
      2167 -1.582046e+02
      2168 -3.620131e+01
      2169  9.094046e+00
      2170  8.669931e+02
      2171  2.796570e+05
      2172  2.225035e+05
      2173  4.884838e+01
      2174  2.078721e+02
      2175  1.741310e+01
      2176  1.666528e+02
      2177  1.738357e+01
      2178 -2.053967e+01
      2179  1.727143e+03
      2180 -2.790441e+06
      2181 -3.231939e+06
      2182  3.148922e+02
      2183  7.377465e+02
      2184  1.908575e+02
      2185  6.350312e+02
      2186  1.909178e+02
      2187 -3.540150e+01
      2188  1.954097e+03
      2189  1.212226e+06
      2190  1.043435e+06
      2191 -3.408247e+02
      2192 -1.446028e+03
      2193 -1.635545e+02
      2194 -1.263475e+03
      2195 -1.648062e+02
      2196  1.158886e+02
      2197  6.947385e+02
      2198  1.651156e+05
      2199  6.173609e+04
      2200  1.755525e+01
      2201  2.733952e+01
      2202  1.138572e+01
      2203 -4.724560e+00
      2204  1.131029e+01
      2205 -3.163541e+00
      2206  7.581310e+02
      2207 -9.502154e+04
      2208 -8.840102e+04
      2209  1.976260e+02
      2210  1.317518e+03
      2211  5.059191e+01
      2212  1.038185e+03
      2213  5.134336e+01
      2214 -7.461939e+01
      2215  1.522286e+03
      2216  3.044797e+05
      2217  3.272179e+05
      2218 -2.163116e+02
      2219 -9.534849e+02
      2220 -9.021423e+01
      2221 -7.848735e+02
      2222 -9.035841e+01
      2223  5.623792e+01
      2224  9.221564e+02
      2225  8.745620e+04
      2226  4.395076e+04
      2227  1.651643e+01
      2228  7.358658e+01
      2229  1.339021e+00
      2230  1.708329e+01
      2231  4.416502e-01
      2232  6.671059e-01
      2233  4.126682e+02
      2234 -5.395483e+04
      2235  8.019117e+04
      2236 -6.359654e+01
      2237 -1.696452e+02
      2238 -3.305618e+01
      2239 -1.144854e+02
      2240 -3.309407e+01
      2241  1.475345e+01
      2242  2.081438e+03
      2243  6.736150e+04
      2244  1.037644e+04
      2245  1.624939e+02
      2246  9.220129e+02
      2247  2.753093e+01
      2248  4.235801e+02
      2249  2.741654e+01
      2250 -5.072925e+01
      2251  6.172000e+02
      2252  8.327605e+04
      2253 -3.144460e+04
      2254  3.083282e+02
      2255  1.405969e+03
      2256  1.494697e+02
      2257  1.201569e+03
      2258  1.497290e+02
      2259 -1.048655e+02
      2260  7.139579e+02
      2261  2.353077e+05
      2262  2.084777e+05
      2263  4.842211e+01
      2264  2.957384e+02
      2265  8.420756e+00
      2266  1.828376e+02
      2267  8.466339e+00
      2268 -1.618819e+01
      2269 -8.428571e+02
      2270  1.209249e+06
      2271  8.911337e+05
      2272 -1.866272e+02
      2273 -8.638115e+02
      2274 -7.452389e+01
      2275 -6.918335e+02
      2276 -7.478642e+01
      2277  1.976596e+01
      2278  4.529250e+03
      2279  9.403263e+05
      2280  5.094751e+05
      2281 -8.647476e+01
      2282 -3.803863e+02
      2283 -3.309377e+01
      2284 -3.686629e+02
      2285 -3.340938e+01
      2286  4.867342e+01
      2287  8.032297e+01
      2288  6.300679e+05
      2289  3.873879e+05
      2290 -8.056635e+01
      2291 -2.654836e+02
      2292 -3.601912e+01
      2293 -2.116557e+02
      2294 -3.607380e+01
      2295  2.459272e+01
      2296 -9.865000e+02
      2297  1.771510e+05
      2298  3.137217e+04
      2299  3.101055e+02
      2300  1.521479e+03
      2301  1.542252e+02
      2302  1.680351e+03
      2303  1.526051e+02
      2304 -2.106041e+02
      2305 -8.979803e+01
      2306  2.805069e+05
      2307 -1.350591e+05
      2308  8.564311e+01
      2309  2.938474e+02
      2310  4.506367e+01
      2311  2.986534e+02
      2312  4.494733e+01
      2313 -1.856166e+01
      2314 -3.761911e+02
      2315  2.322319e+05
      2316  3.463569e+05
      2317 -6.446422e+01
      2318 -1.530399e+02
      2319 -3.996744e+01
      2320 -1.455375e+02
      2321 -3.998073e+01
      2322  1.288030e+01
      2323 -4.917500e+02
      2324 -6.336596e+05
      2325 -6.903146e+05
      2326  1.362085e+02
      2327  3.045894e+02
      2328  8.343402e+01
      2329  2.835115e+02
      2330  8.349705e+01
      2331 -2.973902e+01
      2332  5.937586e+02
      2333 -3.511822e+04
      2334  1.021258e+04
      2335 -5.773464e+01
      2336 -9.743658e+01
      2337 -3.154013e+01
      2338 -5.333464e+01
      2339 -3.153765e+01
      2340  1.041609e+01
      2341  1.859154e+02
      2342  3.106922e+05
      2343  2.964211e+05
      2344 -3.622804e+01
      2345 -7.631076e+01
      2346 -1.914022e+01
      2347 -4.694263e+01
      2348 -1.916515e+01
      2349  9.869558e+00
      2350  3.676936e+02
      2351  1.855929e+05
      2352  1.455285e+05
      2353  5.386224e+00
      2354  1.377497e+01
      2355  5.291077e+00
      2356  1.155711e+01
      2357  5.287892e+00
      2358  2.084737e+00
      2359  7.767521e+01
      2360  8.370776e+05
      2361  8.444978e+05
      2362 -4.824533e+01
      2363 -8.932021e+01
      2364 -3.892959e+01
      2365 -8.791978e+01
      2366 -3.894488e+01
      2367  8.711481e-01
      2368 -1.878725e+02
      2369  5.320409e+05
      2370  4.034850e+05
      2371 -1.606211e+01
      2372 -3.839359e+01
      2373 -4.047465e+00
      2374 -1.464827e+01
      2375 -4.063766e+00
      2376  5.008977e+00
      2377 -7.279979e+01
      2378 -7.846843e+05
      2379 -7.445078e+05
      2380 -3.024577e+01
      2381 -7.613827e+01
      2382 -1.698573e+01
      2383 -6.071491e+01
      2384 -1.699669e+01
      2385  8.293089e+00
      2386  2.426596e+02
      2387 -1.198148e+07
      2388 -1.203438e+07
      2389  2.341371e+02
      2390  8.553033e+02
      2391  9.534532e+01
      2392  5.609809e+02
      2393  9.556242e+01
      2394 -4.416786e+01
      2395 -4.346162e+02
      2396  1.195627e+06
      2397  1.051443e+06
      2398 -6.144197e+01
      2399 -1.050267e+02
      2400 -2.603064e+01
      2401 -3.501013e+01
      2402 -2.607673e+01
      2403  1.160900e+01
      2404  7.432612e+02
      2405 -1.218721e+05
      2406 -2.138059e+05
      2407  2.769676e+02
      2408  7.529180e+02
      2409  1.387740e+02
      2410  6.121715e+02
      2411  1.389492e+02
      2412 -7.082855e+01
      2413  1.304478e+02
      2414  3.668005e+05
      2415  3.713650e+05
      2416 -1.563656e+02
      2417 -4.491114e+02
      2418 -7.520820e+01
      2419 -4.248723e+02
      2420 -7.533915e+01
      2421  5.636319e+01
      2422  6.142105e+01
      2423  3.510218e+05
      2424  2.397162e+05
      2425 -1.710620e+02
      2426 -5.717882e+02
      2427 -6.578083e+01
      2428 -3.576887e+02
      2429 -6.642008e+01
      2430  5.118660e+01
      2431  8.000000e+00
      2432  2.428651e+06
      2433  3.108759e+06
      2434 -5.174345e+02
      2435 -9.364308e+02
      2436 -4.039698e+02
      2437 -9.688593e+02
      2438 -4.042075e+02
      2439 -1.462253e+00
      2440 -1.906000e+02
      2441 -2.040208e+06
      2442 -1.804667e+06
      2443 -1.007565e+02
      2444 -1.405026e+02
      2445 -4.850206e+01
      2446 -6.274432e+01
      2447 -4.848811e+01
      2448  1.940053e+01
      2449  3.460024e+03
      2450 -1.490041e+04
      2451 -7.920353e+03
      2452  1.809973e+02
      2453  1.550927e+03
      2454  3.053621e+01
      2455  6.079198e+02
      2456  3.079546e+01
      2457 -4.199606e+01
      2458  8.255688e+02
      2459  6.139898e+04
      2460  2.575640e+04
      2461  7.521297e+01
      2462  3.211120e+02
      2463  2.406634e+01
      2464  2.380302e+02
      2465  2.181359e+01
      2466 -2.735824e+01
      2467  1.080288e+03
      2468 -1.758968e+04
      2469 -7.531219e+03
      2470  1.832179e+01
      2471  3.892910e+02
      2472 -8.193338e+00
      2473 -2.150014e+02
      2474 -7.685462e+00
      2475  1.497577e+01
      2476  1.214893e+03
      2477 -1.466254e+04
      2478  3.008810e+02
      2479  5.184001e+01
      2480  2.690130e+02
      2481 -1.369131e+01
      2482 -7.403410e+01
      2483 -1.485918e+01
      2484 -3.461908e+00
      2485  3.975000e+03
      2486  4.137070e+04
      2487  3.237270e+04
      2488  1.503383e+02
      2489  7.710179e+02
      2490 -2.552529e+01
      2491 -2.951651e+02
      2492 -2.752849e+01
      2493 -5.483105e+01
      2494 -4.751900e+03
      2495 -1.565020e+05
      2496 -9.964880e+04
      2497 -1.144669e+02
      2498 -2.673629e+02
      2499 -4.945207e+00
      2500  1.307972e+02
      2501  2.645640e-01
      2502  1.363281e+01
      2503 -7.161619e+03
      2504 -8.649912e+04
      2505 -7.729762e+03
      2506 -2.405017e+02
      2507 -3.172467e+03
      2508 -2.956768e+01
      2509 -2.517118e+03
      2510 -2.657130e+01
      2511  7.930955e+01
      2512 -7.603012e+02
      2513 -5.805651e+04
      2514 -2.346465e+04
      2515  1.070833e+02
      2516  2.014119e+03
      2517  1.566937e+01
      2518  1.583428e+03
      2519  1.631235e+01
      2520 -2.932122e+01
      2521 -1.954337e+02
      2522 -1.195510e+05
      2523 -7.113428e+04
      2524  8.974911e+01
      2525  3.418626e+03
      2526  1.235156e+01
      2527  3.230760e+03
      2528  1.245255e+01
      2529 -3.627584e+01
      2530  1.443157e+03
      2531 -1.877576e+05
      2532 -9.250346e+04
      2533  2.103844e+02
      2534  4.817053e+03
      2535  2.500879e+01
      2536  2.852755e+03
      2537  2.522251e+01
      2538 -6.370950e+01
      2539 -3.130952e+03
      2540 -2.537152e+04
      2541 -7.291738e+03
      2542 -2.828610e+01
      2543 -5.170431e+02
      2544  1.933117e+00
      2545  1.643661e+02
      2546  2.386132e+00
      2547 -5.555538e+00
      2548 -1.778176e+04
      2549 -1.920371e+05
      2550  1.607588e+04
      2551 -4.462224e+02
      2552 -7.829582e+03
      2553 -6.185606e+01
      2554 -5.117954e+03
      2555 -6.134710e+01
      2556  1.461035e+02
      2557 -2.266238e+03
      2558 -1.025802e+04
      2559  3.211286e+03
      2560 -2.250688e+01
      2561 -3.312056e+02
      2562 -3.285147e+00
      2563 -4.255317e+02
      2564 -3.081423e+00
      2565  1.790898e+01
      2566 -7.006167e+03
      2567 -1.552141e+05
      2568 -1.878960e+04
      2569 -9.539033e+01
      2570 -2.162442e+03
      2571 -3.278559e+00
      2572 -8.744691e+02
      2573 -2.289666e+00
      2574  6.049826e+00

---

    Code
      set.seed(42)
      gridding(meta, btf) %>% resampling(measure = "BIOMASS", resamps = 1L) %>%
        getAlphaMetrics(measure = "BIOMASS") %>% getLinearRegressions(divType = "alpha")
    Message
      OK: all SL studies have 1 grid cell
    Condition
      Warning in `resampling()`:
      NA values found and removed.
      Only a subset of `x` is used.
    Output
          assemblageID     metric         slope     pvalue significance     intercept
      1     211_529239          S -1.911765e+00 0.06351243            0  3.811541e+03
      2     211_529239          N  7.290853e+00 0.23933085            0 -1.439048e+04
      3     211_529239       maxN  2.105206e+00 0.75240417            0 -4.134429e+03
      4     211_529239    Shannon -7.067557e-03 0.95333575            0  1.562470e+01
      5     211_529239 expShannon -2.097038e-01 0.69448212            0  4.215898e+02
      6     211_529239    Simpson  1.250130e-02 0.79990906            0 -2.415666e+01
      7     211_529239 invSimpson -6.081466e-02 0.85927668            0  1.242750e+02
      8     211_529239        PIE  9.744472e-03 0.84902987            0 -1.867404e+01
      9     211_529239      DomMc -3.133189e-03 0.92193219            0  6.894481e+00
      10    211_525598          S  1.123188e-01 0.86436852            0 -2.074746e+02
      11    211_525598          N  9.392217e+00 0.64074505            0 -1.853032e+04
      12    211_525598       maxN  7.926007e+00 0.57494085            0 -1.566064e+04
      13    211_525598    Shannon -8.788826e-02 0.12814372            0  1.756348e+02
      14    211_525598 expShannon -3.436620e-01 0.16851491            0  6.855707e+02
      15    211_525598    Simpson -3.374674e-02 0.16180198            0  6.749936e+01
      16    211_525598 invSimpson -2.245661e-01 0.23325051            0  4.480209e+02
      17    211_525598        PIE -3.594719e-02 0.14876731            0  7.188405e+01
      18    211_525598      DomMc  2.741801e-02 0.06548162            0 -5.360677e+01
      19    211_521960          S -9.383562e-01 0.12638609            0  1.883582e+03
      20    211_521960          N  1.090548e+01 0.39674589            0 -2.155166e+04
      21    211_521960       maxN  5.708158e+00 0.49757763            0 -1.128345e+04
      22    211_521960    Shannon -6.698794e-02 0.37876385            0  1.348086e+02
      23    211_521960 expShannon -5.108660e-01 0.32946713            0  1.020834e+03
      24    211_521960    Simpson -1.657237e-02 0.47382350            0  3.361993e+01
      25    211_521960 invSimpson -2.345783e-01 0.53273829            0  4.702099e+02
      26    211_521960        PIE -2.029510e-02 0.39846134            0  4.102133e+01
      27    211_521960      DomMc  1.190137e-02 0.62429357            0 -2.303203e+01
      28    211_523410          S -1.229508e-01 0.88353363            0  2.536311e+02
      29    211_523410          N -1.153545e+01 0.33243400            0  2.293799e+04
      30    211_523410       maxN -1.519226e+01 0.14983488            0  3.017498e+04
      31    211_523410    Shannon  1.205090e-01 0.19779984            0 -2.378131e+02
      32    211_523410 expShannon  3.184938e-01 0.31718214            0 -6.279386e+02
      33    211_523410    Simpson  6.404909e-02 0.12393854            0 -1.264659e+02
      34    211_523410 invSimpson  2.339985e-01 0.34224259            0 -4.611118e+02
      35    211_523410        PIE  6.053685e-02 0.18524820            0 -1.194548e+02
      36    211_523410      DomMc -1.595861e-02 0.58379709            0  3.239652e+01
      37    211_517585          S -8.100000e+00 0.28222960            0  1.606540e+04
      38    211_517585          N -4.107570e+01 0.30354215            0  8.147040e+04
      39    211_517585       maxN -3.104810e+01 0.28500737            0  6.158202e+04
      40    211_517585    Shannon -4.005274e-02 0.85312909            0  8.024095e+01
      41    211_517585 expShannon -1.730226e-01 0.73417433            0  3.453567e+02
      42    211_517585    Simpson  2.846898e-02 0.73172947            0 -5.605328e+01
      43    211_517585 invSimpson  7.187258e-02 0.70797767            0 -1.408074e+02
      44    211_517585        PIE  3.155250e-02 0.70394454            0 -6.215584e+01
      45    211_517585      DomMc  2.811972e-02 0.46684338            0 -5.484201e+01
      46    211_516855          S  2.400000e+00 0.11774245            0 -4.751900e+03
      47    211_516855          N  2.755660e+01 0.49204126            0 -5.460246e+04
      48    211_516855       maxN  2.336700e+01 0.55569906            0 -4.630065e+04
      49    211_516855    Shannon -8.258913e-02 0.78187135            0  1.648112e+02
      50    211_516855 expShannon -2.018194e-01 0.78991357            0  4.032430e+02
      51    211_516855    Simpson -6.913214e-02 0.64465612            0  1.375865e+02
      52    211_516855 invSimpson -2.794113e-01 0.64149830            0  5.564012e+02
      53    211_516855        PIE -1.035756e-01 0.53044954            0  2.059505e+02
      54    211_516855      DomMc  2.039186e-02 0.81400255            0 -3.963007e+01
      55   437_2075128          S  3.571429e+00 0.37568068            0 -7.161619e+03
      56   437_2075128          N  3.567555e+03 0.53356355            0 -7.159572e+06
      57   437_2075128       maxN  1.025837e+03 0.08534134            0 -2.060557e+06
      58   437_2075128    Shannon  2.849485e-02 0.86904696            0 -5.498831e+01
      59   437_2075128 expShannon  1.532591e-01 0.93612972            0 -2.973033e+02
      60   437_2075128    Simpson  6.675859e-03 0.80743628            0 -1.257577e+01
      61   437_2075128 invSimpson  7.024539e-02 0.96729134            0 -1.331094e+02
      62   437_2075128        PIE  6.659487e-03 0.80772572            0 -1.254275e+01
      63   437_2075128      DomMc -1.276453e-02 0.85045068            0  2.609115e+01
      64   437_2077319          S  3.975904e-01 0.84512503            0 -7.603012e+02
      65   437_2077319          N  9.775647e+03 0.00557985            1 -1.963961e+07
      66   437_2077319       maxN  1.773273e+03 0.13978616            0 -3.560434e+06
      67   437_2077319    Shannon -3.005516e-02 0.70320392            0  6.306294e+01
      68   437_2077319 expShannon -4.628513e-01 0.69401817            0  9.450090e+02
      69   437_2077319    Simpson  2.122870e-04 0.99009460            0  4.375835e-01
      70   437_2077319 invSimpson -1.950326e-01 0.87398361            0  4.010466e+02
      71   437_2077319        PIE  2.036851e-04 0.99049697            0  4.549336e-01
      72   437_2077319      DomMc -1.772932e-03 0.96240126            0  3.974004e+00
      73   437_2076590          S  4.819277e-02 0.99539237            0 -2.597590e+01
      74   437_2076590          N  6.721535e+03 0.16419572            0 -1.343331e+07
      75   437_2076590       maxN -8.855904e+00 0.99206612            0  3.353006e+04
      76   437_2076590    Shannon  5.769677e-02 0.32995115            0 -1.130239e+02
      77   437_2076590 expShannon  1.404966e+00 0.28684743            0 -2.805031e+03
      78   437_2076590    Simpson  6.543689e-03 0.08090861            0 -1.224747e+01
      79   437_2076590 invSimpson  1.224651e+00 0.04107477            1 -2.451214e+03
      80   437_2076590        PIE  6.543156e-03 0.08092701            0 -1.224639e+01
      81   437_2076590      DomMc -1.905933e-02 0.29055069            0  3.866818e+01
      82   437_2078777          S -2.108434e+00 0.77516324            0  4.302446e+03
      83   437_2078777          N  5.746165e+03 0.18831257            0 -1.148912e+07
      84   437_2078777       maxN  6.616122e+03 0.06881635            0 -1.328309e+07
      85   437_2078777    Shannon -9.282819e-02 0.38815987            0  1.891460e+02
      86   437_2078777 expShannon -1.031922e+00 0.37403571            0  2.087634e+03
      87   437_2078777    Simpson -3.241143e-02 0.23655544            0  6.599889e+01
      88   437_2078777 invSimpson -8.025152e-01 0.41332820            0  1.620685e+03
      89   437_2078777        PIE -3.241247e-02 0.23654455            0  6.600100e+01
      90   437_2078777      DomMc  3.003652e-02 0.42391606            0 -5.992348e+01
      91   437_2076589          S  1.571429e+00 0.03338324            1 -3.130952e+03
      92   437_2076589          N  1.421394e+03 0.47616699            0 -2.839737e+06
      93   437_2076589       maxN  7.596407e+02 0.52578106            0 -1.523031e+06
      94   437_2076589    Shannon -4.703992e-02 0.54335839            0  9.733068e+01
      95   437_2076589 expShannon -6.395930e-01 0.57433063            0  1.301675e+03
      96   437_2076589    Simpson -8.358841e-03 0.54878801            0  1.770479e+01
      97   437_2076589 invSimpson -5.542033e-01 0.63497050            0  1.124337e+03
      98   437_2076589        PIE -8.361745e-03 0.54879592            0  1.771068e+01
      99   437_2076589      DomMc  1.247050e-02 0.62255038            0 -2.470392e+01
      100  437_2075860          S  8.857143e+00 0.21123639            0 -1.778176e+04
      101  437_2075860          N  1.054104e+04 0.05890918            0 -2.114494e+07
      102  437_2075860       maxN  8.881564e+02 0.31794564            0 -1.757952e+06
      103  437_2075860    Shannon  1.916651e-01 0.02901090            1 -3.835970e+02
      104  437_2075860 expShannon  2.063282e+00 0.02431841            1 -4.143262e+03
      105  437_2075860    Simpson  3.842527e-02 0.25010674            0 -7.658824e+01
      106  437_2075860 invSimpson  9.064480e-01 0.07892402            0 -1.819764e+03
      107  437_2075860        PIE  3.842438e-02 0.25011110            0 -7.658645e+01
      108  437_2075860      DomMc -5.299857e-02 0.04894332            1  1.072597e+02
      109  437_2074400          S  1.142857e+00 0.68827910            0 -2.266238e+03
      110  437_2074400          N  4.734568e+02 0.74042016            0 -9.368738e+05
      111  437_2074400       maxN  4.662000e+01 0.94210064            0 -9.119890e+04
      112  437_2074400    Shannon -3.139575e-02 0.72833767            0  6.602287e+01
      113  437_2074400 expShannon -6.032863e-01 0.70148443            0  1.231479e+03
      114  437_2074400    Simpson -2.104224e-03 0.82393528            0  5.152212e+00
      115  437_2074400 invSimpson -4.860387e-01 0.74077749            0  9.908823e+02
      116  437_2074400        PIE -2.106614e-03 0.82384893            0  5.157081e+00
      117  437_2074400      DomMc  4.051863e-03 0.90634243            0 -7.875449e+00
      118  437_2074399          S  3.500000e+00 0.33333333            0 -7.006167e+03
      119  437_2074399          N  1.512423e+04 0.08618974            0 -3.040342e+07
      120  437_2074399       maxN  3.964162e+03 0.09289128            0 -7.970328e+06
      121  437_2074399    Shannon -5.223990e-02 0.63592417            0  1.078477e+02
      122  437_2074399 expShannon -8.656709e-01 0.61786975            0  1.757645e+03
      123  437_2074399    Simpson -8.154281e-03 0.44788194            0  1.730745e+01
      124  437_2074399 invSimpson -8.301166e-01 0.48580372            0  1.680895e+03
      125  437_2074399        PIE -8.163397e-03 0.44757751            0  1.732584e+01
      126  437_2074399      DomMc  2.131072e-02 0.31334874            0 -4.253882e+01

