\name{revealRNA}
\alias{revealRNA}
\title{Explore Your BioInsight Results}
\description{
Consider your count matrix filtered by describeRNA. Here i provide a function to generate the same plots with the new data for a comparison
}
\usage{
revealRNA(counts, biotypes, report = FALSE, verbose = FALSE)
}
\arguments{
  \item{counts}{New count matrix generated by describeRNA function}
  \item{biotypes}{A column called gene_biotype}
  \item{report}{If TRUE, a new set of plot in a proportion of 2:2 will be generated in a temporary directory}
  \item{verbose}{If TRUE, your new table will be printed in the console}
  }
\examples{
#describeRNA
counts = system.file("extdata", "count_matrix.tsv", package = "BioInsight")
counts = read.table(counts[1], header=TRUE, row.names=1)
biotypes = system.file("extdata", "Rattus_Norvegicus_biomart.tsv", package = "BioInsight")
biotypes = read.table(biotypes[1], header=TRUE, row.names=1)

groups = rep(as.factor(c("1","2")), each=5)

describeRNA(counts=counts,
            biotypes=biotypes,
            groups=groups,
            filter=2)

#This example consider that your new count matrix is annotated. If not, you can try to merge:
data = merge(BioInsight, biotypes, by="row.names")
x = data.frame(data$gene_biotype)
revealRNA(counts=data,
          biotypes=x,
          verbose=FALSE,
          report=FALSE)
}
