% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdlm_paral_hdf5.R
\name{bdlm_paral_hdf5}
\alias{bdlm_paral_hdf5}
\title{Linear regression using MLR-MR algorithm with HDF5 data files}
\usage{
bdlm_paral_hdf5(Y, model, blocks, threads = NULL)
}
\arguments{
\item{Y, }{numerical matrix column with response variable}

\item{model, }{numerical matrix with paired observations of the predictor variable X}

\item{blocks, }{integer with number of blocks we want to split matrix if null matrix is splited in blocks as maximum of 1000 variables per block}

\item{threads, }{threads (optional) only if bparal = true, number of concurrent threads in parallelization if threads is null then threads =  maximum number of threads available}
}
\value{
Lineal regression coefficients
}
\description{
Linear regression for Big Data using MLR-MR algorithm to perform lm regression with big data :  https://isglobal-brge.github.io/Master_Modelling/dealing-with-big-data-in-r.html#linear-regression-for-big-data
}
\examples{
# with numeric matrix

library(BigDataStatMeth)
data(mtcars)

Y <- mtcars$mpg
X <- model.matrix(~ wt + cyl, data=mtcars)
m <- 7


res <- bdlm_paral_hdf5( X, Y, m, 1)
res

}
