% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_bw_p.R
\name{step_bw_p}
\alias{step_bw_p}
\title{Automatized stepwise backward for regression models}
\usage{
step_bw_p(
  reg_model,
  s_lower = "~1",
  s_upper = "all",
  trace = TRUE,
  steps = NULL,
  p_threshold = 0.05,
  data = NULL,
  ...
)
}
\arguments{
\item{reg_model}{Regression model. Must be a glm or lm model}

\item{s_lower}{Lower step. Names of the variables to be included at the lower step. Default is "~1" (Intercept)}

\item{s_upper}{Upper step. Names of the variables to be included at the upper step. Default is "all" (Includes all variables in a dataframe)}

\item{trace}{Trace the steps in R console. Display the output of each iteration. Default is TRUE}

\item{steps}{Maximum number of steps in the process. If NULL, steps will be the length of the regression model introduced.}

\item{p_threshold}{Treshold of p value. Default is 0.05}

\item{data}{Dataframe to execute the stepwise process. If NULL, data will be assigned from the regression model data.}

\item{...}{Arguments passed to \code{\link[car:Anova]{car::Anova()}} function.}
}
\value{
An oject class step_bw containing the final model an each step performed in backward regression. The final model can be accessed using $ operator
}
\description{
Automatized stepwise backward for regression models
}
\examples{
data(mtcars)
regression_model<-lm(cyl~., data=mtcars)
stepwise<-step_bw_p(regression_model, trace=FALSE)

final_stepwise_model<-stepwise$final_model

summary(final_stepwise_model)


}
\references{
Efroymson MA. Multiple regression analysis. In: Ralston A, Wilf HS, editors. Mathematical methods for digital computers. New York: Wiley; 1960.
}
