% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiDimRegression.R
\name{BiDimRegression}
\alias{BiDimRegression}
\title{Calculates the bidimensional regression between two 2D configurations}
\usage{
BiDimRegression(coord)
}
\arguments{
\item{coord}{table that must contain two columns for dependent variables (named \code{depV1} and \code{depV2}) and two columns for independent variables (named \code{indepV1} and \code{indepV2}).}
}
\value{
an S3 class \code{BiDimRegression} containing all essential measures of the bidimensional regression
\itemize{
\item \code{euclidean.r, affine.r} - the regression coefficient, defined analogously to Pearson's r.
\item \code{euclidean.rsqr, affine.rsqr} - the squared regression coefficient.
\item \code{euclidean.diABSqr, affine.diABSqr} - the squared distortion index for dependent variables; following Waterman and Gordon's (1984) extension of the bidimensional regression, it provides a measure of comparison of distortions, but the range of values is 0 to 1 following Friedman and Kohler (2003).
\item \code{euclidean.dMaxABSqr, affine.dMaxABSqr} - the maximal squared distortion index for dependent variables.
\item \code{euclidean.diXYSqr, affine.diXYSqr} - the distortion index for independent variables.
\item \code{euclidean.dMaxXYSqr, affine.dMaxXYSqr} - the maximal squared distortion index for independent variables.
\item \code{euclidean.scaleFactorX, affine.scaleFactorX} - the scaling factor of the first dimension (1.0 means no scaling; values below 1.0 indicate a contraction, values above 1.0 indicate an expansion).
\item \code{euclidean.scaleFactorY, affine.scaleFactorY} - the scaling factor of the second dimension.
\item \code{euclidean.angleDEG, affine.angleDEG} - the rotation angle \bold{in degrees}.
\item \code{euclidean.shear, affine.shear} - shearing of the transformed configuration, always zero for the Euclidean transformation.
\item \code{euclidean.ttestDF, affine.ttestDF} - degrees of freedom (DF) for the t-tests regarding the model parameters (alphas and betas).
\item \code{euclidean.alpha1.*, euclidean.alpha2.*, affine.alpha1.*, affine.alpha2.*} - intercept vectors, information includes \code{.coeff} for coefficient, \code{.SE} for standard error, \code{tValue} for \emph{t}-statistics, and \code{pValue} for significance.
\item \code{euclidean.beta1.*, euclidean.beta2.*, affine.beta1.*, affine.beta2.*, affine.beta3.*, affine.beta4.*} - slope vectors, information includes \code{.coeff} for coefficient, \code{.SE} for standard error, \code{tValue} for \emph{t}-statistics, and \code{pValue} for significance.
\item \code{euclidean.fValue, affine.fValue} -  F-statistics, following the advice of Nakaya (1997).
\item \code{euclidean.df1, affine.df1} -  degrees of freedom of the nominator used for the F-statistics propagated by Nakaya (1997); df1 = p-2, with p is the number of elements  needed to calculate the referring model: p=4 for the Euclidean and p=6 for the affine geometry {Nakaya, 1997, Table 1}.
\item \code{euclidean.df2, affine.df2} -  degrees of freedom of the denominator used for the F-statistics propagated by Nakaya (1997); df2 = 2n-p, with p is the number of elements needed to calculate the referring model (see df1) and n is the number of coordinate pairs.
\item \code{euclidean.pValue, affine.pValue} -  the significance level based on the preceding F-statistics.
\item \code{euclidean.dAICso, affine.dAICso} -  the AIC difference between the regarding bidimensional regression model and the bidimensional null model (S0) according to Nakaya (1997), formula 56.
\item \code{eucVSaff.*} - statistical comparison between Euclidean and Affine models, include \code{.fValue} for F-statistics, \code{.df1} and \code{.df2} for the degrees of freedom, \code{.pValue} for the significance level, and \code{.dAIC} for AIC difference between two models.
}
}
\description{
Calculates the bidimensional regression between two 2D configurations using both Euclidean and Affine transformations following the approach by Tobler (1965).
This function assumes strict data format and returns all coefficients and statistics in a single structure. Same functionality is now re-implemented in a R-friendly style, see \code{\link{lm2}} function.
}
\examples{
resultingMeasures <- BiDimRegression(NakayaData)
print(resultingMeasures)

}
\seealso{
\code{\link{lm2}}
}
