/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.substmodel.DifferentialMassProvider;
import dr.evomodel.substmodel.GlmSubstitutionModel;
import dr.evomodel.treedatalikelihood.BeagleDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.ProcessSimulation;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.discrete.BranchDifferentialMassProvider;
import dr.evomodel.treedatalikelihood.discrete.BranchSubstitutionParameterDelegate;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.xml.Reportable;
import java.util.ArrayList;

public class ArbitrarySubstitutionGeneratorGradient
implements GradientWrtParameterProvider,
Reportable {
    private final Parameter parameter;
    private final TreeDataLikelihood treeDataLikelihood;
    private final TreeTrait treeTraitProvider;
    private final Tree tree;
    private final GlmSubstitutionModel substitutionModel;
    private final int stateCount;
    private final double tolerance = 0.01;

    public ArbitrarySubstitutionGeneratorGradient(String string, TreeDataLikelihood treeDataLikelihood, BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate, GlmSubstitutionModel glmSubstitutionModel) {
        this.treeDataLikelihood = treeDataLikelihood;
        this.tree = treeDataLikelihood.getTree();
        this.substitutionModel = glmSubstitutionModel;
        this.parameter = null;
        this.stateCount = glmSubstitutionModel.getDataType().getStateCount();
        String string2 = BranchSubstitutionParameterDelegate.getName(string);
        TreeTrait treeTrait = treeDataLikelihood.getTreeTrait(string2);
        if (treeTrait == null) {
            DifferentialMassProvider differentialMassProvider = d -> {
                double[] dArray = new double[this.stateCount * this.stateCount];
                double[] dArray2 = new double[this.stateCount * this.stateCount];
                glmSubstitutionModel.getInfinitesimalMatrix(dArray2);
                dArray[0] = dArray2[0];
                dArray[1] = dArray2[1];
                dArray[2] = dArray2[2];
                dArray[3] = dArray2[3];
                return dArray;
            };
            ArrayList<DifferentialMassProvider> arrayList = new ArrayList<DifferentialMassProvider>();
            arrayList.add(differentialMassProvider);
            BranchDifferentialMassProvider branchDifferentialMassProvider = new BranchDifferentialMassProvider(null, arrayList);
            BranchSubstitutionParameterDelegate branchSubstitutionParameterDelegate = new BranchSubstitutionParameterDelegate(string, treeDataLikelihood.getTree(), beagleDataLikelihoodDelegate, treeDataLikelihood.getBranchRateModel(), branchDifferentialMassProvider);
            ProcessSimulation processSimulation = new ProcessSimulation(treeDataLikelihood, branchSubstitutionParameterDelegate);
            treeDataLikelihood.addTraits(processSimulation.getTreeTraits());
        }
        this.treeTraitProvider = treeDataLikelihood.getTreeTrait(string2);
        assert (this.treeTraitProvider != null);
    }

    @Override
    public Likelihood getLikelihood() {
        return this.treeDataLikelihood;
    }

    @Override
    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getGradientLogDensity() {
        double d = 0.0;
        double[] dArray = (double[])this.treeTraitProvider.getTrait(this.tree, null);
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return new double[]{d};
    }

    @Override
    public String getReport() {
        return GradientWrtParameterProvider.getReportAndCheckForError(this, 0.0, Double.POSITIVE_INFINITY, null);
    }
}

