/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.datatype;

import dr.evolution.datatype.DataType;
import dr.util.Identifiable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class GeneralDataType
extends DataType
implements Identifiable {
    public static final String GENERAL_DATA_TYPE = "generalDataType";
    public static final String DESCRIPTION = "generalDataType";
    public static final int TYPE = 4;
    public static final GeneralDataType INSTANCE = new GeneralDataType();
    public static final String DELIMITER = ":";
    private char[] validChars = null;
    private Map<Integer, boolean[]> stateSetMap = new HashMap<Integer, boolean[]>();
    private String id = null;
    private List<State> states = new ArrayList<State>();
    private Map<String, State> stateMap = new TreeMap<String, State>();

    public GeneralDataType() {
    }

    public GeneralDataType(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            State state = new State(i, stringArray[i]);
            this.states.add(state);
            this.stateMap.put(stringArray[i], state);
        }
        this.stateCount = this.states.size();
        this.ambiguousStateCount = 0;
    }

    public GeneralDataType(Collection<String> collection) {
        int n = 0;
        for (String string : collection) {
            State state = new State(n, string);
            this.states.add(state);
            this.stateMap.put(string, state);
            ++n;
        }
        this.stateCount = this.states.size();
        this.ambiguousStateCount = 0;
    }

    public void addAlias(String string, String string2) {
        State state = this.stateMap.get(string2);
        if (state == null) {
            throw new IllegalArgumentException("DataType doesn't contain the state, " + string2);
        }
        this.stateMap.put(string, state);
    }

    public void addAmbiguity(String string, String[] stringArray) {
        int n = this.ambiguousStateCount + this.stateCount;
        int[] nArray = new int[stringArray.length];
        int n2 = 0;
        for (String string2 : stringArray) {
            State state = this.stateMap.get(string2);
            if (state == null) {
                throw new IllegalArgumentException("DataType doesn't contain the state, " + string2);
            }
            nArray[n2] = state.number;
            ++n2;
        }
        State state = new State(n, string, nArray);
        this.states.add(state);
        ++this.ambiguousStateCount;
        this.stateMap.put(string, state);
    }

    @Override
    public char[] getValidChars() {
        if (this.validChars == null) {
            boolean bl = false;
            this.validChars = new char[this.stateMap.size()];
            int n = 0;
            for (String string : this.stateMap.keySet()) {
                if (string.length() > 1) {
                    bl = true;
                }
                this.validChars[n] = string.charAt(0);
                ++n;
            }
            if (bl) {
                this.validChars = null;
            }
        }
        return this.validChars;
    }

    @Override
    public int getState(String string) {
        if (string.equals("?")) {
            return this.getUnknownState();
        }
        if (!this.stateMap.containsKey(string)) {
            throw new IllegalArgumentException("Unknown state code, " + string + " for GeneralDataType with id=" + this.getId());
        }
        return this.stateMap.get((Object)string).number;
    }

    @Override
    public boolean isDelimited() {
        for (State state : this.states) {
            if (state.code.length() <= 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDelimiter() {
        return DELIMITER;
    }

    @Override
    public int getState(char c) {
        return this.getState(String.valueOf(c));
    }

    @Override
    public int getUnknownState() {
        return this.stateCount + this.ambiguousStateCount;
    }

    @Override
    public int getGapState() {
        return this.getUnknownState();
    }

    @Override
    public String getCode(int n) {
        return this.states.get((int)n).code;
    }

    @Override
    public int[] getStates(int n) {
        return this.states.get((int)n).ambiguities;
    }

    @Override
    public boolean[] getStateSet(int n) {
        boolean[] blArray = this.stateSetMap.get(n);
        if (blArray == null) {
            blArray = new boolean[this.stateCount];
            if (n >= 0 && n < this.states.size()) {
                int n2;
                State state = this.states.get(n);
                for (n2 = 0; n2 < this.stateCount; ++n2) {
                    blArray[n2] = false;
                }
                int n3 = state.ambiguities.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    blArray[state.ambiguities[n2]] = true;
                }
            } else if (n == this.states.size()) {
                for (int i = 0; i < this.stateCount; ++i) {
                    blArray[i] = true;
                }
            } else {
                throw new IllegalArgumentException("invalid state index");
            }
            this.stateSetMap.put(n, blArray);
        }
        return blArray;
    }

    @Override
    public String getDescription() {
        if (this.id != null) {
            return this.id;
        }
        return "generalDataType";
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String getId() {
        return this.id;
    }

    private class State {
        int number;
        String code;
        int[] ambiguities;

        State(int n, String string) {
            this.number = n;
            this.code = string;
            this.ambiguities = new int[]{n};
        }

        State(int n, String string, int[] nArray) {
            this.number = n;
            this.code = string;
            this.ambiguities = nArray;
        }
    }
}

