/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.tree.AncestralTraitTreeModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;

public class AncestralTraitBranchRateModel
extends AbstractBranchRateModel {
    private final BranchRateModel branchRates;
    private final AncestralTraitTreeModel treeModel;
    private final Tree originalTree;

    public AncestralTraitBranchRateModel(BranchRateModel branchRateModel, AncestralTraitTreeModel ancestralTraitTreeModel) {
        super("ancestral." + branchRateModel.getModelName());
        this.branchRates = branchRateModel;
        this.treeModel = ancestralTraitTreeModel;
        this.originalTree = ancestralTraitTreeModel.getOriginalTree();
        this.addModel(branchRateModel);
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        assert (tree == this.treeModel);
        NodeRef nodeRef2 = this.treeModel.getOriginalNode(nodeRef);
        if (nodeRef2 != null) {
            return this.branchRates.getBranchRate(this.originalTree, nodeRef2);
        }
        return 1.0;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model != this.branchRates) {
            throw new IllegalArgumentException("Unknown model");
        }
        this.fireModelChanged(model);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        throw new IllegalArgumentException("Unknown variable");
    }
}

