/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.MatrixParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;

public class DiagonalMatrix
extends MatrixParameter
implements MatrixParameterInterface,
VariableListener {
    private Parameter diagonalParameter;

    public DiagonalMatrix(Parameter parameter) {
        super("matrixParameter");
        this.addParameter(parameter);
        this.diagonalParameter = parameter;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable != this.diagonalParameter) {
            throw new IllegalArgumentException("Unknown variable");
        }
        this.fireParameterChangedEvent(-1, Variable.ChangeType.ALL_VALUES_CHANGED);
    }

    @Override
    public String getDimensionName(int n) {
        int n2 = n / this.diagonalParameter.getDimension();
        int n3 = n % this.diagonalParameter.getDimension();
        return this.getId() + "." + n2 + "." + n3;
    }

    public Parameter getDiagonalParameter() {
        return this.diagonalParameter;
    }

    @Override
    public double getParameterValue(int n, int n2) {
        if (n != n2) {
            return 0.0;
        }
        return this.diagonalParameter.getParameterValue(n);
    }

    @Override
    public double[][] getParameterAsMatrix() {
        int n = this.getRowDimension();
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = this.diagonalParameter.getParameterValue(i);
        }
        return dArray;
    }

    public void inverse() {
        for (int i = 0; i < this.diagonalParameter.getDimension(); ++i) {
            if ((Double)this.diagonalParameter.getValue(i) == 0.0) {
                throw new RuntimeException("Diagonal matrix is not of full rank");
            }
            this.setParameterValue(i, 1.0 / this.diagonalParameter.getParameterValue(i));
        }
    }

    @Override
    public int getDimension() {
        return this.diagonalParameter.getDimension() * this.diagonalParameter.getDimension();
    }

    @Override
    public double getParameterValue(int n) {
        return this.getParameterValue(n / this.diagonalParameter.getDimension(), n % this.diagonalParameter.getDimension());
    }

    @Override
    public MatrixParameter add(MatrixParameter matrixParameter) {
        MatrixParameter matrixParameter2 = new MatrixParameter(null);
        matrixParameter2.setDimensions(this.getRowDimension(), this.getColumnDimension());
        return this.addInPlace(matrixParameter, matrixParameter2);
    }

    @Override
    public MatrixParameter addInPlace(MatrixParameter matrixParameter, MatrixParameter matrixParameter2) {
        if (this.getColumnDimension() != matrixParameter.getColumnDimension() || this.getRowDimension() != matrixParameter.getRowDimension()) {
            throw new RuntimeException("You cannot add a " + this.getRowDimension() + " by " + this.getColumnDimension() + " matrix to a " + matrixParameter.getRowDimension() + " by " + matrixParameter.getColumnDimension() + " matrix.");
        }
        for (int i = 0; i < this.getRowDimension(); ++i) {
            for (int j = 0; j < this.getColumnDimension(); ++j) {
                if (i == j) {
                    matrixParameter2.setParameterValueQuietly(i, j, this.getParameterValue(i, j) + matrixParameter.getParameterValue(i, j));
                    continue;
                }
                matrixParameter2.setParameterValueQuietly(i, j, matrixParameter.getParameterValue(i, j));
            }
        }
        return matrixParameter2;
    }

    @Override
    public void product(double d) {
        for (int i = 0; i < this.getRowDimension(); ++i) {
            this.setParameterValueQuietly(i, i, d * this.getParameterValue(i, i));
        }
        this.fireParameterChangedEvent();
    }

    @Override
    public MatrixParameter productInPlace(double d, MatrixParameter matrixParameter) {
        for (int i = 0; i < this.getRowDimension(); ++i) {
            matrixParameter.setParameterValueQuietly(i, i, d * this.getParameterValue(i, i));
        }
        return matrixParameter;
    }

    public double getDeterminant() {
        double d = 1.0;
        for (int i = 0; i < this.diagonalParameter.getDimension(); ++i) {
            d *= this.diagonalParameter.getParameterValue(i);
        }
        return d;
    }

    @Override
    public void setParameterValue(int n, double d) {
        this.diagonalParameter.setParameterValue(n, d);
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        this.diagonalParameter.setParameterValueQuietly(n, d);
    }

    @Override
    public int getColumnDimension() {
        return this.diagonalParameter.getDimension();
    }

    @Override
    public int getRowDimension() {
        return this.diagonalParameter.getDimension();
    }

    @Override
    public boolean isConstrainedSymmetric() {
        return true;
    }
}

