/*
 * Decompiled with CFR 0.152.
 */
package dr.geo.distributions;

import cern.jet.math.Bessel;
import dr.geo.distributions.HyperSphereDistribution;
import dr.geo.math.Space;

public class VonMisesDistribution
extends HyperSphereDistribution {
    public VonMisesDistribution(int n, Space space, double[] dArray, double d) {
        super(n, space, dArray, d);
    }

    @Override
    public double logPdf(double[] dArray) {
        return VonMisesDistribution.logPdf(dArray, this.mean, this.kappa, this.space);
    }

    @Override
    public String getType() {
        return "von Mises";
    }

    @Override
    protected int getAllowableDim() {
        return 2;
    }

    private static double logNormalizationConstant(double d) {
        return -LOG_2_PI - Math.log(Bessel.i0(d));
    }

    public static double logPdf(double[] dArray, double[] dArray2, double d, Space space) {
        return VonMisesDistribution.logNormalizationConstant(d) + d * HyperSphereDistribution.innerProduct(dArray, dArray2, space);
    }

    public static void main(String[] stringArray) {
        double d = 2.0;
        double[] dArray = new double[]{1.0};
        double[] dArray2 = new double[]{-4.0};
        System.err.println("logP = " + VonMisesDistribution.logPdf(dArray2, dArray, d, Space.RADIANS) + " ?= -2.094546");
    }
}

