/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous.cdi;

import dr.evomodel.treedatalikelihood.continuous.cdi.InstanceDetails;
import dr.evomodel.treedatalikelihood.continuous.cdi.PrecisionType;
import dr.math.matrixAlgebra.WrappedVector;
import dr.math.matrixAlgebra.missingData.MissingOps;
import dr.xml.Reportable;
import java.util.Arrays;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public interface ContinuousDiffusionIntegrator
extends Reportable {
    public static final int OPERATION_TUPLE_SIZE = 5;
    public static final int NONE = -1;
    public static final double LOG_SQRT_2_PI = 0.5 * Math.log(Math.PI * 2);

    public void finalize() throws Throwable;

    public void setPostOrderPartial(int var1, double[] var2);

    public void getPostOrderPartial(int var1, double[] var2);

    public double getBranchLength(int var1);

    public void getBranchMatrices(int var1, int var2, double[] var3, double[] var4, double[] var5);

    public void getBranchPrecision(int var1, int var2, double[] var3);

    public void getBranchVariance(int var1, int var2, double[] var3);

    public void getBranchDisplacement(int var1, double[] var2);

    public void getBranchActualization(int var1, double[] var2);

    public void getBranch1mActualization(int var1, double[] var2);

    public void getBranchExpectation(double[] var1, double[] var2, double[] var3, double[] var4);

    public void getRootMatrices(int var1, int var2, double[] var3, double[] var4, double[] var5);

    public void getRootPrecision(int var1, int var2, double[] var3);

    public void setPreOrderPartial(int var1, double[] var2);

    public void getPreOrderPartial(int var1, double[] var2);

    public void setWishartStatistics(int[] var1, double[] var2);

    public void getWishartStatistics(int[] var1, double[] var2);

    public void setDiffusionPrecision(int var1, double[] var2, double var3);

    public void setDiffusionStationaryVariance(int var1, double[] var2, double[] var3);

    public void updatePostOrderPartials(int[] var1, int var2, int var3, boolean var4, boolean var5);

    public void updatePreOrderPartials(int[] var1, int var2);

    public InstanceDetails getDetails();

    public void updateBrownianDiffusionMatrices(int var1, int[] var2, double[] var3, double[] var4, int var5);

    public void updateOrnsteinUhlenbeckDiffusionMatrices(int var1, int[] var2, double[] var3, double[] var4, double[] var5, double[] var6, int var7);

    public void updateIntegratedOrnsteinUhlenbeckDiffusionMatrices(int var1, int[] var2, double[] var3, double[] var4, double[] var5, double[] var6, int var7);

    public void calculateRootLogLikelihood(int var1, int var2, int var3, double[] var4, boolean var5, boolean var6);

    public void updatePreOrderPartial(int var1, int var2, int var3, int var4, int var5);

    public void calculatePreOrderRoot(int var1, int var2, int var3);

    public int getBufferCount();

    public int getDimTrait();

    public int getDimProcess();

    public static class Basic
    implements ContinuousDiffusionIntegrator {
        private InstanceDetails details = new InstanceDetails();
        final int numTraits;
        final int dimTrait;
        final int dimProcess;
        final int bufferCount;
        final int diffusionCount;
        final int dimMatrix;
        final int dimPartialForTrait;
        final int dimPartial;
        double[] partials;
        double[] branchLengths;
        double[] variances;
        double[] precisions;
        double[] remainders;
        double[] diffusions;
        double[] determinants;
        int[] degreesOfFreedom;
        double[] outerProducts;
        double[] preOrderPartials;
        int precisionOffset;
        double precisionLogDet;
        static final boolean INLINE = true;
        private static boolean DEBUG = false;

        @Override
        public int getBufferCount() {
            return this.bufferCount;
        }

        @Override
        public int getDimTrait() {
            return this.dimTrait;
        }

        @Override
        public int getDimProcess() {
            return this.dimProcess;
        }

        @Override
        public String getReport() {
            return "";
        }

        public Basic(PrecisionType precisionType, int n, int n2, int n3, int n4, int n5) {
            assert (n > 0);
            assert (n2 > 0);
            assert (n3 > 0);
            assert (n4 > 0);
            assert (n5 > 0);
            this.numTraits = n;
            this.dimTrait = n2;
            this.dimProcess = n3;
            this.bufferCount = n4;
            this.diffusionCount = n5;
            this.dimMatrix = precisionType.getMatrixLength(n2);
            this.dimPartialForTrait = n2 + this.dimMatrix;
            this.dimPartial = n * this.dimPartialForTrait;
            if (DEBUG) {
                System.err.println("numTraits: " + n);
                System.err.println("dimTrait: " + n2);
                System.err.println("dimProcess: " + n3);
                System.err.println("dimMatrix: " + this.dimMatrix);
                System.err.println("dimPartialForTrait: " + this.dimPartialForTrait);
                System.err.println("dimPartial: " + this.dimPartial);
            }
            this.allocateStorage();
        }

        @Override
        public void finalize() throws Throwable {
            super.finalize();
        }

        @Override
        public void setPostOrderPartial(int n, double[] dArray) {
            if (dArray.length != this.dimPartial) {
                System.err.println("here");
            }
            assert (dArray.length == this.dimPartial);
            assert (this.partials != null);
            System.arraycopy(dArray, 0, this.partials, this.dimPartial * n, this.dimPartial);
        }

        @Override
        public void getPostOrderPartial(int n, double[] dArray) {
            assert (this.partials != null);
            assert (dArray.length >= this.dimPartial);
            System.arraycopy(this.partials, this.getArrayStart(n), dArray, 0, this.getArrayLength(n));
        }

        @Override
        public double getBranchLength(int n) {
            return this.branchLengths[n * this.dimMatrix];
        }

        @Override
        public void getBranchMatrices(int n, int n2, double[] dArray, double[] dArray2, double[] dArray3) {
            if (n == -1) {
                throw new IllegalArgumentException("Not yet implemented");
            }
            this.getBranchPrecision(n, n2, dArray);
            this.getBranchDisplacement(n, dArray2);
            this.getBranchActualization(n, dArray3);
        }

        @Override
        public void getBranchPrecision(int n, int n2, double[] dArray) {
            if (n == -1) {
                throw new RuntimeException("Not yet implemented");
            }
            assert (dArray != null);
            assert (dArray.length >= this.dimTrait * this.dimTrait);
            this.updatePrecisionOffsetAndDeterminant(n2);
            double d = 1.0 / this.getBranchLength(n);
            for (int i = 0; i < this.dimTrait * this.dimTrait; ++i) {
                dArray[i] = d * this.diffusions[this.precisionOffset + i];
            }
        }

        @Override
        public void getBranchVariance(int n, int n2, double[] dArray) {
            this.getBranchPrecision(n, n2, dArray);
            DenseMatrix64F denseMatrix64F = DenseMatrix64F.wrap(this.dimTrait, this.dimTrait, dArray);
            CommonOps.invert(denseMatrix64F);
        }

        @Override
        public void getBranchDisplacement(int n, double[] dArray) {
            if (n == -1) {
                throw new RuntimeException("Not yet implemented");
            }
            this.getDefaultDisplacement(dArray);
        }

        private void getDefaultDisplacement(double[] dArray) {
            assert (dArray != null);
            assert (dArray.length >= this.dimTrait);
            Arrays.fill(dArray, 0, this.dimTrait, 0.0);
        }

        @Override
        public void getBranchExpectation(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
            assert (dArray4 != null);
            assert (dArray4.length >= this.dimTrait);
            assert (dArray2 != null);
            assert (dArray2.length >= this.dimTrait);
            System.arraycopy(dArray2, 0, dArray4, 0, this.dimTrait);
        }

        @Override
        public void getBranchActualization(int n, double[] dArray) {
            if (n == -1) {
                throw new RuntimeException("Not yet implemented");
            }
            assert (dArray != null);
            assert (dArray.length >= this.dimTrait);
            for (int i = 0; i < this.dimTrait; ++i) {
                dArray[i] = 1.0;
            }
        }

        @Override
        public void getBranch1mActualization(int n, double[] dArray) {
            if (n == -1) {
                throw new RuntimeException("Not yet implemented");
            }
            assert (dArray != null);
            assert (dArray.length >= this.dimTrait);
            for (int i = 0; i < this.dimTrait; ++i) {
                dArray[i] = 0.0;
            }
        }

        private void getDefaultActualization(double[] dArray) {
            assert (dArray != null);
            assert (dArray.length >= this.dimTrait);
            if (dArray.length >= this.dimTrait * this.dimTrait) {
                for (int i = 0; i < this.dimTrait; ++i) {
                    dArray[i * this.dimTrait + i] = 1.0;
                }
            } else {
                for (int i = 0; i < this.dimTrait; ++i) {
                    dArray[i] = 1.0;
                }
            }
        }

        @Override
        public void getRootMatrices(int n, int n2, double[] dArray, double[] dArray2, double[] dArray3) {
            this.getRootPrecision(n, n2, dArray);
            this.getDefaultDisplacement(dArray2);
            this.getDefaultActualization(dArray3);
        }

        @Override
        public void getRootPrecision(int n, int n2, double[] dArray) {
            assert (dArray != null);
            assert (dArray.length >= this.dimTrait * this.dimTrait);
            this.updatePrecisionOffsetAndDeterminant(n2);
            int n3 = this.dimPartial * n;
            double d = this.partials[n3 + this.dimTrait];
            for (int i = 0; i < this.dimTrait * this.dimTrait; ++i) {
                dArray[i] = d * this.diffusions[this.precisionOffset + i];
            }
        }

        @Override
        public void setPreOrderPartial(int n, double[] dArray) {
            System.arraycopy(dArray, 0, this.preOrderPartials, this.getArrayStart(n), this.getArrayLength(n));
        }

        @Override
        public void getPreOrderPartial(int n, double[] dArray) {
            System.arraycopy(this.preOrderPartials, this.getArrayStart(n), dArray, 0, this.getArrayLength(n));
        }

        private int getArrayStart(int n) {
            return n == -1 ? 0 : this.dimPartial * n;
        }

        private int getArrayLength(int n) {
            return n == -1 ? this.dimPartial * this.bufferCount : this.dimPartial;
        }

        @Override
        public void setWishartStatistics(int[] nArray, double[] dArray) {
            assert (nArray.length == this.numTraits);
            assert (dArray.length == this.dimTrait * this.dimTrait * this.numTraits);
            System.arraycopy(nArray, 0, this.degreesOfFreedom, 0, this.numTraits);
            System.arraycopy(dArray, 0, this.outerProducts, 0, this.dimTrait * this.dimTrait * this.numTraits);
        }

        @Override
        public void getWishartStatistics(int[] nArray, double[] dArray) {
            assert (nArray.length == this.numTraits);
            assert (dArray.length == this.dimTrait * this.dimTrait * this.numTraits);
            System.arraycopy(this.degreesOfFreedom, 0, nArray, 0, this.numTraits);
            System.arraycopy(this.outerProducts, 0, dArray, 0, this.dimTrait * this.dimTrait * this.numTraits);
        }

        @Override
        public void setDiffusionPrecision(int n, double[] dArray, double d) {
            assert (dArray.length == this.dimProcess * this.dimProcess);
            assert (this.diffusions != null);
            assert (this.determinants != null);
            System.arraycopy(dArray, 0, this.diffusions, this.dimProcess * this.dimProcess * n, this.dimProcess * this.dimProcess);
            this.determinants[n] = d;
        }

        @Override
        public void setDiffusionStationaryVariance(int n, double[] dArray, double[] dArray2) {
        }

        @Override
        public void calculateRootLogLikelihood(int n, int n2, int n3, double[] dArray, boolean bl, boolean bl2) {
            assert (dArray.length == this.numTraits);
            assert (!bl2);
            this.updatePrecisionOffsetAndDeterminant(n3);
            if (DEBUG) {
                System.err.println("Root calculation for " + n);
                System.err.println("Prior buffer index is " + n2);
            }
            int n4 = this.dimPartial * n;
            int n5 = this.dimPartial * n2;
            for (int i = 0; i < this.numTraits; ++i) {
                double d = 0.0;
                int n6 = this.precisionOffset;
                double d2 = this.partials[n4 + this.dimTrait];
                double d3 = this.partials[n5 + this.dimTrait];
                if (!Double.isInfinite(d3)) {
                    d2 = d2 * d3 / (d2 + d3);
                }
                for (int j = 0; j < this.dimTrait; ++j) {
                    double d4 = this.partials[n4 + j] - this.partials[n5 + j];
                    for (int k = 0; k < this.dimTrait; ++k) {
                        double d5 = this.partials[n4 + k] - this.partials[n5 + k];
                        d += d4 * this.diffusions[n6] * d5;
                        ++n6;
                    }
                }
                double d6 = (double)(-this.dimTrait) * LOG_SQRT_2_PI + 0.5 * ((double)this.dimTrait * Math.log(d2) + this.precisionLogDet) - 0.5 * d2 * d;
                double d7 = this.remainders[n * this.numTraits + i];
                dArray[i] = d6 + d7;
                if (bl) {
                    int n7 = this.dimTrait * this.dimTrait * i;
                    for (int j = 0; j < this.dimTrait; ++j) {
                        double d8 = this.partials[n4 + j] - this.partials[n5 + j];
                        for (int k = 0; k < this.dimTrait; ++k) {
                            double d9 = this.partials[n4 + k] - this.partials[n5 + k];
                            int n8 = n7++;
                            this.outerProducts[n8] = this.outerProducts[n8] + d8 * d9 * d2;
                        }
                    }
                    int n9 = i;
                    this.degreesOfFreedom[n9] = this.degreesOfFreedom[n9] + 1;
                }
                if (DEBUG) {
                    System.err.print("mean:");
                    for (int j = 0; j < this.dimTrait; ++j) {
                        System.err.print(" " + this.partials[n4 + j]);
                    }
                    System.err.println("");
                    System.err.println("prec: " + this.partials[n4 + this.dimTrait]);
                    System.err.println("rootScalar: " + d2);
                    System.err.println("\t" + d6 + " " + (d6 + d7));
                    if (bl) {
                        System.err.println("Outer-products:" + MissingOps.wrap(this.outerProducts, this.dimTrait * this.dimTrait * i, this.dimTrait, this.dimTrait));
                    }
                    System.err.println("");
                }
                n4 += this.dimPartialForTrait;
                n5 += this.dimPartialForTrait;
            }
            if (DEBUG) {
                System.err.println("End");
            }
        }

        @Override
        public void updatePreOrderPartials(int[] nArray, int n) {
            if (DEBUG) {
                System.err.println("Pre-order operations:");
            }
            throw new RuntimeException("Not yet implemented");
        }

        @Override
        public void updatePostOrderPartials(int[] nArray, int n, int n2, boolean bl, boolean bl2) {
            if (DEBUG) {
                System.err.println("Post-order operations:");
            }
            this.updatePrecisionOffsetAndDeterminant(n2);
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                if (DEBUG) {
                    System.err.println("\t" + this.getOperationString(nArray, n3));
                }
                this.updatePartial(nArray[n3], nArray[n3 + 1], nArray[n3 + 2], nArray[n3 + 3], nArray[n3 + 4], bl, bl2);
                n3 += 5;
            }
            if (DEBUG) {
                System.err.println("End");
                System.err.println("");
            }
        }

        @Override
        public void updateBrownianDiffusionMatrices(int n, int[] nArray, double[] dArray, double[] dArray2, int n2) {
            this.updateBranchLengthsAndDet(n, nArray, dArray, n2);
        }

        private void updateBranchLengthsAndDet(int n, int[] nArray, double[] dArray, int n2) {
            if (DEBUG) {
                System.err.println("Matrices (basic):");
            }
            for (int i = 0; i < n2; ++i) {
                if (DEBUG) {
                    System.err.println("\t" + nArray[i] + " <- " + dArray[i]);
                }
                this.branchLengths[this.dimMatrix * nArray[i]] = dArray[i];
            }
            this.updatePrecisionOffsetAndDeterminant(n);
        }

        void updatePrecisionOffsetAndDeterminant(int n) {
            this.precisionOffset = this.dimProcess * this.dimProcess * n;
            this.precisionLogDet = this.determinants[n];
        }

        @Override
        public void updateOrnsteinUhlenbeckDiffusionMatrices(int n, int[] nArray, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n2) {
            this.updateBranchLengthsAndDet(n, nArray, dArray, n2);
        }

        @Override
        public void updateIntegratedOrnsteinUhlenbeckDiffusionMatrices(int n, int[] nArray, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n2) {
            this.updateBranchLengthsAndDet(n, nArray, dArray, n2);
        }

        @Override
        public InstanceDetails getDetails() {
            return this.details;
        }

        @Override
        public void updatePreOrderPartial(int n, int n2, int n3, int n4, int n5) {
            int n6 = this.dimPartial * n;
            int n7 = this.dimPartial * n2;
            int n8 = this.dimPartial * n4;
            int n9 = this.dimMatrix * n3;
            int n10 = this.dimMatrix * n5;
            double d = this.branchLengths[n9];
            double d2 = this.branchLengths[n10];
            if (DEBUG) {
                System.err.println("updatePreOrderPartial for node " + n2);
                System.err.println("\tvi: " + d + " vj: " + d2);
            }
            for (int i = 0; i < this.numTraits; ++i) {
                double d3 = this.preOrderPartials[n6 + this.dimTrait];
                double d4 = this.partials[n8 + this.dimTrait];
                double d5 = Double.isInfinite(d4) ? 1.0 / d2 : d4 / (1.0 + d4 * d2);
                double d6 = d5 + d3;
                double d7 = Double.isInfinite(d3) ? 1.0 : 1.0 + d5 / d3;
                double d8 = Double.isInfinite(d7) ? 0.0 : 1.0 / d7;
                for (int j = 0; j < this.dimTrait; ++j) {
                    double d9;
                    this.preOrderPartials[n7 + j] = d9 = d8 * this.preOrderPartials[n6 + j] + (1.0 - d8) * this.partials[n8 + j];
                }
                double d10 = Double.isInfinite(d6) ? 1.0 / d : d6 / (1.0 + d6 * d);
                double d11 = this.preOrderPartials[n7 + this.dimTrait] = Double.isInfinite(d10) ? Double.POSITIVE_INFINITY : d10;
                if (DEBUG) {
                    System.err.println("trait: " + i);
                    System.err.println("pM: " + new WrappedVector.Raw(this.preOrderPartials, n6, this.dimTrait));
                    System.err.println("pk: " + d3);
                    System.err.println("sM: " + new WrappedVector.Raw(this.partials, n8, this.dimTrait));
                    System.err.println("sV: " + d2);
                    System.err.println("sPp: " + d5);
                    System.err.println("Pip: " + d6);
                    System.err.println("cM: " + new WrappedVector.Raw(this.preOrderPartials, n7, this.dimTrait));
                    System.err.println("cV: " + d10);
                }
                n6 += this.dimPartialForTrait;
                n7 += this.dimPartialForTrait;
                n8 += this.dimPartialForTrait;
            }
        }

        @Override
        public void calculatePreOrderRoot(int n, int n2, int n3) {
            System.arraycopy(this.partials, this.dimPartial * n, this.preOrderPartials, this.dimPartial * n2, this.dimPartial);
        }

        protected void updatePartial(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
            int n6 = this.dimPartial * n;
            int n7 = this.dimPartial * n2;
            int n8 = this.dimPartial * n4;
            int n9 = this.dimMatrix * n3;
            int n10 = this.dimMatrix * n5;
            double d = this.branchLengths[n9];
            double d2 = this.branchLengths[n10];
            if (DEBUG) {
                System.err.println("i:");
                System.err.println("\tvar : " + this.branchLengths[n9]);
            }
            for (int i = 0; i < this.numTraits; ++i) {
                int n11;
                double d3 = this.partials[n7 + this.dimTrait];
                double d4 = this.partials[n8 + this.dimTrait];
                double d5 = Double.isInfinite(d3) ? 1.0 / d : d3 / (1.0 + d3 * d);
                double d6 = Double.isInfinite(d4) ? 1.0 / d2 : d4 / (1.0 + d4 * d2);
                double d7 = Double.isInfinite(d5 + d6) ? Double.POSITIVE_INFINITY : d5 + d6;
                double d8 = Double.isInfinite(d5) ? 1.0 : 1.0 + d6 / d5;
                double d9 = Double.isInfinite(d8) ? 0.0 : 1.0 / d8;
                for (n11 = 0; n11 < this.dimTrait; ++n11) {
                    this.partials[n6 + n11] = d9 * this.partials[n7 + n11] + (1.0 - d9) * this.partials[n8 + n11];
                }
                this.partials[n6 + this.dimTrait] = d7;
                if (DEBUG) {
                    System.err.println("\ttrait: " + i);
                    System.err.print("\t\tmean i:");
                    for (n11 = 0; n11 < this.dimTrait; ++n11) {
                        System.err.print(" " + this.partials[n7 + n11]);
                    }
                    System.err.println(" prec i: " + d3);
                    System.err.print("\t\tmean j:");
                    for (n11 = 0; n11 < this.dimTrait; ++n11) {
                        System.err.print(" " + this.partials[n8 + n11]);
                    }
                    System.err.println(" prec j: " + d4);
                    if (d4 == 0.0) {
                        System.exit(-1);
                    }
                    System.err.print("\t\tmean k:");
                    for (n11 = 0; n11 < this.dimTrait; ++n11) {
                        System.err.print(" " + this.partials[n6 + n11]);
                    }
                    System.err.println(" prec k: " + d7);
                    System.err.println("");
                }
                double d10 = 0.0;
                if (bl && d3 != 0.0 && d4 != 0.0) {
                    int n12;
                    double d11 = d5 * d6 / d7;
                    double d12 = 0.0;
                    double d13 = 0.0;
                    double d14 = 0.0;
                    int n13 = this.precisionOffset;
                    for (n12 = 0; n12 < this.dimTrait; ++n12) {
                        double d15 = this.partials[n7 + n12];
                        double d16 = this.partials[n8 + n12];
                        double d17 = this.partials[n6 + n12];
                        for (int j = 0; j < this.dimTrait; ++j) {
                            double d18 = this.partials[n7 + j];
                            double d19 = this.partials[n8 + j];
                            double d20 = this.partials[n6 + j];
                            double d21 = this.diffusions[n13];
                            d14 += d15 * d21 * d18;
                            d13 += d16 * d21 * d19;
                            d12 += d17 * d21 * d20;
                            ++n13;
                        }
                    }
                    d10 += (double)(-this.dimTrait) * LOG_SQRT_2_PI + 0.5 * ((double)this.dimTrait * Math.log(d11) + this.precisionLogDet) - 0.5 * (d5 * d14 + d6 * d13 - d7 * d12);
                    if (DEBUG) {
                        System.err.println("\t\t\tpk: " + d7);
                        System.err.println("\t\t\tSSi = " + d5 * d14);
                        System.err.println("\t\t\tSSj = " + d6 * d13);
                        System.err.println("\t\t\tSSk = " + d7 * d12);
                    }
                    if (DEBUG) {
                        System.err.println("\t\tremainder: " + d10);
                    }
                    if (bl2) {
                        n12 = this.dimTrait * this.dimTrait * i;
                        if (DEBUG) {
                            System.err.println("pip: " + d5);
                            System.err.println("pjp: " + d6);
                            System.err.println("sum: " + (d5 + d6));
                            System.err.println("op prec: " + d11);
                        }
                        for (int j = 0; j < this.dimTrait; ++j) {
                            double d22 = this.partials[n7 + j];
                            double d23 = this.partials[n8 + j];
                            for (int k = 0; k < this.dimTrait; ++k) {
                                double d24 = this.partials[n7 + k];
                                double d25 = this.partials[n8 + k];
                                int n14 = n12++;
                                this.outerProducts[n14] = this.outerProducts[n14] + (d22 - d23) * (d24 - d25) * d11;
                            }
                        }
                        if (DEBUG) {
                            System.err.println("Outer-products:" + MissingOps.wrap(this.outerProducts, this.dimTrait * this.dimTrait * i, this.dimTrait, this.dimTrait));
                        }
                        int n15 = i;
                        this.degreesOfFreedom[n15] = this.degreesOfFreedom[n15] + 1;
                    }
                }
                this.remainders[n * this.numTraits + i] = d10 + this.remainders[n2 * this.numTraits + i] + this.remainders[n4 * this.numTraits + i];
                n6 += this.dimPartialForTrait;
                n7 += this.dimPartialForTrait;
                n8 += this.dimPartialForTrait;
            }
        }

        private static void updateMean(double[] dArray, int n, int n2, int n3, double d, double d2, double d3, int n4) {
            double d4 = Double.isInfinite(d) ? 1.0 : 1.0 + d2 / d;
            double d5 = Double.isInfinite(d4) ? 0.0 : 1.0 / d4;
            for (int i = 0; i < n4; ++i) {
                dArray[n + i] = d5 * dArray[n2 + i] + (1.0 - d5) * dArray[n3 + i];
            }
        }

        private void allocateStorage() {
            this.partials = new double[this.dimPartial * this.bufferCount];
            this.branchLengths = new double[this.dimMatrix * this.bufferCount];
            this.remainders = new double[this.numTraits * this.bufferCount];
            this.diffusions = new double[this.dimProcess * this.dimProcess * this.diffusionCount];
            this.determinants = new double[this.diffusionCount];
            this.degreesOfFreedom = new int[this.numTraits];
            this.outerProducts = new double[this.dimProcess * this.dimProcess * this.numTraits];
            this.preOrderPartials = new double[this.dimPartial * this.bufferCount];
        }

        private String getOperationString(int[] nArray, int n) {
            StringBuilder stringBuilder = new StringBuilder("op:");
            for (int i = 0; i < 5; ++i) {
                stringBuilder.append(" ").append(nArray[n + i]);
            }
            return stringBuilder.toString();
        }
    }
}

