/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evolution.tree.Tree;
import dr.evomodel.treedatalikelihood.continuous.ContinuousRateTransformation;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.continuous.cdi.PrecisionType;
import dr.inference.model.CompoundParameter;
import dr.math.matrixAlgebra.WrappedMatrix;
import dr.math.matrixAlgebra.missingData.MissingOps;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.List;
import org.ejml.data.DenseMatrix64F;

public class JointPartialsProvider
implements ContinuousTraitPartialsProvider {
    private final String name;
    private final ContinuousTraitPartialsProvider[] providers;
    private final int traitDim;
    private final int dataDim;
    private final List<Integer> missingIndices;
    private final boolean[] missingIndicators;
    private final boolean defaultAllowSingular;
    private final Boolean computeDeterminant;
    private static final PrecisionType precisionType = PrecisionType.FULL;
    public static final AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private static final String PARSER_NAME = "jointPartialsProvider";

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            List<ContinuousTraitPartialsProvider> list = xMLObject.getAllChildren(ContinuousTraitPartialsProvider.class);
            ContinuousTraitPartialsProvider[] continuousTraitPartialsProviderArray = new ContinuousTraitPartialsProvider[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                continuousTraitPartialsProviderArray[i] = list.get(i);
            }
            return new JointPartialsProvider(PARSER_NAME, continuousTraitPartialsProviderArray);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(ContinuousTraitPartialsProvider.class, 0, Integer.MAX_VALUE)};
        }

        @Override
        public String getParserDescription() {
            return "Merges two Gaussian processes.";
        }

        @Override
        public Class getReturnType() {
            return JointPartialsProvider.class;
        }

        @Override
        public String getParserName() {
            return PARSER_NAME;
        }
    };

    public JointPartialsProvider(String string, ContinuousTraitPartialsProvider[] continuousTraitPartialsProviderArray) {
        this.name = string;
        this.providers = continuousTraitPartialsProviderArray;
        int n = 0;
        int n2 = 0;
        for (ContinuousTraitPartialsProvider continuousTraitPartialsProvider : continuousTraitPartialsProviderArray) {
            n += continuousTraitPartialsProvider.getTraitDimension();
            n2 += continuousTraitPartialsProvider.getDataDimension();
        }
        this.traitDim = n;
        this.dataDim = n2;
        this.missingIndicators = this.setupMissingIndicators();
        this.missingIndices = ContinuousTraitPartialsProvider.indicatorToIndices(this.missingIndicators);
        this.defaultAllowSingular = this.setDefaultAllowSingular();
        this.computeDeterminant = this.defaultAllowSingular;
    }

    private boolean[] setupMissingIndicators() {
        int n;
        int n2 = this.providers[0].getParameter().getParameterCount();
        boolean[] blArray = new boolean[this.dataDim * n2];
        boolean[][] blArray2 = new boolean[this.providers.length][0];
        for (n = 0; n < this.providers.length; ++n) {
            blArray2[n] = this.providers[n].getDataMissingIndicators();
        }
        for (n = 0; n < n2; ++n) {
            int n3 = n * this.dataDim;
            for (int i = 0; i < this.providers.length; ++i) {
                int n4 = this.providers[i].getDataDimension();
                int n5 = n * n4;
                System.arraycopy(blArray2[i], n5, blArray, n3, n4);
                n3 += n4;
            }
        }
        return blArray;
    }

    @Override
    public boolean bufferTips() {
        return true;
    }

    @Override
    public int getTraitCount() {
        return this.providers[0].getTraitCount();
    }

    @Override
    public int getTraitDimension() {
        return this.traitDim;
    }

    @Override
    public int getDataDimension() {
        return this.dataDim;
    }

    @Override
    public PrecisionType getPrecisionType() {
        return precisionType;
    }

    @Override
    public double[] getTipPartial(int n, boolean bl) {
        double[] dArray = new double[precisionType.getPartialsDimension(this.traitDim)];
        int n2 = precisionType.getMeanOffset(this.traitDim);
        int n3 = precisionType.getPrecisionOffset(this.traitDim);
        int n4 = precisionType.getVarianceOffset(this.traitDim);
        int n5 = precisionType.getEffectiveDimensionOffset(this.traitDim);
        int n6 = precisionType.getDeterminantOffset(this.traitDim);
        WrappedMatrix.Indexed indexed = WrappedMatrix.Utils.wrapBlockDiagonalMatrix(dArray, n3, 0, this.traitDim);
        WrappedMatrix.Indexed indexed2 = WrappedMatrix.Utils.wrapBlockDiagonalMatrix(dArray, n4, 0, this.traitDim);
        int n7 = 0;
        for (ContinuousTraitPartialsProvider continuousTraitPartialsProvider : this.providers) {
            double[] dArray2 = continuousTraitPartialsProvider.getTipPartial(n, bl);
            int n8 = continuousTraitPartialsProvider.getTraitDimension();
            int n9 = precisionType.getPrecisionOffset(n8);
            WrappedMatrix.Raw raw = new WrappedMatrix.Raw(dArray2, n9, n8, n8);
            WrappedMatrix.Utils.transferSymmetricBlockDiagonal(raw, indexed, n7);
            WrappedMatrix.Raw raw2 = new WrappedMatrix.Raw(dArray2, precisionType.getVarianceOffset(n8), n8, n8);
            WrappedMatrix.Utils.transferSymmetricBlockDiagonal(raw2, indexed2, n7);
            n7 += n8;
            System.arraycopy(dArray2, precisionType.getMeanOffset(n8), dArray, n2, n8);
            n2 += n8;
            if (precisionType.hasEffectiveDimension()) {
                int n10 = n5;
                dArray[n10] = dArray[n10] + dArray2[precisionType.getEffectiveDimensionOffset(n8)];
            }
            if (!precisionType.hasEffectiveDimension() || !this.computeDeterminant.booleanValue()) continue;
            double d = dArray2[precisionType.getDeterminantOffset(n8)];
            if (!precisionType.isMissingDeterminantValue(d)) {
                DenseMatrix64F denseMatrix64F = MissingOps.wrap(dArray2, n9, n8, n8);
                DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(n8, n8);
                d = MissingOps.safeInvert2(denseMatrix64F, denseMatrix64F2, true).getLogDeterminant();
            }
            int n11 = n6;
            dArray[n11] = dArray[n11] + d;
        }
        if (!this.computeDeterminant.booleanValue()) {
            precisionType.fillNoDeterminantInPartials(dArray, 0, this.traitDim);
        }
        return dArray;
    }

    @Override
    public List<Integer> getMissingIndices() {
        return this.missingIndices;
    }

    @Override
    public boolean[] getDataMissingIndicators() {
        return this.missingIndicators;
    }

    @Override
    public CompoundParameter getParameter() {
        System.err.println("Warning: This is broken. (JointPartialsProvider.getParameter())");
        return this.providers[0].getParameter();
    }

    @Override
    public String getModelName() {
        return this.name;
    }

    @Override
    public boolean getDefaultAllowSingular() {
        return this.defaultAllowSingular;
    }

    private boolean setDefaultAllowSingular() {
        boolean bl = false;
        for (ContinuousTraitPartialsProvider continuousTraitPartialsProvider : this.providers) {
            bl = bl || continuousTraitPartialsProvider.getDefaultAllowSingular();
        }
        return bl;
    }

    @Override
    public boolean suppliesWishartStatistics() {
        boolean bl = true;
        for (ContinuousTraitPartialsProvider continuousTraitPartialsProvider : this.providers) {
            bl = bl && continuousTraitPartialsProvider.suppliesWishartStatistics();
        }
        return bl;
    }

    @Override
    public void addTreeAndRateModel(Tree tree, ContinuousRateTransformation continuousRateTransformation) {
        for (ContinuousTraitPartialsProvider continuousTraitPartialsProvider : this.providers) {
            continuousTraitPartialsProvider.addTreeAndRateModel(tree, continuousRateTransformation);
        }
    }
}

