% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertFromJafroc.R
\name{convertFromJafroc}
\alias{convertFromJafroc}
\title{Convert  \code{.xlsx} File
of \strong{\emph{Jafroc}}
 into \R Object}
\format{
The \code{.xlsx} file of Jafroc
consists of three sheets named \strong{\emph{TP, FP, Truth}}, \strong{\emph{ precisely! Correctly! }}
(other names never be permitted !!)


\strong{\emph{-----------------------------------  TP ------------------------------------------}}


A sheet named \strong{\emph{TP}}  consists of five columns \strong{\emph{ precisely }}  named from the right hand side:

\strong{\emph{ReaderID,	ModalityID,	CaseID,	LesionID,	TP_Rating.}}


\strong{\emph{NOTE.}}
\describe{
\item{  \strong{\emph{CaseID}}            }{  Note that the above word \strong{\emph{CaseID}} means the Image ID vectors indicating the ID of radiographs.  That is "case = image = radiograph".}
\item{ \strong{\emph{the first row}}      }{  Note that the first row of each sheat of \code{.xlsx} file is constructed by the names of column as follows:   }
}

\strong{An Example of the sheet named \emph{TP} in a \emph{\code{.xlsx}} file for the \emph{Jafroc} software}


\strong{ Interpretation of table}

Throughout this explanation, we follow the convention that readers are male.

For example,
the first row means
the first reader (ReaderID=1) correctly find
the first lesion (LesionID = 1)
in the first image (CaseID = 1)
taken by the first modality (ModalityID = 1)
with his rating 5 (TP_Rating =5).

Similarily
the second row means
the first reader (ReaderID=1) correctly find
the 4-th lesion (LesionID = 4)
in the second image (CaseID = 2)
taken by the 2-nd modality (ModalityID = 2)
with his rating 4 (TP_Rating = 4).



\tabular{ccccc}{
  ReaderID \tab   ModalityID   \tab   CaseID \tab   LesionID \tab   TP_Rating.\cr
  -------------------\tab-------------------\tab-------------------\tab-------------------\tab------------------\cr
  1 \tab 1 \tab 1 \tab  1\tab 5\cr
  1 \tab 2 \tab 2  \tab 1\tab 4\cr
  1 \tab 3 \tab 4  \tab 1\tab 5\cr
  1 \tab 1 \tab 8  \tab 1\tab 3\cr
  1 \tab 2 \tab 8  \tab 2\tab 4\cr
  1 \tab 3 \tab 9  \tab 1\tab 4\cr
  1 \tab 1 \tab 9  \tab 2\tab 3\cr
  1 \tab 2 \tab 9  \tab 3\tab 5\cr
  1 \tab 3 \tab 11 \tab 1\tab 3\cr
  2 \tab 1 \tab 1 \tab  1\tab 4\cr
  2 \tab 2 \tab 4  \tab 1\tab 4\cr
  2 \tab 3 \tab 5  \tab 1\tab 4\cr
  2 \tab 1 \tab 8  \tab 1\tab 1\cr
  2 \tab 2 \tab 8  \tab 2\tab 2\cr
  2 \tab 3 \tab 8  \tab 3\tab 2\cr
  2 \tab 1 \tab 10  \tab 1\tab 3\cr
  2 \tab 2 \tab 10 \tab 2\tab 2\cr
  2 \tab 3 \tab 11  \tab 1\tab 2\cr

  : \tab : \tab :  \tab :\tab :\cr
  : \tab : \tab :  \tab :\tab :\cr    }


\strong{\emph{-----------------------------------  FP ------------------------------------------}}



A sheet named \strong{FP}  consists of four columns  \strong{\emph{ precisely }}
 named from the right hand side: \strong{ReaderID,	ModalityID,	CaseID,	FP_Rating}
\strong{An Example of a sheet named FP in a \code{.xlsx} file for the Jafroc software}






\strong{ Interpretation of table}


For example,
the first row means
the first reader (ReaderID=1) makes
 a false alarm location
in the first image (CaseID = 1)
taken by the first modality (ModalityID = 1)
with his rating 2 (TP_Rating =2).

Similarily
the second row means
the first reader (ReaderID=1) makes
 a false alarm location
in the second image (CaseID = 2)
taken by the 2-nd modality (ModalityID = 2)
with his rating 1 (TP_Rating = 1).


Similarily
the 6-th and 7-th rows mean that
the first reader (ReaderID=1) makes
 two false alarm location
in the second patient (CaseID = 2).
The first false alarm  is in the image
taken by the 1-st modality (ModalityID = 1)
with his rating 1 (TP_Rating = 1).
The second false alarm  is in the image
taken by the 3-rd modality (ModalityID = 3)
with his rating 2 (TP_Rating = 2).






\tabular{cccc}{
  ReaderID \tab   ModalityID   \tab   CaseID  \tab   FP_Rating.\cr
-------------------\tab-------------------\tab-------------------\tab------------------\cr
  1 \tab 1 \tab 1 \tab   2\cr
  1 \tab 2 \tab 2  \tab  1\cr
  1 \tab 3 \tab 3  \tab  1\cr
  1 \tab 1 \tab 5  \tab  2\cr
  1 \tab 2 \tab 7 \tab   1\cr
  1 \tab 3 \tab 7  \tab   2\cr
  1 \tab 1 \tab 9  \tab   3\cr
  1 \tab 2 \tab 9  \tab   4\cr
  1 \tab 3 \tab 10 \tab   1\cr
  2 \tab 1 \tab 1 \tab    2\cr
  2 \tab 2 \tab 2  \tab   3\cr
  2 \tab 3 \tab 3  \tab   4\cr
  2 \tab 1 \tab 8  \tab   1\cr
  2 \tab 2 \tab 9  \tab  1\cr
  2 \tab 3 \tab 11  \tab   1\cr
  2 \tab 1 \tab 14  \tab  1\cr
  2 \tab 2 \tab 15 \tab   1\cr
  2 \tab 3 \tab 21  \tab   2\cr
  : \tab :  \tab :\tab :\cr
  : \tab :  \tab :\tab :\cr
     }




\strong{\emph{-----------------------------------  Truth ------------------------------------------}}

A sheet named \strong{Truth }  consists of three columns
\strong{\emph{ precisely }}  named from the right
 hand side:\strong{CaseID,	LesionID,	Weight} .

\strong{An Example of a sheet named Truth in a \code{.xlsx} file for the Jafroc software}


\strong{ Interpretation of table}

For example, the first image (CaseID = 1) contains
three lesions each of which is named 1,2,3, namely LesionID = 1,2,3.
For example, the second image (CaseID = 2) contains
two lesions each of which is named 1,2, namely LesionID = 1,2.
For example, the third image (CaseID = 3) contains
a sinle lesion named 1, namely LesionID = 1.

\tabular{ccc}{
  CaseID \tab   LesionID   \tab     Weight\cr
  -------------------\tab-------------------\tab------------------\cr
  1 \tab 1 \tab    0.3333...\cr
  1 \tab 2 \tab    0.3333...\cr
  1 \tab 3 \tab    0.3333...\cr
  2 \tab 1 \tab    0.5\cr
  2 \tab 2 \tab    0.5\cr
  3 \tab 1 \tab    1\cr
  4 \tab 1 \tab    0.25\cr
  4 \tab 2 \tab    0.25\cr
  4 \tab 3 \tab    0.25\cr
  4 \tab 4 \tab    0.25\cr
  5 \tab 1 \tab    0.5\cr
  5 \tab 2 \tab    0.5\cr
  6 \tab 1 \tab    0.3333...\cr
  6 \tab 2 \tab    0.3333...\cr
  6 \tab 3 \tab    0.3333...\cr
  7 \tab 1 \tab    0.3333...\cr
  7 \tab 2 \tab    0.3333...\cr
  7 \tab 3 \tab    0.3333...\cr
  8 \tab 1 \tab    0.25\cr
  8 \tab 2 \tab    0.25\cr
  8 \tab 3 \tab    0.25\cr
  8 \tab 4 \tab    0.25\cr
  :  \tab :\tab :\cr
  :  \tab :\tab :\cr
  }




Note that the weght are used
such that each image influences
a same effect on the esimates.
Without weight, the images including
many targets (lesions) will have very strong effect
on the estimates.
To avoid such bias, Jafroc uses weight.
In another context,
weight would be used to specify more important lesions in each image.

Revised 2019 Dec 13; 2020 May 27

  However, in this package, we do not use the information of weight.
Since the theory of the author of this package did not consider such weight.
In the future I have to include the notion of weight.
Jafroc use the notion fo figure of metric as non parametric manner.
So, it seems difficult to include it in the Bayesian model,
since generally speaking, Bayesian methodology is parametric.
}
\usage{
convertFromJafroc(No.of.Modalities, No.of.readers, No.of.confidence.levels)
}
\arguments{
\item{No.of.Modalities}{A positive integer, indicating the number of \emph{modalities} which is used in an \code{.xlsx} file.}

\item{No.of.readers}{A positive integer, indicating the number of \emph{readers} which is used in an \code{.xlsx} file.}

\item{No.of.confidence.levels}{A positive integer, indicating the number of \emph{confidence levels} which is used in an \code{.xlsx} file.}
}
\value{
A list, representing FROC data.
}
\description{
\strong{\emph{Convert an FROC dataset}}
\describe{
\item{ \strong{\emph{from}}    }{ \code{.xlsx} file of \strong{\emph{Jafroc}}  }
\item{ \strong{\emph{into}}    }{ \R object   }
}
}
\details{
Create a   dataset to  be passed into the
 function \code{ \link{fit_Bayesian_FROC}}.
Convert an Excel file whose extension
is \code{.xlsx} of Jafroc format to
  an \R object representing FROC data
   to which we will apply functions in
    this package such as  \code{\link{fit_Bayesian_FROC}()}.

Revised 2019 Jun 19
Revised 2019 Dec 13

The return values include a
 list which can be passed to the  function \code{fit_Bayesian_FROC}.
For data of Jafroc, running this function,
  we immediately can fit the author's Bayesian
  FROC model to this return value.

The Jafroc software's format consists of
 suspicious locations marked by readers and true locations.
Such data is \emph{redundant} for our
 Bayesian statistical models.
So, we reduce the information of data to the number of
false positives and number of hits for
 each confidence levels by this function.



Data can be calculated from the following
Jafroc data, in which there are more information than TP and FP.
In fact, in the Jafroc data, the FP and TP are counted for each images, each lesions etc.
So, it has more information.


  It causes limitation of our model.
So, our model start to fit a model to
the reduced data from Jafroc. So,
 the redunction will cause the non accuracy
  evaluation of the observer performance.
The future research I should start the
Jafroc formulation.
}
\examples{

\dontrun{
## Only run examples in interactive R sessions
if (interactive()) {
#========================================================================================
#                  Example for convert the Jafroc data to the BayesianFROC
#========================================================================================

# Work Flow of this example

# step 0) Prepare Jafroc .xlsx file contained in this package
# step 1) Convert the .xlxs file obtained in step 0)
# step 2) Fit a model to data object obtained in step 1)












#========================================================================================
#         step 0)      Make a Jafroc data as an example dataset
#========================================================================================

# If you can search the xlsx file named JAFROC_data.xlsx
# in the director "inst/extdata" of this package,
# Then this step 0) is redundant. The author prepare this example for the people who
# cannot search the xlsx file in the  "inst/extdata" of this package.




# By an xlsx file named JAFROC_data.xlsx in the director "inst/extdata" of this package,
# we can reconstruct it  as follows:(If someone can obtain the Excel file
# from the path BayesianFROC/inst/extdata/JAFROC_data.xlsx, then the following code
# is not required to run. If searching bother you, then run the R script to obtain the
# Excel file.)
# I do not know how to users refer the JAFROC_data.xlsx in this package,
# so I provide it by making the same xlsx file as the JAFROC_data.xlsx.


# Note that JAFROC_data.xlsx cannot remove,
# if it is removed, then devtools::run_examples() make an error.

Truth <- readxl::read_excel(system.file("extdata",
 "JAFROC_data.xlsx",
  package="BayesianFROC"),
   sheet = "Truth")
##### utils::View(Truth)

TP <- readxl::read_excel( system.file("extdata",
                                      "JAFROC_data.xlsx",
                                       package="BayesianFROC"),
                           sheet = "TP")
#### utils::View(TP)

FP <- readxl::read_excel( system.file("extdata",
                                      "JAFROC_data.xlsx",
                                        package="BayesianFROC"),
                          sheet = "FP")
#### utils::View(FP)





sample <- list(TP=TP,FP=FP,Truth=Truth)
openxlsx::write.xlsx(sample,"JafrocDatasetExample.xlsx")

 tcltk::tkmessageBox(
 message="A file named

   JafrocDatasetExample.xlsx


 is created in the working directory")


# Now, we obtain an excel file named "JafrocDatasetExample.xlsx", which is same as
# the JAFROC_data.xlsx.
# whose format is available in the Jafroc software developed by Chakraborty.
# If you use your data, your data must has same format of "JafrocDatasetExample.xlsx".
# Note that other excel data must comply with the above format.

# Note that if you have an excel file
# which is formulated correctolly  for our package,
# this process does not need.




#    (0) From the above, we obtain  "JafrocDatasetExample.xlsx"
#    which is the multiple reader and multiple modality dataset
#    for Jfroc analysis which is NOT implemented in our package,
#     but Chakraborty's software called Jafroc or the R package Rjafroc.




#========================================================================================
#         step 1)      Convert a Jafroc data
#========================================================================================

# (1) Using "JafrocDatasetExample.xlsx" as an example excel file,
# we run the function to convert the excel file from Jafroc format
# to our format:


     dataList <- convertFromJafroc(
                                  No.of.Modalities =5,
                                  No.of.readers    =4,
                                  No.of.confidence.levels = 5
                                   )



# In the variable, there is no xlsx file, since it is selected by interactive manner.
# So, please select the xlsx file obtained in step 0) or your own Jafroc
# .xlsx file.

#========================================================================================
#         step 2)     Fitting a model to data converted from Jafroc
#========================================================================================


#  (2)   Now, we obtain a list of an FROC dataset as an R object named "dataList".
#        Using this, we can fit a model to the dataset by the following code.



          fit  <-  fit_Bayesian_FROC(dataList )



}### Only run examples in interactive R sessions


           }

           # Revised 2019. Jun 19
           # Revised 2019. Dec 13
           # Revised 2020 Feb
           # Revised 2020 April

}
\references{
Bayesian Models for Free-response
Receiver Operating Characteristic Analysis,pre-print
}
\seealso{
Rjafroc, which is unfortunately not on CRAN, now  2019 Jun 19.
Or JAFROC software in the Chakarboty's Web page.
Unfortunately, this software is no longer supported.
}
