% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{metadata_to_fit_MRMC}
\alias{metadata_to_fit_MRMC}
\title{Create metadata for MRMC data}
\usage{
metadata_to_fit_MRMC(dataList, ModifiedPoisson = FALSE)
}
\arguments{
\item{dataList}{A list, consisting of the following \R objects:\code{m,q,c,h,f,NL,C,M,Q} each of which means from the right

\code{m } : A vector, indicating the modality ID = 1,2,... which does not include zero.

\code{q } : A vector, indicating the reader ID = 1,2,... which does not include zero.

\code{c }  : A vector, indicating the confidence = 1,2,... which does not include zero.

\code{h }  : A vector, indicating the number of hits

\code{f }  : A vector, indicating the number of false alarm

\code{NL }  : An positive integer, indicating the number of lesions for all images

\code{C } : An positive integer, indicating the highest number of confidence level

\code{M } : An positive integer, indicating the number of modalities

\code{Q } : An positive integer, indicating the number of readers.

The detail of these dataset, please see the example datasets, e.g. \code{\link{dd}}.}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}.

If \code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \strong{\emph{per lesion}},
and model is fitted
so that the FROC curve is an expected curve
 of points consisting of the pairs of TPF per lesion and FPF  \strong{\emph{per lesion}}.

Similarly,

If \code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \strong{\emph{per image}},
and model is fitted
so that the FROC curve is an expected curve
 of points consisting of the pair of TPF per lesion and FPF  \strong{\emph{per image}}.



To know details, see the author's paper in which I explained \emph{per image} and \emph{per lesion}.
(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  }, now, it is omiited from this package, because the size of vignettes are large.)

If \code{ModifiedPoisson = TRUE},
 then the \emph{False Positive Fraction (FPF)} is defined as follows
 (\eqn{F_c} denotes the number of false alarms with confidence level \eqn{c} )


\deqn{ \frac{F_1+F_2+F_3+F_4+F_5}{N_L}, }

\deqn{ \frac{F_2+F_3+F_4+F_5}{N_L}, }

 \deqn{ \frac{F_3+F_4+F_5}{N_L}, }

  \deqn{ \frac{F_4+F_5}{N_L}, }

   \deqn{ \frac{F_5}{N_L}, }

where \eqn{N_L} is a number of lesions (signal).
To emphasize its denominator  \eqn{N_L},
we also call it the \emph{False Positive Fraction (FPF)} \strong{per lesion}.


On the other hand,


if \code{ModifiedPoisson = FALSE} (Default), then
\emph{False Positive Fraction (FPF)} is given by

\deqn{ \frac{F_1+F_2+F_3+F_4+F_5}{N_I}, }

\deqn{ \frac{F_2+F_3+F_4+F_5}{N_I}, }

 \deqn{ \frac{F_3+F_4+F_5}{N_I}, }

  \deqn{ \frac{F_4+F_5}{N_I}, }

   \deqn{ \frac{F_5}{N_I}, }

where \eqn{N_I} is the number of images (trial).
To emphasize its denominator \eqn{N_I},
we also call it the \emph{False Positive Fraction (FPF)} \strong{per image}.


The model is fitted so that
the estimated FROC curve can be ragraded
 as the expected pairs of   FPF per image and TPF per lesion (\code{ModifiedPoisson = FALSE })

 or as the expected pairs of   FPF per image and TPF per lesion  (\code{ModifiedPoisson = TRUE})

If \code{ModifiedPoisson = TRUE}, then FROC curve means the expected pair of FPF \strong{per lesion} and TPF.

On the other hand, if  \code{ModifiedPoisson = FALSE}, then FROC curve means the expected pair of \strong{FPF per image} and TPF.




So,data of FPF and TPF are changed thus, a fitted model is also changed whether  \code{ModifiedPoisson = TRUE} or \code{FALSE}.
In traditional FROC analysis, it uses only per images (trial). Since we can divide one image into two images or more images, number of
trial is not important. And more important is per signal. So, the author also developed FROC theory to consider FROC analysis under per signal.
One can see that the FROC curve is rigid with respect to change of a number of images, so, it does not matter whether \code{ModifiedPoisson = TRUE} or \code{FALSE}.
This rigidity of curves means that the number of images is redundant parameter for the FROC trial and
thus the author try to exclude it.


Revised 2019 Dec 8
Revised 2019 Nov 25
Revised 2019 August 28}
}
\value{
A list, which includes arrays and vectors.
A metadata such as number of cumulative false alarms
and hits to create and draw the curve.

The
 \emph{False Positive Fraction (FPF)} and
  \emph{True Positive Fraction (TPF)} are also calculated.

\strong{ The components of list} \emph{ I rediscover it  at 2019 Jun 18, I am not sure it is useful? 2019 Dec 8}
\describe{
\item{ \code{ harray}     }{An array of hit, dimension \code{ [C,M,Q]}, where \code{C,M,Q} are a number of confidence level, modalities, readers, respectively.  }
\item{ \code{ farray}     }{An array of false alarms, dimension \code{ [C,M,Q]}, where \code{C,M,Q} are a number of confidence level, modalities, readers, respectively.  }
\item{ \code{ hharray}    }{An array of \strong{cumulative} hits, dimension \code{ [C,M,Q]}, where \code{C,M,Q} are a number of confidence level, modalities, readers, respectively.  }
\item{ \code{ ffarray}    }{An array of \strong{cumulative} false alarms, dimension \code{ [C,M,Q]}, where \code{C,M,Q} are a number of confidence level, modalities, readers, respectively.  }
\item{ \code{ hharrayN}   }{An array of TPF, dimension \code{ [C,M,Q]}, where \code{C,M,Q} are a number of confidence level, modalities, readers, respectively.  }
\item{ \code{ ffarrayN}   }{An array of FPF, dimension \code{ [C,M,Q]}, where \code{C,M,Q} are a number of confidence level, modalities, readers, respectively.  }
\item{ \code{ h}          }{An vector of hit, dimension \code{ [C*M*Q]}, where \code{C,M,Q} are a number of confidence level, modalities, readers, respectively.  }
\item{ \code{ f }         }{An vector of false alarms, dimension \code{ [C*M*Q]}, where \code{C,M,Q} are a number of confidence level, modalities, readers, respectively.  }
\item{ \code{ hh }        }{An vector of \strong{cumulative} hits, dimension \code{ [C*M*Q]}, where \code{C,M,Q} are a number of confidence level, modalities, readers, respectively.  }
\item{ \code{ ff }        }{An vector of \strong{cumulative} false alarms, dimension \code{ [C*M*Q]}, where \code{C,M,Q} are a number of confidence level, modalities, readers, respectively.  }
\item{ \code{ hhN}        }{An vector of TPF, dimension \code{ [C*M*Q]}, where \code{C,M,Q} are a number of confidence level, modalities, readers, respectively.  }
\item{ \code{ ffN}        }{An vector of FPF, dimension \code{ [C*M*Q]}, where \code{C,M,Q} are a number of confidence level, modalities, readers, respectively.  }
}


Revised Nov. 21
}
\description{
The so-called \emph{false positive fraction (FPF)}
and the       \emph{true  positive fraction (TPF)}
are calculated from the number of hits (True Positives: TPs)
and the number of false alarms (False Positives: FPs)
}
\details{
To fit a model to data,
we need a hit data and false data
formulated by both an array and a vector.

It also calculates the so-called
  False Positive Fractions (FPF)
(resp. True Positive Fractions (TPF) )
 which are cumulative sums of false alarms (resp.
  hits)  over number of lesions or images.

 From data of number of hits
  and false alarms,
   we calculate the number
    of cumulative false positives
    and hits per image or lesion, in other words,
    \emph{False Positive Fraction (FPF)}
    and  \emph{True Positive Fraction (TPF)}.
Since there are three subscripts,
\emph{reader}, \emph{modality},
 and \emph{image}, we can create array format
 or vector format etc...

\strong{Abbreviations}

\emph{FPF: false positive fraction }

\emph{TPF: true positive fraction }

\emph{hit : True Positive = TP}

\emph{false alarms: False Positive = FP}






 The traditionaly, the so-called FPF;\emph{False Positive Fraction} and TPT:\emph{True Positive Fraction} are used.
 Recall that our data format:




 \emph{            A single reader and a single modality case   }

------------------------------------------------------------------------------------------------------
\tabular{llll}{
\code{NI, NL }   \tab \strong{ confidence level } \tab \strong{ No. of false alarms} \tab \strong{No. of hits}  \cr
           \tab    \tab   (FP:False Positive)  \tab    (TP:True Positive) \cr
    -----------------------\tab ----------------------- \tab ----------------------------- \tab ------------- \cr
\emph{definitely} present  \tab   5 \tab  \eqn{F_5}   \tab   \eqn{H_5}  \cr
 \emph{probably} present   \tab   4 \tab  \eqn{F_4}  \tab   \eqn{H_4}   \cr
 equivocal                 \tab   3 \tab  \eqn{F_3}  \tab   \eqn{H_3}    \cr
 subtle                    \tab   2 \tab  \eqn{F_2}  \tab  \eqn{H_2}    \cr
 \emph{very} subtle        \tab   1 \tab  \eqn{F_1}  \tab \eqn{H_1}    \cr
 }

---------------------------------------------------------------------------------------------------

FPF is defined as follows;


\deqn{FPF(5):= \frac{F_5}{NI},}
\deqn{FPF(4):= \frac{F_4+F_5}{NI},}
\deqn{FPF(3):= \frac{F_3+F_4+F_5}{NI},}
\deqn{FPF(2):= \frac{F_2+F_3+F_4+F_5}{NI},}
\deqn{FPF(1):= \frac{F_1+F_2+F_3+F_4+F_5}{NI}.}


TPF is defined as follows;


\deqn{TPF(5):= \frac{H_5}{NL},}
\deqn{TPF(4):= \frac{H_4+H_5}{NL},}
\deqn{TPF(3):= \frac{H_3+H_4+H_5}{NL},}
\deqn{TPF(2):= \frac{H_2+H_3+H_4+H_5}{NL},}
\deqn{TPF(1):= \frac{H_1+H_2+H_3+H_4+H_5}{NL}.}
}
\examples{
\donttest{
#----------------------------------------------------------------------------------------
#                     First, we prepare the data endowed with this package.
#----------------------------------------------------------------------------------------



             dat  <- get(data("dataList.Chakra.Web"))


#----------------------------------------------------------------------------------------
#                           #Calculate FPFs and TPFs and etc.
#----------------------------------------------------------------------------------------



                             a <- metadata_to_fit_MRMC(dat)


#Now, we get  a meta-data object named "a".


#----------------------------------------------------------------------------------------
#                                 Check of Definiion
#----------------------------------------------------------------------------------------


                                 a$hh/dat$NL == a$hhN

# Since all of aboves are TRUE, the hhN is a TPF per NL.




#----------------------------------------------------------------------------------------
#                             Plot a FPFs and TPFs
#----------------------------------------------------------------------------------------
#'



                                 FPF = a$ffN
                                 TPF = a$hhN

                               dark_theme()
                               plot(FPF,TPF)

#----------------------------------------------------------------------------------------
#                             Plot a FPFs and TPFs via ggplot
#----------------------------------------------------------------------------------------

                       length(dat$f)==length(FPF)

            q  <- dat$q
            m  <- dat$m
            df <- data.frame(FPF,
                             TPF,
                             m,
                             q
                             )

 ggplot(df, aes(x =FPF, y = TPF, colour = q, group = m)) +geom_point()

# Revised 2019 Jun 18, Revised 2019 Sept 9













}# dottest

}
