

#' @title  Hit Rate data
#' @description For the default value of a variable of a function.
#' @details Hit Rate data of some MRMC data to use as a default value
#' of the function \code{ hits_creator_from_rate}.
#' This is an array obtained from estimates of some data contained in this package.
#' To simulate a replication of dataset, the default values should be used from an actual values.
#'  Thus the author prepare this data.

#' @name p_truth
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#' @seealso \code{hits_creator_from_rate}
#'
NULL


#' @title  Mean data of MRMC
#' @description For the default value of a variable of a function.
#' @details Mean Rate data of some MRMC data to use as a default value
#' of the function \code{ hits_creator_from_rate}.
#' This is an array obtained from estimates of some data contained in this package.
#' To simulate a replication of dataset, the default values should be used from an actual values.
#'  Thus the author prepare this data.

#' @name mu_truth
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#' @seealso \code{hits_creator_from_rate}
#'
NULL



#' @title  Standard Deviation data of MRMC
#' @description For the default value of a variable of a function.
#' @details Standard Deviation Rate data of some MRMC data to use as a default value
#' of the function \code{ hits_creator_from_rate}.
#' This is an array obtained from estimates of some data contained in this package.
#' To simulate a replication of dataset, the default values should be used from an actual values.
#'  Thus the author prepare this data.
#' @name v_truth
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#' @seealso \code{hits_creator_from_rate}
#'
NULL

#' @title  Threshold data of MRMC
#' @description For the default value of a variable of a function.
#' @details Threshold Rate data of some MRMC data to use as a default value
#' of the function \code{ hits_creator_from_rate}.
#' This is an array obtained from estimates of some data contained in this package.
#' To simulate a replication of dataset, the default values should be used from an actual values.
#'  Thus the author prepare this data.
#' @name z_truth
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#' @seealso \code{hits_creator_from_rate}
#'
NULL










#' @title  Single reader and Single modality data
#' @description This is used to build a non-hierarchical FROC model.
#' @details This data appeared in Chakraborty's paper (1988).
#'  This dataset is same as \code{dataList.Chakra.1}.
#'  The difference between two dataset is only explanations for vectors.
#'  That is I attached the name for each vector by \code{names()}.
#'  I hope it help user for understanding what it is.
#' @name dataList.Chakra.1.with.explantation
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#'
#' @references Maximum likelihood analysis of free-response receiver operating characteristic (FROC) data, Dev P. Chakraborty.
#'
#' @keywords Single reader and Single modality data. Non-hierarchical FROC data.
# devtools::document();help(dataList.Chakra.1)
NULL






#' @title  Single reader and Single modality data
#' @description This is used to build a non-hierarchical FROC model.
#' @details This data appeared in Chakraborty's paper (1988)
#' @name dataList.Chakra.1
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#'
#' @references Maximum likelihood analysis of free-response receiver operating characteristic (FROC) data, Dev P. Chakraborty.
#'
#' @keywords Single reader and Single modality data. Non-hierarchical FROC data.
# devtools::document();help(dataList.Chakra.1)
NULL

#' @title  Single reader and Single modality data
#' @description This is used to build a non-hierarchical FROC model.
#' @details This data appeared in Chakraborty's paper (1988)
#' @name dataList.Chakra.2
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#'
#' @references Maximum likelihood analysis of free-response  receiver operating characteristic (FROC) data, Dev P. Chakraborty.
#'
#' @keywords Single reader and Single modality data. Non-hierarchical FROC data.
# devtools::document();help(dataList.Chakra.1)
NULL

#' @title  Single reader and Single modality data
#' @description This is used to build a non-hierarchical FROC model.
#' @details This data appeared in Chakraborty's paper (1988)
#' @name dataList.Chakra.3
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#'
#' @references Maximum likelihood analysis of free-response  receiver operating characteristic (FROC) data, Dev P. Chakraborty.
#'
#' @keywords Single reader and Single modality data. Non-hierarchical FROC data.
# devtools::document();help(dataList.Chakra.1)
NULL

#' @title  Single reader and Single modality data
#' @description This is used to build a non-hierarchical FROC model.
#' @details This data appeared in Chakraborty's paper (1988)
#' @name dataList.Chakra.4
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#'
#' @references Maximum likelihood analysis of free-response  receiver operating characteristic (FROC) data, Dev P. Chakraborty.
#'
#' @keywords Single reader and Single modality data. Non-hierarchical FROC data.
# devtools::document();help(dataList.Chakra.1)
NULL






#' @title  Single reader and Single modality data
#' @description This is used to build a hierarchical FROC model. This data is same as dataList.Chakra.1.
#' @details This data appeared in Chakraborty's paper (1988)
#' @name data.SingleReaderSingleModality
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#'
#' @references Maximum likelihood analysis of free-response  receiver operating characteristic (FROC) data, Dev P. Chakraborty.
#'
#' @keywords Single reader and Single modality data. Non-hierarchical FROC data.
# devtools::document();help(dataList.Chakra.1)
NULL

#' @title  Single reader and Single modality data
#' @description This is used to build a hierarchical FROC model. This data is same as dataList.Chakra.1.
#' @details This data is fictitious.
#' @name dataList.high.ability
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#'
#' @references Maximum likelihood analysis of free-response  receiver operating characteristic (FROC) data, Dev P. Chakraborty.
#'
#' @keywords Single reader and Single modality data. Non-hierarchical FROC data.
# devtools::document();help(dataList.Chakra.1)
NULL



#' @title  Single reader and Single modality data
#' @description This is used to build a hierarchical FROC model. This data is same as dataList.Chakra.1.
#' @details This data is fictitious.
#' @name dataList.low.ability
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#'
#' @references Maximum likelihood analysis of free-response  receiver operating characteristic (FROC) data, Dev P. Chakraborty.
#'
#' @keywords Single reader and Single modality data. Non-hierarchical FROC data.
# devtools::document();help(dataList.Chakra.1)
NULL


#MRMC#########################################################################












#' @title Multiple reader and Multiple modality data
#' @description This is used to build a hierarchical FROC model.
#' @details This data appeared in Chakraborty's JAFROC.
#' @name dataList.Chakra.Web
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#'
#' @references Maximum likelihood analysis of free-response  receiver operating characteristic (FROC) data, Dev P. Chakraborty.
#'
#' @keywords Single reader and Single modality data. Non-hierarchical FROC data.
# devtools::document();help(dataList.Chakra.1)
NULL







#' @title Multiple reader and Multiple modality data
#' @description This is used to build a hierarchical FROC model.
#' @details This data appeared in Chakraborty's JAFROC. I have  ordered so that the modality ID means the  order of AUC. For example modality ID = 1 means its AUC is the highest. modalityID = 2 means its AUC is the second.
#' @name dataList.Chakra.Web.orderd
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#'
#' @references Maximum likelihood analysis of free-response  receiver operating characteristic (FROC) data, Dev P. Chakraborty.
#'
#' @keywords Single reader and Single modality data. Non-hierarchical FROC data.
# devtools::document();help(dataList.Chakra.1)
NULL









#' @title Multiple reader and Multiple modality data
#' @description This is used to build a hierarchical FROC model.
#' @details This data is fictitious.
#' @name  data.hier.ficitious
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#'
#' @references The author' preprint
#' @keywords Single reader and Single modality data. Non-hierarchical FROC data.
# devtools::document();help(dataList.Chakra.1)
NULL


#' @title Multiple reader and Multiple modality data
#' @description This is used to build a hierarchical FROC model. This data is same as dataList.Chakra.Web.
#' @details This data appeared in Chakraborty's paper (1988)
#' @name  data.MultiReaderMultiModality
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#'
#' @references Maximum likelihood analysis of free-response  receiver operating characteristic (FROC) data, Dev P. Chakraborty.
#'
#' @keywords Single reader and Single modality data. Hierarchical FROC data.
# devtools::document();help(dataList.Chakra.1)
NULL



#' @title Multiple reader and one modality data for fit_MRMC_versionTWO
#' @description This is used to build a hierarchical FROC model.
#' @details This data contains only one modality. If see = 12, then the model has converged.
#' @name  dataList.one.modality
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#'
#' @references  Nothing in 2018
#'
#' @keywords Multiple readers and Single modality data.
# devtools::document();help(dataList.Chakra.1)
NULL





#' @title  Single reader and Single modality data
#' @description This is used to build a hierarchical FROC model. This data is same as dataList.Chakra.1.
#' @details This data is fictitious.
#' @name dataList.High
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#'
#' @references Maximum likelihood analysis of free-response  receiver operating characteristic (FROC) data, Dev P. Chakraborty.
#'
#' @keywords Single reader and Single modality data. Non-hierarchical FROC data.
# devtools::document();help(dataList.Chakra.1)
NULL


#' @title  Single reader and Single modality data
#' @description This is used to build a hierarchical FROC model. This data is same as dataList.Chakra.1.
#' @details This data is fictitious.
#' @name dataList.Low
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#'
#' @references Maximum likelihood analysis of free-response  receiver operating characteristic (FROC) data, Dev P. Chakraborty.
#'
#' @keywords Single reader and Single modality data. Non-hierarchical FROC data.
# devtools::document();help(dataList.Chakra.1)
NULL

