% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SurvivalFromCumhaz.R
\name{SurvivalFromCumhaz}
\alias{SurvivalFromCumhaz}
\title{Transform posterior draws from the cumulative hazard into posterior
draws from the survival.}
\usage{
SurvivalFromCumhaz(cumhaz, time.max, surv.factor = 10, surv.epsilon = 1e-10)
}
\arguments{
\item{cumhaz}{A matrix containing posterior draws of the cumulative. Each row
contains one draw, the columns correspond to each interval. The values in each
draw are the values of the cumulative hazard at the end of the corresponding
interval.}

\item{time.max}{The maximum follow-up time to consider, corresponding to the
parameter \eqn{\tau} in Castillo and Van der Pas (2020).}

\item{surv.factor}{The survival function is computed on an equispaced grid
consisting of \code{K x surv.factor} (the number of intervals times this
factor).}

\item{surv.epsilon}{The survival function is computed on the interval [0,
\code{time.max} - \code{surv.epsilon}].}
}
\value{
\item{surv(eval.vec)}{A numeric vector containing the posterior mean of
the survival function, evaluated at \code{K x surv.factor} (where \code{K}
is the number of intervals used in the prior) equidistant time points on
the interval [0, \code{time.max} - \code{surv.epsilon}].}
}
\description{
Most users will not use this function directly, but will instead use the main
function \link{BayesSurv}, which calls this function. This function may be
used to create posterior draws of the survival function, based on posterior
draws of the cumulative hazard. It does so at a number of equispaced time
points on the interval [0, \code{time.max} - \code{surv.epsilon}], with the
number equal to the product of the number of intervals used in the prior, and
a user-defined factor.
}
\references{
Castillo and Van der Pas (2020). Multiscale Bayesian survival
  analysis. <arXiv:2005.02889>.
}
\seealso{
\link{BayesSurv}, which computes the posterior mean and the
radius of the credible band for the cumulative hazard function as
well as the survival, and the posterior mean for the hazard. These objects
can then be visualized by using \link{PlotBayesSurv}.
}
