% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNetwork.R
\name{plotNetwork}
\alias{plotNetwork}
\title{plot network representation of the associations between responses and predictors}
\usage{
plotNetwork(
  x,
  includeResponse = NULL,
  excludeResponse = NULL,
  includePredictor = NULL,
  excludePredictor = NULL,
  MatrixGamma = NULL,
  PmaxPredictor = 0.5,
  PmaxResponse = 0.5,
  nodesizePredictor = 2,
  nodesizeResponse = 15,
  no.isolates = FALSE,
  lineup = 1.2,
  gray.alpha = 0.6,
  edgewith.response = 5,
  edgewith.predictor = 2,
  edge.weight = FALSE,
  label.predictor = NULL,
  label.response = NULL,
  color.predictor = NULL,
  color.response = NULL,
  name.predictors = NULL,
  name.responses = NULL,
  vertex.frame.color = NA,
  layoutInCircle = FALSE,
  header = "",
  ...
)
}
\arguments{
\item{x}{an object of class \code{BayesSUR}}

\item{includeResponse}{A vector of the response names which are shown in the network}

\item{excludeResponse}{A vector of the response names which are not shown in the network}

\item{includePredictor}{A vector of the predictor names which are shown in the network}

\item{excludePredictor}{A vector of the predictor names which are not shown in the network}

\item{MatrixGamma}{A matrix or dataframe of the latent indicator variable. 
Default is \code{NULL} and to extrate it from object of class inheriting 
from an object of class \code{BayesSUR}}

\item{PmaxPredictor}{cutpoint for thresholding the estimated latent 
indicator variable. Default is 0.5}

\item{PmaxResponse}{cutpoint for thresholding the learning structure matrix 
of multiple response variables. Default is 0.5}

\item{nodesizePredictor}{node size of Predictors in the output graph. 
Default is 15}

\item{nodesizeResponse}{node size of response variables in the output graph. 
Default is 25}

\item{no.isolates}{remove isolated nodes from responses graph and full 
graph, may get problem if there are also isolated Predictors}

\item{lineup}{A ratio of the heights between responses' area and predictors'}

\item{gray.alpha}{the opacity. The default is 0.6}

\item{edgewith.response}{the edge width between response nodes}

\item{edgewith.predictor}{the edge width between the predictor and response node}

\item{edge.weight}{draw weighted edges after thresholding at 0.5. The 
default value \code{FALSE} is not to draw weighted edges}

\item{label.predictor}{A vector of the names of predictors}

\item{label.response}{A vector of the names of response variables}

\item{color.predictor}{color of the predictor nodes}

\item{color.response}{color of the response nodes}

\item{name.predictors}{A subtitle for the predictors}

\item{name.responses}{A subtitle for the responses}

\item{vertex.frame.color}{color of the frame of the vertices. If you don't 
want vertices to have a frame, supply NA as the color name}

\item{layoutInCircle}{place vertices on a circle, in the order of their 
vertex ids. The default is \code{FALSE}}

\item{header}{the main title}

\item{...}{other arguments}
}
\description{
Plot the network representation of the associations between responses and 
predictors, based on the estimated gamma matrix and graph of responses 
from a "BayesSUR" class object.
}
\examples{
data("exampleEQTL", package = "BayesSUR")
hyperpar <- list(a_w = 2, b_w = 5)

set.seed(9173)
fit <- BayesSUR(
  Y = exampleEQTL[["blockList"]][[1]],
  X = exampleEQTL[["blockList"]][[2]],
  data = exampleEQTL[["data"]], outFilePath = tempdir(),
  nIter = 100, burnin = 50, nChains = 2, gammaPrior = "hotspot",
  hyperpar = hyperpar, tmpFolder = "tmp/"
)

## check output
# draw network representation of the associations between responses and covariates
plotNetwork(fit)

}
