% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{getFunction}
\alias{getFunction}
\alias{get_model}
\alias{get_sampler}
\title{Get nimbleModel and nimbleSampler Object from the Result of \code{compileModelAndMCMC}}
\usage{
get_model(object)

get_sampler(object)
}
\arguments{
\item{object}{The result of \code{compileModelAndMCMC} function.}
}
\value{
\code{get_model} returns compiled Nimble model object.
\code{get_sampler} returns compiled Nimble sampler object, directly using in \code{runMCMC} function.
}
\description{
Return compiled nimble model object and a corresponding MCMC samplers.
}
\examples{
\donttest{
simdata2 <- data.frame(DATA1$X, y = DATA1$y)

# 1. One tool version
fit_one <- BayesSIM(y ~ ., data = simdata2,
                    niter = 5000, nburnin = 1000, nchain = 1)


# 2. Split version
models <- BayesSIM_setup(y ~ ., data = simdata2)
Ccompile <- compileModelAndMCMC(models)
nimSampler <- get_sampler(Ccompile)
initList <- getInit(models)
mcmc.out <- runMCMC(nimSampler, niter = 5000, nburnin = 1000, thin = 1,
                    nchains = 1, setSeed = TRUE, inits = initList,
                    summary = TRUE, samplesAsCodaMCMC = TRUE)

# "fit_split" becomes exactly the same as the class of "fit_one" object and apply generic functions.
fit_split <- as_bsim(models, mcmc.out)

}
}
\seealso{
\code{\link[nimble]{nimbleModel}},
\code{\link[nimble]{configureMCMC}},
\code{\link[nimble]{buildMCMC}},
\code{\link[nimble]{compileNimble}},
\code{\link[nimble]{runMCMC}}
}
