% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phm_fixed_a0.R
\name{phm.fixed.a0}
\alias{phm.fixed.a0}
\title{Model fitting for the proportional hazards model with piecewise constant hazard and fixed a0}
\usage{
phm.fixed.a0(
  time = NULL,
  event = NULL,
  X = NULL,
  S = NULL,
  historical,
  a0,
  n.intervals,
  change.points = NULL,
  shared.blh = FALSE,
  prior.beta = "Normal",
  prior.beta.mean = rep(0, 50),
  prior.beta.sd = rep(1000, 50),
  prior.lambda = "Gamma",
  prior.lambda.hp1 = rep(10^(-5), 50),
  prior.lambda.hp2 = rep(10^(-5), 50),
  prior.lambda0.hp1 = rep(10^(-5), 50),
  prior.lambda0.hp2 = rep(10^(-5), 50),
  lower.limits = NULL,
  upper.limits = rep(100, 50),
  slice.widths = rep(0.1, 50),
  current.data = TRUE,
  nMC = 10000,
  nBI = 250
)
}
\arguments{
\item{time}{Vector of follow up times.}

\item{event}{Vector of status indicators. Normally 0=alive and 1=dead.}

\item{X}{Matrix of covariates. The first column must be the treatment indicator.}

\item{S}{Vector of integers, where each integer represents the stratum that the subject belongs to. For example, if there are three strata, S can take values 1, 2 or 3.}

\item{historical}{List of historical dataset(s). East historical dataset is stored in a list which contains four \emph{named} elements: \code{time}, \code{event}, \code{X} and \code{S}.
\itemize{
\item \code{time} is a vector of follow up times.
\item \code{event} is a vector of status indicators. Normally 0=alive and 1=dead.
\item \code{X} is a matrix of covariates. The first column must be the treatment indicator.
\item \code{S} is a vector of integers, where each integer represents the stratum that the subject belongs to. For example, if there are three strata, S can take values 1, 2 or 3.
}}

\item{a0}{Vector containing numbers between 0 and 1 indicating the discounting parameter value for each historical dataset. The length of the vector should be equal to the length of \code{historical}.}

\item{n.intervals}{Vector of integers, indicating the number of intervals for the baseline hazards for each stratum. The length of the vector should be equal to the total number of strata.}

\item{change.points}{List of vectors. Each vector in the list contains the change points for the baseline hazards for each stratum. The length of the list should be equal to the total number of strata.
For a given stratum, if there is only one interval, then \code{change.points} should be \code{NULL} for that stratum.
By default, we assign the change points so that the same number of events are observed in all the intervals in the pooled current and historical data.}

\item{shared.blh}{Logical value indicating whether baseline hazard parameters are shared between the current and historical data. If TRUE, baseline hazard parameters are shared. The default value is FALSE.}

\item{prior.beta}{Prior used for \eqn{\beta}. The choices are "Uniform" and "Normal". If \code{prior.beta} is "Uniform", the uniform improper prior is used.
If \code{prior.beta} is "Normal", independent normal priors are used for each element of \eqn{\beta}. The default choice is "Normal".}

\item{prior.beta.mean}{(Only applies if \code{prior.beta} is "Normal") vector of means of the normal prior on \eqn{\beta}. The default value is zero for all the elements of \eqn{\beta}.}

\item{prior.beta.sd}{(Only applies if \code{prior.beta} is "Normal") vector of standard deviations of the normal prior on \eqn{\beta}. The default value is 10^3 for all the elements of \eqn{\beta}.}

\item{prior.lambda}{Prior used for \eqn{\lambda}. The choices are "Gamma", "Log-normal" and "Improper". The default choice is "Gamma".

If \code{prior.lambda} is "Gamma", then the prior on the first element of \eqn{\lambda} is

Gamma(shape=\code{prior.lambda.hp1[1]}, rate=\code{prior.lambda.hp2[1]}).

If \code{prior.lambda} is "Log-normal", then the prior on the first element of \eqn{\lambda} is Log-normal(mean=\code{prior.lambda.hp1[1]}, sd=\code{prior.lambda.hp2[1]}).

If \code{prior.lambda} is "Improper", then the prior on each element of \eqn{\lambda} is the improper prior \eqn{\lambda^{-1}}.}

\item{prior.lambda.hp1}{(Only applies if \code{prior.lambda} is "Gamma" or "Log-normal") Vector of first hyperparameters of the prior on \eqn{\lambda}.
The length of the vector should be equal to the dimension of \eqn{\lambda}, i.e., the total number of intervals for all strata. The default value is 10^(-5) for all the elements of \eqn{\lambda}.}

\item{prior.lambda.hp2}{(Only applies if \code{prior.lambda} is "Gamma" or "Log-normal") Vector of second hyperparameters of the prior on \eqn{\lambda}.
The length of the vector should be equal to the dimension of \eqn{\lambda}, i.e., the total number of intervals for all strata. The default value is 10^(-5) for all the elements of \eqn{\lambda}.}

\item{prior.lambda0.hp1}{(Only applies if \code{shared.blh} is FALSE and if \code{prior.lambda} is "Gamma" or "Log-normal") Vector of first hyperparameters of the prior on \eqn{\lambda_0}.
We assume the same distribution choice for the prior for \eqn{\lambda_0} and \eqn{\lambda}.
The length of the vector should be equal to the dimension of \eqn{\lambda_0}, i.e., the total number of intervals for all strata. The default value is 10^(-5) for all the elements of \eqn{\lambda_0}.}

\item{prior.lambda0.hp2}{(Only applies if \code{shared.blh} is FALSE and if \code{prior.lambda} is "Gamma" or "Log-normal") Vector of second hyperparameters of the prior on \eqn{\lambda_0}.
We assume the same distribution choice for the prior for \eqn{\lambda_0} and \eqn{\lambda}.
The length of the vector should be equal to the dimension of \eqn{\lambda_0}, i.e., the total number of intervals for all strata. The default value is 10^(-5) for all the elements of \eqn{\lambda_0}.}

\item{lower.limits}{Vector of lower limits for parameters (\eqn{\beta}, \eqn{\lambda}, and \eqn{\lambda_0}, in this order) to be used by the slice sampler. The length of the vector should be equal to the total number of parameters. The default is -100 for \eqn{\beta} and 0 for \eqn{\lambda} and \eqn{\lambda_0} (may not be appropriate for all situations).}

\item{upper.limits}{Vector of upper limits for parameters (\eqn{\beta}, \eqn{\lambda}, and \eqn{\lambda_0}, in this order) to be used by the slice sampler. The length of the vector should be equal to the total number of parameters. The default is 100 for all parameters (may not be appropriate for all situations).}

\item{slice.widths}{Vector of initial slice widths for parameters (\eqn{\beta}, \eqn{\lambda}, and \eqn{\lambda_0}, in this order) to be used by the slice sampler. The length of the vector should be equal to the total number of parameters. The default is 0.1 for all parameters (may not be appropriate for all situations).}

\item{current.data}{Logical value indicating whether current data is included. The default is TRUE. If FALSE, only historical data is included in the analysis,
and the posterior samples can be used as a discrete approximation to the sampling prior in
\code{\link{power.phm.fixed.a0}} and \code{\link{power.phm.random.a0}}.}

\item{nMC}{Number of iterations (excluding burn-in samples) for the slice sampler. The default is 10,000.}

\item{nBI}{Number of burn-in samples for the slice sampler. The default is 250.}
}
\value{
Posterior samples of \eqn{\beta}, \eqn{\lambda} and \eqn{\lambda_0} (if baseline hazards are not shared between the current and historical data) are returned.
}
\description{
Model fitting using power priors for the proportional hazards model with piecewise constant hazard and fixed \eqn{a_0}
}
\details{
The proportional hazards model with piecewise constant hazard is implemented.
We assume \eqn{\beta} is the regression coefficients. We assume the first column of the covariate matrix is the treatment indicator,
and the corresponding parameter is \eqn{\beta_1}. The baseline hazards of the current data are denoted by \eqn{\lambda}.
The baseline hazards of the historical data are denoted by \eqn{\lambda_0}.
If the baseline hazards are shared between the historical and current data, then \eqn{\lambda_0}=\eqn{\lambda}.

Posterior samples are obtained through slice sampling.
The default lower limits are -100 for \eqn{\beta} and 0 for \eqn{\lambda} and \eqn{\lambda_0}. The default upper limits
for the parameters are 100. The default slice widths for the parameters are 0.1.
The defaults may not be appropriate for all situations, and the user can specify the appropriate limits
and slice width for each parameter.
}
\examples{
set.seed(1)
# Simulate current data
n <- 50
P <- 4
time <- round(rexp(n, rate=0.5),1)
event <- rep(1,n)
X <- matrix(rbinom(n*P,prob=0.5,size=1), ncol=P)
S <- c(rep(1,n/2),rep(2,n/2))

# Simulate two historical datasets
n <- 100
time1 <- round(rexp(n, rate=0.5),1)
event1 <- rep(1,n)
X1 <- matrix(rbinom(n*P,prob=0.5,size=1), ncol=P)
S1 <- c(rep(1,n/2),rep(2,n/2))
time2 <- round(rexp(n, rate=0.7),1)
event2 <- rep(1,n)
X2 <- matrix(rbinom(n*P,prob=0.5,size=1), ncol=P)
S2 <- c(rep(1,n/2),rep(2,n/2))
historical <- list(list(time=time1, event=event1, X=X1, S=S1),
                   list(time=time2, event=event2, X=X2, S=S2))

# a0 is 0.3 for the first historical dataset and 0.6 for the second
a0 <- c(0.3, 0.6)


# We choose three intervals for the first stratum and two intervals for the second stratum
n.intervals <- c(3,2) 
change.points <- list(c(1,2), 2)


nMC <- 1000 # nMC should be larger in practice
nBI <- 50

result <- phm.fixed.a0(time=time, event=event, X=X, S=S,
                       historical=historical, a0=a0, n.intervals=n.intervals, 
                       change.points=change.points, nMC=nMC, nBI=nBI)

# posterior mean of beta
colMeans(result$beta_samples) 
# posterior mean of baseline hazards for stratum 1
colMeans(result$lambda_samples[[1]]) 
# posterior mean of baseline hazards for stratum 2
colMeans(result$lambda_samples[[2]]) 
# posterior mean of historical baseline hazards for stratum 1
colMeans(result$lambda0_samples[[1]]) 
# posterior mean of historical baseline hazards for stratum 2
colMeans(result$lambda0_samples[[2]]) 




}
\references{
Ibrahim, J. G., Chen, M.-H. and Sinha, D. (2001). Bayesian Survival Analysis. New York: Springer Science & Business Media.

Psioda, M. A. and Ibrahim, J. G. (2019). Bayesian clinical trial design using historical data that inform the treatment effect. Biostatistics 20, 400–415.

Shen, Y., Psioda, M. A., and Joseph, J. G. (2023). BayesPPD: an R package for Bayesian sample size determination using the power and normalized power prior for generalized linear models. The R Journal, 14(4).
}
\seealso{
\code{\link{power.phm.fixed.a0}}
}
