% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OC_func_NPO.R
\name{get_oc_NPO}
\alias{get_oc_NPO}
\title{Generate operating characteristics for Bayesian two-stage trial design
of ordinal endpoints without proportional odds assumption}
\usage{
get_oc_NPO(alpha, pro_ctr, U, fixed_ss, ors, nmax, fixed_es, ntrial, method)
}
\arguments{
\item{alpha}{the desired type I error to be controlled}

\item{pro_ctr}{distribution of clinical categories for the
control group}

\item{U}{the desirability of each outcome level}

\item{fixed_ss}{fixed sample size when simulates the OC for various effect
size}

\item{ors}{a user-defined matrix, each row denotes the various scenarios,
the number of columns depend on the number of outcome scales.}

\item{nmax}{the maximum sample size when simulates the OC for different sample size, the increment is 50 and
the initial sample size is 50 for each arm each stage.}

\item{fixed_es}{fixed effect size when simulate the OC for various sample
size}

\item{ntrial}{the number of simulated trials}

\item{method}{whether the statistical test for interim/final analysis is Bayesian or
Frequentist. method = "Frequentist" for Frequentist approach; method = "Bayesian"
for Bayesian approach}
}
\value{
get_oc_NPO() returns the operating characteristics of design as a
table, including (1) user-defined value, either sample size or effect size
(2) corresponding power (3) average sample size
}
\description{
Obtain operating characteristics (OC) of the Bayesian two-stage trial
design with ordinal endpoints while the proportional odds assumption are
violated.
}
\details{
Grid search of sample size is used for guarantee a desirable type I error rate.
  The upper limitation is 400, and lower limitation default is sample size 50
  for the control and treatment groups at each stage. Default increment of the
  sequence is 50.

  For the parameter estimation section, we have two options, and can be selected using
  the method argument.Two following options are available: (i) method = "Frequentist",
  (ii) method = "Bayesian". If method = "Frequentist", parameters are estimated via package
  ordinal, which is based on frequentist method, while method = "Bayesian", parameters are
  estimated through Bayesian model.

  Specifically, the numerical utilities U reflect the desirability of each outcome
  level. To do this, in our example, we first set U[1] = 100 and U[5] = 0, and then
  asked physicians to specify numerical values for the intermediate levels, that
  reflect their desirability relative to the best and worst levels.

  Function provides two types of operating characteristics via simulation. If user
  specifies the value of ors and fixed_ss, function will calculate the design's power
  in terms of effect size. If user specifies the value of nmax and fixed_es, function
  will calculate the design's power in terms of sample size, and nmax is the upper
  limitation of sample size for the treatment and control groups at each stage, the lower
  limitation is 50, the default increment of the sequence is 10.

  Please note, in our example, argument ntrial =  5 is for the time saving purpose.
}
\examples{

ors = matrix(c(1.5,1.5,1,1,1,1.5,1.5,1.1,1.1,1.1), nrow=2, ncol=5, byrow=TRUE)

get_oc_NPO(alpha = 0.05, pro_ctr = c(0.58,0.05,0.17,0.03,0.04,0.13),
           U = c(100,80,65,25,10,0), fixed_ss = 200, ors, ntrial = 5,
           method = "Frequentist")

set.seed(123)
get_oc_NPO(alpha = 0.05, pro_ctr = c(0.58,0.05,0.17,0.03,0.04,0.13),
           U = c(100,80,65,25,10,0), nmax = 100, fixed_es = c(1.5,1.3,1,1,1),
           ntrial = 5, method = "Frequentist")

}
