% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_smc_options.R
\name{set_smc_options}
\alias{set_smc_options}
\title{Set SMC compute options}
\usage{
set_smc_options(
  n_particles = 1000,
  mcmc_steps = 5,
  resampler = c("stratified", "systematic", "residual", "multinomial"),
  latent_sampling_lag = NA_integer_
)
}
\arguments{
\item{n_particles}{Integer specifying the number of particles.}

\item{mcmc_steps}{Number of MCMC steps to be applied in the resample-move
step.}

\item{resampler}{Character string defining the resampling method to use. One
of "stratified", "systematic", "residual", and "multinomial". Defaults to
"stratified". While multinomial resampling was used in
\insertCite{steinSequentialInferenceMallows2023;textual}{BayesMallows},
stratified, systematic, or residual resampling typically give lower Monte
Carlo error \insertCite{Douc2005,Hol2006,Naesseth2019}{BayesMallows}.}

\item{latent_sampling_lag}{Parameter specifying the number of timesteps to go
back when resampling the latent ranks in the move step. See Section 6.2.3
of \insertCite{Kantas2015}{BayesMallows} for details. The \eqn{L} in their
notation corresponds to \code{latent_sampling_lag}. See more under Details.
Defaults to \code{NA}, which means that all latent ranks from previous timesteps
are moved. If set to \code{0}, no move step is applied to the latent ranks.}
}
\value{
An object of class "SMCOptions".
}
\description{
Sets the SMC compute options to be used in
\code{\link[=update_mallows.BayesMallows]{update_mallows.BayesMallows()}}.
}
\section{Lag parameter in move step}{


The parameter \code{latent_sampling_lag} corresponds to \eqn{L} in
\insertCite{Kantas2015}{BayesMallows}. Its use in this package is can be
explained in terms of Algorithm 12 in
\insertCite{steinSequentialInferenceMallows2023}{BayesMallows}. The
relevant line of the algorithm is:

\strong{for} \eqn{j = 1 : M_{t}} \strong{do} \cr
\strong{M-H step:} update \eqn{\tilde{\mathbf{R}}_{j}^{(i)}} with proposal
\eqn{\tilde{\mathbf{R}}_{j}' \sim q(\tilde{\mathbf{R}}_{j}^{(i)} |
  \mathbf{R}_{j}, \boldsymbol{\rho}_{t}^{(i)}, \alpha_{t}^{(i)})}.\cr
\strong{end}

Let \eqn{L} denote the value of \code{latent_sampling_lag}. With this parameter,
we modify for algorithm so it becomes

\strong{for} \eqn{j = M_{t-L+1} : M_{t}} \strong{do} \cr
\strong{M-H step:} update \eqn{\tilde{\mathbf{R}}_{j}^{(i)}} with proposal
\eqn{\tilde{\mathbf{R}}_{j}' \sim q(\tilde{\mathbf{R}}_{j}^{(i)} |
  \mathbf{R}_{j}, \boldsymbol{\rho}_{t}^{(i)}, \alpha_{t}^{(i)})}.\cr
\strong{end}

This means that with \eqn{L=0} no move step is performed on any latent
ranks, whereas \eqn{L=1} means that the move step is only applied to the
parameters entering at the given timestep. The default,
\code{latent_sampling_lag = NA} means that \eqn{L=t} at each timestep, and hence
all latent ranks are part of the move step at each timestep.
}

\references{
\insertAllCited{}
}
\seealso{
Other preprocessing: 
\code{\link{get_transitive_closure}()},
\code{\link{set_compute_options}()},
\code{\link{set_initial_values}()},
\code{\link{set_model_options}()},
\code{\link{set_priors}()},
\code{\link{setup_rank_data}()}
}
\concept{preprocessing}
