% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_sample_probabilities}
\alias{get_sample_probabilities}
\title{Get Sample Probabilities}
\usage{
get_sample_probabilities(
  rho_item_rank,
  alpha,
  remaining_set_ranks,
  metric,
  n_items
)
}
\arguments{
\item{rho_item_rank}{An integer value rank of an item in the current consensus ranking}

\item{alpha}{Numeric value of the scale parameter}

\item{remaining_set_ranks}{A sequence of integer values of the set of possible ranks that we can assign the item}

\item{metric}{A character string specifying the distance metric to use in the
Bayesian Mallows Model. Available options are \code{"footrule"},
\code{"spearman"}, \code{"cayley"}, \code{"hamming"}, \code{"kendall"}, and
\code{"ulam"}.}

\item{n_items}{Integer is the number of items in the consensus ranking}
}
\value{
sample_prob_list A numeric sequence of sample probabilities for selecting a specific rank given the current
        rho_item_rank
}
\description{
Calculate probability of assigning a set of specific ranks to an specific item
given its rank in the consensus ranking
}
