\name{BPSevalHR}
\alias{BPSevalHR}
\title{Function to Evaluate BPS Hazard Rates}
\description{A function to evaluate a (prior or posterior) sample of first order autoregressive BPS hazard rates on a grid of time points.}
\usage{BPSevalHR(time, sample)}
\arguments{
  \item{time}{vector of time points where the hazard rates in the sample should be evaluated}
  \item{sample}{sample of BPS hazard rates (as generated by \code{\link{BPSpriorSample}} or \code{\link{BPSpostSample}})}
}
\value{A matrix with as many rows as hazard rates in the sample and as many columns as time points in the grid.}
\seealso{\code{\link{BPSplotHR}}}
\examples{
# set RNG seed (for example reproducibility only)
set.seed(1234)

# select a BPS prior distribution
hypars<-BPSpriorElicit(r0 = 0.1, H = 1, T00 = 50, ord = 4, G = 3, c = 0.9)
# generate a sample of ten hazard rates
prior<-BPSpriorSample(ss = 10, hyp = hypars)

# evaluate the ten hazard rates at year multiples
BPSevalHR(time = seq(0,50), sample = prior)
}
\keyword{survival}
