% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\docType{methods}
\name{growLin}
\alias{growLin}
\alias{growLin,Organism-method}
\title{Function for letting organisms grow linearly}
\usage{
growLin(object, growth)

\S4method{growLin}{Organism}(object, growth)
}
\arguments{
\item{object}{An object of class Organisms.}

\item{growth}{A number indicating the current biomass, which has to be updated.}
}
\value{
Returns the updated biomass of the organisms of interest.
}
\description{
The generic function \code{growLin} implements a growth model of organisms in their environment.
}
\details{
Linear growth of organisms is implemented by adding the calculated growthrate by \code{optimizeLP} to the already present growth value.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
org <- Organism(Ec_core,deathrate=0.05,
           growthlimit=0.05,growtype="exponential") #initialize a organism
growLin(org,1)
}
\seealso{
\code{\link{Organism-class}} and \code{\link{optimizeLP}}
}

