% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_generic.R
\name{modCond}
\alias{modCond}
\title{modCond class constructor}
\usage{
modCond(density = NULL, grideval = NULL, clust = NULL, mean = NULL,
  sigma2 = NULL, probs = NULL, niter = NULL, nburn = NULL,
  nnew = NULL, tot_time = NULL, univariate = TRUE, dep = FALSE,
  group_log = NULL, nclust = NULL, group = NULL, wvals = NULL)
}
\arguments{
\item{density}{a matrix containing the density value corresponding to the grid points}

\item{grideval}{a set of values to evaluate the density}

\item{clust}{a matrix containing the corresponding clusters for each observation, for each iteration}

\item{mean}{values for the location parameters}

\item{sigma2}{values for the scale parameters}

\item{probs}{values for the mixing measure}

\item{niter}{number of iterations}

\item{nburn}{number of burn-in iterations}

\item{nnew}{number of new clusters sampled at each iteration}

\item{tot_time}{execution time}

\item{univariate}{if the model is univariate (TRUE/FALSE)}

\item{dep}{if the model is dependent Dirichlet process (TRUE/FALSE)}

\item{group_log}{group allocation for dependent Dirichlet process}

\item{nclust}{number of cluster for dependent Dirichlet process}

\item{group}{true group allocation for dependent Dirichlet process}

\item{wvals}{values of the processes weights}
}
\description{
define the modCond class, could be for univariate or multivariate estimated models
}
\examples{
data_toy <- c(rnorm(100, -3, 1), rnorm(100, 3, 1))
grid <- seq(-7, 7, length.out = 50)
est_model <- condMCMC(data = data_toy, grid = grid, niter = 1000,
                      nburn = 100, napprox = 100, nupd = 100)
str(est_model)
class(est_model)

}
