% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMT.Psi.R
\name{BMT.Psi}
\alias{BMT.Psi}
\alias{dBMT.Psi}
\alias{pBMT.Psi}
\alias{qBMT.Psi}
\alias{rBMT.Psi}
\title{The BMT-Psi Distribution.}
\usage{
dBMT.Psi(x, mean = 0, sd = 1, log = FALSE)

pBMT.Psi(q, mean = 0, sd = 1, lower.tail = TRUE, log.p = FALSE)

qBMT.Psi(p, mean = 0, sd = 1, lower.tail = TRUE, log.p = FALSE)

rBMT.Psi(n, mean = 0, sd = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mean}{vector of means.}

\item{sd}{vector of standard deviations.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le 
x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the lenght is taken
to be the number required}
}
\value{
\code{dBMT.Psi} gives the density, \code{pBMT.Psi} the distribution 
  function, \code{qBMT.Psi} the quantile function, and \code{rBMT.Psi} 
  generates random deviates.
  
  The length of the result is determined by \code{n} for \code{rBMT.Psi}, and
  is the maximum of the lengths of the numerical arguments for the other 
  functions.
  
  The numerical arguments other than \code{n} are recycled to the length of 
  the result. Only the first elements of the logical arguments are used.
  
  \code{sd <= 0} is an error and returns \code{NaN}.
}
\description{
Density, distribution function, quantile function, random number
  generation for the BMT-Psi distribution with mean equal to \code{mean} and 
  standard deviation equal to \code{sd}.
}
\details{
If \code{mean} or \code{sd} are not specified they assume the 
  default values of 0 and 1, respectively.
  
  The BMT-Psi distribution is the BMT distribution with \eqn{\kappa_l = 
  \kappa_r = 0.63355781127887611515}. The BMT-Psi cumulative distribution 
  function (cdf) is the closest BMT cdf to the logistic cdf with scale =
  1 / d and d = 1.70174439 (Camilli, 1994, p. 295).
}
\examples{

layout(matrix(1:4, 2, 2))

curve(plogis(x, scale = 1 / 1.70174439), -4, 4, col = "red", lty = 2, ylab = "cdf")
curve(pBMT.Psi(x), add = TRUE, col = "blue", lty = 3)
legend("topleft", legend = c("logis(0, 1 / 1.70174439)","BMT-Psi(0,1)"), 
       bty = "n", col = c("red","blue"), lty = 2:3)

curve(plogis(x, scale = 1 / 1.70174439)-pBMT.Psi(x), -4, 4)

curve(qlogis(x, scale = 1 / 1.70174439), col = "red", lty = 2, xlab = "p", ylab = "qf")
curve(qBMT.Psi(x), add = TRUE, col = "blue", lty = 3)

hist(rBMT.Psi(10000), freq = FALSE, breaks = seq(-4, 4, 0.25), border = "blue")
curve(dlogis(x, scale = 1 / 1.70174439), add = TRUE, col = "red", lty = 2)
curve(dBMT.Psi(x), add = TRUE, col = "blue", lty = 3)
}
\references{
Torres-Jimenez, C. J. (2018), \emph{The BMT Item Response Theory 
  model: A new skewed distribution family with bounded domain and an IRT 
  model based on it}, PhD thesis, Doctorado en ciencias - Estadistica, 
  Universidad Nacional de Colombia, Sede Bogota.
  
  Camilli, G. (1994). Teacher's corner: origin of the scaling constant d= 1.7
  in item response theory. Journal of Educational Statistics, 19(3), 293-295.
}
\seealso{
\link{Distributions} for other standard distributions. 
  \code{\link{pBMT}} for the BMT distribution and \code{\link{pBMT.Phi}} for 
  the BMT-Phi distribution.
}
\author{
Camilo Jose Torres-Jimenez [aut,cre] \email{cjtorresj@unal.edu.co}
}
