\name{plot.bicreg}
\alias{plot.bicreg}
\alias{plot.bic.glm}
\alias{plot.bic.surv}
\alias{plot}
\title{ Plots the posterior distributions of coefficients derived from Bayesian model averaging}
\description{
  Displays plots of the posterior distributions of the coefficients generated by Bayesian model averaging over linear regression, generalized linear and survival analysis models.
}
\usage{
\method{plot}{bicreg}(x, e = 1e-04, mfrow = NULL, include = 1:x$n.vars, 
                      include.intercept = TRUE, ...)

\method{plot}{bic.glm}(x, e = 1e-04, mfrow = NULL, include = 1:length(x$namesx), ...)

\method{plot}{bic.surv}(x, e = 1e-04, mfrow = NULL, include = 1:length(x$namesx), ...)
}
\arguments{
  \item{x}{ object of type bicreg, bic.glm or bic.surv. }
  \item{e}{ optional numeric value specifying the range over which the distributions are to be graphed.  }
  \item{mfrow}{ optional vector specifying the layout for each set of graphs }
  \item{include}{ optional numerical vector specifying which variables to graph (excluding intercept)}
  \item{include.intercept}{ optional logical value, if true the posterior distribution of the intercept is incuded in the plots}
  \item{...}{other parameters to be passed to \code{plot} and \code{lines}}
}
\details{Produces a plot of the posterior distribuion of the coefficients produced by model averaging. 
The posterior probability that the coefficient is zero is represented by a solid line at zero, with height equal to the probability.
The nonzero part of the distribution is scaled so that the maximum height is equal to the probability that the coefficient is nonzero.

The parameter \code{e} specifies the range over which the distributions are to be graphed by specifying the tail probabilities that dictate the range to plot over. }
\references{Hoeting, J.A., Raftery, A.E. and Madigan, D. (1996). A method for simultaneous variable selection and outlier identification in linear regression. Computational Statistics and Data Analysis, 22, 251-270.
 }
\author{Ian Painter \email{ian.painter@AT@gmail.com}}
\examples{
library(MASS)
data(UScrime)
x<- UScrime[,-16]
y<- log(UScrime[,16])
x[,-2]<- log(x[,-2])
plot( bicreg(x, y)) 
}
\keyword{regression}
\keyword{models}
