% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLP_data.R
\name{BLP_data}
\alias{BLP_data}
\title{Prepares data and parameters related to the BLP algorithm for estimation.}
\usage{
BLP_data(model, market_identifier, product_identifier = NULL, par_delta,
  group_structure = NULL, productData, demographic_draws,
  integration_accuracy, integration_method, integration_draws,
  integration_weights, integration_seed, blp_inner_tol = 1e-09,
  blp_inner_maxit = 10000)
}
\arguments{
\item{model}{the model to be estimated in R's formula syntax,}

\item{market_identifier}{character specifying the market identifier (variable name must be included in \code{productData}),}

\item{product_identifier}{optional: character specifying the product identifier (variable name must be included in \code{productData}),}

\item{par_delta}{optional: numeric vector with starting guesses for the mean utility (variable name must be included in \code{productData}),}

\item{group_structure}{optional: character specifying a group structure for clustered standard erros (variable name must be included in \code{productData}),}

\item{productData}{data.frame with product characteristics ,}

\item{demographic_draws}{optional: list with demographic draws for each market to consider observed heterogeneity (see details),}

\item{integration_accuracy}{integer specifying integration accuracy,}

\item{integration_method}{character specifying integration method,}

\item{integration_draws}{numeric matrix of manually provided integration draws (see details),}

\item{integration_weights}{numeric vector of manually provided integration weights,}

\item{integration_seed}{seed for the draws of Monte Carlo based integration,}

\item{blp_inner_tol}{tolerance for the contraction mapping (default: 1e-9),}

\item{blp_inner_maxit}{maximum iterations for the contraction mapping (default: 10000)}
}
\value{
Returns an object of class \code{blp_data}.
}
\description{
Prepares data and parameters related to the BLP algorithm for estimation.
}
\details{
For any form of user provided integration draws, i.e. \code{integration_draws} (unobserved heterogeneity)
or \code{demographic_draws} (observed heterogeneity), list entries must be named and contain the variable \code{market_identifier} to allow market matching.
Each line in these list entries contains the draws for one market.
In case of unobserved heterogeneity, list names must match the random coefficients from the model formula.
}
\examples{
K<-2 #number of random coefficients
data <- get_BLP_dataset(nmkt = 25, nbrn = 20,
                        Xlin = c("price", "x1", "x2", "x3", "x4", "x5"),
                        Xexo = c("x1", "x2", "x3", "x4", "x5"),
                        Xrandom = paste0("x",1:K),instruments = paste0("iv",1:10),
                        true.parameters = list(Xlin.true.except.price = rep(0.2,5),
                                               Xlin.true.price = -0.2,
                                               Xrandom.true = rep(2,K),
                                               instrument.effects = rep(2,10),
                                               instrument.Xexo.effects = rep(1,5)),
                        price.endogeneity = list( mean.xi = -2,
                                                  mean.eita = 0,
                                                  cov = cbind( c(1,0.7), c(0.7,1))),
                        printlevel = 0, seed = 234234 )


model <- as.formula("shares ~  price + x1 + x2 + x3 + x4 + x5 |
                    x1 + x2 + x3 + x4 + x5 |
                    0+ x1 + x2 |
                    iv1 + iv2 + iv3 + iv4 + iv5 + iv6 + iv7 + iv8 +iv9 +iv10" )

blp_data <- BLP_data(model = model, market_identifier="cdid",
                     product_id = "prod_id",
                     productData = data,
                     integration_method = "MLHS" ,
                     integration_accuracy = 40,
                     integration_seed = 1)

}
