% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_occurrence_country}
\alias{BIEN_occurrence_country}
\title{Extract species occurrence records by country.}
\usage{
BIEN_occurrence_country(country, cultivated = FALSE, only.new.world = TRUE,
  all.taxonomy = FALSE, native.status = FALSE, observation.type = FALSE,
  political.boundaries = FALSE, ...)
}
\arguments{
\item{country}{A single country or a vector of country.}

\item{cultivated}{Return cultivated records as well?  Default is FALSE.}

\item{only.new.world}{Return only records from the New World?  Default is true}

\item{all.taxonomy}{Return all taxonomic information?  This includes the raw data as well as the "scrubbed" data.}

\item{native.status}{Return information on introduction status?  The default value is FALSE. A value of TRUE also returns additional information on introduction status.}

\item{observation.type}{Return information on type of observation (i.e. specimen vs. plot)?  The default value is FALSE.}

\item{political.boundaries}{Return information on political boundaries for an observation? The default value is FALSE.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Dataframe containing occurrence records for the specified country.
}
\description{
BIEN_occurrence_country extracts occurrences records for the specified country/countries.
}
\examples{
\dontrun{
library(RPostgreSQL)
BIEN_occurrence_country("Cuba")
country_vector<-c("Cuba","Bahamas")
BIEN_occurrence_country(country_vector)}
}
\seealso{
Other occurrence functions: \code{\link{BIEN_occurrence_box}},
  \code{\link{BIEN_occurrence_county}},
  \code{\link{BIEN_occurrence_family}},
  \code{\link{BIEN_occurrence_genus}},
  \code{\link{BIEN_occurrence_records_per_species}},
  \code{\link{BIEN_occurrence_shapefile}},
  \code{\link{BIEN_occurrence_species}},
  \code{\link{BIEN_occurrence_state}}
}
