% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_list_shapefile}
\alias{BIEN_list_shapefile}
\title{Extract a list of species within a given shapefile.}
\usage{
BIEN_list_shapefile(shapefile, cultivated = FALSE, only.new.world = TRUE,
  print.query = FALSE, ...)
}
\arguments{
\item{shapefile}{An object of class SpatialPolygonsDataFrame.  Note that the polygon must be in WGS84.}

\item{cultivated}{Return cultivated records as well?  Default is FALSE.}

\item{only.new.world}{Return only records from the New World?  Default is true}

\item{print.query}{Should the PostgreSQL query be printed? The default value is FALSE.}

\item{...}{Additional arguments passed to BIEN_sql}
}
\value{
Dataframe containing a list of all species with occurrences in the supplied shapefile.
}
\description{
BIEN_list_shapefile produces a list of all species with occurrence record falling within a user-supplied GIS shapefile.
}
\note{
We recommend using the function readOGR() in the rgdal package to read in shapefiles.  Other methods may cause problems related to handling holes in polygons.
}
\examples{
\dontrun{
BIEN_ranges_species("Carnegiea gigantea")#saves ranges to the current working directory
shape<-readOGR(dsn = ".",layer = "Carnegiea_gigantea")
#shapefiles should be read with readOGR(), see note.
species_list<-BIEN_list_shapefile(shapefile=shape)}
}
\seealso{
Other list functions: \code{\link{BIEN_list_all}},
  \code{\link{BIEN_list_country}},
  \code{\link{BIEN_list_county}},
  \code{\link{BIEN_list_state}}
}

