% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgvar_main.R
\name{residuals.bgvar}
\alias{residuals.bgvar}
\alias{residuals}
\alias{resid.bgvar}
\title{Extract residuals of Global Vector Autoregression}
\usage{
\method{residuals}{bgvar}(object, ...)

\method{resid}{bgvar}(object, ...)
}
\arguments{
\item{object}{a fitted \code{bgvar} object.}

\item{...}{other arguments.}
}
\value{
returns a list with the following arguments \itemize{
\item{\code{global}}{ is a (T-p) times K times saves/thin array containing the residuals of the global model.}
\item{\code{country}}{ is a (T-p) times K times saves/thin array containing the residuals of the country models.}
\item{\code{Data}}{ is a (T-p) times K matrix containing the data of the model.}
}
}
\description{
Calculate residuals of the global model and the country models.
}
\details{
This function calculates residuals of the global and the country models based on a \code{bgvar} object. Country models' residuals are equivalent to output generated by the \code{print.bgvar} function in case no trimming has been used. If trimming was invoked to discard unstable draws output of both functions might differ since \code{print.bgvar} calculates residuals as a running mean to save storage which is based on the \emph{whole} set of posterior draws (including discarded draws). In this case it is recommended to recalculate the residuals with \code{residuals.bgvar} and re-do the serial autocorrelation or average pairwise cross-correlation analysis using functions \code{resid.corr.test} and \code{avg.pair.cc}.
}
\examples{
\donttest{
library(BGVAR)
data(eerData)
model.ssvs <- bgvar(Data=eerData,W=W.trade0012,plag=1,saves=100,burns=100,
                    prior="SSVS")
res <- residuals(model.ssvs)
}
\donttest{
resid(model.ssvs)
}
}
\seealso{
\code{\link{bgvar}} for estimation of a \code{bgvar} object.
}
\author{
Maximilian Boeck, Martin Feldkircher
}
