% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irf_main.R
\name{plot.bgvar.irf}
\alias{plot.bgvar.irf}
\title{Plot predictions of bgvar}
\usage{
\method{plot}{bgvar.irf}(x, ..., resp, shock.nr = 1, cumulative = FALSE)
}
\arguments{
\item{x}{an object of class \code{bgvar.irf}.}

\item{...}{additional arguments.}

\item{resp}{specify a variable to plot predictions.}

\item{shock.nr}{specify shock to be plotted.}

\item{cumulative}{whether cumulative impulse response functions should be plotted. Default is set to \code{FALSE}.}
}
\value{
No return value.
}
\description{
Plots the predictions of an object of class \code{bgvar.predict}.
}
\examples{
\donttest{
library(BGVAR)
data(eerData)
model.ssvs.eer<-bgvar(Data=eerData,W=W.trade0012,saves=100,burns=100,plag=1,prior="SSVS",
                      eigen=TRUE)
# US monetary policy shock
shocks<-list();shocks$var="stir";shocks$cN<-"US";shocks$ident="chol";shocks$scal=-100
irf.chol.us.mp<-IRF(obj=model.ssvs.eer,shock=shocks,nhor=24)
# plots an impulse response function
plot(irf.chol.us.mp,resp="US.y")
}
}
\seealso{
\code{\link{IRF}}
}
\author{
Maximilian Boeck, Martin Feldkircher
}
