% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confirm.R
\name{confirm}
\alias{confirm}
\title{Confirmatory Hypothesis Testing}
\usage{
confirm(Y, hypothesis, prior_sd = 0.25, iter = 25000, cores = 2)
}
\arguments{
\item{Y}{data matrix  (\emph{n} by  \emph{p}).}

\item{hypothesis}{hypothesis (or hypotheses) to be tested}

\item{prior_sd}{hypothesized standard deviation of the prior distribution}

\item{iter}{posterior and prior samples. 25,000 is the default, as it results in a more stable Bayes factor than using, say, 5,000.}

\item{cores}{number of cores for parallel computing. The default is 2, but this can be adjusted}
}
\value{
list of class \code{confirm}:

\itemize{
\item \code{BF_matrix} matrix of Bayes factors for each hypothesis. Also includes the compliment
\item \code{post_prob} posterior hypothesis probabilities
\item \code{hypotheses} \code{hypothesis}
\item \code{call} match.call()
\item \code{p} number of variables
\item \code{n} number of observations
\item \code{iter} number of posterior samples
\item \code{delta} hyperparameter of matrix-F prior distribution (corresponds to prior_sd)
\item \code{parcors_mat} partial correlation matrix
\item \code{returned_mats} contrast matrices
}
}
\description{
Traditionally, Gaussian graphical models are inherently exploratory. That is, automated model selection is performed. A key aspect of \strong{BGGM} is the ability to extend inference beyond exploratory and to
confirmatory hypothesis testing. This is accomplished by testing equality and/or inequality constraints for sets of edges (partial correlations).
}
\note{
Currently inequality and equality restrictions can be tested. The former is an ordering the respective edge sizes,
whereas the latter allows for testing whether certain edges are exactly the same.

see \code{methods(class = "confirm")}
}
\examples{
\donttest{

# p = 10
Y <- BGGM::bfi[,1:10]

# hypothesis
hypothesis <- c("1--2 > 1--3 > 1--4 > 1--5")

# test inequality contraint
test_order <-  confirm(Y = Y, hypothesis  = hypothesis,
                      prior_sd = 0.5, iter = 50000,
                      cores = 2)
# summary
summary(test_order)


# test hypothesized directions

# hypothesis
hypothesis <- c("(1--2, 1--3, 1--4)  <  0 < (1--6)")

# test directions
test_directions <-  confirm(Y = Y, hypothesis  = hypothesis,
                      prior_sd = 0.5, iter = 50000,
                      cores = 2)
# summary
summary(test_directions)
}
}
