% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictability.R
\name{bayes_R2}
\alias{bayes_R2}
\title{Bayesian Variance Explained (R2)}
\usage{
bayes_R2(object, cred = 0.95, iter = 1000, cores = 2, ...)
}
\arguments{
\item{object}{object of class \code{estimate}}

\item{cred}{credible interval width used for selecting the network}

\item{iter}{iterations used for computing R2}

\item{cores}{number of cores for parallel computing}

\item{...}{currently ignored}
}
\value{
object of classes \code{bayes_R2} and \code{metric}
}
\description{
Compute Bayesian R2. In contrast to the functions
\code{\link{mse}}, \code{\link{mae}}, etc., this can be used to
compare predictabiltiy between nodes within a network or between
networks. Also, only posterior predictive R2 is implemented.
}
\examples{
\donttest{
# data
Y <- subset(tas, gender == "M")[,-ncol(tas)]

# fit model
fit <- estimate(Y)

# bayes R2
r2 <- bayes_R2(fit, iter = 50)

# print summary
r2

# plot
plot(r2)
}
}
