% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBeIdSymbolTable.R
\name{getBeIdSymbolTable}
\alias{getBeIdSymbolTable}
\title{Get a table of biological entity (BE) identifiers and symbols}
\usage{
getBeIdSymbolTable(
  be,
  source,
  organism,
  restricted,
  entity = TRUE,
  verbose = FALSE,
  recache = FALSE,
  filter = NULL
)
}
\arguments{
\item{be}{one BE}

\item{source}{the BE ID database}

\item{organism}{organism name}

\item{restricted}{boolean indicating if the results should be restricted to
direct symbols}

\item{entity}{boolean indicating if the technical ID of BE should be
returned}

\item{verbose}{boolean indicating if the CQL query should be displayed}

\item{recache}{boolean indicating if the CQL query should be run even if
the table is already in cache}

\item{filter}{character vector on which to filter id. If NULL (default),
the result is not filtered: all IDs are taken into account.}
}
\value{
a data.frame with the
following fields:
\itemize{
\item \strong{id}: the from BE ID
\item \strong{symbol}: the BE symbol
\item \strong{canonical}: true if the symbol is canonical for the direct BE ID
\item \strong{direct}: false if the symbol is not directly associated to the BE ID
\item \strong{entity}: (optional) the technical ID of to BE
}
}
\description{
Get a table of biological entity (BE) identifiers and symbols
}
\examples{
\dontrun{
getBeIdSymbolTable(
   be="Gene",
   source="EntrezGene",
   organism="human"
)
}

}
\seealso{
\link{getBeIdSymbols}, \link{getBeIdNameTable}
}
