% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLEbinomBCD.R
\name{MLEbinomBCD}
\alias{MLEbinomBCD}
\title{Maximum Likelihood Estimation for a Bivariate Binomial Distribution via Conditional Specification}
\usage{
MLEbinomBCD(data, fixed_n1 = NULL, fixed_n2 = NULL, verbose = TRUE)
}
\arguments{
\item{data}{A data frame or matrix with columns `X` and `Y`}

\item{fixed_n1}{known value of `n1` (NULL to estimate)}

\item{fixed_n2}{known value of `n2` (NULL to estimate)}

\item{verbose}{logical; print progress}
}
\value{
A list of class \code{"MLEpoisBCD"} containing:
\describe{
  \item{\code{n1}}{estimated n1}
  \item{\code{n2}}{estimated n2}
  \item{\code{p1}}{estimated p1}
  \item{\code{p2}}{estimated p2}
  \item{\code{lambda}}{estimated lambda}
  \item{\code{logLik}}{Maximum log-likelihood achieved.}
  \item{\code{AIC}}{Akaike Information Criterion.}
  \item{\code{BIC}}{Bayesian Information Criterion.}
  \item{\code{convergence}}{Convergence status from the optimizer (0 means successful).}
}
}
\description{
Estimates the parameters of a Bivariate Binomial Conditionals via Conditional Specification using maximum likelihood.
}
\examples{
data <- rbinomBCD(n = 10,n1 = 5, n2 = 3, p1 = 0.6, p2 = 0.4, lambda = 1.2)
MLEbinomBCD(data)
MLEbinomBCD(data, fixed_n1 = 5, fixed_n2 = 3)

}
