\name{greatcopper}
\docType{data}
\alias{greatcopper}
\title{Great-Copper butterfly data}
\description{Great Copper butterflies in Willamette Valley of Oregon. Once presumed to be extinct from western Oregon since 1970 (R. A. Pyle, 2002, Butterflies of Cascadia, Seattle Audubon Society), the great copper (Lycaena xanthoides Lycaenidae), was rediscovered in several wetland prairie remnants in the summer of 2004 (see Severns and Villegas 2005 for an account). Until this rediscovery, the habitat and host plants were unknown for western Oregon populations, and the great copper was conspicuously sparse in collections, with a total of twelve specimens captured between 1896 and 1970.  A current estimate of the extant populations is alarmingly low, about 100 individuals across three subpopulations in the Willamette Valley. The great copper occurs in much larger numbers through much of California. \url{http://people.oregonstate.edu/~wilsomar/Persp_GrtCop.htm}

This dataset has been first analyzed in Ramsey F, Severns P (2010) and later re-analyzed in Farcomeni (2011) and Alunni Fegatelli and Tardella (2012)} 

\usage{greatcopper}
\format{A matrix with 45 rows (observed butterflies) and 8 columns (capture occasions)}

%\author{Danilo Alunni Fegatelli Maintainer: \email{danilo.alunnifegatelli@uniroma1.it}}
\references{

Severns, P.M. and Villegas, S. (2005) Butterflies Hanging on to Existence in the Willamette Valley: A Relict Population of the Great Copper (Lycaena xanthoides Boisduval), Northwest Science, Vol. 79, No. 1, 77--80.

Severns, P.M. and Villegas, S. (2006) Conserving a wetland butterfly: quantifying early lifestage survival through seasonal flooding, adult nectar, and habitat preference, Journal of Insect Conservation 10 (4), 361-370

Ramsey F, Severns P (2010) Persistence models for mark-recapture. Environmental and Ecological Statistics 17(1):97--109

Farcomeni A. (2011) Recapture models under equality constraints for the conditional capture probabilities. Biometrika 98(1):237--242

Alunni Fegatelli, D. and Tardella, L. (2012) Improved inference on capture recapture models with behavioural effects. Statistical Methods & Applications Volume 22, Issue 1, pp 45-66 10.1007/s10260-012-0221-4
}

\examples{
data(greatcopper)
}
\keyword{Datasets}
