% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_stats_teams.R
\name{do_stats_teams}
\alias{do_stats_teams}
\title{Accumulated and average statistics for teams}
\usage{
do_stats_teams(df_games, season, competition, type_season)
}
\arguments{
\item{df_games}{Data frame with the games, players info, advanced stats and
eventually recoded teams names.}

\item{season}{String indicating the season, for example, 2017-2018.}

\item{competition}{String. Options are "ACB", "Euroleague" and "Eurocup".}

\item{type_season}{String with the round of competition, for example regular season
or playoffs and so on.}
}
\value{
A list with two elements:
\itemize{
\item df_team_total: Data frame with the total statistics for every team.
\item df_team_mean: Data frame with the average statistics for every team.
}
}
\description{
This function computes the total and average statistics for every team.
}
\examples{
compet <- "ACB"
df <- do_join_games_bio(compet, acb_games_1718, acb_players_1718)
df$Compet <- compet
df_teams <- do_stats_teams(df, "2017-2018", "ACB", "Regular Season")
# Total statistics:
#df_teams$df_team_total
# Average statistics:
#df_teams$df_team_mean

}
\author{
Guillermo Vinue
}
