% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{kernel.originality}
\alias{kernel.originality}
\title{Functional originality of observations in kernel density hypervolumes.}
\usage{
kernel.originality(comm, frac = 0.1, relative = FALSE)
}
\arguments{
\item{comm}{A 'Hypervolume' or 'HypervolumesList' object, preferably built using function kernel.build.}

\item{frac}{A value between 0.01 and 1, indicating the fraction of random points to be used in the estimation of originality. Default is 0.1.}

\item{relative}{A boolean (T/F) indicating whether originality should be relative to the most original species in the community.}
}
\value{
A vector or matrix with the originality values of each species or individual in each site.
}
\description{
Average dissimilarity between a species or individual and a sample of random points within the boundaries of the n-dimensional hypervolume.
}
\details{
A measure of the originality (sensu Pavoine et al., 2005) of each observation (species or individuals) used to construct the n-dimensional hypervolume. In a probabilistic hypervolume, originality is calculated as the average distance between each observation to a sample of stochastic points within the boundaries of the n-dimensional hypervolume (Mammola & Cardoso, 2020).
Originality is a measure of functional rarity (sensu Violle et al., 2017; Carmona et al., 2017) that allows to map the contribution of each observation to the divergence components of FD (Mammola & Cardoso, 2020).
The number of sample points to be used in the estimation of the originality is controlled by the frac parameter. Increase frac for less deviation in the estimation, but mind that computation time also increases.
}
\examples{
\dontrun{
comm = rbind(c(1,3,0,5,3), c(3,2,5,1,0))
colnames(comm) = c("SpA", "SpB", "SpC", "SpD", "SpE")
rownames(comm) = c("Site 1", "Site 2")

trait = data.frame(body = c(1,2,3,4,4), beak = c(1,5,4,1,2))
rownames(trait) = colnames(comm)

hv = kernel.build(comm[1,], trait)
kernel.originality(hv)
hvlist = kernel.build(comm, trait)
kernel.originality(hvlist)
kernel.originality(hvlist, relative = TRUE)
}
}
\references{
Carmona, C.P., de Bello, F., Sasaki, T., Uchida, K. & Partel, M. (2017) Towards a common toolbox for rarity: A response to Violle et al. Trends in Ecology and Evolution, 32: 889-891.

Mammola, S. & Cardoso, P. (2020) Functional diversity metrics using kernel density n-dimensional hypervolumes. Methods in Ecology and Evolution, 11: 986-995.

Pavoine, S., Ollier, S. & Dufour, A.-B. (2005) Is the originality of a species measurable? Ecology Letters, 8: 579-586.

Violle, C., Thuiller, W., Mouquet, N., Munoz, F., Kraft, N.J.B., Cadotte, M.W., ... & Mouillot, D. (2017) Functional rarity: the ecology of outliers. Trends in Ecology and Evolution, 32: 356-367.
}
