% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{hyper.build}
\alias{hyper.build}
\title{Build hyperspace.}
\usage{
hyper.build(distance, ord = "pcoa", axes = 1, stats = FALSE)
}
\arguments{
\item{distance}{A dist object representing the distances between species.}

\item{ord}{Method used to reduce the dimensionality of variables using either of the ordination methods "pcoa" or "nmds".}

\item{axes}{If 0 < axes <= 1 a PCoA is done and as many axes as needed to achieve this proportion of variance explained are selected.
If axes > 1 these many axes are selected for either PCoA or NMDS.}

\item{stats}{If TRUE and ord = TRUE, stats for each dimension are returned.}
}
\value{
Either a matrix with the coordinates of each species in hyperspace or a list containing this matrix plus the stats for each dimension.
}
\description{
Builds hyperspace using distance data for hull.build or kernel.build.
}
\details{
Note that each community should have at least 3 species and more species than traits or axes (if axes > 0) to build convex hull hypervolumes.
Transformation of traits is recommended if (Carvalho & Cardoso, 2020):
\enumerate{
\item Some traits are not continuous;
\item Some traits are correlated; or
\item There are less species than traits + 1, in which case the number of axes should be smaller.
}
}
\examples{
trait = data.frame(body = c(1,2,3,4,4), beak = c(1,5,4,1,2))
rownames(trait) = c("SpA", "SpB", "SpC", "SpD", "SpE")
distance = gower(trait)

hs = hyper.build(distance, axes = 0.8, stats = TRUE)
plot(hs$trait)
hs$stats
hs = hyper.build(distance, ord = "nmds", axes = 2, stats = TRUE)
plot(hs$trait)
hs$stats
}
\references{
Carvalho, J.C. & Cardoso, P. (2020) Decomposing the causes for niche differentiation between species using hypervolumes. Frontiers in Ecology and Evolution, 8: 243.
}
