% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_priors.R
\name{TG}
\alias{TG}
\title{Generalized g-Prior Distribution for Coefficients in BMA Models}
\usage{
TG(alpha = 2)
}
\arguments{
\item{alpha}{a scalar > 0, recommended alpha=.5 (betaprime) or 1.  alpha=2
corresponds to the uniform prior on the shrinkage factor.}
}
\value{
returns an object of class "prior", with the family and
hyerparameters.
}
\description{
Creates an object representing the Truncated Gamma (tCCH) mixture of
g-priors on coefficients for BAS, where u = 1/(1+g) has a Gamma distribution
supported on (0, 1].
}
\details{
Creates a structure used for \code{\link{bas.glm}}.
}
\examples{

TG(alpha = 2)
CCH(alpha = 2, beta = 100, s = 0)
}
\seealso{
\code{\link{CCH}} \code{\link{bas.glm}}

Other beta priors: 
\code{\link{CCH}()},
\code{\link{EB.local}()},
\code{\link{IC.prior}()},
\code{\link{Jeffreys}()},
\code{\link{beta.prime}()},
\code{\link{g.prior}()},
\code{\link{hyper.g.n}()},
\code{\link{hyper.g}()},
\code{\link{intrinsic}()},
\code{\link{robust}()},
\code{\link{tCCH}()},
\code{\link{testBF.prior}()}
}
\author{
Merlise Clyde
}
\concept{beta priors}
