\name{toys}
\alias{D1.toy}
\alias{D2.toy}
\alias{d.toy}
\alias{phi.toy}
\alias{theta.toy}
\alias{t.vec.toy}
\alias{toys}
\alias{x.toy}
\alias{x.toy2}
\alias{x.vec}
\alias{y.toy}
\alias{z.toy}
\alias{V.toy}
\alias{X.dist.toy}
\docType{data}
\title{Toy datasets}
\description{
  Toy datasets that illustrate the package.
}
\usage{
  data(toys)
  D1.toy
  D2.toy
  d.toy
  phi.toy
  theta.toy
  V.toy
  X.dist.toy
}
\format{
  The \code{D1.toy} matrix is 8 rows of code run points, with five
  columns.  The first two columns are the lat and long and the next
  three are parameter values.

  The \code{D2.toy} matrix is five rows of observations on two
  variables, \code{x} and \code{y} which are styled
  ``latitude and longitude''.

  \code{d.toy} is the \dQuote{data} vector consisting of length 13: elements
  1-8 are code runs and elements 9-13 are observations.
  
  \code{theta.toy} is a vector of length three that is a working example
  of \eqn{\theta}{theta}.  The parameters are designed to work with
  \code{computer.model()}.

  \code{t.vec.toy} is a matrix of eight rows and three columns.  Each
  row specifies a value for \eqn{\theta}{theta}.  The eight rows
  correspond to  eight code runs.

  \code{x.toy} and \code{x.toy2} are vectors of length two that gives a
  sample point at which observations may be made (or the code run).
  The gloss of the two elements is latitude and longitude.

  \code{x.vec} is a matrix whose rows are reasonable x values but
  \emph{not} those in \code{D2.toy}.
  
  \code{y.toy} is a vector of length eight.  Each element corresponds to
  the output from a code run at each of the rows of \code{D1.toy}.
  
  \code{z.toy} is a vector of length five.  Each element corresponds to
  a measurement at each of the rows of \code{D2.toy}.

  \code{V.toy} is a five by five variance-covariance matrix for the toy
  datasets.

  \code{X.dist.toy} is a toy example of a distribution of \code{X} for
  use in calibrated uncertainty analysis, section 4.2.
  
  \strong{Brief description of functions fully documented under their own manpage}
  
  \code{create.new.toy.datasets()} is a function to create new toy
  datasets with any number of observations and code runs.

  \code{E.theta.toy()} is a function that returns expectation of
  \code{H(D)} with respect to \eqn{\theta}{theta};
  \code{Edash.theta.toy()} returns expectation with  respect to \eqn{E'}{Edash}.
  \code{extractor.toy()} is a function that extracts \code{x.star.toy}
  and \code{t.vec.toy} from \code{D2}; toy example needed because the
  extraction differs from case to case.

  \code{H1.toy()} is a function that applies basis functions to rows of
  \code{D1} and \code{D2}

  \code{phi.fun.toy()} is a function to create or modify
  (\code{phi.change.toy()}) hyperparameters \eqn{\phi}{phi}
  in a form suitable for passing to the other functions in the library.

  \code{pdm.maker.toy()} is a function that makes a positive definite
  matrix out of hyperparameters \eqn{\psi_1}{psi1} and
  \eqn{\psi_2}{psi2}.  Used by \code{phi.fun.toy()}.

  \code{stage1()} is a function that performs the first of O'Hagan's
  three stage optimization on the toy dataset.
  
}
\details{
  All toy datasets are documented here.  There are also several toy
  functions that are needed for a toy problem; these are documented
  separately (they are too diverse to document fully in a single
  manpage).  Nevertheless a terse summary  for each toy function
  is provided on this page.  All toy functions in the package are listed
  under \dQuote{See Also}.
}
\references{
  M. C. Kennedy and A. O'Hagan 2001. \dQuote{Bayesian
    calibration of computer models}.  Journal of the Royal Statistical
  Society B, 63(3) pp425-464
  
  M. C. Kennedy and A. O'Hagan 2001.  \dQuote{Supplementary details on
    Bayesian calibration of computer models}, Internal report, University
  of Sheffield.  Available at \url{http://www.shef.ac.uk/~st1ao/ps/calsup.ps}
  
  R. K. S. Hankin 2005. \dQuote{Introducing BACCO, an R bundle for
    Bayesian analysis of computer code output}, Journal of Statistical
  Software, 14(16)
}
\author{Robin K. S. Hankin}
\seealso{
  \code{\link{create.new.toy.datasets}},
  \code{\link{E.theta.toy}},
  \code{\link{extractor.toy}},
  \code{\link{H1.toy}},
  \code{\link{phi.fun.toy}},
  \code{\link{stage1}}
}
\examples{
data(toys)
D1.toy
extractor.toy(D1.toy)

D2.fun(theta=theta.toy , D2=D2.toy)
D2.fun(theta=theta.toy,D2=D2.toy[1,,drop=FALSE])

corr.matrix(D1.toy,scales=rep(1,5))
corr.matrix(D1.toy, pos.def.matrix=diag(5))

}

\keyword{datasets}
