% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/datasets.R
\name{upload.dataset}
\alias{upload.dataset}
\title{Upload an R data frame to an AzureML workspace.}
\usage{
upload.dataset(x, ws, name, description = "", family_id = "", ...)
}
\arguments{
\item{x}{An R data frame object}

\item{ws}{An AzureML workspace reference returned by \code{\link{workspace}}.}

\item{name}{A character name for the new AzureML dataset (may not match an existing dataset name)}

\item{description}{An optional character description of the dataset}

\item{family_id}{An optional AzureML family identifier}

\item{...}{Optional additional options passed to \code{write.table}}
}
\value{
A single-row data frame of "Datasets" class that corresponds to the uploaded object now available in ws$datasets.
}
\description{
Upload any R data frame to an AzureML workspace using the \code{GenericTSV} format.
}
\note{
The additional \code{\link[utils]{write.table}} options may not include \code{sep} or \code{row.names} or \code{file}, but any other options are accepted.
The AzureML API does not support uploads for _replacing_ datasets with new data by re-using a name. If you need to do this, first delete the dataset from the AzureML Studio interface, then upload a new version.
}
\examples{
\dontrun{
  library(AzureML)
  
  ws <- workspace()
  
  # Upload the R airquality data.frame to the workspace.
  upload.dataset(airquality, ws, "airquality")

  # Example datasets (airquality should be among them now)
  head(datasets(ws))

  # Now delete what we've just uploaded
  delete.datasets(ws, "airquality")
}
}
\seealso{
Other dataset functions: \code{\link{datasets}};
  \code{\link{delete.datasets}};
  \code{\link{download.intermediate.dataset}};
  \code{\link{workspace}}
}

