% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_object.R
\docType{class}
\name{ms_object}
\alias{ms_object}
\title{Microsoft Graph object}
\format{
An R6 object of class \code{ms_object}.
}
\description{
Base class representing a object in Microsoft Graph. All other Graph object classes ultimately inherit from this class.
}
\section{Fields}{

\itemize{
\item \code{token}: The token used to authenticate with the Graph host.
\item \code{tenant}: The Azure Active Directory tenant for this object.
\item \code{type}: The type of object, in a human-readable format.
\item \code{properties}: The object properties, as obtained from the Graph host.
}
}

\section{Methods}{

\itemize{
\item \code{new(...)}: Initialize a new directory object. Do not call this directly; see 'Initialization' below.
\item \code{delete(confirm=TRUE)}: Delete an object. By default, ask for confirmation first.
\item \code{update(...)}: Update the object information in Azure Active Directory.
\item \code{do_operation(...)}: Carry out an arbitrary operation on the object.
\item \code{sync_fields()}: Synchronise the R object with the data in Azure Active Directory.
\item \code{get_list_pager(...)}: Returns a pager object, which is an \emph{iterator} for a set of paged query results. See 'Paged results' below.
}
}

\section{Initialization}{

Objects of this class should not be created directly. Instead, create an object of the appropriate subclass.
}

\section{List methods}{

All \verb{list_*} methods have \code{filter} and \code{n} arguments to limit the number of results. The former should be an \href{https://docs.microsoft.com/en-us/graph/query-parameters#filter-parameter}{OData expression} as a string to filter the result set on. The latter should be a number setting the maximum number of (filtered) results to return. The default values are \code{filter=NULL} and \code{n=Inf}. If \code{n=NULL}, the \code{ms_graph_pager} iterator object is returned instead to allow manual iteration over the results.

Support in the underlying Graph API for OData queries is patchy. Not all endpoints that return lists of objects support filtering, and if they do, they may not allow all of the defined operators. If your filtering expression results in an error, you can carry out the operation without filtering and then filter the results on the client side.
}

\section{Paged results}{

Microsoft Graph returns lists in pages, with each page containing a subset of objects and a link to the next page. AzureGraph provides an iterator-based API that lets you access each page individually, or collect them all into a single object.

To create a new pager object, call the \code{get_list_pager()} method with the following arguments:
\itemize{
\item \code{lst}: A list containing the first page of results, generally from a call to the \code{do_operation()} method.
\item \verb{next_link_name,value_name}: The names of the components of \code{first_page} containing the link to the next page, and the set of values for the page respectively. The default values are \verb{@odata.nextLink} and \code{value}.
\item \code{generate_objects}: Whether the iterator should return a list containing the parsed JSON for the page values, or convert it into a list of R6 objects.
\item \code{type_filter}: Any extra arguments required to initialise the returned objects. Only used if \code{generate_objects} is TRUE.
\item \code{default_generator}: The default generator object to use when converting a list of properties into an R6 object, if the class can't be detected. Defaults to \code{ms_object}. Only used if \code{generate_objects} is TRUE.
\item \code{...}: Any extra arguments required to initialise the returned objects. Only used if \code{generate_objects} is TRUE.
}

This returns an object of class \link{ms_graph_pager}, which is an \emph{iterator} for the set of paged results. Each call to the object's \code{value} active binding yields the next page. When all pages have been returned, \code{value} contains NULL.

The format of the returned values can take one of 3 forms, based on the initial format of the first page and the \code{generate_objects} argument.

If the first page of results is a data frame (each item has been converted into a row), then the pager will return results as data frames. In this case, the \code{output} field is automatically set to "data.frame" and the \code{generate_objects} initialization argument is ignored. Usually this will be the case when the results are meant to represent external data, eg items in a SharePoint list.

If the first page of results is a list, the \code{generate_objects} argument sets whether to convert the items in each page into R6 objects defined by the AzureGraph class framework. If \code{generate_objects} is TRUE, the \code{output} field is set to "object", and if \code{generate_objects} is FALSE, the \code{output} field is set to "list".

You can also call the \code{extract_list_values()} function to get all or some of the values from a pager, without having to manually combine the pages together.
}

\section{Deprecated methods}{

The following methods are private and \strong{deprecated}, and form the older AzureGraph API for accessing paged results. They will eventually be removed.
\itemize{
\item \code{get_paged_list(lst, next_link_name, value_name, simplify, n)}: This method reconstructs the list, given the first page.
\item \code{init_list_objects(lst, type_filter, default_generator, ...)}: \code{get_paged_list} returns a raw list, the result of parsing the JSON response from the Graph host. This method converts the list into actual R6 objects.
}
}

\seealso{
\link{ms_graph}, \link{az_object}, \link{ms_graph_pager}, \link{extract_list_values}

\href{https://docs.microsoft.com/en-us/graph/overview}{Microsoft Graph overview},
\href{https://docs.microsoft.com/en-us/graph/api/overview?view=graph-rest-1.0}{REST API reference}
}
