% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_object.R
\docType{class}
\name{ms_object}
\alias{ms_object}
\title{Azure Active Directory object}
\format{
An R6 object of class \code{ms_object}.
}
\description{
Base class representing a object in Microsoft Graph. All other Graph object classes ultimately inherit from this class.
}
\section{Fields}{

\itemize{
\item \code{token}: The token used to authenticate with the Graph host.
\item \code{tenant}: The Azure Active Directory tenant for this object.
\item \code{type}: The type of object, in a human-readable format.
\item \code{properties}: The object properties.
}
}

\section{Methods}{

\itemize{
\item \code{new(...)}: Initialize a new directory object. Do not call this directly; see 'Initialization' below.
\item \code{delete(confirm=TRUE)}: Delete an object. By default, ask for confirmation first.
\item \code{update(...)}: Update the object information in Azure Active Directory.
\item \code{do_operation(...)}: Carry out an arbitrary operation on the object.
\item \code{sync_fields()}: Synchronise the R object with the data in Azure Active Directory.
}
}

\section{Initialization}{

Objects of this class should not be created directly. Instead, create an object of the appropriate subclass.
}

\seealso{
\link{ms_graph}, \link{az_object}

\href{https://docs.microsoft.com/en-us/graph/overview}{Microsoft Graph overview},
\href{https://docs.microsoft.com/en-us/graph/api/overview?view=graph-rest-1.0}{REST API reference}
}
