% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3Classes.R
\name{plot.archaeophases_plot}
\alias{plot.archaeophases_plot}
\title{Recreate a graphical plot}
\usage{
\method{plot}{archaeophases_plot}(x, ...)
}
\arguments{
\item{x}{An \code{archaeophases_plot} object.}

\item{...}{Other parameters.}
}
\description{
Recreates a graphic from data and metadata held in a
\code{archaeophases_plot} object.
}
\details{
Uses data stored in the \code{archaeophases_plot} object, along with
metadata from the call of the plotting function, to recreate the original
graphic on the display.
}
\examples{

\dontrun{
# Read from connection
  ox <- read_oxcal("http://tsdye.online/AP/ox.csv")
  tp_1 <- tempo_plot(ox, position = 1:ncol(ox))
# Recreate the tempo_plot with the original arguments
  plot(tp_1)
}
}
\seealso{
\code{\link{tempo_plot}}

\code{\link{occurrence_plot}}

\code{\link{marginal_plot}}

\code{\link{multi_marginal_plot}}

\code{\link{tempo_activity_plot}}

\code{\link{multi_dates_plot}}
}
\author{
Thomas S. Dye, \email{tsd@tsdye.online}
}
