% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ApacheLogProcessor.R
\name{read.apache.log.combined}
\alias{read.apache.log.combined}
\title{read.apache.log.combined}
\usage{
read.apache.log.combined(file, url_includes = "", url_excludes = "",
  url_query_string = TRUE, url_http_version = TRUE,
  url_http_method = TRUE, columns = c("ip", "datetime", "url", "httpcode",
  "size", "referer", "useragent"), num_cores = 1)
}
\arguments{
\item{file}{string. Full path to the log file.}

\item{url_includes}{regex. If passed only the urls that matches with the regular expression passed will be returned.}

\item{url_excludes}{regex. If passed only the urls that don't matches with the regular expression passed will be returned.}

\item{url_query_string}{boolean. If the query string will be included in url column.}

\item{url_http_version}{booelan. If the http version will be included in url column.}

\item{url_http_method}{boolean. If the http method will be included in url column.}

\item{columns}{list. List of columns names that will be included in data frame output. All columns is the default value. c("ip", "datetime", "url", "httpcode", "size" , "referer", "useragent")}

\item{num_cores}{number. Number of cores for parallel execution, if not passed 1 core is assumed. Used only to convert datetime form string to datetime type.}
}
\value{
a data frame with the apache log file information.
}
\description{
Reads the Apache Log Combined Format and return a data frame with the log data.
}
\details{
The functions recives a full path to the log file and process the default log combined format of Apache.
LogFormat "\%h \%l \%u \%t \\"\%r\\" \%>s \%b \\"\%\{Referer\}i\\" \\"\%\{User-Agent\}i\\"" combined
}
\examples{
path = system.file("examples", "apache_example.txt", package = "ApacheLogProcessor")

#Read the full log with all lines and columns and return a data frame
df1 = read.apache.log.combined(path)

#Read only the lines that url matches with the pattern passed
df2 = read.apache.log.combined(path, url_includes="infinance")

#Read only the lines that url matches with the pattern passed, but do not matche the exclude pattern
df3 = read.apache.log.combined(path, url_includes="infinance", url_excludes="infinanceclient")

#Removes the method and query string from urls
df4 = read.apache.log.combined(path, url_http_method=FALSE, url_query_string=FALSE)

#Return only the ip, url and datetime columns
df5 = read.apache.log.combined(path, columns=c("ip", "url", "datetime"))

#Process using 3 cores in parallel for speed up.
df6 = read.apache.log.combined(path, num_cores=2)
}
\author{
Diogo Silveira Mendonca
}
\seealso{
\url{http://httpd.apache.org/docs/1.3/logs.html}
}

